/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.collab.Participant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

class ParticipantPool {
    private List<Participant> _participants;

    public ParticipantPool(List<Participant> participants) {
        this._participants = participants;
    }

    public boolean isEmpty() {
        return this._participants.isEmpty();
    }

    public Participant chooseRandom(Participant exclude) {
        return this.chooseRandom(Collections.singletonList(exclude));
    }

    public Participant chooseRandom() {
        return this.chooseRandom(Collections.EMPTY_LIST);
    }

    public Participant chooseRandom(Collection<Participant> exclude) {
        if (exclude.isEmpty()) {
            return this.chooseRandom(this._participants);
        }
        ArrayList<Participant> nue = new ArrayList<Participant>(this._participants.size());
        nue.addAll(this._participants);
        nue.removeAll(exclude);
        if (nue.isEmpty()) {
            return this.chooseRandomImpl(this._participants);
        }
        return this.chooseRandomImpl(nue);
    }

    private Participant chooseRandomImpl(List<Participant> participants) {
        if (participants.isEmpty()) {
            return null;
        }
        Random random = new Random();
        return participants.get(random.nextInt(participants.size()));
    }
}

