/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.ui.GraphMessageType;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class ChatFilterSettings {
    private static final String PREF_SHOW_INFO = "showInfo";
    private static final String PREF_SHOW_WARNING = "showWarning";
    private static final String PREF_SHOW_ERROR = "showError";
    private static final String PREF_SHOW_NOTIFICATIONS_OWN = "showNotificationsOwn";
    private static final String PREF_SHOW_GRAPH_CHANGES_OWN = "showGraphChangesOwn";
    private static final String PREF_SHOW_NOTIFICATIONS_OTHER = "showNotificationsOther";
    private static final String PREF_SHOW_GRAPH_CHANGES_OTHER = "showGraphChangesOther";

    public static boolean isShow(LogMessageLevel level, boolean isDebugMode) {
        switch (level) {
            case Info: {
                return ChatFilterSettings.isShowInfo();
            }
            case Warning: {
                return ChatFilterSettings.isShowWarning();
            }
            case Error: {
                return ChatFilterSettings.isShowError();
            }
        }
        return isDebugMode;
    }

    public static boolean isShow(GraphMessageType type) {
        switch (type) {
            case OWN_NOTIFICATION: {
                return ChatFilterSettings.isShowOwnNotifications();
            }
            case OWN_GRAPH_CHANGE: {
                return ChatFilterSettings.isShowOwnGraphMessages();
            }
            case OTHER_NOTIFICATION: {
                return ChatFilterSettings.isShowOtherNotifications();
            }
            case OTHER_GRAPH_CHANGE: {
                return ChatFilterSettings.isShowOtherGraphMessages();
            }
        }
        return true;
    }

    public static void setShowInfo(boolean showInfo) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_INFO, showInfo);
    }

    public static boolean isShowInfo() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_INFO, true);
    }

    public static void setShowWarning(boolean showWarning) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_WARNING, showWarning);
    }

    public static boolean isShowWarning() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_WARNING, true);
    }

    public static void setShowError(boolean showError) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_ERROR, showError);
    }

    public static boolean isShowError() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_ERROR, true);
    }

    public static void setShowOwnNotifications(boolean showOwnNotifications) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_NOTIFICATIONS_OWN, showOwnNotifications);
    }

    public static boolean isShowOwnNotifications() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_NOTIFICATIONS_OWN, true);
    }

    public static void setShowOwnGraphMessages(boolean showOwnGraphMessages) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_GRAPH_CHANGES_OWN, showOwnGraphMessages);
    }

    public static boolean isShowOwnGraphMessages() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_GRAPH_CHANGES_OWN, true);
    }

    public static void setShowOtherNotifications(boolean showOtherNotifications) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_NOTIFICATIONS_OTHER, showOtherNotifications);
    }

    public static boolean isShowOtherNotifications() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_NOTIFICATIONS_OTHER, true);
    }

    public static void setShowOtherGraphMessages(boolean showOtherGraphMessages) {
        ChatFilterSettings.getPreferences().putBoolean(PREF_SHOW_GRAPH_CHANGES_OTHER, showOtherGraphMessages);
    }

    public static boolean isShowOtherGraphMessages() {
        return ChatFilterSettings.getPreferences().getBoolean(PREF_SHOW_GRAPH_CHANGES_OTHER, true);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ChatFilterSettings.class);
    }
}

