/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CloseTourDialog
extends TourDialog {
    private TourStep tourStep = TourStep.DEFAULT;
    private JButton closeButton;
    private JButton continueButton;
    private TitlePanel titlePanel;

    public CloseTourDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(360, 0));
        this.initComponents();
        this.adjustLocation();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_CLOSE_BACKGROUND);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "continue");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "continue");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "continue");
        this.getRootPane().getActionMap().put("continue", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloseTourDialog.this.continueButton.doClick();
            }
        });
    }

    @Override
    protected Point getRelativeLocation() {
        Rectangle parentBounds = this.getParentFrame().getBounds();
        return new Point(parentBounds.width - this.getWidth(), 58);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JTextArea contentTextArea = new JTextArea();
        this.closeButton = new JButton();
        this.continueButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(CloseTourDialog.class, (String)"CloseTourDialog.titlePanel.title"));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(5);
        contentTextArea.setText(NbBundle.getMessage(CloseTourDialog.class, (String)"CloseTourDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        this.closeButton.setFont(this.closeButton.getFont().deriveFont((float)this.closeButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(CloseTourDialog.class, (String)"CloseTourDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloseTourDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.continueButton.setBackground(UIManager.getLookAndFeelDefaults().getColor("Button.background").darker().darker());
        this.continueButton.setFont(this.continueButton.getFont().deriveFont((float)this.continueButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)this.continueButton, (String)NbBundle.getMessage(CloseTourDialog.class, (String)"CloseTourDialog.continueButton.text"));
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloseTourDialog.this.continueButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(contentTextArea).addComponent(this.titlePanel, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.continueButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(contentTextArea, -2, -1, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.continueButton)).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.tourStep.closeTour();
    }

    private void continueButtonActionPerformed(ActionEvent evt) {
        this.tourStep.next();
    }

    public static class Presenter
    extends TourDialogPresenter<CloseTourDialog> {
        @Override
        protected CloseTourDialog createTourDialog(Frame frame) {
            return new CloseTourDialog(frame);
        }
    }
}

