/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TabularTransformNames {
    public static final String NAME_PREFIX = "generated.";
    public static final String SEARCH_NAME_SUFFIX = ".search";
    public static final String GLOBAL_SEARCH_NAME = "generated.global.search";

    public static String getTransformName(TabularTransformSource source, TabularTransform tabularTransform) {
        Args.notNull((Object)((Object)source), (String)"source");
        Args.notNull((Object)tabularTransform, (String)"tabularTransform");
        String indexesStr = tabularTransform.getLinkIndexes().stream().map(Object::toString).collect(Collectors.joining("."));
        return NAME_PREFIX + source.getName() + "." + indexesStr + (tabularTransform.isReverse() ? ".reverse" : "");
    }

    public static String getTransformDisplayName(TabularTransformSource source, TabularTransform tabularTransform) {
        TabularGraph tabularGraph = MappingRegistry.getDefault().get(source.getTabularGraphName());
        List<TabularGraphLink> links = tabularTransform.getLinks(tabularGraph);
        List<TabularGraphEntity> sources = TabularTransformNames.getEntities(links, TabularGraphLink::getSource);
        List<TabularGraphEntity> targets = TabularTransformNames.getEntities(links, TabularGraphLink::getTarget);
        boolean reverse = tabularTransform.isReverse();
        return TabularTransformNames.getCommonEntityName(source, reverse ? targets : sources) + " to " + TabularTransformNames.getCommonEntityName(source, reverse ? sources : targets);
    }

    public static String getGlobalSearchTransformName() {
        return GLOBAL_SEARCH_NAME;
    }

    public static String getGlobalSearchTransformDisplayName() {
        return "Search All Tabular Sources";
    }

    public static String getSearchTransformName(TabularTransformSource source) {
        return NAME_PREFIX + source.getName() + SEARCH_NAME_SUFFIX;
    }

    public static String getSearchTransformDisplayName(TabularTransformSource source) {
        return "Search (" + source.getDisplayName() + ")";
    }

    private static List<TabularGraphEntity> getEntities(List<TabularGraphLink> links, Function<TabularGraphLink, TabularGraphEntity> func) {
        return links.stream().map(func::apply).collect(Collectors.toList());
    }

    private static String getCommonEntityName(TabularTransformSource source, List<TabularGraphEntity> entities) {
        TabularGraphEntity firstEntity = entities.get(0);
        String displayName = TabularTransformNames.getEntityName(source, firstEntity).orElse(null);
        if (displayName != null) {
            for (TabularGraphEntity entity : entities) {
                String other;
                if (firstEntity.equals(entity) || displayName.equals(other = (String)TabularTransformNames.getEntityName(source, firstEntity).orElse(null))) continue;
                displayName = null;
                break;
            }
        }
        return displayName != null ? displayName : TabularTransformNames.getEntitySpecDisplayName(firstEntity);
    }

    private static Optional<String> getEntityName(TabularTransformSource source, TabularGraphEntity entity) {
        return source.getEntityNames().getName(entity);
    }

    private static String getEntitySpecDisplayName(TabularGraphEntity entity) {
        String specName = entity.getEntitySpecName();
        MaltegoEntitySpec entitySpec = (MaltegoEntitySpec)EntityRegistry.getDefault().get(specName);
        String displayName = entitySpec != null ? entitySpec.getDisplayName() : specName;
        return displayName;
    }
}

