/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpype.html.AttrParser;
import org.jpype.html.Html;
import org.jpype.html.HtmlHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HtmlTreeHandler
implements HtmlHandler {
    final Document root;
    LinkedList<Element> elementStack = new LinkedList();
    AttrParser attrParser;
    Node current;
    int errors = 0;

    public HtmlTreeHandler() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.root = documentBuilder.newDocument();
            this.current = this.root;
            this.attrParser = new AttrParser(this.root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private String lastNodeName() {
        if (this.elementStack.isEmpty()) {
            return "";
        }
        return this.elementStack.getLast().getNodeName();
    }

    @Override
    public void startElement(String string, String string2) {
        Object object;
        string = string.toLowerCase().trim();
        String string3 = string2;
        while (Html.OPTIONAL_ELEMENTS.contains(string) && Html.OPTIONAL_CLOSE.contains(object = this.lastNodeName() + ":" + string)) {
            this.endElement(this.lastNodeName());
        }
        try {
            object = this.root.createElement(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Fail to create node '" + string + "'", exception);
        }
        if (string2 != null) {
            for (Attr attr : (List)this.attrParser.parse(string2)) {
                object.setAttributeNode(attr);
            }
        }
        this.current.appendChild((Node)object);
        if (Html.VOID_ELEMENTS.contains(string)) {
            return;
        }
        this.current = object;
        this.elementStack.add((Element)object);
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this.elementStack) {
            stringBuilder.append("/");
            stringBuilder.append(element.getNodeName());
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getLength() <= 0) continue;
            stringBuilder.append('[');
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                stringBuilder.append(attr.getName());
                stringBuilder.append('=');
                stringBuilder.append(attr.getValue());
                stringBuilder.append(' ');
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public void endElement(String string) {
        string = string.toLowerCase().trim();
        if (this.elementStack.isEmpty()) {
            throw new RuntimeException("Empty stack");
        }
        Element element = this.elementStack.getLast();
        while (!element.getNodeName().equals(string) && Html.OPTIONAL_ELEMENTS.contains(element.getNodeName())) {
            this.endElement(element.getNodeName());
            element = this.elementStack.getLast();
        }
        if (!element.getNodeName().equals(string)) {
            Element element2;
            ++this.errors;
            ListIterator<Element> listIterator = this.elementStack.listIterator(this.elementStack.size() - 1);
            int n = 0;
            while (listIterator.hasNext() && !(element2 = listIterator.previous()).getNodeName().equals(string)) {
                ++n;
            }
            if (listIterator.hasPrevious()) {
                for (int i = 0; i < n; ++i) {
                    System.err.println("Ignoring missing close tag " + element.getNodeName() + ", got " + string + " at " + this.getPath());
                    this.endElement(element.getNodeName());
                }
            } else {
                if (this.errors > 3) {
                    throw new RuntimeException("mismatch element " + string + " " + element.getNodeName() + " at " + this.getPath());
                }
                System.err.println("Ignoring mismatched element " + string + " " + element.getNodeName() + " at " + this.getPath());
                return;
            }
        }
        this.elementStack.removeLast();
        this.current = this.elementStack.isEmpty() ? this.root : (Node)this.elementStack.getLast();
    }

    @Override
    public void comment(String string) {
        if (string.equals(">")) {
            throw new RuntimeException();
        }
        this.current.appendChild(this.root.createComment(string));
    }

    @Override
    public void text(String string) {
        if (string.length() == 0) {
            return;
        }
        if (string.contains("<")) {
            throw new RuntimeException("bad text `" + string + "` at " + this.getPath());
        }
        if (this.current == this.root) {
            return;
        }
        this.current.appendChild(this.root.createTextNode(string));
    }

    @Override
    public void cdata(String string) {
        this.current.appendChild(this.root.createCDATASection(string));
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public Object getResult() {
        return this.root;
    }

    @Override
    public void directive(String string) {
        int n = string.indexOf(" ");
        this.current.appendChild(this.root.createProcessingInstruction(string.substring(0, n), string.substring(n).trim()));
    }
}

