# coding: utf-8

"""
    OneLogin API Python SDK

    Official Python SDK for the OneLogin API
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_call, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, constr, validator

from typing import List, Optional

from onelogin.models.list_message_templates200_response_inner import ListMessageTemplates200ResponseInner
from onelogin.models.message_template import MessageTemplate

from onelogin.api_client import ApiClient
from onelogin.api_response import ApiResponse
from onelogin.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BrandingServiceTemplatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_message_template(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], locale : Annotated[Optional[constr(strict=True)], Field(description="The 2 character language locale for the template. e.g. en = English, es = Spanish")] = None, message_template : Optional[MessageTemplate] = None, **kwargs) -> MessageTemplate:  # noqa: E501
        """Create Message Template  # noqa: E501

        Create Message Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_message_template(brand_id, locale, message_template, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish
        :type locale: str
        :param message_template:
        :type message_template: MessageTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_message_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_message_template_with_http_info(brand_id, locale, message_template, **kwargs)  # noqa: E501

    @validate_call
    def create_message_template_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], locale : Annotated[Optional[constr(strict=True)], Field(description="The 2 character language locale for the template. e.g. en = English, es = Spanish")] = None, message_template : Optional[MessageTemplate] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Message Template  # noqa: E501

        Create Message Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_message_template_with_http_info(brand_id, locale, message_template, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish
        :type locale: str
        :param message_template:
        :type message_template: MessageTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'locale',
            'message_template'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_message_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']


        # process the query parameters
        _query_params = []
        if _params.get('locale') is not None:  # noqa: E501
            _query_params.append(('locale', _params['locale']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['message_template'] is not None:
            _body_params = _params['message_template']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '422': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def delete_message_template(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> None:  # noqa: E501
        """Delete Message Template  # noqa: E501

        Delete Message Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_message_template(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_message_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_message_template_with_http_info(brand_id, template_id, **kwargs)  # noqa: E501

    @validate_call
    def delete_message_template_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Message Template  # noqa: E501

        Delete Message Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_message_template_with_http_info(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'template_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_message_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']

        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates/{template_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def get_master_by_type(self, template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], **kwargs) -> MessageTemplate:  # noqa: E501
        """Get Master Template by Type  # noqa: E501

        Get Master Template by Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_master_by_type(template_type, async_req=True)
        >>> result = thread.get()

        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_master_by_type_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_master_by_type_with_http_info(template_type, **kwargs)  # noqa: E501

    @validate_call
    def get_master_by_type_with_http_info(self, template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get Master Template by Type  # noqa: E501

        Get Master Template by Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_master_by_type_with_http_info(template_type, async_req=True)
        >>> result = thread.get()

        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'template_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_master_by_type" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['template_type']:
            _path_params['template_type'] = _params['template_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '404': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/master/templates/{template_type}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def get_message_template_by_id(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> MessageTemplate:  # noqa: E501
        """Get Message Template  # noqa: E501

        Get Message Template by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_template_by_id(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_message_template_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_message_template_by_id_with_http_info(brand_id, template_id, **kwargs)  # noqa: E501

    @validate_call
    def get_message_template_by_id_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get Message Template  # noqa: E501

        Get Message Template by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_template_by_id_with_http_info(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'template_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_template_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']

        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '404': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates/{template_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def get_template_by_locale(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], locale : Annotated[constr(strict=True), Field(..., description="The 2 character language locale for the template. e.g. en = English, es = Spanish")], **kwargs) -> MessageTemplate:  # noqa: E501
        """Get Template by Type & Locale  # noqa: E501

        Get Template by Type and Locale  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_template_by_locale(brand_id, template_type, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_template_by_locale_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_template_by_locale_with_http_info(brand_id, template_type, locale, **kwargs)  # noqa: E501

    @validate_call
    def get_template_by_locale_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], locale : Annotated[constr(strict=True), Field(..., description="The 2 character language locale for the template. e.g. en = English, es = Spanish")], **kwargs) -> ApiResponse:  # noqa: E501
        """Get Template by Type & Locale  # noqa: E501

        Get Template by Type and Locale  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_template_by_locale_with_http_info(brand_id, template_type, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'template_type',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_template_by_locale" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']

        if _params['template_type']:
            _path_params['template_type'] = _params['template_type']

        if _params['locale']:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '404': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates/{template_type}/{locale}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def list_message_templates(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], locale : Annotated[Optional[constr(strict=True)], Field(description="The 2 character language locale for the template. e.g. en = English, es = Spanish")] = None, **kwargs) -> List[ListMessageTemplates200ResponseInner]:  # noqa: E501
        """List Message Templates  # noqa: E501

        List Message Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_message_templates(brand_id, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[ListMessageTemplates200ResponseInner]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_message_templates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_message_templates_with_http_info(brand_id, locale, **kwargs)  # noqa: E501

    @validate_call
    def list_message_templates_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], locale : Annotated[Optional[constr(strict=True)], Field(description="The 2 character language locale for the template. e.g. en = English, es = Spanish")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List Message Templates  # noqa: E501

        List Message Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_message_templates_with_http_info(brand_id, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[ListMessageTemplates200ResponseInner], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_message_templates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']


        # process the query parameters
        _query_params = []
        if _params.get('locale') is not None:  # noqa: E501
            _query_params.append(('locale', _params['locale']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "List[ListMessageTemplates200ResponseInner]",
            '401': "AltErr",
            '422': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def update_message_template_by_id(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> MessageTemplate:  # noqa: E501
        """Update Message Template  # noqa: E501

        Update Message Template by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_message_template_by_id(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_message_template_by_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_message_template_by_id_with_http_info(brand_id, template_id, **kwargs)  # noqa: E501

    @validate_call
    def update_message_template_by_id_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_id : Annotated[StrictInt, Field(..., description="Unique identifier for the template to return.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Message Template  # noqa: E501

        Update Message Template by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_message_template_by_id_with_http_info(brand_id, template_id, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_id: Unique identifier for the template to return. (required)
        :type template_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'template_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_message_template_by_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']

        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '422': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates/{template_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_call
    def update_template_by_locale(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], locale : Annotated[constr(strict=True), Field(..., description="The 2 character language locale for the template. e.g. en = English, es = Spanish")], **kwargs) -> MessageTemplate:  # noqa: E501
        """Update Template by Type & Locale  # noqa: E501

        Update Template by Type and Locale  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_template_by_locale(brand_id, template_type, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_template_by_locale_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_template_by_locale_with_http_info(brand_id, template_type, locale, **kwargs)  # noqa: E501

    @validate_call
    def update_template_by_locale_with_http_info(self, brand_id : Annotated[StrictInt, Field(..., description="Unique identifier for the branding object.")], template_type : Annotated[StrictStr, Field(..., description="The message template type to return.")], locale : Annotated[constr(strict=True), Field(..., description="The 2 character language locale for the template. e.g. en = English, es = Spanish")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Template by Type & Locale  # noqa: E501

        Update Template by Type and Locale  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_template_by_locale_with_http_info(brand_id, template_type, locale, async_req=True)
        >>> result = thread.get()

        :param brand_id: Unique identifier for the branding object. (required)
        :type brand_id: int
        :param template_type: The message template type to return. (required)
        :type template_type: str
        :param locale: The 2 character language locale for the template. e.g. en = English, es = Spanish (required)
        :type locale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'brand_id',
            'template_type',
            'locale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_template_by_locale" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['brand_id']:
            _path_params['brand_id'] = _params['brand_id']

        if _params['template_type']:
            _path_params['template_type'] = _params['template_type']

        if _params['locale']:
            _path_params['locale'] = _params['locale']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2']  # noqa: E501

        _response_types_map = {
            '200': "MessageTemplate",
            '401': "AltErr",
            '404': "AltErr",
        }

        return self.api_client.call_api(
            '/api/2/branding/brands/{brand_id}/templates/{template_type}/{locale}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
