rule MALWARE_Emotet_OneNote_Delivery_vbs_Mar23
{
	meta:
		author = "SECUINFRA Falcon Team (@SI_FalconTeam)"
		description = "Detects Microsoft OneNote files used to deliver Emotet (VBScript Payload)"
		reference = "https://www.secuinfra.com/en/news/the-whale-surfaces-again-emotet-epoch4-spam-botnet-returns/"
		date = "2023-03-22"
		version = "1.1"
		tlp = "CLEAR"
		hash0 = "dd9fcdcaf5c26fc27863c86aa65948924f23ab9faa261562cbc9d65ac80d33d4"
		hash1 = "ca2234b9c6f7c453b91a1ca10fc7b05487f94850be7ac5ea42986347d93772d8"
		hash2 = "b75681c1f99c4caf541478cc417ee9e8fba48f9b902c45d8bda0158a61ba1a2f"
		hash3 = "7c4591fd03b73ba6d0ec71a3cf89a04bfb4bd240d359117d96834a83727bdcc2"
		hash4 = "8fd4f59a30ef77ddf94cfb61d50212c8604316634c26e2bd0849494cba8da1af"
		yarahub_reference_md5 = "9933577fa741233071f0714d7fbffbff"
		yarahub_uuid = "c38da3bc-37bb-4c77-8d7b-392566d3d310"
		yarahub_license = "CC BY 4.0"
		yarahub_rule_matching_tlp = "TLP:WHITE"
		yarahub_rule_sharing_tlp = "TLP:WHITE"
		yarahub_author_twitter = "@SI_FalconTeam"

	strings:
		$s_protected = "This document is protected" wide
		$s_click = "You have to double-click \"View\" button to open" wide
		$s_press = "press to unblock document" wide
		$s_imgFileName = "Untitled picture.jpg" wide
		$s_id = "W5M0MpCehiHzreSzNTczkc9d" ascii
		
		$radTmp = /rad.{5}\.tmp/ 

		$ext0 = ".vbs" ascii wide
		$ext1 = ".vbe" ascii wide
		$ext2 = ".wsf" ascii wide
		$ext3 = ".wsc" ascii wide
		$ext4 = ".htm" ascii wide
		$ext5 = ".hta" ascii wide

		// based on @DhaeyerWolf's rule: https://yaraify.abuse.ch/yarahub/rule/OneNote_EmbeddedFiles_NoPictures/
		$GUID = {E7 16 E3 BD 65 26 11 45 A4 C4 8D 4D 0B 7A 9E AC}
		$PNG = { E7 16 E3 BD 65 26 11 45 A4 C4 8D 4D 0B 7A 9E AC ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 89 50 4E 47 0D 0A 1A 0A }
		$JPG = { E7 16 E3 BD 65 26 11 45 A4 C4 8D 4D 0B 7A 9E AC ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 FF D8 FF }

	condition:
		uint32be(0x0) == 0xE4525C7B
		and any of ($s_*)
		and $radTmp
		and any of ($ext*)
		and (#GUID > #PNG + #JPG)
}