/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.AnalysisResultAdded;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.Pool;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.Volume;

public abstract class AbstractContent
implements Content {
    private static final BlackboardArtifact.Type GEN_INFO_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GEN_INFO);
    public static final long UNKNOWN_ID = -1L;
    private final SleuthkitCase db;
    private final long objId;
    private final String name;
    private volatile Content parent;
    private volatile String uniquePath;
    protected long parentId;
    private volatile boolean hasChildren;
    private volatile boolean checkedHasChildren;
    private volatile int childrenCount;
    private BlackboardArtifact genInfoArtifact = null;

    protected AbstractContent(SleuthkitCase db, long obj_id, String name) {
        this.db = db;
        this.objId = obj_id;
        this.name = name;
        this.parentId = -1L;
        this.checkedHasChildren = false;
        this.hasChildren = false;
        this.childrenCount = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        if (this.uniquePath == null) {
            Content myParent;
            Object tempUniquePath = "";
            if (!this.name.isEmpty()) {
                tempUniquePath = "/" + this.getName();
            }
            if ((myParent = this.getParent()) != null) {
                tempUniquePath = myParent.getUniquePath() + (String)tempUniquePath;
            }
            this.uniquePath = tempUniquePath;
        }
        return this.uniquePath;
    }

    @Override
    public boolean hasChildren() throws TskCoreException {
        if (this.checkedHasChildren) {
            return this.hasChildren;
        }
        this.hasChildren = this.getSleuthkitCase().getHasChildren(this);
        this.checkedHasChildren = true;
        return this.hasChildren;
    }

    @Override
    public int getChildrenCount() throws TskCoreException {
        if (this.childrenCount != -1) {
            return this.childrenCount;
        }
        this.childrenCount = this.getSleuthkitCase().getContentChildrenCount(this);
        this.hasChildren = this.childrenCount > 0;
        this.checkedHasChildren = true;
        return this.childrenCount;
    }

    @Override
    public Content getParent() throws TskCoreException {
        if (this.parent == null) {
            Optional<Long> parentIdOpt = this.getParentId();
            this.parent = !parentIdOpt.isPresent() ? null : this.db.getContentById(parentIdOpt.get());
        }
        return this.parent;
    }

    void setParent(Content parent) {
        this.parent = parent;
    }

    @Beta
    public Optional<Long> getParentId() throws TskCoreException {
        SleuthkitCase.ObjectInfo parentInfo;
        if (this.parentId == -1L && (parentInfo = this.db.getParentInfo(this)) != null) {
            this.parentId = parentInfo.getId();
        }
        return this.parentId == -1L ? Optional.empty() : Optional.of(this.parentId);
    }

    void setParentId(long parentId) {
        this.parentId = parentId;
    }

    @Override
    public long getId() {
        return this.objId;
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        ArrayList<Content> children = new ArrayList<Content>();
        children.addAll(this.getSleuthkitCase().getAbstractFileChildren(this));
        children.addAll(this.getSleuthkitCase().getBlackboardArtifactChildren(this));
        return children;
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        ArrayList<Long> childrenIDs = new ArrayList<Long>();
        childrenIDs.addAll(this.getSleuthkitCase().getAbstractFileChildrenIds(this));
        childrenIDs.addAll(this.getSleuthkitCase().getBlackboardArtifactChildrenIds(this));
        return childrenIDs;
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        Content myParent = this.getParent();
        if (myParent == null) {
            return null;
        }
        return myParent.getDataSource();
    }

    boolean isPoolContent() throws TskCoreException {
        return this.getPool() != null;
    }

    Volume getPoolVolume() throws TskCoreException {
        Content myParent = this.getParent();
        if (myParent == null) {
            return null;
        }
        if (!(myParent instanceof AbstractContent)) {
            return null;
        }
        if (myParent instanceof Volume) {
            if (((Volume)myParent).isPoolContent()) {
                return (Volume)myParent;
            }
            return null;
        }
        return ((AbstractContent)myParent).getPoolVolume();
    }

    Pool getPool() throws TskCoreException {
        Content myParent = this.getParent();
        if (myParent == null) {
            return null;
        }
        if (!(myParent instanceof AbstractContent)) {
            return null;
        }
        if (myParent instanceof Pool) {
            return (Pool)myParent;
        }
        return ((AbstractContent)myParent).getPool();
    }

    public SleuthkitCase getSleuthkitCase() {
        return this.db;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractContent other = (AbstractContent)obj;
        if (this.objId != other.objId) {
            return false;
        }
        try {
            if (this.getChildrenCount() != other.getChildrenCount()) {
                return false;
            }
        }
        catch (TskCoreException ex) {
            Logger.getLogger(AbstractContent.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public int hashCode() {
        int hash = 7 + (int)(this.objId ^ this.objId >>> 32);
        try {
            hash = 41 * hash + this.getChildrenCount();
        }
        catch (TskCoreException ex) {
            Logger.getLogger(AbstractContent.class.getName()).log(Level.SEVERE, null, ex);
        }
        return hash;
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(int artifactTypeID) throws TskCoreException {
        if (artifactTypeID == BlackboardArtifact.ARTIFACT_TYPE.TSK_GEN_INFO.getTypeID()) {
            return this.getGenInfoArtifact(true);
        }
        BlackboardArtifact.Type artifactType = this.db.getBlackboard().getArtifactType(artifactTypeID);
        switch (artifactType.getCategory()) {
            case DATA_ARTIFACT: {
                return this.newDataArtifact(artifactType, Collections.emptyList());
            }
            case ANALYSIS_RESULT: {
                AnalysisResultAdded addedResult = this.newAnalysisResult(artifactType, Score.SCORE_UNKNOWN, null, null, null, Collections.emptyList());
                return addedResult.getAnalysisResult();
            }
        }
        throw new TskCoreException(String.format("Unknown category: %s for artifact type id: %d", artifactType.getCategory().getName(), artifactTypeID));
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        long dataSourceObjectId = this.getDataSource().getId();
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.db.getBlackboard().newAnalysisResult(artifactType, this.objId, dataSourceObjectId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException(String.format("Error adding analysis result to content with objId = %d.", this.objId), ex);
        }
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList, long dataSourceId) throws TskCoreException {
        long dataSourceObjectId = dataSourceId;
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.db.getBlackboard().newAnalysisResult(artifactType, this.objId, dataSourceObjectId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException(String.format("Error adding analysis result to content with objId = %d.", this.objId), ex);
        }
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId) throws TskCoreException {
        return this.db.getBlackboard().newDataArtifact(artifactType, this.objId, this.getDataSource().getId(), attributesList, osAccountId);
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId, long dataSourceId) throws TskCoreException {
        return this.db.getBlackboard().newDataArtifact(artifactType, this.objId, dataSourceId, attributesList, osAccountId);
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        return this.newDataArtifact(artifactType, attributesList, null);
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.newArtifact(type.getTypeID());
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(String artifactTypeName) throws TskCoreException {
        return this.getArtifacts(this.db.getBlackboard().getArtifactType(artifactTypeName).getTypeID());
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(int artifactTypeID) throws TskCoreException {
        if (artifactTypeID == BlackboardArtifact.ARTIFACT_TYPE.TSK_GEN_INFO.getTypeID()) {
            if (this.genInfoArtifact == null) {
                this.getGenInfoArtifact(false);
            }
            ArrayList<BlackboardArtifact> list = new ArrayList<BlackboardArtifact>();
            if (this.genInfoArtifact != null) {
                list.add(this.genInfoArtifact);
            }
            return list;
        }
        return this.db.getBlackboardArtifacts(artifactTypeID, this.objId);
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.getArtifacts(type.getTypeID());
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact() throws TskCoreException {
        return this.getGenInfoArtifact(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BlackboardArtifact getGenInfoArtifact(boolean create) throws TskCoreException {
        BlackboardArtifact retArt;
        if (this.genInfoArtifact != null) {
            return this.genInfoArtifact;
        }
        ArrayList<BlackboardArtifact> arts = this.db.getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_GEN_INFO, this.objId);
        if (arts.isEmpty()) {
            if (!create) return null;
            retArt = this.newDataArtifact(GEN_INFO_TYPE, Collections.emptyList());
        } else {
            retArt = arts.get(0);
        }
        this.genInfoArtifact = retArt;
        return retArt;
    }

    @Override
    public ArrayList<BlackboardAttribute> getGenInfoAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attr_type) throws TskCoreException {
        ArrayList<BlackboardAttribute> returnList = new ArrayList<BlackboardAttribute>();
        if (this.genInfoArtifact == null) {
            this.getGenInfoArtifact(false);
            if (this.genInfoArtifact == null) {
                return returnList;
            }
        }
        for (BlackboardAttribute attribute : this.genInfoArtifact.getAttributes()) {
            if (attribute.getAttributeType().getTypeID() != attr_type.getTypeID()) continue;
            returnList.add(attribute);
        }
        return returnList;
    }

    @Override
    public ArrayList<BlackboardArtifact> getAllArtifacts() throws TskCoreException {
        return this.db.getMatchingArtifacts("WHERE obj_id = " + this.objId);
    }

    @Override
    public List<AnalysisResult> getAllAnalysisResults() throws TskCoreException {
        return this.db.getBlackboard().getAnalysisResults(this.objId);
    }

    @Override
    public List<DataArtifact> getAllDataArtifacts() throws TskCoreException {
        return this.db.getBlackboard().getDataArtifactsBySource(this.objId);
    }

    @Override
    public Score getAggregateScore() throws TskCoreException {
        return this.db.getScoringManager().getAggregateScore(this.objId);
    }

    @Override
    public List<AnalysisResult> getAnalysisResults(BlackboardArtifact.Type artifactType) throws TskCoreException {
        return this.db.getBlackboard().getAnalysisResults(this.objId, artifactType.getTypeID());
    }

    @Override
    public long getArtifactsCount(String artifactTypeName) throws TskCoreException {
        return this.db.getBlackboardArtifactsCount(artifactTypeName, this.objId);
    }

    @Override
    public long getArtifactsCount(int artifactTypeID) throws TskCoreException {
        return this.db.getBlackboardArtifactsCount(artifactTypeID, this.objId);
    }

    @Override
    public long getArtifactsCount(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.db.getBlackboardArtifactsCount(type, this.objId);
    }

    @Override
    public long getAllArtifactsCount() throws TskCoreException {
        return this.db.getBlackboardArtifactsCount(this.objId);
    }

    @Override
    public Set<String> getHashSetNames() throws TskCoreException {
        HashSet<String> hashNames = new HashSet<String>();
        ArrayList<BlackboardArtifact> artifacts = this.getArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_HASHSET_HIT);
        for (BlackboardArtifact a : artifacts) {
            BlackboardAttribute attribute = a.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SET_NAME));
            if (attribute == null) continue;
            hashNames.add(attribute.getValueString());
        }
        return Collections.unmodifiableSet(hashNames);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean preserveState) {
        if (preserveState) {
            return "AbstractContent [\tobjId " + String.format("%010d", this.objId) + "\tname " + this.name + "\tparentId " + this.parentId + "\t\tcheckedHasChildren " + this.checkedHasChildren + "\thasChildren " + this.hasChildren + "\tchildrenCount " + this.childrenCount + "uniquePath " + this.uniquePath + "]\t";
        }
        try {
            if (this.getParent() != null) {
                return "AbstractContent [\tobjId " + String.format("%010d", this.objId) + "\tname " + this.name + "\tcheckedHasChildren " + this.checkedHasChildren + "\thasChildren " + this.hasChildren + "\tchildrenCount " + this.childrenCount + "\tgetUniquePath " + this.getUniquePath() + "\tgetParent " + this.getParent().getId() + "]\t";
            }
            return "AbstractContent [\tobjId " + String.format("%010d", this.objId) + "\tname " + this.name + "\tcheckedHasChildren " + this.checkedHasChildren + "\thasChildren " + this.hasChildren + "\tchildrenCount " + this.childrenCount + "\tuniquePath " + this.getUniquePath() + "\tparentId " + this.parentId + "]\t";
        }
        catch (TskCoreException ex) {
            Logger.getLogger(AbstractContent.class.getName()).log(Level.SEVERE, "Could not find Parent", ex);
            return "AbstractContent [\tobjId " + String.format("%010d", this.objId) + "\tname " + this.name + "\tparentId " + this.parentId + "\t\tcheckedHasChildren " + this.checkedHasChildren + "\thasChildren " + this.hasChildren + "\tchildrenCount " + this.childrenCount + "uniquePath " + this.uniquePath + "]\t";
        }
    }
}

