/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sleuthkit.datamodel.AbstractAttribute;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.AnalysisResultAdded;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitVisitableItem;
import org.sleuthkit.datamodel.TskCoreException;

public abstract class BlackboardArtifact
implements Content {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final long artifactId;
    private final long sourceObjId;
    private final long artifactObjId;
    private final Long dataSourceObjId;
    private final int artifactTypeId;
    private final String artifactTypeName;
    private final String displayName;
    private ReviewStatus reviewStatus;
    private final SleuthkitCase sleuthkitCase;
    private final List<BlackboardAttribute> attrsCache = new ArrayList<BlackboardAttribute>();
    private boolean loadedCacheFromDb = false;
    private volatile Content parent;
    private volatile String uniquePath;
    private byte[] contentBytes = null;
    private volatile boolean checkedHasChildren;
    private volatile boolean hasChildren;
    private volatile int childrenCount;

    BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long sourceObjId, long artifactObjId, Long dataSourceObjId, int artifactTypeID, String artifactTypeName, String displayName, ReviewStatus reviewStatus) {
        this.sleuthkitCase = sleuthkitCase;
        this.artifactId = artifactID;
        this.sourceObjId = sourceObjId;
        this.artifactObjId = artifactObjId;
        this.artifactTypeId = artifactTypeID;
        this.dataSourceObjId = dataSourceObjId;
        this.artifactTypeName = artifactTypeName;
        this.displayName = displayName;
        this.reviewStatus = reviewStatus;
        this.checkedHasChildren = false;
        this.hasChildren = false;
        this.childrenCount = -1;
    }

    BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long sourceObjId, long artifactObjID, Long dataSourceObjID, int artifactTypeID, String artifactTypeName, String displayName, ReviewStatus reviewStatus, boolean isNew) {
        this(sleuthkitCase, artifactID, sourceObjId, artifactObjID, dataSourceObjID, artifactTypeID, artifactTypeName, displayName, reviewStatus);
        if (isNew) {
            this.loadedCacheFromDb = true;
        }
    }

    public SleuthkitCase getSleuthkitCase() {
        return this.sleuthkitCase;
    }

    public long getArtifactID() {
        return this.artifactId;
    }

    public long getObjectID() {
        return this.sourceObjId;
    }

    @Beta
    public Long getDataSourceObjectID() {
        return this.dataSourceObjId;
    }

    public int getArtifactTypeID() {
        return this.artifactTypeId;
    }

    public Type getType() throws TskCoreException {
        Type standardTypesValue = Type.STANDARD_TYPES.get(this.getArtifactTypeID());
        if (standardTypesValue != null) {
            return standardTypesValue;
        }
        return this.getSleuthkitCase().getBlackboard().getArtifactType(this.getArtifactTypeID());
    }

    public String getArtifactTypeName() {
        return this.artifactTypeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() throws TskCoreException {
        BlackboardAttribute.ATTRIBUTE_TYPE[] typesThatCanHaveDate;
        AbstractAttribute attr = null;
        StringBuilder shortDescription = new StringBuilder("");
        if (Type.STANDARD_TYPES.get(this.artifactTypeId) != null) {
            switch (ARTIFACT_TYPE.fromID(this.artifactTypeId).ordinal()) {
                case 45: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_MAC_ADDRESS));
                    break;
                }
                case 41: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SSID));
                    break;
                }
                case 36: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_REMOTE_PATH));
                    break;
                }
                case 5: 
                case 14: 
                case 18: 
                case 20: 
                case 31: 
                case 56: 
                case 59: 
                case 60: 
                case 62: 
                case 63: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME));
                    break;
                }
                case 27: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_NAME));
                    break;
                }
                case 38: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ID));
                    if (attr != null) break;
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_CARD_NUMBER));
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 35: 
                case 44: 
                case 48: 
                case 57: 
                case 65: 
                case 66: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
                    break;
                }
                case 58: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TEXT));
                    break;
                }
                case 9: 
                case 11: 
                case 34: 
                case 64: 
                case 70: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SET_NAME));
                    break;
                }
                case 32: 
                case 39: 
                case 40: 
                case 46: 
                case 55: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT));
                    break;
                }
                case 25: 
                case 47: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 51: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN));
                    break;
                }
                case 8: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_KEYWORD_PREVIEW));
                    break;
                }
                case 10: {
                    attr = this.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_ID));
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 49: {
                    BlackboardAttribute.ATTRIBUTE_TYPE t;
                    BlackboardAttribute.ATTRIBUTE_TYPE[] typesThatCanHaveName;
                    BlackboardAttribute.ATTRIBUTE_TYPE[] aTTRIBUTE_TYPEArray = typesThatCanHaveName = new BlackboardAttribute.ATTRIBUTE_TYPE[]{BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_HOME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_MOBILE, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_OFFICE, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_FROM, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_TO, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_HOME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_OFFICE, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_LOCATION};
                    int n = aTTRIBUTE_TYPEArray.length;
                    for (int i = 0; i < n && ((attr = this.getAttribute(new BlackboardAttribute.Type(t = aTTRIBUTE_TYPEArray[i]))) == null || ((BlackboardAttribute)attr).getDisplayString().isEmpty()); ++i) {
                    }
                    break;
                }
            }
        }
        if (attr != null) {
            shortDescription.append(attr.getAttributeType().getDisplayName()).append(": ").append(((BlackboardAttribute)attr).getDisplayString());
        } else {
            shortDescription.append(this.getDisplayName());
        }
        for (BlackboardAttribute.ATTRIBUTE_TYPE t : typesThatCanHaveDate = new BlackboardAttribute.ATTRIBUTE_TYPE[]{BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_SENT, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_RCVD, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_MODIFIED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END}) {
            BlackboardAttribute date = this.getAttribute(new BlackboardAttribute.Type(t));
            if (date == null || date.getDisplayString().isEmpty()) continue;
            shortDescription.append(" ");
            shortDescription.append(MessageFormat.format(bundle.getString("BlackboardArtifact.shortDescriptionDate.text"), date.getDisplayString()));
            break;
        }
        return shortDescription.toString();
    }

    public ReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(ReviewStatus newStatus) throws TskCoreException {
        this.getSleuthkitCase().setReviewStatus(this, newStatus);
        this.reviewStatus = newStatus;
    }

    public void addAttribute(BlackboardAttribute attribute) throws TskCoreException {
        attribute.setArtifactId(this.artifactId);
        attribute.setCaseDatabase(this.getSleuthkitCase());
        this.getSleuthkitCase().addBlackboardAttribute(attribute, this.artifactTypeId);
        this.attrsCache.add(attribute);
    }

    public List<BlackboardAttribute> getAttributes() throws TskCoreException {
        ArrayList<BlackboardAttribute> attributes;
        if (!this.loadedCacheFromDb) {
            attributes = this.getSleuthkitCase().getBlackboard().getBlackboardAttributes(this);
            this.attrsCache.clear();
            this.attrsCache.addAll(attributes);
            this.loadedCacheFromDb = true;
        } else {
            attributes = new ArrayList<BlackboardAttribute>(this.attrsCache);
        }
        return attributes;
    }

    void setAttributes(List<BlackboardAttribute> attributes) {
        this.attrsCache.clear();
        this.attrsCache.addAll(attributes);
        this.loadedCacheFromDb = true;
    }

    public BlackboardAttribute getAttribute(BlackboardAttribute.Type attributeType) throws TskCoreException {
        List<BlackboardAttribute> attributes = this.getAttributes();
        for (BlackboardAttribute attribute : attributes) {
            if (!attribute.getAttributeType().equals(attributeType)) continue;
            return attribute;
        }
        return null;
    }

    public void addAttributes(Collection<BlackboardAttribute> attributes) throws TskCoreException {
        if (attributes.isEmpty()) {
            return;
        }
        for (BlackboardAttribute attribute : attributes) {
            attribute.setArtifactId(this.artifactId);
            attribute.setCaseDatabase(this.getSleuthkitCase());
        }
        this.getSleuthkitCase().addBlackboardAttributes(attributes, this.artifactTypeId);
        this.attrsCache.addAll(attributes);
    }

    public void addAttributes(Collection<BlackboardAttribute> attributes, SleuthkitCase.CaseDbTransaction caseDbTransaction) throws TskCoreException {
        if (Objects.isNull(attributes) || attributes.isEmpty()) {
            throw new TskCoreException("Illegal argument passed to addAttributes: null or empty attributes passed to addAttributes");
        }
        if (Objects.isNull(caseDbTransaction)) {
            throw new TskCoreException("Illegal argument passed to addAttributes: null caseDbTransaction passed to addAttributes");
        }
        try {
            for (BlackboardAttribute attribute : attributes) {
                attribute.setArtifactId(this.artifactId);
                attribute.setCaseDatabase(this.getSleuthkitCase());
                this.getSleuthkitCase().addBlackBoardAttribute(attribute, this.artifactTypeId, caseDbTransaction.getConnection());
            }
            this.attrsCache.addAll(attributes);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error adding blackboard attributes", ex);
        }
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        if (this.uniquePath == null) {
            String tempUniquePath = "";
            Content myParent = this.getParent();
            if (myParent != null) {
                tempUniquePath = myParent.getUniquePath();
            }
            this.uniquePath = tempUniquePath;
        }
        return this.uniquePath;
    }

    @Override
    public Content getParent() throws TskCoreException {
        if (this.parent == null) {
            this.parent = this.getSleuthkitCase().getContentById(this.sourceObjId);
        }
        return this.parent;
    }

    @Override
    public ArrayList<BlackboardArtifact> getAllArtifacts() throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public List<AnalysisResult> getAllAnalysisResults() throws TskCoreException {
        return this.sleuthkitCase.getBlackboard().getAnalysisResults(this.artifactObjId);
    }

    @Override
    public List<DataArtifact> getAllDataArtifacts() throws TskCoreException {
        return this.sleuthkitCase.getBlackboard().getDataArtifactsBySource(this.artifactObjId);
    }

    @Override
    public Score getAggregateScore() throws TskCoreException {
        return this.sleuthkitCase.getScoringManager().getAggregateScore(this.artifactObjId);
    }

    @Override
    public List<AnalysisResult> getAnalysisResults(Type artifactType) throws TskCoreException {
        return this.sleuthkitCase.getBlackboard().getAnalysisResults(this.artifactObjId, artifactType.getTypeID());
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(String artifactTypeName) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(int artifactTypeID) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(ARTIFACT_TYPE type) throws TskCoreException {
        return new ArrayList<BlackboardArtifact>();
    }

    @Override
    public long getAllArtifactsCount() throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(String artifactTypeName) throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(int artifactTypeID) throws TskCoreException {
        return 0L;
    }

    @Override
    public long getArtifactsCount(ARTIFACT_TYPE type) throws TskCoreException {
        return 0L;
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact() throws TskCoreException {
        return null;
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact(boolean create) throws TskCoreException {
        if (create) {
            throw new TskCoreException("Artifacts of artifacts are not supported.");
        }
        return null;
    }

    @Override
    public ArrayList<BlackboardAttribute> getGenInfoAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attr_type) throws TskCoreException {
        return new ArrayList<BlackboardAttribute>();
    }

    @Override
    public Set<String> getHashSetNames() throws TskCoreException {
        return new HashSet<String>();
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(int artifactTypeID) throws TskCoreException {
        throw new TskCoreException("Cannot create artifact of an artifact. Not supported.");
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        long dataSourceId = this.getDataSource().getId();
        SleuthkitCase.CaseDbTransaction trans = this.sleuthkitCase.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.sleuthkitCase.getBlackboard().newAnalysisResult(artifactType, this.getId(), dataSourceId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding analysis result.", ex);
        }
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList, long dataSourceId) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction trans = this.sleuthkitCase.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.sleuthkitCase.getBlackboard().newAnalysisResult(artifactType, this.getId(), dataSourceId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding analysis result.", ex);
        }
    }

    @Override
    public DataArtifact newDataArtifact(Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId) throws TskCoreException {
        throw new TskCoreException("Cannot create data artifact of an artifact. Not supported.");
    }

    @Override
    public DataArtifact newDataArtifact(Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId, long dataSourceId) throws TskCoreException {
        throw new TskCoreException("Cannot create data artifact of an artifact. Not supported.");
    }

    @Override
    public DataArtifact newDataArtifact(Type artifactType, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        return this.newDataArtifact(artifactType, attributesList, null);
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(ARTIFACT_TYPE type) throws TskCoreException {
        throw new TskCoreException("Cannot create artifact of an artifact. Not supported.");
    }

    @Override
    public <T> T accept(ContentVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BlackboardArtifact other = (BlackboardArtifact)object;
        return this.artifactId == other.getArtifactID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (int)(this.artifactId ^ this.artifactId >>> 32);
        return hash;
    }

    public String toString() {
        return "BlackboardArtifact{artifactID=" + this.artifactId + ", objID=" + this.getObjectID() + ", artifactObjID=" + this.artifactObjId + ", artifactTypeID=" + this.artifactTypeId + ", artifactTypeName=" + this.artifactTypeName + ", displayName=" + this.displayName + ", Case=" + String.valueOf(this.getSleuthkitCase()) + "}";
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public long getSize() {
        if (this.contentBytes == null) {
            try {
                this.loadArtifactContent();
            }
            catch (TskCoreException ex) {
                return 0L;
            }
        }
        return this.contentBytes.length;
    }

    @Override
    public void close() {
        this.contentBytes = null;
    }

    @Override
    public final int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.contentBytes == null) {
            this.loadArtifactContent();
        }
        if (0 == this.contentBytes.length) {
            return 0;
        }
        long readLen = Math.min((long)this.contentBytes.length - offset, len);
        System.arraycopy(this.contentBytes, 0, buf, 0, (int)readLen);
        return (int)readLen;
    }

    @Override
    public String getName() {
        return this.displayName + this.getArtifactID();
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        return this.dataSourceObjId != null ? this.getSleuthkitCase().getContentById(this.dataSourceObjId) : null;
    }

    private void loadArtifactContent() throws TskCoreException {
        StringBuilder artifactContents = new StringBuilder();
        Content dataSource = null;
        try {
            dataSource = this.getDataSource();
        }
        catch (TskCoreException ex) {
            throw new TskCoreException("Unable to get datasource for artifact: " + this.toString(), ex);
        }
        if (dataSource == null) {
            throw new TskCoreException("Datasource was null for artifact: " + this.toString());
        }
        try {
            for (BlackboardAttribute attribute : this.getAttributes()) {
                artifactContents.append(attribute.getAttributeType().getDisplayName());
                artifactContents.append(" : ");
                artifactContents.append(attribute.getDisplayString());
                artifactContents.append(System.lineSeparator());
            }
        }
        catch (TskCoreException ex) {
            throw new TskCoreException("Unable to get attributes for artifact: " + this.toString(), ex);
        }
        try {
            this.contentBytes = artifactContents.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TskCoreException("Failed to convert artifact string to bytes for artifact: " + this.toString(), ex);
        }
    }

    @Deprecated
    protected BlackboardArtifact(SleuthkitCase sleuthkitCase, long artifactID, long objID, long artifactObjID, long dataSourceObjId, int artifactTypeID, String artifactTypeName, String displayName) {
        this(sleuthkitCase, artifactID, objID, artifactObjID, dataSourceObjId, artifactTypeID, artifactTypeName, displayName, ReviewStatus.UNDECIDED);
    }

    @Deprecated
    public List<BlackboardAttribute> getAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attributeType) throws TskCoreException {
        if (!this.loadedCacheFromDb) {
            ArrayList<BlackboardAttribute> attrs = this.getSleuthkitCase().getBlackboardAttributes(this);
            this.attrsCache.clear();
            this.attrsCache.addAll(attrs);
            this.loadedCacheFromDb = true;
        }
        ArrayList<BlackboardAttribute> filteredAttributes = new ArrayList<BlackboardAttribute>();
        for (BlackboardAttribute attr : this.attrsCache) {
            if (attr.getAttributeType().getTypeID() != attributeType.getTypeID()) continue;
            filteredAttributes.add(attr);
        }
        return filteredAttributes;
    }

    @Override
    public long getId() {
        return this.artifactObjId;
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        ArrayList<Long> childrenIDs = new ArrayList<Long>();
        childrenIDs.addAll(this.getSleuthkitCase().getAbstractFileChildrenIds(this));
        childrenIDs.addAll(this.getSleuthkitCase().getBlackboardArtifactChildrenIds(this));
        return childrenIDs;
    }

    @Override
    public int getChildrenCount() throws TskCoreException {
        if (this.childrenCount != -1) {
            return this.childrenCount;
        }
        this.childrenCount = this.getSleuthkitCase().getContentChildrenCount(this);
        this.hasChildren = this.childrenCount > 0;
        this.checkedHasChildren = true;
        return this.childrenCount;
    }

    @Override
    public boolean hasChildren() throws TskCoreException {
        if (this.checkedHasChildren) {
            return this.hasChildren;
        }
        this.childrenCount = this.getSleuthkitCase().getContentChildrenCount(this);
        this.hasChildren = this.childrenCount > 0;
        this.checkedHasChildren = true;
        return this.hasChildren;
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        ArrayList<Content> children = new ArrayList<Content>();
        children.addAll(this.getSleuthkitCase().getAbstractFileChildren(this));
        children.addAll(this.getSleuthkitCase().getBlackboardArtifactChildren(this));
        return children;
    }

    public static enum ReviewStatus {
        APPROVED(1, "APPROVED", "ReviewStatus.Approved"),
        REJECTED(2, "REJECTED", "ReviewStatus.Rejected"),
        UNDECIDED(3, "UNDECIDED", "ReviewStatus.Undecided");

        private final Integer id;
        private final String name;
        private final String displayName;
        private static final Map<Integer, ReviewStatus> idToStatus;

        private ReviewStatus(Integer id, String name, String displayNameKey) {
            this.id = id;
            this.name = name;
            this.displayName = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle").getString(displayNameKey);
        }

        public static ReviewStatus withID(int id) {
            return idToStatus.get(id);
        }

        public Integer getID() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        static {
            idToStatus = new HashMap<Integer, ReviewStatus>();
            for (ReviewStatus status : ReviewStatus.values()) {
                idToStatus.put(status.getID(), status);
            }
        }
    }

    public static final class Type
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Type TSK_GEN_INFO = new Type(1, "TSK_GEN_INFO", bundle.getString("BlackboardArtifact.tskGenInfo.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_BOOKMARK = new Type(2, "TSK_WEB_BOOKMARK", bundle.getString("BlackboardArtifact.tskWebBookmark.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_COOKIE = new Type(3, "TSK_WEB_COOKIE", bundle.getString("BlackboardArtifact.tskWebCookie.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_HISTORY = new Type(4, "TSK_WEB_HISTORY", bundle.getString("BlackboardArtifact.tskWebHistory.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_DOWNLOAD = new Type(5, "TSK_WEB_DOWNLOAD", bundle.getString("BlackboardArtifact.tskWebDownload.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_RECENT_OBJECT = new Type(6, "TSK_RECENT_OBJ", bundle.getString("BlackboardArtifact.tsk.recentObject.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_INSTALLED_PROG = new Type(8, "TSK_INSTALLED_PROG", bundle.getString("BlackboardArtifact.tskInstalledProg.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_KEYWORD_HIT = new Type(9, "TSK_KEYWORD_HIT", bundle.getString("BlackboardArtifact.tskKeywordHits.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_HASHSET_HIT = new Type(10, "TSK_HASHSET_HIT", bundle.getString("BlackboardArtifact.tskHashsetHit.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_DEVICE_ATTACHED = new Type(11, "TSK_DEVICE_ATTACHED", bundle.getString("BlackboardArtifact.tskDeviceAttached.text"), Category.DATA_ARTIFACT);
        @Deprecated
        public static final Type TSK_INTERESTING_FILE_HIT = new Type(12, "TSK_INTERESTING_FILE_HIT", bundle.getString("BlackboardArtifact.tskInterestingFileHit.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_EMAIL_MSG = new Type(13, "TSK_EMAIL_MSG", bundle.getString("BlackboardArtifact.tskEmailMsg.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_EXTRACTED_TEXT = new Type(14, "TSK_EXTRACTED_TEXT", bundle.getString("BlackboardArtifact.tskExtractedText.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_SEARCH_QUERY = new Type(15, "TSK_WEB_SEARCH_QUERY", bundle.getString("BlackboardArtifact.tskWebSearchQuery.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_METADATA_EXIF = new Type(16, "TSK_METADATA_EXIF", bundle.getString("BlackboardArtifact.tskMetadataExif.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_OS_INFO = new Type(19, "TSK_OS_INFO", bundle.getString("BlackboardArtifact.tskOsInfo.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_SERVICE_ACCOUNT = new Type(21, "TSK_SERVICE_ACCOUNT", bundle.getString("BlackboardArtifact.tskServiceAccount.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_CONTACT = new Type(23, "TSK_CONTACT", bundle.getString("BlackboardArtifact.tskContact.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_MESSAGE = new Type(24, "TSK_MESSAGE", bundle.getString("BlackboardArtifact.tskMessage.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_CALLLOG = new Type(25, "TSK_CALLLOG", bundle.getString("BlackboardArtifact.tskCalllog.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_CALENDAR_ENTRY = new Type(26, "TSK_CALENDAR_ENTRY", bundle.getString("BlackboardArtifact.tskCalendarEntry.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_SPEED_DIAL_ENTRY = new Type(27, "TSK_SPEED_DIAL_ENTRY", bundle.getString("BlackboardArtifact.tskSpeedDialEntry.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_BLUETOOTH_PAIRING = new Type(28, "TSK_BLUETOOTH_PAIRING", bundle.getString("BlackboardArtifact.tskBluetoothPairing.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_GPS_BOOKMARK = new Type(29, "TSK_GPS_BOOKMARK", bundle.getString("BlackboardArtifact.tskGpsBookmark.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_GPS_LAST_KNOWN_LOCATION = new Type(30, "TSK_GPS_LAST_KNOWN_LOCATION", bundle.getString("BlackboardArtifact.tskGpsLastKnownLocation.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_GPS_SEARCH = new Type(31, "TSK_GPS_SEARCH", bundle.getString("BlackboardArtifact.tskGpsSearch.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_PROG_RUN = new Type(32, "TSK_PROG_RUN", bundle.getString("BlackboardArtifact.tskProgRun.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_ENCRYPTION_DETECTED = new Type(33, "TSK_ENCRYPTION_DETECTED", bundle.getString("BlackboardArtifact.tskEncryptionDetected.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_EXT_MISMATCH_DETECTED = new Type(34, "TSK_EXT_MISMATCH_DETECTED", bundle.getString("BlackboardArtifact.tskExtMismatchDetected.text"), Category.ANALYSIS_RESULT);
        @Deprecated
        public static final Type TSK_INTERESTING_ARTIFACT_HIT = new Type(35, "TSK_INTERESTING_ARTIFACT_HIT", bundle.getString("BlackboardArtifact.tskInterestingArtifactHit.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_GPS_ROUTE = new Type(36, "TSK_GPS_ROUTE", bundle.getString("BlackboardArtifact.tskGpsRoute.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_REMOTE_DRIVE = new Type(37, "TSK_REMOTE_DRIVE", bundle.getString("BlackboardArtifact.tskRemoteDrive.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_FACE_DETECTED = new Type(38, "TSK_FACE_DETECTED", bundle.getString("BlackboardArtifact.tskFaceDetected.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_ACCOUNT = new Type(39, "TSK_ACCOUNT", bundle.getString("BlackboardArtifact.tskAccount.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_ENCRYPTION_SUSPECTED = new Type(40, "TSK_ENCRYPTION_SUSPECTED", bundle.getString("BlackboardArtifact.tskEncryptionSuspected.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_OBJECT_DETECTED = new Type(41, "TSK_OBJECT_DETECTED", bundle.getString("BlackboardArtifact.tskObjectDetected.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_WIFI_NETWORK = new Type(42, "TSK_WIFI_NETWORK", bundle.getString("BlackboardArtifact.tskWIFINetwork.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_DEVICE_INFO = new Type(43, "TSK_DEVICE_INFO", bundle.getString("BlackboardArtifact.tskDeviceInfo.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_SIM_ATTACHED = new Type(44, "TSK_SIM_ATTACHED", bundle.getString("BlackboardArtifact.tskSimAttached.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_BLUETOOTH_ADAPTER = new Type(45, "TSK_BLUETOOTH_ADAPTER", bundle.getString("BlackboardArtifact.tskBluetoothAdapter.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WIFI_NETWORK_ADAPTER = new Type(46, "TSK_WIFI_NETWORK_ADAPTER", bundle.getString("BlackboardArtifact.tskWIFINetworkAdapter.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_VERIFICATION_FAILED = new Type(47, "TSK_VERIFICATION_FAILED", bundle.getString("BlackboardArtifact.tskVerificationFailed.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_DATA_SOURCE_USAGE = new Type(48, "TSK_DATA_SOURCE_USAGE", bundle.getString("BlackboardArtifact.tskDataSourceUsage.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_WEB_FORM_AUTOFILL = new Type(49, "TSK_WEB_FORM_AUTOFILL", bundle.getString("BlackboardArtifact.tskWebFormAutofill.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_FORM_ADDRESS = new Type(50, "TSK_WEB_FORM_ADDRESSES ", bundle.getString("BlackboardArtifact.tskWebFormAddresses.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_CACHE = new Type(52, "TSK_WEB_CACHE", bundle.getString("BlackboardArtifact.tskWebCache.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_TL_EVENT = new Type(53, "TSK_TL_EVENT", bundle.getString("BlackboardArtifact.tskTLEvent.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_CLIPBOARD_CONTENT = new Type(54, "TSK_CLIPBOARD_CONTENT", bundle.getString("BlackboardArtifact.tskClipboardContent.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_ASSOCIATED_OBJECT = new Type(55, "TSK_ASSOCIATED_OBJECT", bundle.getString("BlackboardArtifact.tskAssociatedObject.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_USER_CONTENT_SUSPECTED = new Type(56, "TSK_USER_CONTENT_SUSPECTED", bundle.getString("BlackboardArtifact.tskUserContentSuspected.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_METADATA = new Type(57, "TSK_METADATA", bundle.getString("BlackboardArtifact.tskMetadata.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_GPS_TRACK = new Type(58, "TSK_GPS_TRACK", bundle.getString("BlackboardArtifact.tskTrack.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_ACCOUNT_TYPE = new Type(59, "TSK_WEB_ACCOUNT_TYPE", bundle.getString("BlackboardArtifact.tskWebAccountType.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_SCREEN_SHOTS = new Type(60, "TSK_SCREEN_SHOTS", bundle.getString("BlackboardArtifact.tskScreenShots.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_PROG_NOTIFICATIONS = new Type(62, "TSK_PROG_NOTIFICATIONS", bundle.getString("BlackboardArtifact.tskProgNotifications.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_BACKUP_EVENT = new Type(63, "TSK_BACKUP_EVENT", bundle.getString("BlackboardArtifact.tskBackupEvent.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_DELETED_PROG = new Type(64, "TSK_DELETED_PROG", bundle.getString("BlackboardArtifact.tskDeletedProg.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_USER_DEVICE_EVENT = new Type(65, "TSK_USER_DEVICE_EVENT", bundle.getString("BlackboardArtifact.tskUserDeviceEvent.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_YARA_HIT = new Type(66, "TSK_YARA_HIT", bundle.getString("BlackboardArtifact.tskYaraHit.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_GPS_AREA = new Type(67, "TSK_GPS_AREA", bundle.getString("BlackboardArtifact.tskGPSArea.text"), Category.DATA_ARTIFACT);
        public static final Type TSK_WEB_CATEGORIZATION = new Type(68, "TSK_WEB_CATEGORIZATION", bundle.getString("BlackboardArtifact.tskWebCategorization.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_PREVIOUSLY_SEEN = new Type(69, "TSK_PREVIOUSLY_SEEN", bundle.getString("BlackboardArtifact.tskPreviouslySeen.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_PREVIOUSLY_UNSEEN = new Type(70, "TSK_PREVIOUSLY_UNSEEN", bundle.getString("BlackboardArtifact.tskPreviouslyUnseen.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_PREVIOUSLY_NOTABLE = new Type(71, "TSK_PREVIOUSLY_NOTABLE", bundle.getString("BlackboardArtifact.tskPreviouslyNotable.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_INTERESTING_ITEM = new Type(72, "TSK_INTERESTING_ITEM", bundle.getString("BlackboardArtifact.tskInterestingItem.text"), Category.ANALYSIS_RESULT);
        public static final Type TSK_MALWARE = new Type(73, "TSK_MALWARE", bundle.getString("BlackboardArtifact.tskMalware.text"), Category.ANALYSIS_RESULT);
        static final Map<Integer, Type> STANDARD_TYPES = Collections.unmodifiableMap(Stream.of(TSK_GEN_INFO, TSK_WEB_BOOKMARK, TSK_WEB_COOKIE, TSK_WEB_HISTORY, TSK_WEB_DOWNLOAD, TSK_RECENT_OBJECT, TSK_INSTALLED_PROG, TSK_KEYWORD_HIT, TSK_HASHSET_HIT, TSK_DEVICE_ATTACHED, TSK_EMAIL_MSG, TSK_EXTRACTED_TEXT, TSK_WEB_SEARCH_QUERY, TSK_METADATA_EXIF, TSK_OS_INFO, TSK_SERVICE_ACCOUNT, TSK_CONTACT, TSK_MESSAGE, TSK_CALLLOG, TSK_CALENDAR_ENTRY, TSK_SPEED_DIAL_ENTRY, TSK_BLUETOOTH_PAIRING, TSK_GPS_BOOKMARK, TSK_GPS_LAST_KNOWN_LOCATION, TSK_GPS_SEARCH, TSK_PROG_RUN, TSK_ENCRYPTION_DETECTED, TSK_EXT_MISMATCH_DETECTED, TSK_GPS_ROUTE, TSK_REMOTE_DRIVE, TSK_FACE_DETECTED, TSK_ACCOUNT, TSK_ENCRYPTION_SUSPECTED, TSK_OBJECT_DETECTED, TSK_WIFI_NETWORK, TSK_DEVICE_INFO, TSK_SIM_ATTACHED, TSK_BLUETOOTH_ADAPTER, TSK_WIFI_NETWORK_ADAPTER, TSK_VERIFICATION_FAILED, TSK_DATA_SOURCE_USAGE, TSK_WEB_FORM_AUTOFILL, TSK_WEB_FORM_ADDRESS, TSK_WEB_CACHE, TSK_TL_EVENT, TSK_CLIPBOARD_CONTENT, TSK_ASSOCIATED_OBJECT, TSK_USER_CONTENT_SUSPECTED, TSK_METADATA, TSK_GPS_TRACK, TSK_WEB_ACCOUNT_TYPE, TSK_SCREEN_SHOTS, TSK_PROG_NOTIFICATIONS, TSK_BACKUP_EVENT, TSK_DELETED_PROG, TSK_USER_DEVICE_EVENT, TSK_YARA_HIT, TSK_GPS_AREA, TSK_WEB_CATEGORIZATION, TSK_PREVIOUSLY_SEEN, TSK_PREVIOUSLY_UNSEEN, TSK_PREVIOUSLY_NOTABLE, TSK_INTERESTING_ITEM, TSK_MALWARE).collect(Collectors.toMap(type -> type.getTypeID(), type -> type)));
        private final String typeName;
        private final int typeID;
        private final String displayName;
        private final Category category;

        Type(int typeID, String typeName, String displayName, Category category) {
            this.typeID = typeID;
            this.typeName = typeName;
            this.displayName = displayName;
            this.category = category;
        }

        public Type(ARTIFACT_TYPE type) {
            this(type.getTypeID(), type.getLabel(), type.getDisplayName(), type.getCategory());
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Category getCategory() {
            return this.category;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Type)) {
                return false;
            }
            return ((Type)that).sameType(this);
        }

        private boolean sameType(Type that) {
            return this.typeName.equals(that.getTypeName()) && this.displayName.equals(that.getDisplayName()) && this.typeID == that.getTypeID();
        }

        public int hashCode() {
            int hash = 11;
            hash = 83 * hash + Objects.hashCode(this.typeID);
            hash = 83 * hash + Objects.hashCode(this.displayName);
            hash = 83 * hash + Objects.hashCode(this.typeName);
            return hash;
        }
    }

    public static enum ARTIFACT_TYPE implements SleuthkitVisitableItem
    {
        TSK_GEN_INFO(1, "TSK_GEN_INFO", bundle.getString("BlackboardArtifact.tskGenInfo.text"), Category.DATA_ARTIFACT),
        TSK_WEB_BOOKMARK(2, "TSK_WEB_BOOKMARK", bundle.getString("BlackboardArtifact.tskWebBookmark.text"), Category.DATA_ARTIFACT),
        TSK_WEB_COOKIE(3, "TSK_WEB_COOKIE", bundle.getString("BlackboardArtifact.tskWebCookie.text"), Category.DATA_ARTIFACT),
        TSK_WEB_HISTORY(4, "TSK_WEB_HISTORY", bundle.getString("BlackboardArtifact.tskWebHistory.text"), Category.DATA_ARTIFACT),
        TSK_WEB_DOWNLOAD(5, "TSK_WEB_DOWNLOAD", bundle.getString("BlackboardArtifact.tskWebDownload.text"), Category.DATA_ARTIFACT),
        TSK_RECENT_OBJECT(6, "TSK_RECENT_OBJ", bundle.getString("BlackboardArtifact.tsk.recentObject.text"), Category.DATA_ARTIFACT),
        TSK_GPS_TRACKPOINT(7, "TSK_GPS_TRACKPOINT", bundle.getString("BlackboardArtifact.tskGpsTrackpoint.text"), Category.DATA_ARTIFACT),
        TSK_INSTALLED_PROG(8, "TSK_INSTALLED_PROG", bundle.getString("BlackboardArtifact.tskInstalledProg.text"), Category.DATA_ARTIFACT),
        TSK_KEYWORD_HIT(9, "TSK_KEYWORD_HIT", bundle.getString("BlackboardArtifact.tskKeywordHits.text"), Category.ANALYSIS_RESULT),
        TSK_HASHSET_HIT(10, "TSK_HASHSET_HIT", bundle.getString("BlackboardArtifact.tskHashsetHit.text"), Category.ANALYSIS_RESULT),
        TSK_DEVICE_ATTACHED(11, "TSK_DEVICE_ATTACHED", bundle.getString("BlackboardArtifact.tskDeviceAttached.text"), Category.DATA_ARTIFACT),
        TSK_INTERESTING_FILE_HIT(12, "TSK_INTERESTING_FILE_HIT", bundle.getString("BlackboardArtifact.tskInterestingFileHit.text"), Category.ANALYSIS_RESULT),
        TSK_EMAIL_MSG(13, "TSK_EMAIL_MSG", bundle.getString("BlackboardArtifact.tskEmailMsg.text"), Category.DATA_ARTIFACT),
        TSK_EXTRACTED_TEXT(14, "TSK_EXTRACTED_TEXT", bundle.getString("BlackboardArtifact.tskExtractedText.text"), Category.DATA_ARTIFACT),
        TSK_WEB_SEARCH_QUERY(15, "TSK_WEB_SEARCH_QUERY", bundle.getString("BlackboardArtifact.tskWebSearchQuery.text"), Category.DATA_ARTIFACT),
        TSK_METADATA_EXIF(16, "TSK_METADATA_EXIF", bundle.getString("BlackboardArtifact.tskMetadataExif.text"), Category.ANALYSIS_RESULT),
        TSK_TAG_FILE(17, "TSK_TAG_FILE", bundle.getString("BlackboardArtifact.tagFile.text"), Category.ANALYSIS_RESULT),
        TSK_TAG_ARTIFACT(18, "TSK_TAG_ARTIFACT", bundle.getString("BlackboardArtifact.tskTagArtifact.text"), Category.ANALYSIS_RESULT),
        TSK_OS_INFO(19, "TSK_OS_INFO", bundle.getString("BlackboardArtifact.tskOsInfo.text"), Category.DATA_ARTIFACT),
        TSK_OS_ACCOUNT(20, "TSK_OS_ACCOUNT", bundle.getString("BlackboardArtifact.tskOsAccount.text"), Category.DATA_ARTIFACT),
        TSK_SERVICE_ACCOUNT(21, "TSK_SERVICE_ACCOUNT", bundle.getString("BlackboardArtifact.tskServiceAccount.text"), Category.DATA_ARTIFACT),
        TSK_TOOL_OUTPUT(22, "TSK_TOOL_OUTPUT", bundle.getString("BlackboardArtifact.tskToolOutput.text"), Category.DATA_ARTIFACT),
        TSK_CONTACT(23, "TSK_CONTACT", bundle.getString("BlackboardArtifact.tskContact.text"), Category.DATA_ARTIFACT),
        TSK_MESSAGE(24, "TSK_MESSAGE", bundle.getString("BlackboardArtifact.tskMessage.text"), Category.DATA_ARTIFACT),
        TSK_CALLLOG(25, "TSK_CALLLOG", bundle.getString("BlackboardArtifact.tskCalllog.text"), Category.DATA_ARTIFACT),
        TSK_CALENDAR_ENTRY(26, "TSK_CALENDAR_ENTRY", bundle.getString("BlackboardArtifact.tskCalendarEntry.text"), Category.DATA_ARTIFACT),
        TSK_SPEED_DIAL_ENTRY(27, "TSK_SPEED_DIAL_ENTRY", bundle.getString("BlackboardArtifact.tskSpeedDialEntry.text"), Category.DATA_ARTIFACT),
        TSK_BLUETOOTH_PAIRING(28, "TSK_BLUETOOTH_PAIRING", bundle.getString("BlackboardArtifact.tskBluetoothPairing.text"), Category.DATA_ARTIFACT),
        TSK_GPS_BOOKMARK(29, "TSK_GPS_BOOKMARK", bundle.getString("BlackboardArtifact.tskGpsBookmark.text"), Category.DATA_ARTIFACT),
        TSK_GPS_LAST_KNOWN_LOCATION(30, "TSK_GPS_LAST_KNOWN_LOCATION", bundle.getString("BlackboardArtifact.tskGpsLastKnownLocation.text"), Category.DATA_ARTIFACT),
        TSK_GPS_SEARCH(31, "TSK_GPS_SEARCH", bundle.getString("BlackboardArtifact.tskGpsSearch.text"), Category.DATA_ARTIFACT),
        TSK_PROG_RUN(32, "TSK_PROG_RUN", bundle.getString("BlackboardArtifact.tskProgRun.text"), Category.DATA_ARTIFACT),
        TSK_ENCRYPTION_DETECTED(33, "TSK_ENCRYPTION_DETECTED", bundle.getString("BlackboardArtifact.tskEncryptionDetected.text"), Category.ANALYSIS_RESULT),
        TSK_EXT_MISMATCH_DETECTED(34, "TSK_EXT_MISMATCH_DETECTED", bundle.getString("BlackboardArtifact.tskExtMismatchDetected.text"), Category.ANALYSIS_RESULT),
        TSK_INTERESTING_ARTIFACT_HIT(35, "TSK_INTERESTING_ARTIFACT_HIT", bundle.getString("BlackboardArtifact.tskInterestingArtifactHit.text"), Category.ANALYSIS_RESULT),
        TSK_GPS_ROUTE(36, "TSK_GPS_ROUTE", bundle.getString("BlackboardArtifact.tskGpsRoute.text"), Category.DATA_ARTIFACT),
        TSK_REMOTE_DRIVE(37, "TSK_REMOTE_DRIVE", bundle.getString("BlackboardArtifact.tskRemoteDrive.text"), Category.DATA_ARTIFACT),
        TSK_FACE_DETECTED(38, "TSK_FACE_DETECTED", bundle.getString("BlackboardArtifact.tskFaceDetected.text"), Category.ANALYSIS_RESULT),
        TSK_ACCOUNT(39, "TSK_ACCOUNT", bundle.getString("BlackboardArtifact.tskAccount.text"), Category.DATA_ARTIFACT),
        TSK_ENCRYPTION_SUSPECTED(40, "TSK_ENCRYPTION_SUSPECTED", bundle.getString("BlackboardArtifact.tskEncryptionSuspected.text"), Category.ANALYSIS_RESULT),
        TSK_OBJECT_DETECTED(41, "TSK_OBJECT_DETECTED", bundle.getString("BlackboardArtifact.tskObjectDetected.text"), Category.ANALYSIS_RESULT),
        TSK_WIFI_NETWORK(42, "TSK_WIFI_NETWORK", bundle.getString("BlackboardArtifact.tskWIFINetwork.text"), Category.DATA_ARTIFACT),
        TSK_DEVICE_INFO(43, "TSK_DEVICE_INFO", bundle.getString("BlackboardArtifact.tskDeviceInfo.text"), Category.DATA_ARTIFACT),
        TSK_SIM_ATTACHED(44, "TSK_SIM_ATTACHED", bundle.getString("BlackboardArtifact.tskSimAttached.text"), Category.DATA_ARTIFACT),
        TSK_BLUETOOTH_ADAPTER(45, "TSK_BLUETOOTH_ADAPTER", bundle.getString("BlackboardArtifact.tskBluetoothAdapter.text"), Category.DATA_ARTIFACT),
        TSK_WIFI_NETWORK_ADAPTER(46, "TSK_WIFI_NETWORK_ADAPTER", bundle.getString("BlackboardArtifact.tskWIFINetworkAdapter.text"), Category.DATA_ARTIFACT),
        TSK_VERIFICATION_FAILED(47, "TSK_VERIFICATION_FAILED", bundle.getString("BlackboardArtifact.tskVerificationFailed.text"), Category.ANALYSIS_RESULT),
        TSK_DATA_SOURCE_USAGE(48, "TSK_DATA_SOURCE_USAGE", bundle.getString("BlackboardArtifact.tskDataSourceUsage.text"), Category.ANALYSIS_RESULT),
        TSK_WEB_FORM_AUTOFILL(49, "TSK_WEB_FORM_AUTOFILL", bundle.getString("BlackboardArtifact.tskWebFormAutofill.text"), Category.DATA_ARTIFACT),
        TSK_WEB_FORM_ADDRESS(50, "TSK_WEB_FORM_ADDRESSES ", bundle.getString("BlackboardArtifact.tskWebFormAddresses.text"), Category.DATA_ARTIFACT),
        TSK_DOWNLOAD_SOURCE(51, "TSK_DOWNLOAD_SOURCE", bundle.getString("BlackboardArtifact.tskDownloadSource.text"), Category.DATA_ARTIFACT),
        TSK_WEB_CACHE(52, "TSK_WEB_CACHE", bundle.getString("BlackboardArtifact.tskWebCache.text"), Category.DATA_ARTIFACT),
        TSK_TL_EVENT(53, "TSK_TL_EVENT", bundle.getString("BlackboardArtifact.tskTLEvent.text"), Category.DATA_ARTIFACT),
        TSK_CLIPBOARD_CONTENT(54, "TSK_CLIPBOARD_CONTENT", bundle.getString("BlackboardArtifact.tskClipboardContent.text"), Category.DATA_ARTIFACT),
        TSK_ASSOCIATED_OBJECT(55, "TSK_ASSOCIATED_OBJECT", bundle.getString("BlackboardArtifact.tskAssociatedObject.text"), Category.DATA_ARTIFACT),
        TSK_USER_CONTENT_SUSPECTED(56, "TSK_USER_CONTENT_SUSPECTED", bundle.getString("BlackboardArtifact.tskUserContentSuspected.text"), Category.ANALYSIS_RESULT),
        TSK_METADATA(57, "TSK_METADATA", bundle.getString("BlackboardArtifact.tskMetadata.text"), Category.DATA_ARTIFACT),
        TSK_GPS_TRACK(58, "TSK_GPS_TRACK", bundle.getString("BlackboardArtifact.tskTrack.text"), Category.DATA_ARTIFACT),
        TSK_WEB_ACCOUNT_TYPE(59, "TSK_WEB_ACCOUNT_TYPE", bundle.getString("BlackboardArtifact.tskWebAccountType.text"), Category.ANALYSIS_RESULT),
        TSK_SCREEN_SHOTS(60, "TSK_SCREEN_SHOTS", bundle.getString("BlackboardArtifact.tskScreenShots.text"), Category.DATA_ARTIFACT),
        TSK_PROG_NOTIFICATIONS(62, "TSK_PROG_NOTIFICATIONS", bundle.getString("BlackboardArtifact.tskProgNotifications.text"), Category.DATA_ARTIFACT),
        TSK_BACKUP_EVENT(63, "TSK_BACKUP_EVENT", bundle.getString("BlackboardArtifact.tskBackupEvent.text"), Category.DATA_ARTIFACT),
        TSK_DELETED_PROG(64, "TSK_DELETED_PROG", bundle.getString("BlackboardArtifact.tskDeletedProg.text"), Category.DATA_ARTIFACT),
        TSK_USER_DEVICE_EVENT(65, "TSK_USER_DEVICE_EVENT", bundle.getString("BlackboardArtifact.tskUserDeviceEvent.text"), Category.DATA_ARTIFACT),
        TSK_YARA_HIT(66, "TSK_YARA_HIT", bundle.getString("BlackboardArtifact.tskYaraHit.text"), Category.ANALYSIS_RESULT),
        TSK_GPS_AREA(67, "TSK_GPS_AREA", bundle.getString("BlackboardArtifact.tskGPSArea.text"), Category.DATA_ARTIFACT),
        TSK_WEB_CATEGORIZATION(68, "TSK_WEB_CATEGORIZATION", bundle.getString("BlackboardArtifact.tskWebCategorization.text"), Category.ANALYSIS_RESULT),
        TSK_PREVIOUSLY_SEEN(69, "TSK_PREVIOUSLY_SEEN", bundle.getString("BlackboardArtifact.tskPreviouslySeen.text"), Category.ANALYSIS_RESULT),
        TSK_PREVIOUSLY_UNSEEN(70, "TSK_PREVIOUSLY_UNSEEN", bundle.getString("BlackboardArtifact.tskPreviouslyUnseen.text"), Category.ANALYSIS_RESULT),
        TSK_PREVIOUSLY_NOTABLE(71, "TSK_PREVIOUSLY_NOTABLE", bundle.getString("BlackboardArtifact.tskPreviouslyNotable.text"), Category.ANALYSIS_RESULT),
        TSK_INTERESTING_ITEM(72, "TSK_INTERESTING_ITEM", bundle.getString("BlackboardArtifact.tskInterestingItem.text"), Category.ANALYSIS_RESULT),
        TSK_MALWARE(73, "TSK_MALWARE", bundle.getString("BlackboardArtifact.tskMalware.text"), Category.ANALYSIS_RESULT);

        private final String label;
        private final int typeId;
        private final String displayName;
        private final Category category;

        private ARTIFACT_TYPE(int typeId, String label, String displayName) {
            this(typeId, label, displayName, Category.DATA_ARTIFACT);
        }

        private ARTIFACT_TYPE(int typeId, String label, String displayName, Category category) {
            this.typeId = typeId;
            this.label = label;
            this.displayName = displayName;
            this.category = category;
        }

        public int getTypeID() {
            return this.typeId;
        }

        public String getLabel() {
            return this.label;
        }

        public Category getCategory() {
            return this.category;
        }

        public static ARTIFACT_TYPE fromLabel(String label) {
            for (ARTIFACT_TYPE value : ARTIFACT_TYPE.values()) {
                if (!value.getLabel().equals(label)) continue;
                return value;
            }
            throw new IllegalArgumentException("No ARTIFACT_TYPE matching type: " + label);
        }

        public static ARTIFACT_TYPE fromID(int id) {
            for (ARTIFACT_TYPE value : ARTIFACT_TYPE.values()) {
                if (value.getTypeID() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No ARTIFACT_TYPE matching type: " + id);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public <T> T accept(SleuthkitItemVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static enum Category {
        DATA_ARTIFACT(0, "DATA_ARTIFACT", ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle").getString("CategoryType.DataArtifact")),
        ANALYSIS_RESULT(1, "ANALYSIS_RESULT", ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle").getString("CategoryType.AnalysisResult"));

        private final Integer id;
        private final String name;
        private final String displayName;
        private static final Map<Integer, Category> idToCategory;

        private Category(Integer id, String name, String displayName) {
            this.id = id;
            this.name = name;
            this.displayName = displayName;
        }

        public static Category fromID(int id) {
            return idToCategory.get(id);
        }

        public Integer getID() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        static {
            idToCategory = new HashMap<Integer, Category>();
            for (Category status : Category.values()) {
                idToCategory.put(status.getID(), status);
            }
        }
    }
}

