/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public final class CaseDbAccessManager {
    private static final Logger logger = Logger.getLogger(CaseDbAccessManager.class.getName());
    private final SleuthkitCase tskDB;

    CaseDbAccessManager(SleuthkitCase skCase) {
        this.tskDB = skCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(String tableName, String columnName) throws TskCoreException {
        boolean doesColumnExists = false;
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            doesColumnExists = this.columnExists(tableName, columnName, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
        return doesColumnExists;
    }

    public boolean columnExists(String tableName, String columnName, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        boolean columnExists;
        block13: {
            columnExists = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
                statement = connection.createStatement();
                if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
                    String tableInfoQuery = "PRAGMA table_info(%s)";
                    resultSet = statement.executeQuery(String.format(tableInfoQuery, tableName));
                    while (resultSet.next()) {
                        if (!resultSet.getString("name").equalsIgnoreCase(columnName)) continue;
                        columnExists = true;
                        break block13;
                    }
                    break block13;
                }
                String tableInfoQueryTemplate = "SELECT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='%s' AND column_name='%s')";
                resultSet = statement.executeQuery(String.format(tableInfoQueryTemplate, tableName.toLowerCase(), columnName.toLowerCase()));
                if (resultSet.next()) {
                    columnExists = resultSet.getBoolean(1);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error checking if column  " + columnName + "exists ", ex);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex2) {
                        logger.log(Level.WARNING, "Failed to to close resultset after checking column", ex2);
                    }
                }
                SleuthkitCase.closeStatement(statement);
            }
        }
        return columnExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws TskCoreException {
        boolean doesTableExist = false;
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            doesTableExist = this.tableExists(tableName, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
        return doesTableExist;
    }

    public boolean tableExists(String tableName, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        boolean tableExists;
        block13: {
            tableExists = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
                statement = connection.createStatement();
                if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
                    resultSet = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                    while (resultSet.next()) {
                        if (!resultSet.getString("name").equalsIgnoreCase(tableName)) continue;
                        tableExists = true;
                        break block13;
                    }
                    break block13;
                }
                String tableInfoQueryTemplate = "SELECT EXISTS (SELECT 1 FROM information_schema.tables WHERE table_name='%s')";
                resultSet = statement.executeQuery(String.format(tableInfoQueryTemplate, tableName.toLowerCase()));
                if (resultSet.next()) {
                    tableExists = resultSet.getBoolean(1);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error checking if table  " + tableName + "exists ", ex);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ex2) {
                        logger.log(Level.WARNING, "Failed to to close resultset after checking table", ex2);
                    }
                }
                SleuthkitCase.closeStatement(statement);
            }
        }
        return tableExists;
    }

    public void createTable(String tableName, String tableSchema) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(tableSchema);
        this.tskDB.acquireSingleUserCaseWriteLock();
        String createSQL = "CREATE TABLE IF NOT EXISTS " + tableName + " " + tableSchema;
        try (SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(createSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating table " + tableName, ex);
        }
        finally {
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTable(String tableName, String alterSQL) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            this.alterTable(tableName, alterSQL, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public void alterTable(String tableName, String alterSQL, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(alterSQL);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        Statement statement = null;
        String sql = "ALTER TABLE " + tableName + " " + alterSQL;
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        catch (SQLException ex) {
            if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType() && alterSQL.toLowerCase().contains("add column") && ex.getMessage().toLowerCase().contains("duplicate column name")) {
                logger.log(Level.WARNING, String.format("Column being added by SQL = %s already exists in table %s", alterSQL, tableName));
                return;
            }
            throw new TskCoreException(String.format("Error altering table  %s with SQL = %s", tableName, sql), ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
        }
    }

    public void createIndex(String indexName, String tableName, String colsSQL) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateIndexName(indexName);
        this.validateSQL(colsSQL);
        this.tskDB.acquireSingleUserCaseWriteLock();
        String indexSQL = "CREATE INDEX IF NOT EXISTS " + indexName + " ON " + tableName + " " + colsSQL;
        try (SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(indexSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating index " + tableName, ex);
        }
        finally {
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            long rowId = this.insert(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
            long l = rowId;
            return l;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public long insert(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        long rowId = 0L;
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        PreparedStatement statement = null;
        Object insertSQL = "INSERT";
        if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
            insertSQL = (String)insertSQL + " OR IGNORE";
        }
        insertSQL = (String)insertSQL + " INTO " + tableName + " " + sql;
        try {
            statement = connection.prepareStatement((String)insertSQL, 1);
            connection.executeUpdate(statement);
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                rowId = resultSet.getLong(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error inserting row in table " + tableName + " with sql = " + (String)insertSQL, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertOrUpdate(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            long rowId = this.insertOrUpdate(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
            long l = rowId;
            return l;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public long insertOrUpdate(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        long rowId = 0L;
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        PreparedStatement statement = null;
        Object insertSQL = "INSERT";
        if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
            insertSQL = (String)insertSQL + " OR REPLACE";
        }
        insertSQL = (String)insertSQL + " INTO " + tableName + " " + sql;
        try {
            statement = connection.prepareStatement((String)insertSQL, 1);
            connection.executeUpdate(statement);
            ResultSet resultSet = statement.getGeneratedKeys();
            resultSet.next();
            rowId = resultSet.getLong(1);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error inserting row in table " + tableName + " with sql = " + (String)insertSQL, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return rowId;
    }

    @Beta
    public CaseDbPreparedStatement prepareUpdate(String tableName, String sql, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        String updateSQL = "UPDATE " + tableName + " " + sql;
        try {
            return new CaseDbPreparedStatement(StatementType.UPDATE, updateSQL, trans);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating update prepared statement for query:\n" + updateSQL, ex);
        }
    }

    @Beta
    public void update(CaseDbPreparedStatement preparedStatement) throws TskCoreException {
        if (!preparedStatement.getType().equals((Object)StatementType.UPDATE)) {
            throw new TskCoreException("CaseDbPreparedStatement has incorrect type for update operation");
        }
        try {
            preparedStatement.getStatement().executeUpdate();
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating row in table  with sql = ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String tableName, String sql) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction localTrans = this.tskDB.beginTransaction();
        try {
            this.update(tableName, sql, localTrans);
            localTrans.commit();
            localTrans = null;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex);
                }
            }
        }
    }

    public void update(String tableName, String sql, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        Statement statement = null;
        String updateSQL = "UPDATE " + tableName + " " + sql;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(updateSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error Updating table " + tableName, ex);
        }
        finally {
            SleuthkitCase.closeStatement(statement);
        }
    }

    public void select(String sql, CaseDbAccessQueryCallback queryCallback) throws TskCoreException {
        if (queryCallback == null) {
            throw new TskCoreException("Callback is null");
        }
        this.validateSQL(sql);
        this.tskDB.acquireSingleUserCaseReadLock();
        String selectSQL = "SELECT " + sql;
        try (SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(selectSQL);){
            queryCallback.process(resultSet);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error running SELECT query.", ex);
        }
        finally {
            this.tskDB.releaseSingleUserCaseReadLock();
        }
    }

    @Beta
    public CaseDbPreparedStatement prepareSelect(String sql) throws TskCoreException {
        String selectSQL = "SELECT " + sql;
        try {
            return new CaseDbPreparedStatement(StatementType.SELECT, selectSQL, false);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating select prepared statement for query:\n" + selectSQL, ex);
        }
    }

    @Beta
    public CaseDbPreparedStatement prepareSelect(String sql, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        this.validateSQL(sql);
        String selectSQL = "SELECT " + sql;
        try {
            return new CaseDbPreparedStatement(StatementType.SELECT, selectSQL, trans);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating select prepared statement for query:\n" + selectSQL, ex);
        }
    }

    @Beta
    public void select(CaseDbPreparedStatement preparedStatement, CaseDbAccessQueryCallback queryCallback) throws TskCoreException {
        if (!preparedStatement.getType().equals((Object)StatementType.SELECT)) {
            throw new TskCoreException("CaseDbPreparedStatement has incorrect type for select operation");
        }
        try (ResultSet resultSet = preparedStatement.getStatement().executeQuery();){
            queryCallback.process(resultSet);
        }
        catch (SQLException ex) {
            throw new TskCoreException(MessageFormat.format("Error running SELECT query:\n{0}", preparedStatement.getOriginalSql()), ex);
        }
    }

    @Beta
    public void select(CaseDbPreparedStatement preparedStatement, boolean runOptimize, CaseDbAccessQueryCallback queryCallback) throws TskCoreException {
        if (runOptimize && this.tskDB.getDatabaseType() == TskData.DbType.SQLITE) {
            try (Statement optimizeStmt = preparedStatement.connection.createStatement();){
                optimizeStmt.execute("PRAGMA optimize");
            }
            catch (SQLException ex) {
                throw new TskCoreException("An error occurred while attempting to optimize the call", ex);
            }
        }
        this.select(preparedStatement, queryCallback);
    }

    @Beta
    public CaseDbPreparedStatement prepareInsert(String tableName, String sql, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        Object insertSQL = "INSERT";
        if (TskData.DbType.SQLITE == this.tskDB.getDatabaseType()) {
            insertSQL = (String)insertSQL + " OR IGNORE";
        }
        insertSQL = (String)insertSQL + " INTO " + tableName + " " + sql;
        try {
            return new CaseDbPreparedStatement(StatementType.INSERT, (String)insertSQL, trans);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error creating insert prepared statement for query:\n" + (String)insertSQL, ex);
        }
    }

    @Beta
    public void insert(CaseDbPreparedStatement preparedStatement) throws TskCoreException {
        if (!preparedStatement.getType().equals((Object)StatementType.INSERT)) {
            throw new TskCoreException("CaseDbPreparedStatement has incorrect type for insert operation");
        }
        try {
            preparedStatement.getStatement().executeUpdate();
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error inserting row in table  with sql = ", ex);
        }
    }

    public void delete(String tableName, String sql) throws TskCoreException {
        this.validateTableName(tableName);
        this.validateSQL(sql);
        this.tskDB.acquireSingleUserCaseWriteLock();
        String deleteSQL = "DELETE FROM " + tableName + " " + sql;
        try (SleuthkitCase.CaseDbConnection connection = this.tskDB.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(deleteSQL);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from table " + tableName, ex);
        }
        finally {
            this.tskDB.releaseSingleUserCaseWriteLock();
        }
    }

    private void validateTableName(String tableName) throws TskCoreException {
        if (SleuthkitCase.getCoreTableNames().contains(tableName.toLowerCase())) {
            throw new TskCoreException("Attempt to modify a core TSK table " + tableName);
        }
        if (tableName.toLowerCase().startsWith("tsk_")) {
            throw new TskCoreException("Modifying tables with tsk_ prefix is not allowed. ");
        }
    }

    private void validateIndexName(String indexName) throws TskCoreException {
        if (indexName.isEmpty()) {
            throw new TskCoreException("Invalid index name " + indexName);
        }
        if (SleuthkitCase.getCoreIndexNames().contains(indexName.toLowerCase())) {
            throw new TskCoreException("Attempt to modify a core TSK index " + indexName);
        }
    }

    private void validateSQL(String sql) throws TskCoreException {
    }

    @Beta
    public class CaseDbPreparedStatement
    implements AutoCloseable {
        private final SleuthkitCase.CaseDbConnection connection;
        private final PreparedStatement preparedStatement;
        private final String originalSql;
        private final LockType lockType;
        private final StatementType type;

        private CaseDbPreparedStatement(StatementType type, String query, boolean isWriteLockRequired) throws SQLException, TskCoreException {
            if (isWriteLockRequired) {
                CaseDbAccessManager.this.tskDB.acquireSingleUserCaseWriteLock();
                this.lockType = LockType.WRITE;
            } else {
                CaseDbAccessManager.this.tskDB.acquireSingleUserCaseReadLock();
                this.lockType = LockType.READ;
            }
            this.connection = CaseDbAccessManager.this.tskDB.getConnection();
            this.preparedStatement = this.connection.getPreparedStatement(query, 2);
            this.originalSql = query;
            this.type = type;
        }

        private CaseDbPreparedStatement(StatementType type, String query, SleuthkitCase.CaseDbTransaction trans) throws SQLException, TskCoreException {
            this.lockType = LockType.NONE;
            this.connection = trans.getConnection();
            this.preparedStatement = this.connection.getPreparedStatement(query, 2);
            this.originalSql = query;
            this.type = type;
        }

        private PreparedStatement getStatement() {
            return this.preparedStatement;
        }

        private StatementType getType() {
            return this.type;
        }

        private String getOriginalSql() {
            return this.originalSql;
        }

        public void reset() throws TskCoreException {
            try {
                this.preparedStatement.clearParameters();
            }
            catch (SQLException ex) {
                throw new TskCoreException("An error occurred while clearing parameters.", ex);
            }
        }

        public void setBoolean(int parameterIndex, boolean x) throws TskCoreException {
            try {
                this.preparedStatement.setBoolean(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setByte(int parameterIndex, byte x) throws TskCoreException {
            try {
                this.preparedStatement.setByte(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setInt(int parameterIndex, int x) throws TskCoreException {
            try {
                this.preparedStatement.setInt(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setLong(int parameterIndex, long x) throws TskCoreException {
            try {
                this.preparedStatement.setLong(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setDouble(int parameterIndex, double x) throws TskCoreException {
            try {
                this.preparedStatement.setDouble(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setString(int parameterIndex, String x) throws TskCoreException {
            try {
                this.preparedStatement.setString(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setDate(int parameterIndex, Date x) throws TskCoreException {
            try {
                this.preparedStatement.setDate(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setTime(int parameterIndex, Time x) throws TskCoreException {
            try {
                this.preparedStatement.setTime(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setTimestamp(int parameterIndex, Timestamp x) throws TskCoreException {
            try {
                this.preparedStatement.setTimestamp(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        public void setObject(int parameterIndex, Object x) throws TskCoreException {
            try {
                this.preparedStatement.setObject(parameterIndex, x);
            }
            catch (SQLException ex) {
                throw new TskCoreException(MessageFormat.format("There was an error setting the value at index: {0} to {1}", parameterIndex, x), ex);
            }
        }

        @Override
        public void close() throws SQLException {
            if (this.lockType.equals((Object)LockType.NONE)) {
                return;
            }
            this.connection.close();
            if (this.lockType.equals((Object)LockType.WRITE)) {
                CaseDbAccessManager.this.tskDB.releaseSingleUserCaseWriteLock();
            } else {
                CaseDbAccessManager.this.tskDB.releaseSingleUserCaseReadLock();
            }
        }
    }

    private static enum StatementType {
        SELECT,
        INSERT,
        UPDATE;

    }

    public static interface CaseDbAccessQueryCallback {
        public void process(ResultSet var1);
    }

    private static enum LockType {
        READ,
        WRITE,
        NONE;

    }
}

