/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.AccountDeviceInstance;
import org.sleuthkit.datamodel.AccountFileInstance;
import org.sleuthkit.datamodel.AccountPair;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CommManagerSqlStringUtils;
import org.sleuthkit.datamodel.CommunicationsFilter;
import org.sleuthkit.datamodel.CommunicationsUtils;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.InvalidAccountIDException;
import org.sleuthkit.datamodel.Relationship;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskDataException;

public final class CommunicationsManager {
    private static final Logger LOGGER = Logger.getLogger(CommunicationsManager.class.getName());
    private static final BlackboardArtifact.Type ACCOUNT_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT);
    private final SleuthkitCase db;
    private final Map<Account.Type, Integer> accountTypeToTypeIdMap = new ConcurrentHashMap<Account.Type, Integer>();
    private final Map<String, Account.Type> typeNameToAccountTypeMap = new ConcurrentHashMap<String, Account.Type>();
    private static final Set<Integer> RELATIONSHIP_ARTIFACT_TYPE_IDS = new HashSet<Integer>(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_CONTACT.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG.getTypeID()));
    private static final String RELATIONSHIP_ARTIFACT_TYPE_IDS_CSV_STR = CommManagerSqlStringUtils.buildCSVString(RELATIONSHIP_ARTIFACT_TYPE_IDS);

    CommunicationsManager(SleuthkitCase skCase) throws TskCoreException {
        this.db = skCase;
        this.initAccountTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAccountTypes() throws TskCoreException {
        block32: {
            this.db.acquireSingleUserCaseWriteLock();
            try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
                 Statement statement = connection.createStatement();){
                int count = this.readAccountTypes();
                if (0 != count) break block32;
                for (Account.Type type : Account.Type.PREDEFINED_ACCOUNT_TYPES) {
                    try {
                        statement.execute("INSERT INTO account_types (type_name, display_name) VALUES ( '" + type.getTypeName() + "', '" + type.getDisplayName() + "')");
                    }
                    catch (SQLException ex) {
                        try (ResultSet resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM account_types WHERE type_name = '" + type.getTypeName() + "'");){
                            resultSet.next();
                            if (resultSet.getLong("count") == 0L) {
                                throw ex;
                            }
                        }
                    }
                    ResultSet rs2 = connection.executeQuery(statement, "SELECT account_type_id FROM account_types WHERE type_name = '" + type.getTypeName() + "'");
                    try {
                        rs2.next();
                        int typeID = rs2.getInt("account_type_id");
                        Account.Type accountType = new Account.Type(type.getTypeName(), type.getDisplayName());
                        this.accountTypeToTypeIdMap.put(accountType, typeID);
                        this.typeNameToAccountTypeMap.put(type.getTypeName(), accountType);
                    }
                    finally {
                        if (rs2 == null) continue;
                        rs2.close();
                    }
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Failed to add row to account_types", ex);
            }
            finally {
                this.db.releaseSingleUserCaseWriteLock();
            }
        }
    }

    private int readAccountTypes() throws TskCoreException {
        SleuthkitCase.CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int count = 0;
        this.db.acquireSingleUserCaseReadLock();
        try {
            connection = this.db.getConnection();
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM account_types");
            resultSet.next();
            if (resultSet.getLong("count") > 0L) {
                resultSet.close();
                resultSet = connection.executeQuery(statement, "SELECT * FROM account_types");
                while (resultSet.next()) {
                    Account.Type accountType = new Account.Type(resultSet.getString("type_name"), resultSet.getString("display_name"));
                    this.accountTypeToTypeIdMap.put(accountType, resultSet.getInt("account_type_id"));
                    this.typeNameToAccountTypeMap.put(accountType.getTypeName(), accountType);
                }
                count = this.typeNameToAccountTypeMap.size();
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to read account_types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.db.releaseSingleUserCaseReadLock();
        return count;
    }

    SleuthkitCase getSleuthkitCase() {
        return this.db;
    }

    public Account.Type addAccountType(String accountTypeName, String displayName) throws TskCoreException {
        Account.Type type;
        ResultSet rs;
        Statement s;
        SleuthkitCase.CaseDbTransaction trans;
        Account.Type accountType;
        block6: {
            accountType = new Account.Type(accountTypeName, displayName);
            if (this.accountTypeToTypeIdMap.containsKey(accountType)) {
                return accountType;
            }
            trans = this.db.beginTransaction();
            s = null;
            rs = null;
            s = trans.getConnection().createStatement();
            rs = trans.getConnection().executeQuery(s, "SELECT * FROM account_types WHERE type_name = '" + accountTypeName + "'");
            if (rs.next()) break block6;
            rs.close();
            s.execute("INSERT INTO account_types (type_name, display_name) VALUES ( '" + accountTypeName + "', '" + displayName + "')");
            rs = trans.getConnection().executeQuery(s, "SELECT * FROM account_types WHERE type_name = '" + accountTypeName + "'");
            rs.next();
            int typeID = rs.getInt("account_type_id");
            accountType = new Account.Type(rs.getString("type_name"), rs.getString("display_name"));
            this.accountTypeToTypeIdMap.put(accountType, typeID);
            this.typeNameToAccountTypeMap.put(accountTypeName, accountType);
            trans.commit();
            Account.Type type2 = accountType;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            return type2;
        }
        try {
            int typeID = rs.getInt("account_type_id");
            accountType = new Account.Type(rs.getString("type_name"), rs.getString("display_name"));
            this.accountTypeToTypeIdMap.put(accountType, typeID);
            type = accountType;
        }
        catch (SQLException ex) {
            try {
                trans.rollback();
                throw new TskCoreException("Error adding account type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        return type;
    }

    public AccountFileInstance createAccountFileInstance(Account.Type accountType, String accountUniqueID, String moduleName, Content sourceFile, List<BlackboardAttribute> attributes, Long ingestJobId) throws TskCoreException, InvalidAccountIDException {
        Account account = this.getOrCreateAccount(accountType, this.normalizeAccountID(accountType, accountUniqueID));
        BlackboardArtifact accountArtifact = this.getOrCreateAccountFileInstanceArtifact(accountType, this.normalizeAccountID(accountType, accountUniqueID), moduleName, sourceFile, attributes, ingestJobId);
        return new AccountFileInstance(accountArtifact, account);
    }

    @Deprecated
    public AccountFileInstance createAccountFileInstance(Account.Type accountType, String accountUniqueID, String moduleName, Content sourceFile) throws TskCoreException, InvalidAccountIDException {
        return this.createAccountFileInstance(accountType, accountUniqueID, moduleName, sourceFile, null, null);
    }

    public Account getAccount(Account.Type accountType, String accountUniqueID) throws TskCoreException, InvalidAccountIDException {
        Account account = null;
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = connection.executeQuery(s, "SELECT * FROM accounts WHERE account_type_id = " + this.getAccountTypeId(accountType) + " AND account_unique_identifier = '" + this.normalizeAccountID(accountType, accountUniqueID) + "'");){
            if (rs.next()) {
                account = new Account(rs.getInt("account_id"), accountType, rs.getString("account_unique_identifier"));
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting account type id", ex);
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return account;
    }

    public void addRelationships(AccountFileInstance sender, List<AccountFileInstance> recipients, BlackboardArtifact sourceArtifact, Relationship.Type relationshipType, long dateTime) throws TskCoreException, TskDataException {
        if (sourceArtifact.getDataSourceObjectID() == null) {
            throw new TskDataException("Source Artifact does not have a valid data source.");
        }
        if (!relationshipType.isCreatableFrom(sourceArtifact)) {
            throw new TskDataException("Can not make a " + relationshipType.getDisplayName() + " relationship from a" + sourceArtifact.getDisplayName());
        }
        ArrayList<Long> accountIDs = new ArrayList<Long>();
        if (null != sender) {
            accountIDs.add(sender.getAccount().getAccountID());
            if (!sender.getDataSourceObjectID().equals(sourceArtifact.getDataSourceObjectID())) {
                throw new TskDataException("Sender and relationship are from different data sources :Sender source ID" + sender.getDataSourceObjectID() + " != relationship source ID" + sourceArtifact.getDataSourceObjectID());
            }
        }
        for (AccountFileInstance recipient : recipients) {
            accountIDs.add(recipient.getAccount().getAccountID());
            if (recipient.getDataSourceObjectID().equals(sourceArtifact.getDataSourceObjectID())) continue;
            throw new TskDataException("Recipient and relationship are from different data sources :Recipient source ID" + recipient.getDataSourceObjectID() + " != relationship source ID" + sourceArtifact.getDataSourceObjectID());
        }
        Object query = "INTO account_relationships (account1_id, account2_id, relationship_source_obj_id, date_time, relationship_type, data_source_obj_id  ) VALUES (?,?,?,?,?,?)";
        switch (this.db.getDatabaseType()) {
            case POSTGRESQL: {
                query = "INSERT " + (String)query + " ON CONFLICT DO NOTHING";
                break;
            }
            case SQLITE: {
                query = "INSERT OR IGNORE " + (String)query;
                break;
            }
            default: {
                throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
            }
        }
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            SleuthkitCase.CaseDbConnection connection = trans.getConnection();
            PreparedStatement preparedStatement = connection.getPreparedStatement((String)query, 2);
            for (int i = 0; i < accountIDs.size(); ++i) {
                for (int j = i + 1; j < accountIDs.size(); ++j) {
                    long account1_id = (Long)accountIDs.get(i);
                    long account2_id = (Long)accountIDs.get(j);
                    preparedStatement.clearParameters();
                    preparedStatement.setLong(1, account1_id);
                    preparedStatement.setLong(2, account2_id);
                    preparedStatement.setLong(3, sourceArtifact.getId());
                    if (dateTime > 0L) {
                        preparedStatement.setLong(4, dateTime);
                    } else {
                        preparedStatement.setNull(4, -5);
                    }
                    preparedStatement.setInt(5, relationshipType.getTypeID());
                    preparedStatement.setLong(6, sourceArtifact.getDataSourceObjectID());
                    connection.executeUpdate(preparedStatement);
                }
            }
            trans.commit();
        }
        catch (SQLException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding accounts relationship", ex);
        }
    }

    private Account getOrCreateAccount(Account.Type accountType, String accountUniqueID) throws TskCoreException, InvalidAccountIDException {
        Account account = this.getAccount(accountType, accountUniqueID);
        if (null == account) {
            String query = " INTO accounts (account_type_id, account_unique_identifier) VALUES ( " + this.getAccountTypeId(accountType) + ", '" + this.normalizeAccountID(accountType, accountUniqueID) + "')";
            switch (this.db.getDatabaseType()) {
                case POSTGRESQL: {
                    query = "INSERT " + query + " ON CONFLICT DO NOTHING";
                    break;
                }
                case SQLITE: {
                    query = "INSERT OR IGNORE " + query;
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
                }
            }
            SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
            Statement s = null;
            ResultSet rs = null;
            try {
                s = trans.getConnection().createStatement();
                s.execute(query);
                trans.commit();
                account = this.getAccount(accountType, accountUniqueID);
            }
            catch (SQLException ex) {
                trans.rollback();
                throw new TskCoreException("Error adding an account", ex);
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
            }
        }
        return account;
    }

    private BlackboardArtifact getOrCreateAccountFileInstanceArtifact(Account.Type accountType, String accountUniqueID, String moduleName, Content sourceFile, List<BlackboardAttribute> originalAttrs, Long ingestJobId) throws TskCoreException {
        if (sourceFile == null) {
            throw new TskCoreException("Source file not provided.");
        }
        BlackboardArtifact accountArtifact = this.getAccountFileInstanceArtifact(accountType, accountUniqueID, sourceFile);
        if (accountArtifact == null) {
            ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
            attributes.add(new BlackboardAttribute(BlackboardAttribute.Type.TSK_ACCOUNT_TYPE, moduleName, accountType.getTypeName()));
            attributes.add(new BlackboardAttribute(BlackboardAttribute.Type.TSK_ID, moduleName, accountUniqueID));
            if (originalAttrs != null) {
                attributes.addAll(originalAttrs);
            }
            accountArtifact = sourceFile.newDataArtifact(ACCOUNT_TYPE, attributes);
            try {
                this.db.getBlackboard().postArtifact(accountArtifact, moduleName, ingestJobId);
            }
            catch (Blackboard.BlackboardException ex) {
                LOGGER.log(Level.SEVERE, String.format("Error posting new account artifact to the blackboard (object ID = %d)", accountArtifact.getId()), ex);
            }
        }
        return accountArtifact;
    }

    private BlackboardArtifact getAccountFileInstanceArtifact(Account.Type accountType, String accountUniqueID, Content sourceFile) throws TskCoreException {
        DataArtifact accountArtifact = null;
        String queryStr = "SELECT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id, artifacts.review_status_id AS review_status_id, tsk_data_artifacts.os_account_obj_id AS os_account_obj_id FROM blackboard_artifacts AS artifacts\tJOIN blackboard_attributes AS attr_account_type\t\tON artifacts.artifact_id = attr_account_type.artifact_id JOIN blackboard_attributes AS attr_account_id\t\tON artifacts.artifact_id = attr_account_id.artifact_id\t\tAND attr_account_id.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ID.getTypeID() + "\t    AND attr_account_id.value_text = '" + accountUniqueID + "' LEFT JOIN tsk_data_artifacts ON tsk_data_artifacts.artifact_obj_id = artifacts.artifact_obj_id WHERE artifacts.artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT.getTypeID() + " AND attr_account_type.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ACCOUNT_TYPE.getTypeID() + " AND attr_account_type.value_text = '" + accountType.getTypeName() + "' AND artifacts.obj_id = " + sourceFile.getId();
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = connection.executeQuery(s, queryStr);){
            if (rs.next()) {
                BlackboardArtifact.Type bbartType = this.db.getBlackboard().getArtifactType(rs.getInt("artifact_type_id"));
                accountArtifact = new DataArtifact(this.db, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getObject("data_source_obj_id") != null ? Long.valueOf(rs.getLong("data_source_obj_id")) : null, bbartType.getTypeID(), bbartType.getTypeName(), bbartType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id")), rs.getLong("os_account_obj_id"), false);
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting account", ex);
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return accountArtifact;
    }

    /*
     * Exception decompiling
     */
    public Account.Type getAccountType(String accountTypeName) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AccountDeviceInstance> getAccountDeviceInstancesWithRelationships(CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<AccountPair, Long> getRelationshipCountsPairwise(Set<AccountDeviceInstance> accounts, CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getRelationshipSourcesCount(AccountDeviceInstance accountDeviceInstance, CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<Content> getRelationshipSources(Set<AccountDeviceInstance> accountDeviceInstanceList, CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AccountDeviceInstance> getRelatedAccountDeviceInstances(AccountDeviceInstance accountDeviceInstance, CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Content> getRelationshipSources(AccountDeviceInstance account1, AccountDeviceInstance account2, CommunicationsFilter filter) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<AccountFileInstance> getAccountFileInstances(Account account) throws TskCoreException {
        ArrayList<AccountFileInstance> accountFileInstanceList = new ArrayList<AccountFileInstance>();
        List<BlackboardArtifact> artifactList = this.getSleuthkitCase().getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT, BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ID, account.getTypeSpecificID());
        if (artifactList != null && !artifactList.isEmpty()) {
            for (BlackboardArtifact artifact : artifactList) {
                accountFileInstanceList.add(new AccountFileInstance(artifact, account));
            }
        }
        if (!accountFileInstanceList.isEmpty()) {
            return accountFileInstanceList;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public List<Account.Type> getAccountTypesInUse() throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Account> getAccountsRelatedToArtifact(BlackboardArtifact artifact) throws TskCoreException {
        if (artifact == null) {
            throw new IllegalArgumentException("null arugment passed to getAccountsRelatedToArtifact");
        }
        ArrayList<Account> accountList = new ArrayList<Account>();
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            try {
                String query = String.format("SELECT DISTINCT (account_id), account_type_id, account_unique_identifier\tFROM ( SELECT DISTINCT (account_id), account_type_id, account_unique_identifier FROM accounts JOIN account_relationships ON account1_id = account_id WHERE relationship_source_obj_id = %d UNION  SELECT DISTINCT (account_id), account_type_id, account_unique_identifier FROM accounts JOIN account_relationships ON account2_id = account_id WHERE relationship_source_obj_id = %d) AS unionOfRelationships", artifact.getId(), artifact.getId());
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery(query);){
                    while (rs.next()) {
                        Account.Type accountType = null;
                        int accountTypeId = rs.getInt("account_type_id");
                        for (Map.Entry<Account.Type, Integer> entry : this.accountTypeToTypeIdMap.entrySet()) {
                            if (entry.getValue() != accountTypeId) continue;
                            accountType = entry.getKey();
                            break;
                        }
                        accountList.add(new Account(rs.getInt("account_id"), accountType, rs.getString("account_unique_identifier")));
                    }
                }
                catch (SQLException ex) {
                    throw new TskCoreException("Unable to get account list for give artifact " + artifact.getId(), ex);
                }
            }
            finally {
                this.db.releaseSingleUserCaseReadLock();
            }
        }
        return accountList;
    }

    int getAccountTypeId(Account.Type accountType) {
        if (this.accountTypeToTypeIdMap.containsKey(accountType)) {
            return this.accountTypeToTypeIdMap.get(accountType);
        }
        return 0;
    }

    private String normalizeAccountID(Account.Type accountType, String accountUniqueID) throws InvalidAccountIDException {
        if (accountUniqueID == null || accountUniqueID.isEmpty()) {
            throw new InvalidAccountIDException("Account id is null or empty.");
        }
        String normalizedAccountID = accountType.equals(Account.Type.PHONE) ? CommunicationsUtils.normalizePhoneNum(accountUniqueID) : (accountType.equals(Account.Type.EMAIL) ? CommunicationsUtils.normalizeEmailAddress(accountUniqueID) : accountUniqueID.toLowerCase().trim());
        return normalizedAccountID;
    }

    private String getCommunicationsFilterSQL(CommunicationsFilter commFilter, Set<String> applicableFilters) {
        if (null == commFilter || commFilter.getAndFilters().isEmpty()) {
            return "";
        }
        Object sqlStr = "";
        StringBuilder sqlSB = new StringBuilder();
        boolean first = true;
        for (CommunicationsFilter.SubFilter subFilter : commFilter.getAndFilters()) {
            String subfilterSQL;
            if (!applicableFilters.contains(subFilter.getClass().getName()) || (subfilterSQL = subFilter.getSQL(this)).isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sqlSB.append(" AND ");
            }
            sqlSB.append("( ");
            sqlSB.append(subfilterSQL);
            sqlSB.append(" )");
        }
        if (!sqlSB.toString().isEmpty()) {
            sqlStr = "( " + sqlSB.toString() + " )";
        }
        return sqlStr;
    }

    private String getMostRecentFilterLimitSQL(CommunicationsFilter filter) {
        String limitStr = "";
        if (filter != null && !filter.getAndFilters().isEmpty()) {
            for (CommunicationsFilter.SubFilter subFilter : filter.getAndFilters()) {
                if (!subFilter.getClass().getName().equals(CommunicationsFilter.MostRecentFilter.class.getName())) continue;
                limitStr = subFilter.getSQL(this);
                break;
            }
        }
        return limitStr;
    }

    private List<BlackboardArtifact> getDataArtifactsFromResult(ResultSet resultSet) throws SQLException, TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        while (resultSet.next()) {
            BlackboardArtifact.Type bbartType = this.db.getBlackboard().getArtifactType(resultSet.getInt("artifact_type_id"));
            artifacts.add(new DataArtifact(this.db, resultSet.getLong("artifact_id"), resultSet.getLong("obj_id"), resultSet.getLong("artifact_obj_id"), resultSet.getObject("data_source_obj_id") != null ? Long.valueOf(resultSet.getLong("data_source_obj_id")) : null, bbartType.getTypeID(), bbartType.getTypeName(), bbartType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(resultSet.getInt("review_status_id")), resultSet.getLong("os_account_obj_id"), false));
        }
        return artifacts;
    }
}

