/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Attribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public abstract class FsContent
extends AbstractFile {
    private static final Logger logger = Logger.getLogger(FsContent.class.getName());
    private List<String> metaDataText = null;
    @Deprecated
    protected volatile long fileHandle = 0L;

    FsContent(SleuthkitCase db, long objId, long dataSourceObjectId, long fsObjId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String extension, String ownerUid, Long osAccountObjId, TskData.CollectedStatus collected, List<Attribute> fileAttributes) {
        super(db, objId, dataSourceObjectId, fsObjId, attrType, attrId, name, fileType, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, sha256Hash, sha1Hash, knownState, parentPath, mimeType, extension, ownerUid, osAccountObjId, collected, fileAttributes);
    }

    public long getFileSystemId() {
        return this.getFileSystemObjectId().orElse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFileHandle() throws TskCoreException {
        if (this.fileHandle == 0L) {
            FsContent fsContent = this;
            synchronized (fsContent) {
                if (this.fileHandle == 0L) {
                    this.fileHandle = SleuthkitJNI.openFile(this.getFileSystem().getFileSystemHandle(), this.metaAddr, this.attrType, this.attrId, this.getSleuthkitCase());
                }
            }
        }
    }

    long getFileHandle() {
        return this.fileHandle;
    }

    @Override
    protected synchronized int readInt(byte[] buf, long offset, long len) throws TskCoreException {
        if (offset == 0L && this.size == 0L) {
            return 0;
        }
        Content dataSource = this.getDataSource();
        if (dataSource instanceof Image && ArrayUtils.isEmpty((Object[])((Image)dataSource).getPaths())) {
            return 0;
        }
        this.loadFileHandle();
        return SleuthkitJNI.readFile(this.fileHandle, buf, offset, len);
    }

    @Override
    public boolean isRoot() {
        try {
            FileSystem fs = this.getFileSystem();
            return fs.getRoot_inum() == this.getMetaAddr();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Exception while calling 'getFileSystem' on " + String.valueOf(this), ex);
            return false;
        }
    }

    public AbstractFile getParentDirectory() throws TskCoreException {
        return this.getSleuthkitCase().getParentDirectory(this);
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        return this.getFileSystem().getDataSource();
    }

    public synchronized List<String> getMetaDataText() throws TskCoreException {
        if (this.metaDataText != null) {
            return this.metaDataText;
        }
        if (this.metaAddr == 0L) {
            this.metaDataText = new ArrayList<String>();
            this.metaDataText.add("");
            return this.metaDataText;
        }
        this.loadFileHandle();
        this.metaDataText = SleuthkitJNI.getFileMetaDataText(this.fileHandle);
        return this.metaDataText;
    }

    @Override
    public synchronized void close() {
        if (this.fileHandle != 0L) {
            SleuthkitJNI.closeFile(this.fileHandle);
            this.fileHandle = 0L;
        }
    }

    @Override
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String toString(boolean preserveState) {
        String path = "";
        try {
            path = this.getUniquePath();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error loading unique path for object ID: {0}", this.getId());
        }
        return super.toString(preserveState) + "FsContent [\tfsObjId " + this.getFileSystemId() + "\tuniquePath " + path + "\tfileHandle " + this.getFileHandle() + "]\t";
    }

    @Deprecated
    FsContent(SleuthkitCase db, long objId, long fsObjId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, short attrId, String name, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, TskData.FileKnown knownState, String parentPath) {
        this(db, objId, db.getDataSourceObjectId(objId), fsObjId, attrType, (int)attrId, name, TskData.TSK_DB_FILES_TYPE_ENUM.FS, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, (String)null, (String)null, knownState, parentPath, (String)null, (String)null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT, Collections.emptyList());
    }

    @Deprecated
    FsContent(SleuthkitCase db, long objId, long dataSourceObjectId, long fsObjId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, short attrId, String name, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, TskData.FileKnown knownState, String parentPath, String mimeType) {
        this(db, objId, dataSourceObjectId, fsObjId, attrType, (int)attrId, name, TskData.TSK_DB_FILES_TYPE_ENUM.FS, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, (String)null, (String)null, knownState, parentPath, mimeType, (String)null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT, Collections.emptyList());
    }

    @Deprecated
    FsContent(SleuthkitCase db, long objId, long dataSourceObjectId, long fsObjId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String extension, String ownerUid, Long osAccountObjId, List<Attribute> fileAttributes) {
        this(db, objId, dataSourceObjectId, fsObjId, attrType, attrId, name, TskData.TSK_DB_FILES_TYPE_ENUM.FS, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, (String)null, (String)null, knownState, parentPath, mimeType, (String)null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT, TskData.CollectedStatus.UNKNOWN, Collections.emptyList());
    }
}

