/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.TskCoreException;

public class HashUtility {
    private static final int BUFFER_SIZE = 16384;

    public static List<HashResult> calculateHashes(Content content, Collection<HashType> hashTypes) throws TskCoreException {
        HashMap<HashType, MessageDigest> digests = new HashMap<HashType, MessageDigest>();
        for (HashType type : hashTypes) {
            try {
                digests.put(type, MessageDigest.getInstance(type.getName()));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new TskCoreException("No algorithm found matching name " + type.getName(), ex);
            }
        }
        byte[] data = new byte[16384];
        int totalChunks = (int)Math.ceil((double)content.getSize() / 16384.0);
        for (long i = 0L; i < (long)totalChunks; ++i) {
            int read;
            try {
                read = content.read(data, i * 16384L, 16384L);
            }
            catch (TskCoreException ex) {
                throw new TskCoreException("Error reading data at address " + i * 16384L + " from content with ID: " + content.getId(), ex);
            }
            if (read == -1) break;
            if (read == 16384) {
                for (HashType hashType : hashTypes) {
                    ((MessageDigest)digests.get((Object)hashType)).update(data);
                }
                continue;
            }
            byte[] subData = Arrays.copyOfRange(data, 0, read);
            for (HashType type3 : hashTypes) {
                ((MessageDigest)digests.get((Object)type3)).update(subData);
            }
        }
        ArrayList<HashResult> results = new ArrayList<HashResult>();
        for (HashType type : hashTypes) {
            byte[] byArray = ((MessageDigest)digests.get((Object)type)).digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : byArray) {
                sb.append(String.format("%02x", b));
            }
            results.add(new HashResult(type, sb.toString()));
        }
        return results;
    }

    public static boolean isValidMd5Hash(String md5Hash) {
        return md5Hash.matches("^[A-Fa-f0-9]{32}$");
    }

    public static boolean isValidSha1Hash(String sha1Hash) {
        return sha1Hash.matches("^[A-Fa-f0-9]{40}$");
    }

    public static boolean isValidSha256Hash(String sha256Hash) {
        return sha256Hash.matches("^[A-Fa-f0-9]{64}$");
    }

    public static boolean isNoDataMd5(String md5) {
        return md5.toLowerCase().equals("d41d8cd98f00b204e9800998ecf8427e");
    }

    @Deprecated
    public static String calculateMd5(AbstractFile file) throws IOException {
        Logger logger = Logger.getLogger(HashUtility.class.getName());
        String md5Hash = HashUtility.calculateMd5Hash(file);
        try {
            file.getSleuthkitCase().setMd5Hash(file, md5Hash);
        }
        catch (TskCoreException ex) {
            logger.log(Level.WARNING, "Error updating content's md5 in database", ex);
        }
        return md5Hash;
    }

    @Deprecated
    public static String calculateMd5Hash(Content content) throws IOException {
        try {
            List<HashResult> results = HashUtility.calculateHashes(content, Arrays.asList(HashType.MD5));
            return results.stream().filter(result -> result.getType().equals((Object)HashType.MD5)).findFirst().get().getValue();
        }
        catch (TskCoreException ex) {
            throw new IOException(ex);
        }
    }

    public static enum HashType {
        MD5("MD5"),
        SHA256("SHA-256");

        private final String name;

        private HashType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    public static class HashResult {
        private final HashType type;
        private final String value;

        public HashResult(HashType type, String value) {
            this.type = type;
            this.value = value;
        }

        public HashType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

