/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.LibraryUtils;

public class LibraryLock
implements AutoCloseable {
    private static final String LIB_FILE_LOCK_TEXT = "lib_lock";
    private static final String TMP_DIR_KEY = "java.io.tmpdir";
    private static final String USER_NAME_KEY = "user.name";
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static LibraryLock libLock = null;
    private File libTskJniFile;
    private RandomAccessFile lockFileRaf;
    private FileChannel lockFileChannel;
    private FileLock lockFileLock;
    private LockState lockState;

    public static LibraryLock acquireLibLock() {
        if (libLock == null) {
            libLock = LibraryLock.getLibLock();
        }
        return libLock;
    }

    public static void removeLibLock() throws Exception {
        if (libLock != null) {
            libLock.close();
        }
    }

    private static LibraryLock getLibLock() {
        File libTskJniFile = LibraryUtils.getTempFile(System.getProperty(TMP_DIR_KEY, ""), LibraryUtils.Lib.TSK_JNI.getLibName(), System.getProperty(USER_NAME_KEY, ""), LibraryUtils.getExtByPlatform());
        if (libTskJniFile.isFile() && !libTskJniFile.canWrite()) {
            LibraryLock libraryLock;
            RandomAccessFile lockFileRaf = new RandomAccessFile(libTskJniFile, "r");
            try {
                LockState lockState = LibraryLock.isNewLock(lockFileRaf) ? LockState.HELD_BY_NEW : LockState.HELD_BY_OLD;
                libraryLock = new LibraryLock(lockState, libTskJniFile, lockFileRaf, null, null);
            }
            catch (Throwable lockState) {
                try {
                    try {
                        lockFileRaf.close();
                    }
                    catch (Throwable throwable) {
                        lockState.addSuppressed(throwable);
                    }
                    throw lockState;
                }
                catch (IOException ex) {
                    Logger.getLogger(LibraryLock.class.getCanonicalName()).log(Level.WARNING, "An error occurred while acquiring the TSK lib lock", ex);
                    return new LibraryLock(LockState.HELD_BY_OLD, libTskJniFile, null, null, null);
                }
            }
            lockFileRaf.close();
            return libraryLock;
        }
        libTskJniFile.getParentFile().mkdirs();
        RandomAccessFile lockFileRaf = null;
        FileChannel lockFileChannel = null;
        FileLock lockFileLock = null;
        try {
            lockFileRaf = new RandomAccessFile(libTskJniFile, "rw");
            lockFileChannel = lockFileRaf.getChannel();
            FileLock fileLock = lockFileLock = lockFileChannel == null ? null : lockFileChannel.tryLock(1024L, 1L, false);
            if (lockFileLock != null) {
                lockFileRaf.setLength(0L);
                lockFileRaf.write(UTF8_BOM);
                lockFileRaf.writeChars(LIB_FILE_LOCK_TEXT);
                return new LibraryLock(LockState.ACQUIRED, libTskJniFile, lockFileRaf, lockFileChannel, lockFileLock);
            }
            LockState lockState = LibraryLock.isNewLock(lockFileRaf) ? LockState.HELD_BY_NEW : LockState.HELD_BY_OLD;
            return new LibraryLock(lockState, libTskJniFile, lockFileRaf, lockFileChannel, null);
        }
        catch (IOException ex) {
            Logger.getLogger(LibraryLock.class.getCanonicalName()).log(Level.WARNING, "An error occurred while acquiring the TSK lib lock", ex);
            return new LibraryLock(LockState.HELD_BY_OLD, libTskJniFile, lockFileRaf, lockFileChannel, lockFileLock);
        }
    }

    private static boolean isNewLock(RandomAccessFile libRaf) throws IOException {
        libRaf.seek(0L);
        byte[] startFileArr = new byte[UTF8_BOM.length];
        int read = libRaf.read(startFileArr);
        return read == startFileArr.length && Arrays.equals(UTF8_BOM, startFileArr);
    }

    private LibraryLock(LockState lockState, File lockFile, RandomAccessFile lockFileRaf, FileChannel lockFileChannel, FileLock lockFileLock) {
        this.libTskJniFile = lockFile;
        this.lockFileRaf = lockFileRaf;
        this.lockFileChannel = lockFileChannel;
        this.lockFileLock = lockFileLock;
        this.lockState = lockState;
    }

    public LockState getLockState() {
        return this.lockState;
    }

    public File getLibTskJniFile() {
        return this.libTskJniFile;
    }

    @Override
    public void close() throws Exception {
        if (this.lockFileLock != null) {
            this.lockFileLock.close();
            this.lockFileLock = null;
        }
        if (this.lockFileChannel != null) {
            this.lockFileChannel.close();
            this.lockFileChannel = null;
        }
        if (this.lockFileRaf != null) {
            this.lockFileRaf.close();
            this.lockFileRaf = null;
        }
        if (this.libTskJniFile != null) {
            this.libTskJniFile.delete();
            this.libTskJniFile = null;
        }
    }

    public static enum LockState {
        HELD_BY_OLD,
        HELD_BY_NEW,
        ACQUIRED;

    }
}

