/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.Objects;
import java.util.ResourceBundle;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskDataException;

public class OsAccountInstance
implements Comparable<OsAccountInstance> {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final SleuthkitCase skCase;
    private final long instanceId;
    private final long accountId;
    private final long dataSourceId;
    private final OsAccountInstanceType instanceType;
    private OsAccount account;
    private DataSource dataSource;

    OsAccountInstance(SleuthkitCase skCase, long instanceId, OsAccount account, long dataSourceId, OsAccountInstanceType instanceType) {
        this(skCase, instanceId, account.getId(), dataSourceId, instanceType);
        this.account = account;
    }

    OsAccountInstance(SleuthkitCase skCase, long instanceId, long accountObjId, long dataSourceObjId, OsAccountInstanceType instanceType) {
        this.skCase = skCase;
        this.instanceId = instanceId;
        this.accountId = accountObjId;
        this.dataSourceId = dataSourceObjId;
        this.instanceType = instanceType;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public OsAccount getOsAccount() throws TskCoreException {
        if (this.account == null) {
            try {
                this.account = this.skCase.getOsAccountManager().getOsAccountByObjectId(this.accountId);
            }
            catch (TskCoreException ex) {
                throw new TskCoreException(String.format("Failed to get OsAccount for id %d", this.accountId), ex);
            }
        }
        return this.account;
    }

    public DataSource getDataSource() throws TskCoreException {
        if (this.dataSource == null) {
            try {
                this.dataSource = this.skCase.getDataSource(this.dataSourceId);
            }
            catch (TskDataException ex) {
                throw new TskCoreException(String.format("Failed to get DataSource for id %d", this.dataSourceId), ex);
            }
        }
        return this.dataSource;
    }

    public OsAccountInstanceType getInstanceType() {
        return this.instanceType;
    }

    private long getDataSourceId() {
        return this.dataSourceId;
    }

    @Override
    public int compareTo(OsAccountInstance other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.dataSourceId != other.getDataSourceId()) {
            return Long.compare(this.dataSourceId, other.getDataSourceId());
        }
        return Long.compare(this.accountId, other.accountId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OsAccountInstance other = (OsAccountInstance)obj;
        if (this.instanceId != other.instanceId) {
            return false;
        }
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.instanceType != other.instanceType) {
            return false;
        }
        return this.dataSourceId == other.getDataSourceId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.instanceId);
        hash = 67 * hash + Objects.hashCode(this.dataSourceId);
        hash = 67 * hash + Objects.hashCode(this.accountId);
        hash = 67 * hash + Objects.hashCode((Object)this.instanceType);
        return hash;
    }

    public static enum OsAccountInstanceType {
        LAUNCHED(0, bundle.getString("OsAccountInstanceType.Launched.text"), bundle.getString("OsAccountInstanceType.Launched.descr.text")),
        ACCESSED(1, bundle.getString("OsAccountInstanceType.Accessed.text"), bundle.getString("OsAccountInstanceType.Accessed.descr.text")),
        REFERENCED(2, bundle.getString("OsAccountInstanceType.Referenced.text"), bundle.getString("OsAccountInstanceType.Referenced.descr.text"));

        private final int id;
        private final String name;
        private final String description;

        private OsAccountInstanceType(int id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static OsAccountInstanceType fromID(int typeId) {
            for (OsAccountInstanceType statusType : OsAccountInstanceType.values()) {
                if (statusType.ordinal() != typeId) continue;
                return statusType;
            }
            return null;
        }

        public static OsAccountInstanceType fromString(String name) {
            return Arrays.stream(OsAccountInstanceType.values()).filter(val -> val.getName().equals(name)).findFirst().orElse(null);
        }
    }
}

