/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.OsAccountRealm;
import org.sleuthkit.datamodel.OsAccountRealmManager;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskEvent;
import org.sleuthkit.datamodel.TskException;
import org.sleuthkit.datamodel.WindowsAccountUtils;

public final class OsAccountManager {
    private final SleuthkitCase db;
    private final Object osAcctInstancesCacheLock;
    private final NavigableMap<OsAccountInstanceKey, OsAccountInstance> osAccountInstanceCache;

    OsAccountManager(SleuthkitCase skCase) {
        this.db = skCase;
        this.osAcctInstancesCacheLock = new Object();
        this.osAccountInstanceCache = new ConcurrentSkipListMap<OsAccountInstanceKey, OsAccountInstance>();
    }

    OsAccount newOsAccount(String uniqueAccountId, OsAccountRealm realm) throws TskCoreException {
        if (Strings.isNullOrEmpty((String)uniqueAccountId)) {
            throw new TskCoreException("Cannot create OS account with null uniqueId.");
        }
        if (realm == null) {
            throw new TskCoreException("Cannot create OS account without a realm.");
        }
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            OsAccount account = this.newOsAccount(uniqueAccountId, null, realm, OsAccount.OsAccountStatus.UNKNOWN, trans);
            trans.commit();
            trans = null;
            OsAccount osAccount = account;
            return osAccount;
        }
        catch (SQLException ex) {
            trans.rollback();
            trans = null;
            Optional<OsAccount> osAccount = this.getOsAccountByAddr(uniqueAccountId, realm);
            if (osAccount.isPresent()) {
                OsAccount osAccount2 = osAccount.get();
                return osAccount2;
            }
            throw new TskCoreException(String.format("Error creating OsAccount with uniqueAccountId = %s in realm id = %d", uniqueAccountId, realm.getRealmId()), ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    public OsAccount newWindowsOsAccount(String sid, String loginName, String realmName, Host referringHost, OsAccountRealm.RealmScope realmScope) throws TskCoreException, NotUserSIDException {
        OsAccountRealmManager.OsRealmUpdateResult realmUpdateResult;
        if (realmScope == null) {
            throw new TskCoreException("RealmScope cannot be null. Use UNKNOWN if scope is not known.");
        }
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to create an account.");
        }
        if ((StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)loginName)) {
            throw new TskCoreException("Cannot create OS account with both uniqueId and loginName as null.");
        }
        if ((StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)realmName)) {
            throw new TskCoreException("Realm name or SID is required to create a Windows account.");
        }
        if (!(StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0") || WindowsAccountUtils.isWindowsUserSid(sid))) {
            throw new NotUserSIDException(String.format("SID = %s is not a user SID.", sid));
        }
        if (StringUtils.isBlank((CharSequence)sid) && !StringUtils.isBlank((CharSequence)loginName) && !StringUtils.isBlank((CharSequence)realmName) && WindowsAccountUtils.isWindowsWellKnownAccountName(loginName, realmName)) {
            sid = WindowsAccountUtils.getWindowsWellKnownAccountSid(loginName, realmName);
        }
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            sid = sid.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)loginName)) {
            loginName = loginName.toLowerCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)realmName)) {
            realmName = realmName.toLowerCase(Locale.ENGLISH);
        }
        Optional<Object> anotherRealmWithSameName = Optional.empty();
        Optional<Object> anotherRealmWithSameAddr = Optional.empty();
        OsAccountRealm realm = null;
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            realmUpdateResult = this.db.getOsAccountRealmManager().getAndUpdateWindowsRealm(sid, realmName, referringHost, connection);
            Optional<OsAccountRealm> realmOptional = realmUpdateResult.getUpdatedRealm();
            if (realmOptional.isPresent()) {
                realm = realmOptional.get();
                if (realmUpdateResult.getUpdateStatus() == OsAccountRealmManager.OsRealmUpdateStatus.UPDATED) {
                    anotherRealmWithSameName = this.db.getOsAccountRealmManager().getAnotherRealmByName(realmOptional.get(), realmName, referringHost, connection);
                    if (anotherRealmWithSameName.isPresent() && ((OsAccountRealm)anotherRealmWithSameName.get()).getRealmAddr().isPresent()) {
                        anotherRealmWithSameName = Optional.empty();
                    }
                    if ((anotherRealmWithSameAddr = this.db.getOsAccountRealmManager().getAnotherRealmByAddr(realmOptional.get(), realmName, referringHost, connection)).isPresent() && !((OsAccountRealm)anotherRealmWithSameAddr.get()).getRealmNames().isEmpty()) {
                        anotherRealmWithSameName = Optional.empty();
                    }
                }
            }
        }
        if (null == realm) {
            realm = this.db.getOsAccountRealmManager().newWindowsRealm(sid, realmName, referringHost, realmScope);
        } else if (realmUpdateResult.getUpdateStatus() == OsAccountRealmManager.OsRealmUpdateStatus.UPDATED && (anotherRealmWithSameName.isPresent() || anotherRealmWithSameAddr.isPresent())) {
            SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
            try {
                if (anotherRealmWithSameName.isPresent()) {
                    this.db.getOsAccountRealmManager().mergeRealms((OsAccountRealm)anotherRealmWithSameName.get(), realm, trans);
                }
                if (anotherRealmWithSameAddr.isPresent()) {
                    this.db.getOsAccountRealmManager().mergeRealms((OsAccountRealm)anotherRealmWithSameAddr.get(), realm, trans);
                }
                trans.commit();
            }
            catch (TskCoreException ex) {
                trans.rollback();
                throw ex;
            }
        }
        return this.newWindowsOsAccount(sid, loginName, realm);
    }

    public OsAccount newWindowsOsAccount(String sid, String loginName, OsAccountRealm realm) throws TskCoreException, NotUserSIDException {
        if ((StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)loginName)) {
            throw new TskCoreException("Cannot create OS account with both uniqueId and loginName as null.");
        }
        if (!(StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0") || WindowsAccountUtils.isWindowsUserSid(sid))) {
            throw new NotUserSIDException(String.format("SID = %s is not a user SID.", sid));
        }
        String resolvedLoginName = WindowsAccountUtils.toWellknownEnglishLoginName(loginName);
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            OsAccountUpdateResult updateResult;
            String fullName;
            String wellKnownLoginName;
            String uniqueId;
            String string = uniqueId = !StringUtils.isBlank((CharSequence)sid) && !sid.equalsIgnoreCase("S-1-0-0") ? sid : null;
            if (!StringUtils.isBlank((CharSequence)sid) && !sid.equalsIgnoreCase("S-1-0-0") && WindowsAccountUtils.isWindowsWellKnownSid(sid) && !StringUtils.isEmpty((CharSequence)(wellKnownLoginName = WindowsAccountUtils.getWindowsWellKnownSidLoginName(sid)))) {
                resolvedLoginName = wellKnownLoginName;
            }
            OsAccount account = this.newOsAccount(uniqueId, resolvedLoginName, realm, OsAccount.OsAccountStatus.UNKNOWN, trans);
            if (!StringUtils.isBlank((CharSequence)sid) && !sid.equalsIgnoreCase("S-1-0-0") && WindowsAccountUtils.isWindowsWellKnownSid(sid) && StringUtils.isNotBlank((CharSequence)(fullName = WindowsAccountUtils.getWindowsWellKnownSidFullName(sid))) && (updateResult = this.updateStandardOsAccountAttributes(account, fullName, null, null, null, trans)).getUpdatedAccount().isPresent()) {
                account = updateResult.getUpdatedAccount().get();
            }
            trans.commit();
            trans = null;
            OsAccount osAccount = account;
            return osAccount;
        }
        catch (SQLException ex) {
            Optional<OsAccount> osAccount;
            trans.rollback();
            trans = null;
            if (!Strings.isNullOrEmpty((String)sid) && (osAccount = this.getOsAccountByAddr(sid, realm)).isPresent()) {
                OsAccount osAccount2 = osAccount.get();
                return osAccount2;
            }
            if (!Strings.isNullOrEmpty((String)resolvedLoginName) && (osAccount = this.getOsAccountByLoginName(resolvedLoginName, realm)).isPresent()) {
                OsAccount osAccount3 = osAccount.get();
                return osAccount3;
            }
            throw new TskCoreException(String.format("Error creating OsAccount with sid = %s, loginName = %s, realm = %s, referring host = %s", sid != null ? sid : "Null", resolvedLoginName != null ? resolvedLoginName : "Null", !realm.getRealmNames().isEmpty() ? realm.getRealmNames().get(0) : "Null", realm.getScopeHost().isPresent() ? realm.getScopeHost().get().getName() : "Null"), ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    @Beta
    public OsAccount newLocalLinuxOsAccount(String uid, String loginName, Host referringHost) throws TskCoreException {
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to create a local OS account.");
        }
        if (StringUtils.isBlank((CharSequence)uid) && StringUtils.isBlank((CharSequence)loginName)) {
            throw new TskCoreException("Cannot create OS account with both uniqueId and loginName as null.");
        }
        OsAccountRealm localRealm = this.db.getOsAccountRealmManager().newLocalLinuxRealm(referringHost);
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            OsAccount account = this.newOsAccount(uid, loginName, localRealm, OsAccount.OsAccountStatus.UNKNOWN, trans);
            trans.commit();
            trans = null;
            OsAccount osAccount = account;
            return osAccount;
        }
        catch (SQLException ex) {
            Optional<OsAccount> osAccount;
            trans.rollback();
            trans = null;
            if (!Strings.isNullOrEmpty((String)uid) && (osAccount = this.getOsAccountByAddr(uid, localRealm)).isPresent()) {
                OsAccount osAccount2 = osAccount.get();
                return osAccount2;
            }
            if (!Strings.isNullOrEmpty((String)loginName) && (osAccount = this.getOsAccountByLoginName(loginName, localRealm)).isPresent()) {
                OsAccount osAccount3 = osAccount.get();
                return osAccount3;
            }
            throw new TskCoreException(String.format("Error creating OsAccount with uid = %s, loginName = %s, realm = %s, referring host = %s", uid != null ? uid : "Null", loginName != null ? loginName : "Null", !localRealm.getRealmNames().isEmpty() ? localRealm.getRealmNames().get(0) : "Null", localRealm.getScopeHost().isPresent() ? localRealm.getScopeHost().get().getName() : "Null"), ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    private OsAccount newOsAccount(String uniqueId, String loginName, OsAccountRealm realm, OsAccount.OsAccountStatus accountStatus, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException, SQLException {
        if (Objects.isNull(realm)) {
            throw new TskCoreException("Cannot create an OS Account, realm is NULL.");
        }
        String signature = OsAccountManager.getOsAccountSignature(uniqueId, loginName);
        SleuthkitCase.CaseDbConnection connection = trans.getConnection();
        long parentObjId = 0L;
        short objTypeId = TskData.ObjectType.OS_ACCOUNT.getObjectType();
        long osAccountObjId = this.db.addObject(parentObjId, objTypeId, connection);
        String accountInsertSQL = "INSERT INTO tsk_os_accounts(os_account_obj_id, login_name, realm_id, addr, signature, status) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.getPreparedStatement(accountInsertSQL, 2);
        preparedStatement.clearParameters();
        preparedStatement.setLong(1, osAccountObjId);
        preparedStatement.setString(2, loginName);
        preparedStatement.setLong(3, realm.getRealmId());
        preparedStatement.setString(4, uniqueId);
        preparedStatement.setString(5, signature);
        preparedStatement.setInt(6, accountStatus.getId());
        connection.executeUpdate(preparedStatement);
        OsAccount account = new OsAccount(this.db, osAccountObjId, realm.getRealmId(), loginName, uniqueId, signature, null, null, null, accountStatus, OsAccount.OsAccountDbStatus.ACTIVE);
        trans.registerAddedOsAccount(account);
        return account;
    }

    private Optional<OsAccount> getOsAccountByAddr(String addr, Host host) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            Optional<OsAccount> optional = this.getOsAccountByAddr(addr, host, connection);
            return optional;
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<OsAccount> getOsAccountByAddr(String uniqueId, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Optional<OsAccount> getOsAccountByAddr(String uniqueId, OsAccountRealm realm) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Optional<OsAccount> getOsAccountByLoginName(String loginName, OsAccountRealm realm) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OsAccount getOsAccountByObjectId(long osAccountObjId) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            OsAccount osAccount = this.getOsAccountByObjectId(osAccountObjId, connection);
            return osAccount;
        }
    }

    /*
     * Exception decompiling
     */
    OsAccount getOsAccountByObjectId(long osAccountObjId, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OsAccountInstance newOsAccountInstance(OsAccount osAccount, DataSource dataSource, OsAccountInstance.OsAccountInstanceType instanceType) throws TskCoreException {
        if (osAccount == null) {
            throw new TskCoreException("Cannot create account instance with null account.");
        }
        if (dataSource == null) {
            throw new TskCoreException("Cannot create account instance with null data source.");
        }
        Optional<OsAccountInstance> existingInstance = this.cachedAccountInstance(osAccount.getId(), dataSource.getId(), instanceType);
        if (existingInstance.isPresent()) {
            return existingInstance.get();
        }
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            OsAccountInstance osAccountInstance = this.newOsAccountInstance(osAccount.getId(), dataSource.getId(), instanceType, connection);
            return osAccountInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OsAccountInstance newOsAccountInstance(long osAccountId, long dataSourceObjId, OsAccountInstance.OsAccountInstanceType instanceType, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        Optional<OsAccountInstance> existingInstance = this.cachedAccountInstance(osAccountId, dataSourceObjId, instanceType);
        if (existingInstance.isPresent()) {
            return existingInstance.get();
        }
        this.db.acquireSingleUserCaseWriteLock();
        try {
            String accountInsertSQL = this.db.getInsertOrIgnoreSQL("INTO tsk_os_account_instances(os_account_obj_id, data_source_obj_id, instance_type) VALUES (?, ?, ?)");
            PreparedStatement preparedStatement = connection.getPreparedStatement(accountInsertSQL, 1);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, osAccountId);
            preparedStatement.setLong(2, dataSourceObjId);
            preparedStatement.setInt(3, instanceType.getId());
            connection.executeUpdate(preparedStatement);
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                if (resultSet.next()) {
                    OsAccountInstance accountInstance = new OsAccountInstance(this.db, resultSet.getLong(1), osAccountId, dataSourceObjId, instanceType);
                    Object object = this.osAcctInstancesCacheLock;
                    synchronized (object) {
                        OsAccountInstanceKey key = new OsAccountInstanceKey(this, osAccountId, dataSourceObjId);
                        for (OsAccountInstance.OsAccountInstanceType type : OsAccountInstance.OsAccountInstanceType.values()) {
                            if (accountInstance.getInstanceType().compareTo(type) >= 0) continue;
                            this.osAccountInstanceCache.remove(key);
                        }
                        this.osAccountInstanceCache.put(key, accountInstance);
                    }
                    this.db.fireTSKEvent(new TskEvent.OsAcctInstancesAddedTskEvent(Collections.singletonList(accountInstance)));
                    object = accountInstance;
                    return object;
                }
                Optional<OsAccountInstance> existingInstanceRetry = this.cachedAccountInstance(osAccountId, dataSourceObjId, instanceType);
                if (existingInstanceRetry.isPresent()) {
                    OsAccountInstance osAccountInstance = existingInstanceRetry.get();
                    return osAccountInstance;
                }
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding OS account instance for OS account object id = %d, data source object id = %d", osAccountId, dataSourceObjId), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
        String whereClause = " tsk_os_account_instances.os_account_obj_id = " + osAccountId + " AND tsk_os_account_instances.data_source_obj_id = " + dataSourceObjId;
        List<OsAccountInstance> instances = this.getOsAccountInstances(whereClause);
        if (instances.isEmpty()) {
            throw new TskCoreException(String.format("Could not get autogen key after row insert or reload instance for OS account instance. OS account object id = %d, data source object id = %d", osAccountId, dataSourceObjId));
        }
        OsAccountInstance accountInstance = instances.get(0);
        Object object = this.osAcctInstancesCacheLock;
        synchronized (object) {
            OsAccountInstanceKey key = new OsAccountInstanceKey(this, osAccountId, dataSourceObjId);
            for (OsAccountInstance.OsAccountInstanceType type : OsAccountInstance.OsAccountInstanceType.values()) {
                if (accountInstance.getInstanceType().compareTo(type) >= 0) continue;
                this.osAccountInstanceCache.remove(key);
            }
            this.osAccountInstanceCache.put(key, accountInstance);
        }
        return accountInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<OsAccountInstance> cachedAccountInstance(long osAccountId, long dataSourceObjId, OsAccountInstance.OsAccountInstanceType instanceType) {
        Object object = this.osAcctInstancesCacheLock;
        synchronized (object) {
            OsAccountInstanceKey key = new OsAccountInstanceKey(this, osAccountId, dataSourceObjId);
            OsAccountInstance instance = (OsAccountInstance)this.osAccountInstanceCache.get(key);
            if (instance != null && instanceType.compareTo(instance.getInstanceType()) >= 0) {
                return Optional.of(instance);
            }
            return Optional.empty();
        }
    }

    /*
     * Exception decompiling
     */
    public List<OsAccount> getOsAccounts(Host host) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<OsAccount> getOsAccountsByDataSourceObjId(long dataSourceId) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void mergeOsAccountsForRealms(OsAccountRealm sourceRealm, OsAccountRealm destRealm, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        List<OsAccount> destinationAccounts = this.getOsAccounts(destRealm, trans.getConnection());
        List<OsAccount> sourceAccounts = this.getOsAccounts(sourceRealm, trans.getConnection());
        for (OsAccount sourceAccount : sourceAccounts) {
            Optional<OsAccount> matchingDestAccount;
            List duplicateDestAccounts;
            if (sourceAccount.getAddr().isPresent() && sourceAccount.getLoginName().isPresent() && (duplicateDestAccounts = destinationAccounts.stream().filter(p -> p.getAddr().equals(sourceAccount.getAddr()) || p.getLoginName().equals(sourceAccount.getLoginName()) && !p.getAddr().isPresent()).collect(Collectors.toList())).size() > 1) {
                OsAccount combinedDestAccount = (OsAccount)duplicateDestAccounts.get(0);
                duplicateDestAccounts.remove(combinedDestAccount);
                for (OsAccount dupeDestAccount : duplicateDestAccounts) {
                    this.mergeOsAccounts(dupeDestAccount, combinedDestAccount, trans);
                }
            }
            if ((matchingDestAccount = this.getMatchingAccountForMerge(sourceAccount, destinationAccounts, true)).isPresent()) {
                this.mergeOsAccounts(sourceAccount, matchingDestAccount.get(), trans);
                continue;
            }
            String query = "UPDATE tsk_os_accounts SET realm_id = " + destRealm.getRealmId() + " WHERE os_account_obj_id = " + sourceAccount.getId();
            try (Statement s = trans.getConnection().createStatement();){
                s.executeUpdate(query);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error executing SQL update: " + query, ex);
            }
            trans.registerChangedOsAccount(sourceAccount);
        }
    }

    private Optional<OsAccount> getMatchingAccountForMerge(OsAccount sourceAccount, List<OsAccount> destinationAccounts, boolean ignoreCase) {
        List matchingDestAccounts;
        OsAccount matchingDestAccount = null;
        if (sourceAccount.getAddr().isPresent() && !(matchingDestAccounts = destinationAccounts.stream().filter(p -> p.getAddr().equals(sourceAccount.getAddr())).collect(Collectors.toList())).isEmpty()) {
            matchingDestAccount = (OsAccount)matchingDestAccounts.get(0);
        }
        if (matchingDestAccount == null && sourceAccount.getLoginName().isPresent() && !(matchingDestAccounts = destinationAccounts.stream().filter(p -> p.getLoginName().isPresent()).filter(p -> (ignoreCase ? p.getLoginName().get().equalsIgnoreCase(sourceAccount.getLoginName().get()) : p.getLoginName().get().equals(sourceAccount.getLoginName().get())) && (!sourceAccount.getAddr().isPresent() || !p.getAddr().isPresent())).collect(Collectors.toList())).isEmpty()) {
            matchingDestAccount = (OsAccount)matchingDestAccounts.get(0);
        }
        return Optional.ofNullable(matchingDestAccount);
    }

    private void mergeOsAccount(OsAccount account, boolean ignoreCase, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        Long realmId = account.getRealmId();
        OsAccountRealm realm = this.db.getOsAccountRealmManager().getRealmByRealmId(realmId, trans.getConnection());
        List<OsAccount> osAccounts = this.getOsAccounts(realm, trans.getConnection());
        osAccounts.removeIf(acc -> Objects.equals(acc.getId(), account.getId()));
        Optional<OsAccount> matchingAccount = this.getMatchingAccountForMerge(account, osAccounts, ignoreCase);
        if (matchingAccount.isPresent()) {
            this.mergeOsAccounts(matchingAccount.get(), account, trans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOsAccounts(OsAccount sourceAccount, OsAccount destAccount, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        Object query = "";
        try (Statement s = trans.getConnection().createStatement();){
            query = this.makeOsAccountUpdateQuery("tsk_os_account_attributes", sourceAccount, destAccount);
            s.executeUpdate((String)query);
            query = "DELETE FROM tsk_os_account_instances WHERE id IN ( SELECT   sourceAccountInstance.id FROM   tsk_os_account_instances destAccountInstance INNER JOIN tsk_os_account_instances sourceAccountInstance ON destAccountInstance.data_source_obj_id = sourceAccountInstance.data_source_obj_id WHERE destAccountInstance.os_account_obj_id = " + destAccount.getId() + " AND sourceAccountInstance.os_account_obj_id = " + sourceAccount.getId() + " AND sourceAccountInstance.instance_type = destAccountInstance.instance_type)";
            s.executeUpdate((String)query);
            query = this.makeOsAccountUpdateQuery("tsk_os_account_instances", sourceAccount, destAccount);
            s.executeUpdate((String)query);
            Object object = this.osAcctInstancesCacheLock;
            synchronized (object) {
                this.osAccountInstanceCache.clear();
            }
            query = this.makeOsAccountUpdateQuery("tsk_files", sourceAccount, destAccount);
            s.executeUpdate((String)query);
            query = this.makeOsAccountUpdateQuery("tsk_data_artifacts", sourceAccount, destAccount);
            s.executeUpdate((String)query);
            trans.registerMergedOsAccount(sourceAccount.getId(), destAccount.getId());
            String mergedSignature = this.makeMergedOsAccountSignature();
            query = "UPDATE tsk_os_accounts SET merged_into = " + destAccount.getId() + ", db_status = " + OsAccount.OsAccountDbStatus.MERGED.getId() + ", signature = '" + mergedSignature + "'  WHERE os_account_obj_id = " + sourceAccount.getId();
            s.executeUpdate((String)query);
            trans.registerDeletedOsAccount(sourceAccount.getId());
            this.mergeOsAccountObjectsAndUpdateDestAccount(sourceAccount, destAccount, trans);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error executing SQL update: " + (String)query, ex);
        }
    }

    private String makeMergedOsAccountSignature() {
        return "MERGED " + UUID.randomUUID().toString();
    }

    private String makeOsAccountUpdateQuery(String tableName, OsAccount sourceAccount, OsAccount destAccount) {
        return "UPDATE " + tableName + " SET os_account_obj_id = " + destAccount.getId() + " WHERE os_account_obj_id = " + sourceAccount.getId();
    }

    private OsAccount mergeOsAccountObjectsAndUpdateDestAccount(OsAccount sourceAccount, OsAccount destAccount, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        OsAccountUpdateResult updateStatus;
        OsAccount mergedDestAccount = destAccount;
        String destLoginName = null;
        String destAddr = null;
        if (!destAccount.getLoginName().isPresent() && sourceAccount.getLoginName().isPresent()) {
            destLoginName = sourceAccount.getLoginName().get();
        }
        if (!destAccount.getAddr().isPresent() && sourceAccount.getAddr().isPresent()) {
            destAddr = sourceAccount.getAddr().get();
        }
        if ((updateStatus = this.updateOsAccountCore(destAccount, destAddr, destLoginName, trans)).getUpdateStatusCode() == OsAccountUpdateStatus.UPDATED && updateStatus.getUpdatedAccount().isPresent()) {
            mergedDestAccount = updateStatus.getUpdatedAccount().get();
        }
        String destFullName = null;
        Long destCreationTime = null;
        if (!destAccount.getFullName().isPresent() && sourceAccount.getFullName().isPresent()) {
            destFullName = sourceAccount.getFullName().get();
        }
        if (!destAccount.getCreationTime().isPresent() && sourceAccount.getCreationTime().isPresent()) {
            destCreationTime = sourceAccount.getCreationTime().get();
        }
        if ((updateStatus = this.updateStandardOsAccountAttributes(destAccount, destFullName, null, null, destCreationTime, trans)).getUpdateStatusCode() == OsAccountUpdateStatus.UPDATED && updateStatus.getUpdatedAccount().isPresent()) {
            mergedDestAccount = updateStatus.getUpdatedAccount().get();
        }
        return mergedDestAccount;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<OsAccount> getOsAccounts(OsAccountRealm realm, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT * FROM tsk_os_accounts WHERE realm_id = " + realm.getRealmId() + " AND db_status = " + OsAccount.OsAccountDbStatus.ACTIVE.getId() + " ORDER BY os_account_obj_id";
        try (Statement s = connection.createStatement();){
            ArrayList<OsAccount> arrayList;
            block15: {
                ResultSet rs = connection.executeQuery(s, queryString);
                try {
                    ArrayList<OsAccount> accounts = new ArrayList<OsAccount>();
                    while (rs.next()) {
                        accounts.add(this.osAccountFromResultSet(rs));
                    }
                    arrayList = accounts;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting OS accounts for realm id = %d", realm.getRealmId()), ex);
        }
    }

    /*
     * Exception decompiling
     */
    public List<OsAccount> getOsAccounts() throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Optional<OsAccount> getWindowsOsAccount(String sid, String loginName, String realmName, Host referringHost) throws TskCoreException, NotUserSIDException {
        Optional<OsAccountRealm> realm;
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to get an account.");
        }
        if ((StringUtils.isBlank((CharSequence)sid) || sid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)loginName)) {
            throw new TskCoreException("Cannot get an OS account with both SID and loginName as null.");
        }
        if (StringUtils.isBlank((CharSequence)sid) && !StringUtils.isBlank((CharSequence)loginName) && !StringUtils.isBlank((CharSequence)realmName) && WindowsAccountUtils.isWindowsWellKnownAccountName(loginName, realmName)) {
            sid = WindowsAccountUtils.getWindowsWellKnownAccountSid(loginName, realmName);
        }
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            sid = sid.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)loginName)) {
            loginName = loginName.toLowerCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)realmName)) {
            realmName = realmName.toLowerCase(Locale.ENGLISH);
        }
        if (!(realm = this.db.getOsAccountRealmManager().getWindowsRealm(sid, realmName, referringHost)).isPresent()) {
            return Optional.empty();
        }
        if (!Strings.isNullOrEmpty((String)sid) && !sid.equalsIgnoreCase("S-1-0-0")) {
            if (!WindowsAccountUtils.isWindowsUserSid(sid)) {
                throw new NotUserSIDException(String.format("SID = %s is not a user SID.", sid));
            }
            Optional<OsAccount> account = this.getOsAccountByAddr(sid, realm.get());
            if (account.isPresent()) {
                return account;
            }
        }
        if (!Strings.isNullOrEmpty((String)loginName)) {
            String resolvedLoginName = WindowsAccountUtils.toWellknownEnglishLoginName(loginName);
            return this.getOsAccountByLoginName(resolvedLoginName, realm.get());
        }
        return Optional.empty();
    }

    @Beta
    public Optional<OsAccount> getLocalLinuxOsAccount(String uid, String loginName, Host referringHost) throws TskCoreException {
        Optional<OsAccount> account;
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to get an account.");
        }
        if (StringUtils.isBlank((CharSequence)uid) && StringUtils.isBlank((CharSequence)loginName)) {
            throw new TskCoreException("Cannot get an OS account with both UID and loginName as null.");
        }
        Optional<OsAccountRealm> realm = this.db.getOsAccountRealmManager().getLocalLinuxRealm(referringHost);
        if (!realm.isPresent()) {
            return Optional.empty();
        }
        if (!Strings.isNullOrEmpty((String)uid) && (account = this.getOsAccountByAddr(uid, realm.get())).isPresent()) {
            return account;
        }
        if (!Strings.isNullOrEmpty((String)loginName)) {
            return this.getOsAccountByLoginName(loginName, realm.get());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtendedOsAccountAttributes(OsAccount account, List<OsAccount.OsAccountAttribute> accountAttributes) throws TskCoreException {
        OsAccount osAccount = account;
        synchronized (osAccount) {
            this.db.acquireSingleUserCaseWriteLock();
            try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
                for (OsAccount.OsAccountAttribute accountAttribute : accountAttributes) {
                    String attributeInsertSQL = "INSERT INTO tsk_os_account_attributes(os_account_obj_id, host_id, source_obj_id, attribute_type_id, value_type, value_byte, value_text, value_int32, value_int64, value_double) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement preparedStatement = connection.getPreparedStatement(attributeInsertSQL, 1);
                    preparedStatement.clearParameters();
                    preparedStatement.setLong(1, account.getId());
                    if (accountAttribute.getHostId().isPresent()) {
                        preparedStatement.setLong(2, accountAttribute.getHostId().get());
                    } else {
                        preparedStatement.setNull(2, 0);
                    }
                    if (accountAttribute.getSourceObjectId().isPresent()) {
                        preparedStatement.setLong(3, accountAttribute.getSourceObjectId().get());
                    } else {
                        preparedStatement.setNull(3, 0);
                    }
                    preparedStatement.setLong(4, accountAttribute.getAttributeType().getTypeID());
                    preparedStatement.setLong(5, accountAttribute.getAttributeType().getValueType().getType());
                    if (accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
                        preparedStatement.setBytes(6, accountAttribute.getValueBytes());
                    } else {
                        preparedStatement.setBytes(6, null);
                    }
                    if (accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING || accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
                        preparedStatement.setString(7, accountAttribute.getValueString());
                    } else {
                        preparedStatement.setString(7, null);
                    }
                    if (accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
                        preparedStatement.setInt(8, accountAttribute.getValueInt());
                    } else {
                        preparedStatement.setNull(8, 0);
                    }
                    if (accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME || accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG) {
                        preparedStatement.setLong(9, accountAttribute.getValueLong());
                    } else {
                        preparedStatement.setNull(9, 0);
                    }
                    if (accountAttribute.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
                        preparedStatement.setDouble(10, accountAttribute.getValueDouble());
                    } else {
                        preparedStatement.setNull(10, 0);
                    }
                    connection.executeUpdate(preparedStatement);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Error adding OS Account attribute for account id = %d", account.getId()), ex);
            }
            finally {
                this.db.releaseSingleUserCaseWriteLock();
            }
            List<OsAccount.OsAccountAttribute> currentAttribsList = this.getOsAccountAttributes(account);
            account.setAttributesInternal(currentAttribsList);
        }
        this.fireChangeEvent(account);
    }

    /*
     * Exception decompiling
     */
    List<OsAccount.OsAccountAttribute> getOsAccountAttributes(OsAccount account) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<OsAccountInstance> getOsAccountInstances(OsAccount account) throws TskCoreException {
        String whereClause = " tsk_os_account_instances.os_account_obj_id = " + account.getId();
        return this.getOsAccountInstances(whereClause);
    }

    public List<OsAccountInstance> getOsAccountInstances(List<Long> instanceIDs) throws TskCoreException {
        String instanceIds = instanceIDs.stream().map(id -> id.toString()).collect(Collectors.joining(","));
        ArrayList<OsAccountInstance> osAcctInstances = new ArrayList();
        String querySQL = "SELECT * FROM tsk_os_account_instances \tWHERE tsk_os_account_instances.id IN (" + instanceIds + ")";
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             PreparedStatement preparedStatement = connection.getPreparedStatement(querySQL, 2);
             ResultSet results = connection.executeQuery(preparedStatement);){
            osAcctInstances = this.getOsAccountInstancesFromResultSet(results);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to get OsAccountInstances (SQL = " + querySQL + ")", ex);
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return osAcctInstances;
    }

    private List<OsAccountInstance> getOsAccountInstances(String whereClause) throws TskCoreException {
        ArrayList<OsAccountInstance> osAcctInstances = new ArrayList();
        String querySQL = "SELECT tsk_os_account_instances.*  FROM tsk_os_account_instances  INNER JOIN ( SELECT os_account_obj_id,  data_source_obj_id, MIN(instance_type) AS min_instance_type \t\t\t\t\tFROM tsk_os_account_instances\t\t\t\t\tGROUP BY os_account_obj_id, data_source_obj_id ) grouped_instances  ON tsk_os_account_instances.os_account_obj_id = grouped_instances.os_account_obj_id  AND tsk_os_account_instances.instance_type = grouped_instances.min_instance_type  WHERE " + whereClause;
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             PreparedStatement preparedStatement = connection.getPreparedStatement(querySQL, 2);
             ResultSet results = connection.executeQuery(preparedStatement);){
            osAcctInstances = this.getOsAccountInstancesFromResultSet(results);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to get OsAccountInstances (SQL = " + querySQL + ")", ex);
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return osAcctInstances;
    }

    private List<OsAccountInstance> getOsAccountInstancesFromResultSet(ResultSet results) throws SQLException {
        ArrayList<OsAccountInstance> osAcctInstances = new ArrayList<OsAccountInstance>();
        while (results.next()) {
            long instanceId = results.getLong("id");
            long osAccountObjID = results.getLong("os_account_obj_id");
            long dataSourceObjId = results.getLong("data_source_obj_id");
            int instanceType = results.getInt("instance_type");
            osAcctInstances.add(new OsAccountInstance(this.db, instanceId, osAccountObjID, dataSourceObjId, OsAccountInstance.OsAccountInstanceType.fromID(instanceType)));
        }
        return osAcctInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsAccountUpdateResult updateStandardOsAccountAttributes(OsAccount osAccount, String fullName, OsAccount.OsAccountType accountType, OsAccount.OsAccountStatus accountStatus, Long creationTime) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            OsAccountUpdateResult updateStatus = this.updateStandardOsAccountAttributes(osAccount, fullName, accountType, accountStatus, creationTime, trans);
            trans.commit();
            trans = null;
            OsAccountUpdateResult osAccountUpdateResult = updateStatus;
            return osAccountUpdateResult;
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    OsAccountUpdateResult updateStandardOsAccountAttributes(OsAccount osAccount, String fullName, OsAccount.OsAccountType accountType, OsAccount.OsAccountStatus accountStatus, Long creationTime, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        OsAccountUpdateStatus updateStatusCode = OsAccountUpdateStatus.NO_CHANGE;
        try {
            SleuthkitCase.CaseDbConnection connection = trans.getConnection();
            if (!StringUtils.isBlank((CharSequence)fullName)) {
                this.updateAccountColumn(osAccount.getId(), "full_name", fullName, connection);
                updateStatusCode = OsAccountUpdateStatus.UPDATED;
            }
            if (Objects.nonNull((Object)accountType)) {
                this.updateAccountColumn(osAccount.getId(), "type", accountType.getId(), connection);
                updateStatusCode = OsAccountUpdateStatus.UPDATED;
            }
            if (Objects.nonNull((Object)accountStatus)) {
                this.updateAccountColumn(osAccount.getId(), "status", accountStatus.getId(), connection);
                updateStatusCode = OsAccountUpdateStatus.UPDATED;
            }
            if (Objects.nonNull(creationTime)) {
                this.updateAccountColumn(osAccount.getId(), "created_date", creationTime, connection);
                updateStatusCode = OsAccountUpdateStatus.UPDATED;
            }
            if (updateStatusCode == OsAccountUpdateStatus.NO_CHANGE) {
                return new OsAccountUpdateResult(updateStatusCode, null);
            }
            OsAccount updatedAccount = this.getOsAccountByObjectId(osAccount.getId(), connection);
            trans.registerChangedOsAccount(updatedAccount);
            return new OsAccountUpdateResult(updateStatusCode, updatedAccount);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating account with addr = %s, account id = %d", osAccount.getAddr().orElse("Unknown"), osAccount.getId()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateAccountColumn(long accountObjId, String colName, T colValue, SleuthkitCase.CaseDbConnection connection) throws SQLException, TskCoreException {
        String updateSQL = "UPDATE tsk_os_accounts  SET " + colName + " = ?  WHERE os_account_obj_id = ?";
        this.db.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement preparedStatement = connection.getPreparedStatement(updateSQL, 2);
            preparedStatement.clearParameters();
            if (Objects.isNull(colValue)) {
                preparedStatement.setNull(1, 0);
            } else if (colValue instanceof String) {
                preparedStatement.setString(1, (String)colValue);
            } else if (colValue instanceof Long) {
                preparedStatement.setLong(1, (Long)colValue);
            } else if (colValue instanceof Integer) {
                preparedStatement.setInt(1, (Integer)colValue);
            } else {
                throw new TskCoreException(String.format("Unhandled column data type received while updating the account (%d) ", accountObjId));
            }
            preparedStatement.setLong(2, accountObjId);
            connection.executeUpdate(preparedStatement);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    private void updateAccountSignature(long accountObjId, String signature, SleuthkitCase.CaseDbConnection connection) throws SQLException {
        String updateSQL = "UPDATE tsk_os_accounts SET \t\tsignature =        CASE WHEN db_status = " + OsAccount.OsAccountDbStatus.ACTIVE.getId() + " THEN ? ELSE signature END   WHERE os_account_obj_id = ?";
        PreparedStatement preparedStatement = connection.getPreparedStatement(updateSQL, 2);
        preparedStatement.clearParameters();
        preparedStatement.setString(1, signature);
        preparedStatement.setLong(2, accountObjId);
        connection.executeUpdate(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsAccountUpdateResult updateCoreWindowsOsAccountAttributes(OsAccount osAccount, String accountSid, String loginName, String realmName, Host referringHost) throws TskCoreException, NotUserSIDException {
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            if (StringUtils.isNotBlank((CharSequence)accountSid)) {
                accountSid = accountSid.toUpperCase(Locale.ENGLISH);
            }
            if (StringUtils.isNotBlank((CharSequence)loginName)) {
                loginName = loginName.toLowerCase(Locale.ENGLISH);
            }
            if (StringUtils.isNotBlank((CharSequence)realmName)) {
                realmName = realmName.toLowerCase(Locale.ENGLISH);
            }
            OsAccountUpdateResult updateStatus = this.updateCoreWindowsOsAccountAttributes(osAccount, accountSid, loginName, realmName, referringHost, trans);
            trans.commit();
            trans = null;
            OsAccountUpdateResult osAccountUpdateResult = updateStatus;
            return osAccountUpdateResult;
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    private OsAccountUpdateResult updateCoreWindowsOsAccountAttributes(OsAccount osAccount, String accountSid, String loginName, String realmName, Host referringHost, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException, NotUserSIDException {
        String resolvedLoginName;
        OsAccountUpdateResult updateStatus;
        Optional<OsAccount> updatedAccount;
        if (!StringUtils.isBlank((CharSequence)accountSid) && !accountSid.equalsIgnoreCase("S-1-0-0") || !StringUtils.isBlank((CharSequence)realmName)) {
            String resolvedRealmName = WindowsAccountUtils.toWellknownEnglishRealmName(realmName);
            OsAccountRealmManager.OsRealmUpdateResult realmUpdateResult = this.db.getOsAccountRealmManager().getAndUpdateWindowsRealm(accountSid, resolvedRealmName, referringHost, trans.getConnection());
            Optional<OsAccountRealm> realmOptional = realmUpdateResult.getUpdatedRealm();
            if (realmOptional.isPresent() && realmUpdateResult.getUpdateStatus() == OsAccountRealmManager.OsRealmUpdateStatus.UPDATED) {
                Optional<OsAccountRealm> anotherRealmWithSameAddr;
                Optional<OsAccountRealm> anotherRealmWithSameName = this.db.getOsAccountRealmManager().getAnotherRealmByName(realmOptional.get(), realmName, referringHost, trans.getConnection());
                if (anotherRealmWithSameName.isPresent() && anotherRealmWithSameName.get().getRealmAddr().isPresent()) {
                    anotherRealmWithSameName = Optional.empty();
                }
                if ((anotherRealmWithSameAddr = this.db.getOsAccountRealmManager().getAnotherRealmByAddr(realmOptional.get(), realmName, referringHost, trans.getConnection())).isPresent() && !anotherRealmWithSameAddr.get().getRealmNames().isEmpty()) {
                    anotherRealmWithSameName = Optional.empty();
                }
                if (anotherRealmWithSameName.isPresent()) {
                    this.db.getOsAccountRealmManager().mergeRealms(anotherRealmWithSameName.get(), realmOptional.get(), trans);
                }
                if (anotherRealmWithSameAddr.isPresent()) {
                    this.db.getOsAccountRealmManager().mergeRealms(anotherRealmWithSameAddr.get(), realmOptional.get(), trans);
                }
            }
        }
        if ((updatedAccount = (updateStatus = this.updateOsAccountCore(osAccount, accountSid, resolvedLoginName = WindowsAccountUtils.toWellknownEnglishLoginName(loginName), trans)).getUpdatedAccount()).isPresent() && updateStatus.updateStatus != OsAccountUpdateStatus.NO_CHANGE) {
            this.mergeOsAccount(updatedAccount.get(), true, trans);
        }
        return updateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsAccountUpdateResult updateCoreLocalLinuxOsAccountAttributes(OsAccount osAccount, String uid, String loginName) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            OsAccountUpdateResult updateStatus = this.updateCoreLocalLinuxOsAccountAttributes(osAccount, uid, loginName, trans);
            trans.commit();
            trans = null;
            OsAccountUpdateResult osAccountUpdateResult = updateStatus;
            return osAccountUpdateResult;
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    @Beta
    private OsAccountUpdateResult updateCoreLocalLinuxOsAccountAttributes(OsAccount osAccount, String uid, String loginName, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        OsAccountUpdateResult updateStatus = this.updateOsAccountCore(osAccount, uid, loginName, trans);
        Optional<OsAccount> updatedAccount = updateStatus.getUpdatedAccount();
        if (updatedAccount.isPresent()) {
            this.mergeOsAccount(updatedAccount.get(), false, trans);
        }
        return updateStatus;
    }

    private OsAccountUpdateResult updateOsAccountCore(OsAccount osAccount, String address, String loginName, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        OsAccountUpdateStatus updateStatusCode = OsAccountUpdateStatus.NO_CHANGE;
        try {
            SleuthkitCase.CaseDbConnection connection;
            block9: {
                connection = trans.getConnection();
                if (!(StringUtils.isBlank((CharSequence)address) || address.equalsIgnoreCase("S-1-0-0") || StringUtils.isBlank((CharSequence)osAccount.getAddr().orElse(null)) || address.equalsIgnoreCase(osAccount.getAddr().orElse("")))) {
                    throw new TskCoreException(String.format("Account (%d) already has an address (%s), address cannot be updated.", osAccount.getId(), osAccount.getAddr().orElse("NULL")));
                }
                if (StringUtils.isBlank((CharSequence)osAccount.getAddr().orElse(null)) && !StringUtils.isBlank((CharSequence)address) && !address.equalsIgnoreCase("S-1-0-0")) {
                    this.updateAccountColumn(osAccount.getId(), "addr", address, connection);
                    updateStatusCode = OsAccountUpdateStatus.UPDATED;
                }
                if (StringUtils.isBlank((CharSequence)osAccount.getLoginName().orElse(null)) && !StringUtils.isBlank((CharSequence)loginName)) {
                    this.updateAccountColumn(osAccount.getId(), "login_name", loginName, connection);
                    updateStatusCode = OsAccountUpdateStatus.UPDATED;
                }
                if (updateStatusCode == OsAccountUpdateStatus.NO_CHANGE) {
                    return new OsAccountUpdateResult(updateStatusCode, osAccount);
                }
                OsAccount currAccount = this.getOsAccountByObjectId(osAccount.getId(), connection);
                String newAddress = currAccount.getAddr().orElse(null);
                String newLoginName = currAccount.getLoginName().orElse(null);
                String newSignature = OsAccountManager.getOsAccountSignature(newAddress, newLoginName);
                try {
                    this.updateAccountSignature(osAccount.getId(), newSignature, connection);
                }
                catch (SQLException ex) {
                    if (!osAccount.getAddr().isEmpty() || StringUtils.isBlank((CharSequence)address)) break block9;
                    OsAccountRealm realm = this.db.getOsAccountRealmManager().getRealmByRealmId(osAccount.getRealmId(), connection);
                    Optional<OsAccount> matchingAddrAcct = this.getOsAccountByAddr(address, realm.getScopeHost().get(), connection);
                    if (matchingAddrAcct.isEmpty() || matchingAddrAcct.get().getId() == osAccount.getId() || matchingAddrAcct.get().getLoginName().isPresent()) {
                        throw ex;
                    }
                    this.mergeOsAccounts(matchingAddrAcct.get(), osAccount, trans);
                }
            }
            OsAccount updatedAccount = this.getOsAccountByObjectId(osAccount.getId(), connection);
            trans.registerChangedOsAccount(updatedAccount);
            return new OsAccountUpdateResult(updateStatusCode, updatedAccount);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating account with unique id = %s, account id = %d", osAccount.getAddr().orElse("Unknown"), osAccount.getId()), ex);
        }
    }

    public List<Host> getHosts(OsAccount account) throws TskCoreException {
        ArrayList<Host> hostList = new ArrayList<Host>();
        String query = "SELECT tsk_hosts.id AS hostId, name, db_status FROM tsk_hosts  JOIN data_source_info ON tsk_hosts.id = data_source_info.host_id\tJOIN tsk_os_account_instances ON data_source_info.obj_id = tsk_os_account_instances.data_source_obj_id WHERE os_account_obj_id = " + account.getId();
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             Statement s = connection.createStatement();
             ResultSet rs = connection.executeQuery(s, query);){
            while (rs.next()) {
                hostList.add(new Host(rs.getLong("hostId"), rs.getString("name"), Host.HostDbStatus.fromID(rs.getInt("db_status"))));
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Failed to get host list for os account %d", account.getId()), ex);
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return hostList;
    }

    private OsAccount osAccountFromResultSet(ResultSet rs) throws SQLException {
        OsAccount.OsAccountType accountType = null;
        int typeId = rs.getInt("type");
        if (!rs.wasNull()) {
            accountType = OsAccount.OsAccountType.fromID(typeId);
        }
        Long creationTime = rs.getLong("created_date");
        if (rs.wasNull()) {
            creationTime = null;
        }
        return new OsAccount(this.db, rs.getLong("os_account_obj_id"), rs.getLong("realm_id"), rs.getString("login_name"), rs.getString("addr"), rs.getString("signature"), rs.getString("full_name"), creationTime, accountType, OsAccount.OsAccountStatus.fromID(rs.getInt("status")), OsAccount.OsAccountDbStatus.fromID(rs.getInt("db_status")));
    }

    private void fireChangeEvent(OsAccount account) {
        this.db.fireTSKEvent(new TskEvent.OsAccountsUpdatedTskEvent(Collections.singletonList(account)));
    }

    static String getOsAccountSignature(String uniqueId, String loginName) throws TskCoreException {
        String signature;
        if (!Strings.isNullOrEmpty((String)uniqueId)) {
            signature = uniqueId;
        } else if (!Strings.isNullOrEmpty((String)loginName)) {
            signature = loginName;
        } else {
            throw new TskCoreException("OS Account must have either a uniqueID or a login name.");
        }
        return signature;
    }

    public static class NotUserSIDException
    extends TskException {
        private static final long serialVersionUID = 1L;

        public NotUserSIDException() {
            super("No error message available.");
        }

        public NotUserSIDException(String msg) {
            super(msg);
        }

        public NotUserSIDException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    public static final class OsAccountUpdateResult {
        private final OsAccountUpdateStatus updateStatus;
        private final OsAccount updatedAccount;

        OsAccountUpdateResult(OsAccountUpdateStatus updateStatus, OsAccount updatedAccount) {
            this.updateStatus = updateStatus;
            this.updatedAccount = updatedAccount;
        }

        public OsAccountUpdateStatus getUpdateStatusCode() {
            return this.updateStatus;
        }

        public Optional<OsAccount> getUpdatedAccount() {
            return Optional.ofNullable(this.updatedAccount);
        }
    }

    private class OsAccountInstanceKey
    implements Comparable<OsAccountInstanceKey> {
        private final long osAccountId;
        private final long dataSourceId;

        OsAccountInstanceKey(OsAccountManager osAccountManager, long osAccountId, long dataSourceId) {
            this.osAccountId = osAccountId;
            this.dataSourceId = dataSourceId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            OsAccountInstanceKey otherKey = (OsAccountInstanceKey)other;
            if (this.osAccountId != otherKey.osAccountId) {
                return false;
            }
            return this.dataSourceId == otherKey.dataSourceId;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (int)(this.osAccountId ^ this.osAccountId >>> 32);
            hash = 53 * hash + (int)(this.dataSourceId ^ this.dataSourceId >>> 32);
            return hash;
        }

        @Override
        public int compareTo(OsAccountInstanceKey other) {
            if (this.equals(other)) {
                return 0;
            }
            if (this.dataSourceId != other.dataSourceId) {
                return Long.compare(this.dataSourceId, other.dataSourceId);
            }
            return Long.compare(this.osAccountId, other.osAccountId);
        }
    }

    public static enum OsAccountUpdateStatus {
        NO_CHANGE,
        UPDATED,
        MERGED;

    }
}

