/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.Host;

public final class OsAccountRealm {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final long id;
    private final String realmName;
    private final String realmAddr;
    private String signature;
    private final Host host;
    private final ScopeConfidence scopeConfidence;
    private final RealmDbStatus dbStatus;

    OsAccountRealm(long id, String realmName, String realmAddr, String signature, Host host, ScopeConfidence scopeConfidence, RealmDbStatus dbStatus) {
        this.id = id;
        this.realmName = realmName;
        this.realmAddr = realmAddr;
        this.signature = signature;
        this.host = host;
        this.scopeConfidence = scopeConfidence;
        this.dbStatus = dbStatus;
    }

    long getRealmId() {
        return this.id;
    }

    public List<String> getRealmNames() {
        ArrayList<String> namesList = new ArrayList<String>();
        if (!Objects.isNull(this.realmName)) {
            namesList.add(this.realmName);
        }
        return namesList;
    }

    public Optional<String> getRealmAddr() {
        return Optional.ofNullable(this.realmAddr);
    }

    String getSignature() {
        return this.signature;
    }

    public Optional<Host> getScopeHost() {
        return Optional.ofNullable(this.host);
    }

    public ScopeConfidence getScopeConfidence() {
        return this.scopeConfidence;
    }

    RealmDbStatus getDbStatus() {
        return this.dbStatus;
    }

    public RealmScope getScope() {
        return this.getScopeHost().isPresent() ? RealmScope.LOCAL : RealmScope.DOMAIN;
    }

    boolean setSignature(String signature) {
        if (StringUtils.isNotBlank((CharSequence)signature)) {
            this.signature = signature;
            return true;
        }
        return false;
    }

    public static enum ScopeConfidence {
        KNOWN(0, bundle.getString("OsAccountRealm.Known.text")),
        INFERRED(1, bundle.getString("OsAccountRealm.Inferred.text"));

        private final int id;
        private final String name;

        private ScopeConfidence(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static ScopeConfidence fromID(int typeId) {
            for (ScopeConfidence statusType : ScopeConfidence.values()) {
                if (statusType.ordinal() != typeId) continue;
                return statusType;
            }
            return null;
        }
    }

    static enum RealmDbStatus {
        ACTIVE(0, "Active"),
        MERGED(1, "Merged"),
        DELETED(2, "Deleted");

        private final int id;
        private final String name;

        private RealmDbStatus(int id, String name) {
            this.id = id;
            this.name = name;
        }

        int getId() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        static RealmDbStatus fromID(int typeId) {
            for (RealmDbStatus type : RealmDbStatus.values()) {
                if (type.ordinal() != typeId) continue;
                return type;
            }
            return null;
        }
    }

    public static enum RealmScope {
        UNKNOWN(0, bundle.getString("OsAccountRealm.Unknown.text")),
        LOCAL(1, bundle.getString("OsAccountRealm.Local.text")),
        DOMAIN(2, bundle.getString("OsAccountRealm.Domain.text"));

        private final int id;
        private final String name;

        private RealmScope(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static RealmScope fromID(int typeId) {
            for (RealmScope scopeType : RealmScope.values()) {
                if (scopeType.ordinal() != typeId) continue;
                return scopeType;
            }
            return null;
        }
    }
}

