/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccountManager;
import org.sleuthkit.datamodel.OsAccountRealm;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.WindowsAccountUtils;

public final class OsAccountRealmManager {
    private static final Logger LOGGER = Logger.getLogger(OsAccountRealmManager.class.getName());
    private static final String LOCAL_REALM_NAME = "local";
    private final SleuthkitCase db;
    private static final String REALM_QUERY_STRING = "SELECT realms.id as realm_id, realms.realm_name as realm_name, realms.realm_addr as realm_addr, realms.realm_signature as realm_signature, realms.scope_host_id, realms.scope_confidence, realms.db_status, hosts.id, hosts.name as host_name  FROM tsk_os_account_realms as realms\t\tLEFT JOIN tsk_hosts as hosts ON realms.scope_host_id = hosts.id";

    OsAccountRealmManager(SleuthkitCase skCase) {
        this.db = skCase;
    }

    public OsAccountRealm newWindowsRealm(String accountSid, String realmName, Host referringHost, OsAccountRealm.RealmScope realmScope) throws TskCoreException, OsAccountManager.NotUserSIDException {
        Host scopeHost;
        if (realmScope == null) {
            throw new TskCoreException("RealmScope cannot be null. Use UNKNOWN if scope is not known.");
        }
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to create a realm.");
        }
        if ((StringUtils.isBlank((CharSequence)accountSid) || accountSid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)realmName)) {
            throw new TskCoreException("Either an address or a name is required to create a realm.");
        }
        if (StringUtils.isNotBlank((CharSequence)accountSid)) {
            accountSid = accountSid.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)realmName)) {
            realmName = realmName.toLowerCase(Locale.ENGLISH);
        }
        OsAccountRealm.ScopeConfidence scopeConfidence = switch (realmScope) {
            case OsAccountRealm.RealmScope.DOMAIN -> {
                scopeHost = null;
                yield OsAccountRealm.ScopeConfidence.KNOWN;
            }
            case OsAccountRealm.RealmScope.LOCAL -> {
                scopeHost = referringHost;
                yield OsAccountRealm.ScopeConfidence.KNOWN;
            }
            default -> {
                boolean isHostRealmKnown = this.isHostRealmKnown(referringHost);
                if (isHostRealmKnown) {
                    scopeHost = null;
                    yield OsAccountRealm.ScopeConfidence.KNOWN;
                }
                scopeHost = referringHost;
                yield OsAccountRealm.ScopeConfidence.INFERRED;
            }
        };
        String realmAddr = null;
        String resolvedRealmName = WindowsAccountUtils.toWellknownEnglishRealmName(realmName);
        if (!Strings.isNullOrEmpty((String)accountSid) && !accountSid.equalsIgnoreCase("S-1-0-0")) {
            if (!WindowsAccountUtils.isWindowsUserSid(accountSid)) {
                throw new OsAccountManager.NotUserSIDException(String.format("SID = %s is not a user SID.", accountSid));
            }
            realmAddr = WindowsAccountUtils.getWindowsRealmAddress(accountSid);
            if (WindowsAccountUtils.isWindowsWellKnownSid(accountSid)) {
                scopeHost = referringHost;
                scopeConfidence = OsAccountRealm.ScopeConfidence.KNOWN;
                String wellKnownRealmName = WindowsAccountUtils.getWindowsWellKnownSidRealmName(accountSid);
                if (!StringUtils.isEmpty((CharSequence)wellKnownRealmName)) {
                    resolvedRealmName = wellKnownRealmName;
                }
            }
        }
        String signature = OsAccountRealmManager.makeRealmSignature(realmAddr, resolvedRealmName, scopeHost);
        return this.newRealm(resolvedRealmName, realmAddr, signature, scopeHost, scopeConfidence);
    }

    @Beta
    public OsAccountRealm newLocalLinuxRealm(Host referringHost) throws TskCoreException {
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required to create a realm.");
        }
        String realmName = LOCAL_REALM_NAME;
        OsAccountRealm.ScopeConfidence scopeConfidence = OsAccountRealm.ScopeConfidence.KNOWN;
        String signature = OsAccountRealmManager.makeRealmSignature("", realmName, referringHost);
        return this.newRealm(realmName, "", signature, referringHost, scopeConfidence);
    }

    @Beta
    public Optional<OsAccountRealm> getLocalLinuxRealm(Host referringHost) throws TskCoreException {
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required get a realm.");
        }
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            Optional<OsAccountRealm> optional = this.getRealmByName(LOCAL_REALM_NAME, referringHost, connection);
            return optional;
        }
    }

    public Optional<OsAccountRealm> getWindowsRealm(String accountSid, String realmName, Host referringHost) throws TskCoreException, OsAccountManager.NotUserSIDException {
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required get a realm.");
        }
        if ((Strings.isNullOrEmpty((String)accountSid) || accountSid.equalsIgnoreCase("S-1-0-0")) && Strings.isNullOrEmpty((String)realmName)) {
            throw new TskCoreException("Realm address or name is required get a realm.");
        }
        if (StringUtils.isNotBlank((CharSequence)accountSid)) {
            accountSid = accountSid.toUpperCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)realmName)) {
            realmName = realmName.toLowerCase(Locale.ENGLISH);
        }
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            Optional<OsAccountRealm> optional = this.getWindowsRealm(accountSid, realmName, referringHost, connection);
            return optional;
        }
    }

    Optional<OsAccountRealm> getWindowsRealm(String accountSid, String realmName, Host referringHost, SleuthkitCase.CaseDbConnection connection) throws TskCoreException, OsAccountManager.NotUserSIDException {
        String resolvedRealmName;
        Optional<OsAccountRealm> realm;
        if (referringHost == null) {
            throw new TskCoreException("A referring host is required get a realm.");
        }
        if ((StringUtils.isBlank((CharSequence)accountSid) || accountSid.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)realmName)) {
            throw new TskCoreException("Realm address or name is required get a realm.");
        }
        if (!Strings.isNullOrEmpty((String)accountSid) && !accountSid.equalsIgnoreCase("S-1-0-0")) {
            if (!WindowsAccountUtils.isWindowsUserSid(accountSid)) {
                throw new OsAccountManager.NotUserSIDException(String.format("SID = %s is not a user SID.", accountSid));
            }
            String realmAddr = WindowsAccountUtils.getWindowsRealmAddress(accountSid);
            realm = this.getRealmByAddr(realmAddr, referringHost, connection);
            if (realm.isPresent()) {
                return realm;
            }
        }
        if ((realm = this.getRealmByName(resolvedRealmName = WindowsAccountUtils.toWellknownEnglishRealmName(realmName), referringHost, connection)).isPresent() && !Strings.isNullOrEmpty((String)accountSid) && !accountSid.equalsIgnoreCase("S-1-0-0") && realm.get().getRealmAddr().isPresent()) {
            return Optional.empty();
        }
        return realm;
    }

    OsRealmUpdateResult getAndUpdateWindowsRealm(String accountSid, String realmName, Host referringHost, SleuthkitCase.CaseDbConnection connection) throws TskCoreException, OsAccountManager.NotUserSIDException {
        Optional<OsAccountRealm> realmOptional = this.getWindowsRealm(accountSid, realmName, referringHost, connection);
        if (realmOptional.isPresent()) {
            String realmAddr = StringUtils.isNotBlank((CharSequence)accountSid) && !accountSid.equalsIgnoreCase("S-1-0-0") ? WindowsAccountUtils.getWindowsRealmAddress(accountSid) : null;
            OsRealmUpdateResult realmUpdateResult = this.updateRealm(realmOptional.get(), realmAddr, realmName, connection);
            return realmUpdateResult;
        }
        return new OsRealmUpdateResult(OsRealmUpdateStatus.NO_CHANGE, null);
    }

    public OsRealmUpdateResult updateRealm(OsAccountRealm realm, String realmAddr, String realmName) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            OsRealmUpdateResult osRealmUpdateResult = this.updateRealm(realm, realmAddr, realmName, connection);
            return osRealmUpdateResult;
        }
    }

    private OsRealmUpdateResult updateRealm(OsAccountRealm realm, String realmAddr, String realmName, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        if ((StringUtils.isBlank((CharSequence)realmAddr) || realmAddr.equalsIgnoreCase("S-1-0-0")) && StringUtils.isBlank((CharSequence)realmName)) {
            throw new TskCoreException("Realm address or name is required to update realm.");
        }
        OsRealmUpdateStatus updateStatusCode = OsRealmUpdateStatus.NO_CHANGE;
        OsAccountRealm updatedRealm = null;
        this.db.acquireSingleUserCaseWriteLock();
        try {
            List<String> realmNames;
            String currRealmName;
            String currRealmAddr = realm.getRealmAddr().orElse(null);
            if (StringUtils.isBlank((CharSequence)currRealmAddr) && StringUtils.isNotBlank((CharSequence)realmAddr) && !realmAddr.equalsIgnoreCase("S-1-0-0")) {
                this.updateRealmColumn(realm.getRealmId(), "realm_addr", realmAddr, connection);
                currRealmAddr = realmAddr;
                updateStatusCode = OsRealmUpdateStatus.UPDATED;
            }
            String string = currRealmName = (realmNames = realm.getRealmNames()).isEmpty() ? null : realmNames.get(0);
            if (StringUtils.isBlank((CharSequence)currRealmName) && StringUtils.isNotBlank((CharSequence)realmName)) {
                this.updateRealmColumn(realm.getRealmId(), "realm_name", realmName, connection);
                updateStatusCode = OsRealmUpdateStatus.UPDATED;
            }
            if (updateStatusCode == OsRealmUpdateStatus.NO_CHANGE) {
                OsRealmUpdateResult osRealmUpdateResult = new OsRealmUpdateResult(updateStatusCode, realm);
                return osRealmUpdateResult;
            }
            OsAccountRealm currRealm = this.getRealmByRealmId(realm.getRealmId(), connection);
            String newRealmAddr = currRealm.getRealmAddr().orElse(null);
            String newRealmName = !currRealm.getRealmNames().isEmpty() ? currRealm.getRealmNames().get(0) : null;
            String newSignature = OsAccountRealmManager.makeRealmSignature(newRealmAddr, newRealmName, realm.getScopeHost().orElse(null));
            String updateSQL = "UPDATE tsk_os_account_realms SET   realm_signature =    CASE WHEN db_status = " + OsAccountRealm.RealmDbStatus.ACTIVE.getId() + " THEN ? ELSE realm_signature END  WHERE id = ?";
            PreparedStatement preparedStatement = connection.getPreparedStatement(updateSQL, 2);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, newSignature);
            preparedStatement.setLong(2, realm.getRealmId());
            connection.executeUpdate(preparedStatement);
            updatedRealm = this.getRealmByRealmId(realm.getRealmId(), connection);
            OsRealmUpdateResult osRealmUpdateResult = new OsRealmUpdateResult(updateStatusCode, updatedRealm);
            return osRealmUpdateResult;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating realm with id = %d, name = %s, addr = %s", realm.getRealmId(), realmName != null ? realmName : "Null", realm.getRealmAddr().orElse("Null")), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void updateRealmColumn(long realmId, String colName, T colValue, SleuthkitCase.CaseDbConnection connection) throws SQLException, TskCoreException {
        String updateSQL = "UPDATE tsk_os_account_realms  SET " + colName + " = ?  WHERE id = ?";
        this.db.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement preparedStatement = connection.getPreparedStatement(updateSQL, 2);
            preparedStatement.clearParameters();
            if (Objects.isNull(colValue)) {
                preparedStatement.setNull(1, 0);
            } else if (colValue instanceof String) {
                preparedStatement.setString(1, (String)colValue);
            } else if (colValue instanceof Long) {
                preparedStatement.setLong(1, (Long)colValue);
            } else if (colValue instanceof Integer) {
                preparedStatement.setInt(1, (Integer)colValue);
            } else {
                throw new TskCoreException(String.format("Unhandled column data type received while updating the realm (id = %d) ", realmId));
            }
            preparedStatement.setLong(2, realmId);
            connection.executeUpdate(preparedStatement);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    public OsAccountRealm getRealmByRealmId(long id) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            OsAccountRealm osAccountRealm = this.getRealmByRealmId(id, connection);
            return osAccountRealm;
        }
    }

    /*
     * Exception decompiling
     */
    OsAccountRealm getRealmByRealmId(long id, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Optional<OsAccountRealm> getRealmByAddr(String realmAddr, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String whereHostClause = host == null ? " 1 = 1 " : " ( realms.scope_host_id = " + host.getHostId() + " OR realms.scope_host_id IS NULL) ";
        String queryString = "SELECT realms.id as realm_id, realms.realm_name as realm_name, realms.realm_addr as realm_addr, realms.realm_signature as realm_signature, realms.scope_host_id, realms.scope_confidence, realms.db_status, hosts.id, hosts.name as host_name  FROM tsk_os_account_realms as realms\t\tLEFT JOIN tsk_hosts as hosts ON realms.scope_host_id = hosts.id WHERE realms.realm_addr = '" + realmAddr + "'  AND " + whereHostClause + " AND realms.db_status = " + OsAccountRealm.RealmDbStatus.ACTIVE.getId() + " ORDER BY realms.scope_host_id IS NOT NULL, realms.scope_host_id";
        return this.getRealmUsingQuery(queryString, host, connection);
    }

    Optional<OsAccountRealm> getAnotherRealmByAddr(OsAccountRealm realm, String realmAddr, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String whereHostClause = realm.getScopeHost().isPresent() ? " ( realms.scope_host_id = " + realm.getScopeHost().get().getHostId() + " ) " : " realms.scope_host_id IS NULL ";
        String queryString = "SELECT realms.id as realm_id, realms.realm_name as realm_name, realms.realm_addr as realm_addr, realms.realm_signature as realm_signature, realms.scope_host_id, realms.scope_confidence, realms.db_status, hosts.id, hosts.name as host_name  FROM tsk_os_account_realms as realms\t\tLEFT JOIN tsk_hosts as hosts ON realms.scope_host_id = hosts.id WHERE realms.realm_addr = '" + realmAddr + "'  AND " + whereHostClause + " AND realms.id <> " + realm.getRealmId() + " AND realms.db_status = " + OsAccountRealm.RealmDbStatus.ACTIVE.getId() + " ORDER BY realms.scope_host_id IS NOT NULL, realms.scope_host_id";
        return this.getRealmUsingQuery(queryString, host, connection);
    }

    Optional<OsAccountRealm> getRealmByName(String realmName, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String whereHostClause = host == null ? " 1 = 1 " : " ( realms.scope_host_id = " + host.getHostId() + " OR realms.scope_host_id IS NULL ) ";
        String queryString = "SELECT realms.id as realm_id, realms.realm_name as realm_name, realms.realm_addr as realm_addr, realms.realm_signature as realm_signature, realms.scope_host_id, realms.scope_confidence, realms.db_status, hosts.id, hosts.name as host_name  FROM tsk_os_account_realms as realms\t\tLEFT JOIN tsk_hosts as hosts ON realms.scope_host_id = hosts.id WHERE realms.realm_name = '" + realmName + "' AND " + whereHostClause + " AND realms.db_status = " + OsAccountRealm.RealmDbStatus.ACTIVE.getId() + " ORDER BY realms.scope_host_id IS NOT NULL, realms.scope_host_id";
        return this.getRealmUsingQuery(queryString, host, connection);
    }

    Optional<OsAccountRealm> getAnotherRealmByName(OsAccountRealm realm, String realmName, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String whereHostClause = realm.getScopeHost().isPresent() ? " ( realms.scope_host_id = " + realm.getScopeHost().get().getHostId() + " ) " : " realms.scope_host_id IS NULL ";
        String queryString = "SELECT realms.id as realm_id, realms.realm_name as realm_name, realms.realm_addr as realm_addr, realms.realm_signature as realm_signature, realms.scope_host_id, realms.scope_confidence, realms.db_status, hosts.id, hosts.name as host_name  FROM tsk_os_account_realms as realms\t\tLEFT JOIN tsk_hosts as hosts ON realms.scope_host_id = hosts.id WHERE realms.realm_name = '" + realmName + "' AND " + whereHostClause + " AND realms.id <> " + realm.getRealmId() + " AND realms.db_status = " + OsAccountRealm.RealmDbStatus.ACTIVE.getId() + " ORDER BY realms.scope_host_id IS NOT NULL, realms.scope_host_id";
        return this.getRealmUsingQuery(queryString, host, connection);
    }

    /*
     * Exception decompiling
     */
    private Optional<OsAccountRealm> getRealmUsingQuery(String queryString, Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean isHostRealmKnown(Host host) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OsAccountRealm resultSetToAccountRealm(ResultSet rs) throws SQLException {
        long hostId = rs.getLong("scope_host_id");
        Host realmHost = null;
        if (!rs.wasNull()) {
            realmHost = new Host(hostId, rs.getString("host_name"));
        }
        return new OsAccountRealm(rs.getLong("realm_id"), rs.getString("realm_name"), rs.getString("realm_addr"), rs.getString("realm_signature"), realmHost, OsAccountRealm.ScopeConfidence.fromID(rs.getInt("scope_confidence")), OsAccountRealm.RealmDbStatus.fromID(rs.getInt("db_status")));
    }

    /*
     * Exception decompiling
     */
    private OsAccountRealm newRealm(String realmName, String realmAddr, String signature, Host host, OsAccountRealm.ScopeConfidence scopeConfidence) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String makeRealmSignature(String realmAddr, String realmName, Host scopeHost) throws TskCoreException {
        if (Strings.isNullOrEmpty((String)realmAddr) && Strings.isNullOrEmpty((String)realmName)) {
            throw new TskCoreException("Realm address and name can't both be null.");
        }
        String signature = String.format("%s_%s", !Strings.isNullOrEmpty((String)realmAddr) ? realmAddr : realmName, scopeHost != null ? Long.valueOf(scopeHost.getHostId()) : "DOMAIN");
        return signature;
    }

    private String makeMergedRealmSignature() {
        return "MERGED " + UUID.randomUUID().toString();
    }

    void moveOrMergeRealm(OsAccountRealm sourceRealm, Host destHost, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        Optional<Object> optDestRealmAddr = Optional.empty();
        if (sourceRealm.getRealmAddr().isPresent()) {
            optDestRealmAddr = this.db.getOsAccountRealmManager().getRealmByAddr(sourceRealm.getRealmAddr().get(), destHost, trans.getConnection());
        }
        Optional<Object> optDestRealmName = Optional.empty();
        if (!sourceRealm.getRealmNames().isEmpty()) {
            optDestRealmName = this.db.getOsAccountRealmManager().getRealmByName(sourceRealm.getRealmNames().get(0), destHost, trans.getConnection());
        }
        OsAccountRealm destRealm = null;
        if (optDestRealmAddr.isPresent() && optDestRealmName.isPresent()) {
            if (((OsAccountRealm)optDestRealmAddr.get()).getRealmId() == ((OsAccountRealm)optDestRealmName.get()).getRealmId()) {
                destRealm = (OsAccountRealm)optDestRealmAddr.get();
            } else if (((OsAccountRealm)optDestRealmName.get()).getRealmAddr().isPresent()) {
                destRealm = (OsAccountRealm)optDestRealmAddr.get();
            } else {
                this.mergeRealms((OsAccountRealm)optDestRealmName.get(), (OsAccountRealm)optDestRealmAddr.get(), trans);
                destRealm = this.getRealmByRealmId(((OsAccountRealm)optDestRealmAddr.get()).getRealmId(), trans.getConnection());
            }
        } else if (optDestRealmAddr.isPresent()) {
            destRealm = (OsAccountRealm)optDestRealmAddr.get();
        } else if (!(!optDestRealmName.isPresent() || ((OsAccountRealm)optDestRealmName.get()).getRealmAddr().isPresent() && sourceRealm.getRealmAddr().isPresent())) {
            destRealm = (OsAccountRealm)optDestRealmName.get();
        }
        if (destRealm == null) {
            this.moveRealm(sourceRealm, destHost, trans);
        } else {
            this.mergeRealms(sourceRealm, destRealm, trans);
        }
    }

    private void moveRealm(OsAccountRealm sourceRealm, Host destHost, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        try (Statement s = trans.getConnection().createStatement();){
            String query = "UPDATE tsk_os_account_realms SET scope_host_id = " + destHost.getHostId() + " WHERE id = " + sourceRealm.getRealmId();
            s.executeUpdate(query);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error moving realm with id: " + sourceRealm.getRealmId() + " to host with id: " + destHost.getHostId(), ex);
        }
    }

    void mergeRealms(OsAccountRealm sourceRealm, OsAccountRealm destRealm, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        this.db.getOsAccountManager().mergeOsAccountsForRealms(sourceRealm, destRealm, trans);
        SleuthkitCase.CaseDbConnection connection = trans.getConnection();
        try (Statement statement = connection.createStatement();){
            String updateStr = "UPDATE tsk_os_account_realms SET db_status = " + OsAccountRealm.RealmDbStatus.MERGED.getId() + ", merged_into = " + destRealm.getRealmId() + ", realm_signature = '" + this.makeMergedRealmSignature() + "'  WHERE id = " + sourceRealm.getRealmId();
            connection.executeUpdate(statement, updateStr);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating status of realm with id: " + sourceRealm.getRealmId(), ex);
        }
        if (!destRealm.getRealmAddr().isPresent() && sourceRealm.getRealmAddr().isPresent()) {
            this.updateRealm(destRealm, sourceRealm.getRealmAddr().get(), null, trans.getConnection());
        } else if (destRealm.getRealmNames().isEmpty() && !sourceRealm.getRealmNames().isEmpty()) {
            this.updateRealm(destRealm, null, sourceRealm.getRealmNames().get(0), trans.getConnection());
        }
    }

    /*
     * Exception decompiling
     */
    List<OsAccountRealm> getRealmsByHost(Host host, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class OsRealmUpdateResult {
        private final OsRealmUpdateStatus updateStatus;
        private final OsAccountRealm updatedRealm;

        OsRealmUpdateResult(OsRealmUpdateStatus updateStatus, OsAccountRealm updatedRealm) {
            this.updateStatus = updateStatus;
            this.updatedRealm = updatedRealm;
        }

        public OsRealmUpdateStatus getUpdateStatus() {
            return this.updateStatus;
        }

        public Optional<OsAccountRealm> getUpdatedRealm() {
            return Optional.ofNullable(this.updatedRealm);
        }
    }

    public static enum OsRealmUpdateStatus {
        NO_CHANGE,
        UPDATED,
        MERGED;

    }
}

