/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;

public class Score
implements Comparable<Score> {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    public static final Score SCORE_NOTABLE = new Score(Significance.NOTABLE, Priority.NORMAL);
    public static final Score SCORE_LIKELY_NOTABLE = new Score(Significance.LIKELY_NOTABLE, Priority.NORMAL);
    public static final Score SCORE_LIKELY_NONE = new Score(Significance.LIKELY_NONE, Priority.NORMAL);
    public static final Score SCORE_NONE = new Score(Significance.NONE, Priority.NORMAL);
    public static final Score SCORE_UNKNOWN = new Score(Significance.UNKNOWN, Priority.NORMAL);
    private final Significance significance;
    private final Priority priority;

    public Score(Significance significance, Priority priority) {
        this.significance = significance;
        this.priority = priority;
    }

    public Significance getSignificance() {
        return this.significance;
    }

    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(Score other) {
        if (this.getPriority() != other.getPriority()) {
            return this.getPriority().ordinal() - other.getPriority().ordinal();
        }
        return this.getSignificance().ordinal() - other.getSignificance().ordinal();
    }

    public static final Comparator<Score> getScoreComparator() {
        return (score1, score2) -> score1.compareTo((Score)score2);
    }

    public static enum Significance {
        UNKNOWN(0, "Unknown", "Significance.Unknown.displayName.text"),
        LIKELY_NONE(8, "LikelyNone", "Significance.LikelyNone.displayName.text"),
        LIKELY_NOTABLE(9, "LikelyNotable", "Significance.LikelyNotable.displayName.text"),
        NONE(18, "None", "Significance.None.displayName.text"),
        NOTABLE(19, "Notable", "Significance.Notable.displayName.text");

        private final int id;
        private final String name;
        private final String displayNameKey;

        private Significance(int id, String name, String displayNameKey) {
            this.id = id;
            this.name = name;
            this.displayNameKey = displayNameKey;
        }

        public static Significance fromString(String name) {
            return Arrays.stream(Significance.values()).filter(val -> val.getName().equals(name)).findFirst().orElse(NONE);
        }

        public static Significance fromID(int id) {
            return Arrays.stream(Significance.values()).filter(val -> val.getId() == id).findFirst().orElse(NONE);
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return bundle.getString(this.displayNameKey);
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Priority {
        NORMAL(0, "Normal", "Score.Priority.Normal.displayName.text"),
        OVERRIDE(10, "Override", "Score.Priority.Override.displayName.text");

        private final int id;
        private final String name;
        private final String displayNameKey;

        private Priority(int id, String name, String displayNameKey) {
            this.id = id;
            this.name = name;
            this.displayNameKey = displayNameKey;
        }

        public static Priority fromString(String name) {
            return Arrays.stream(Priority.values()).filter(val -> val.getName().equals(name)).findFirst().orElse(NORMAL);
        }

        public static Priority fromID(int id) {
            return Arrays.stream(Priority.values()).filter(val -> val.getId() == id).findFirst().orElse(NORMAL);
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return bundle.getString(this.displayNameKey);
        }

        public String toString() {
            return this.name;
        }
    }
}

