/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.AddDataSourceCallbacks;
import org.sleuthkit.datamodel.CaseDbConnectionInfo;
import org.sleuthkit.datamodel.DefaultAddDataSourceCallbacks;
import org.sleuthkit.datamodel.HashEntry;
import org.sleuthkit.datamodel.HashHitInfo;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.LibraryUtils;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCaseDbBridge;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskDataException;

public class SleuthkitJNI {
    private static final Logger logger = Logger.getLogger(SleuthkitJNI.class.getName());
    private static final ReadWriteLock tskLock = new ReentrantReadWriteLock();

    private SleuthkitJNI() {
    }

    static CaseDbHandle newCaseDb(String path) throws TskCoreException {
        return new CaseDbHandle(path);
    }

    static CaseDbHandle newCaseDb(String databaseName, CaseDbConnectionInfo info) throws TskCoreException {
        return new CaseDbHandle(databaseName, info);
    }

    static CaseDbHandle openCaseDb(String path) throws TskCoreException {
        return new CaseDbHandle(path);
    }

    static CaseDbHandle openCaseDb(String databaseName, CaseDbConnectionInfo info) throws TskCoreException {
        return new CaseDbHandle(databaseName, info);
    }

    public static String getVersion() {
        return SleuthkitJNI.getVersionNat();
    }

    public static void startVerboseLogging(String logPath) {
        SleuthkitJNI.startVerboseLoggingNat(logPath);
    }

    public static long openImage(String[] imageFiles, SleuthkitCase skCase) throws TskCoreException {
        if (skCase == null) {
            throw new TskCoreException("SleuthkitCase can not be null");
        }
        return SleuthkitJNI.openImage(imageFiles, 0, true, skCase.getCaseHandleIdentifier());
    }

    public static long openImage(String[] imageFiles, int sSize, SleuthkitCase skCase) throws TskCoreException {
        if (skCase == null) {
            throw new TskCoreException("SleuthkitCase can not be null");
        }
        return SleuthkitJNI.openImage(imageFiles, sSize, true, skCase.getCaseHandleIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long openImage(String[] imageFiles, int sSize, boolean useCache, String caseIdentifer) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long imageHandle;
            StringBuilder keyBuilder = new StringBuilder();
            for (int i = 0; i < imageFiles.length; ++i) {
                keyBuilder.append(imageFiles[i]);
            }
            String imageKey = keyBuilder.toString();
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                String nonNullCaseIdentifer = caseIdentifer;
                if (nonNullCaseIdentifer == null) {
                    nonNullCaseIdentifer = HandleCache.getDefaultCaseIdentifier();
                }
                if (!useCache && HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.containsKey(imageKey)) {
                    long tempImageHandle = HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.get(imageKey);
                    String newPath = "Image_" + UUID.randomUUID().toString();
                    HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.put(newPath, tempImageHandle);
                    HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.remove(imageKey);
                }
                if (useCache && HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.containsKey(imageKey)) {
                    imageHandle = HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.get(imageKey);
                } else {
                    imageHandle = SleuthkitJNI.openImgNat(imageFiles, imageFiles.length, sSize);
                    HandleCache.getCaseHandles((String)nonNullCaseIdentifer).fsHandleCache.put(imageHandle, new HashMap());
                    HandleCache.getCaseHandles((String)nonNullCaseIdentifer).imageHandleCache.put(imageKey, imageHandle);
                }
            }
            long l = imageHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheImageHandle(SleuthkitCase skCase, List<String> imagePaths, long imageHandle) throws TskCoreException {
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < imagePaths.size(); ++i) {
            keyBuilder.append(imagePaths.get(i));
        }
        String imageKey = keyBuilder.toString();
        String caseIdentifier = skCase.getCaseHandleIdentifier();
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            HandleCache.getCaseHandles((String)caseIdentifier).fsHandleCache.put(imageHandle, new HashMap());
            HandleCache.getCaseHandles((String)caseIdentifier).imageHandleCache.put(imageKey, imageHandle);
        }
    }

    public static Image addImageToDatabase(SleuthkitCase skCase, String[] imagePaths, int sectorSize, String timeZone, String md5fromSettings, String sha1fromSettings, String sha256fromSettings, String deviceId) throws TskCoreException {
        return SleuthkitJNI.addImageToDatabase(skCase, imagePaths, sectorSize, timeZone, md5fromSettings, sha1fromSettings, sha256fromSettings, deviceId, null);
    }

    public static Image addImageToDatabase(SleuthkitCase skCase, String[] imagePaths, int sectorSize, String timeZone, String md5fromSettings, String sha1fromSettings, String sha256fromSettings, String deviceId, Host host) throws TskCoreException {
        return SleuthkitJNI.addImageToDatabase(skCase, imagePaths, sectorSize, timeZone, md5fromSettings, sha1fromSettings, sha256fromSettings, deviceId, null, host);
    }

    @Beta
    public static Image addImageToDatabase(SleuthkitCase skCase, String[] imagePaths, int sectorSize, String timeZone, String md5fromSettings, String sha1fromSettings, String sha256fromSettings, String deviceId, String password, Host host) throws TskCoreException {
        String sha256;
        String sha1;
        long imageHandle = SleuthkitJNI.openImgNat(imagePaths, 1, sectorSize);
        List<String> computedPaths = Arrays.asList(SleuthkitJNI.getPathsForImageNat(imageHandle));
        long size = SleuthkitJNI.getSizeForImageNat(imageHandle);
        long type = SleuthkitJNI.getTypeForImageNat(imageHandle);
        long computedSectorSize = SleuthkitJNI.getSectorSizeForImageNat(imageHandle);
        String md5 = md5fromSettings;
        if (StringUtils.isEmpty((CharSequence)md5)) {
            md5 = SleuthkitJNI.getMD5HashForImageNat(imageHandle);
        }
        if (StringUtils.isEmpty((CharSequence)(sha1 = sha1fromSettings))) {
            sha1 = SleuthkitJNI.getSha1HashForImageNat(imageHandle);
        }
        if ((sha256 = sha256fromSettings) == null) {
            sha256 = "";
        }
        String collectionDetails = SleuthkitJNI.getCollectionDetailsForImageNat(imageHandle);
        SleuthkitCase.CaseDbTransaction transaction = skCase.beginTransaction();
        try {
            Image img = skCase.addImage(TskData.TSK_IMG_TYPE_ENUM.valueOf(type), computedSectorSize, size, null, computedPaths, timeZone, md5, sha1, sha256, deviceId, host, password, transaction);
            if (!StringUtils.isEmpty((CharSequence)collectionDetails)) {
                skCase.setAcquisitionDetails(img, collectionDetails);
            }
            transaction.commit();
            img.setImageHandle(imageHandle);
            SleuthkitJNI.cacheImageHandle(skCase, computedPaths, imageHandle);
            return img;
        }
        catch (TskCoreException ex) {
            transaction.rollback();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openVs(long imgHandle, long vsOffset) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            long l = SleuthkitJNI.openVsNat(imgHandle, vsOffset);
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openVsPart(long vsHandle, long volId) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long l = SleuthkitJNI.openVolNat(vsHandle, volId);
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static long openPool(long imgHandle, long offset, SleuthkitCase skCase) throws TskCoreException {
        Map<Long, Long> poolCacheForImage;
        block8: {
            long l;
            SleuthkitJNI.getTSKReadLock();
            try {
                if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                    throw new TskCoreException("Image handle " + imgHandle + " is closed");
                }
                Object object = HandleCache.cacheLock;
                // MONITORENTER : object
                String caseIdentifier = skCase == null ? HandleCache.getDefaultCaseIdentifier() : skCase.getCaseHandleIdentifier();
                if (!HandleCache.getCaseHandles((String)caseIdentifier).poolHandleCache.containsKey(imgHandle)) {
                    HandleCache.getCaseHandles((String)caseIdentifier).poolHandleCache.put(imgHandle, new HashMap());
                }
                if (!(poolCacheForImage = HandleCache.getCaseHandles((String)caseIdentifier).poolHandleCache.get(imgHandle)).containsKey(offset)) break block8;
                l = poolCacheForImage.get(offset);
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                SleuthkitJNI.releaseTSKReadLock();
                throw throwable;
            }
            SleuthkitJNI.releaseTSKReadLock();
            return l;
        }
        long poolHandle = SleuthkitJNI.openPoolNat(imgHandle, offset);
        poolCacheForImage.put(offset, poolHandle);
        long l = poolHandle;
        // MONITOREXIT : object
        SleuthkitJNI.releaseTSKReadLock();
        return l;
    }

    public static long openFs(long imgHandle, long fsOffset, SleuthkitCase skCase) throws TskCoreException {
        return SleuthkitJNI.openFs(imgHandle, fsOffset, "", skCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openFs(long imgHandle, long fsOffset, String password, SleuthkitCase skCase) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long fsHandle;
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                String caseIdentifier = skCase == null ? HandleCache.getDefaultCaseIdentifier() : skCase.getCaseHandleIdentifier();
                Map<Long, Long> imgOffSetToFsHandle = HandleCache.getCaseHandles((String)caseIdentifier).fsHandleCache.get(imgHandle);
                if (imgOffSetToFsHandle == null) {
                    throw new TskCoreException("Missing image offset to file system handle cache for image handle " + imgHandle);
                }
                if (imgOffSetToFsHandle.containsKey(fsOffset)) {
                    fsHandle = imgOffSetToFsHandle.get(fsOffset);
                } else {
                    fsHandle = SleuthkitJNI.openFsDecryptNat(imgHandle, fsOffset, password);
                    imgOffSetToFsHandle.put(fsOffset, fsHandle);
                }
            }
            long l = fsHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long openFsPool(long imgHandle, long fsOffset, long poolHandle, long poolBlock, SleuthkitCase skCase) throws TskCoreException {
        SleuthkitJNI.getTSKWriteLock();
        try {
            long fsHandle;
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                String caseIdentifier = skCase == null ? HandleCache.getDefaultCaseIdentifier() : skCase.getCaseHandleIdentifier();
                Map<Long, Long> imgOffSetToFsHandle = HandleCache.getCaseHandles((String)caseIdentifier).fsHandleCache.get(imgHandle);
                if (imgOffSetToFsHandle == null) {
                    throw new TskCoreException("Missing image offset to file system handle cache for image handle " + imgHandle);
                }
                if (imgOffSetToFsHandle.containsKey(poolBlock)) {
                    fsHandle = imgOffSetToFsHandle.get(poolBlock);
                } else {
                    long poolImgHandle = SleuthkitJNI.getImgInfoForPoolNat(poolHandle, poolBlock);
                    HandleCache.getCaseHandles((String)caseIdentifier).poolImgCache.add(poolImgHandle);
                    fsHandle = SleuthkitJNI.openFsNat(poolImgHandle, fsOffset);
                    imgOffSetToFsHandle.put(poolBlock, fsHandle);
                    HandleCache.getCaseHandles((String)caseIdentifier).poolFsList.add(fsHandle);
                }
            }
            long l = fsHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openFile(long fsHandle, long fileId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, SleuthkitCase skCase) throws TskCoreException {
        boolean withinPool = false;
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            String caseIdentifier = skCase == null ? HandleCache.getDefaultCaseIdentifier() : skCase.getCaseHandleIdentifier();
            if (HandleCache.getCaseHandles((String)caseIdentifier).poolFsList.contains(fsHandle)) {
                withinPool = true;
            }
        }
        if (withinPool) {
            SleuthkitJNI.getTSKWriteLock();
        } else {
            SleuthkitJNI.getTSKReadLock();
        }
        try {
            long fileHandle = SleuthkitJNI.openFileNat(fsHandle, fileId, attrType.getValue(), SleuthkitJNI.convertSignedToUnsigned(attrId));
            Object object2 = HandleCache.cacheLock;
            synchronized (object2) {
                String caseIdentifier = skCase == null ? HandleCache.getDefaultCaseIdentifier() : skCase.getCaseHandleIdentifier();
                HandleCache.addFileHandle(caseIdentifier, fileHandle, fsHandle);
                if (withinPool) {
                    HandleCache.poolFileHandles.add(fileHandle);
                }
            }
            long l = fileHandle;
            return l;
        }
        finally {
            if (withinPool) {
                SleuthkitJNI.releaseTSKWriteLock();
            } else {
                SleuthkitJNI.releaseTSKReadLock();
            }
        }
    }

    private static int convertSignedToUnsigned(int val) {
        if (val >= 0) {
            return val;
        }
        return val & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean imgHandleIsValid(long imgHandle) {
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            return HandleCache.isImageInAnyCache(imgHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readImg(long imgHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            int n = SleuthkitJNI.readImgNat(imgHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readVs(long vsHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readVsNat(vsHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readPool(long poolHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readPoolNat(poolHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readVsPart(long volHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readVolNat(volHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFs(long fsHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readFsNat(fsHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFile(long fileHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        boolean withinPool = false;
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            if (HandleCache.poolFileHandles.contains(fileHandle)) {
                withinPool = true;
            }
        }
        if (withinPool) {
            SleuthkitJNI.getTSKWriteLock();
        } else {
            SleuthkitJNI.getTSKReadLock();
        }
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            int n = SleuthkitJNI.readFileNat(fileHandle, readBuffer, offset, TSK_FS_FILE_READ_OFFSET_TYPE_ENUM.START_OF_FILE.getValue(), len);
            return n;
        }
        finally {
            if (withinPool) {
                SleuthkitJNI.releaseTSKWriteLock();
            } else {
                SleuthkitJNI.releaseTSKReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFileSlack(long fileHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            int n = SleuthkitJNI.readFileNat(fileHandle, readBuffer, offset, TSK_FS_FILE_READ_OFFSET_TYPE_ENUM.START_OF_SLACK.getValue(), len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static List<String> getFileMetaDataText(long fileHandle) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            try {
                String line;
                File tmp = File.createTempFile("tsk", ".txt");
                SleuthkitJNI.saveFileMetaDataTextNat(fileHandle, tmp.getAbsolutePath());
                FileReader fr = new FileReader(tmp.getAbsolutePath());
                BufferedReader textReader = new BufferedReader(fr);
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = textReader.readLine()) != null) {
                    lines.add(line);
                }
                textReader.close();
                fr.close();
                tmp.delete();
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (IOException ex) {
                throw new TskCoreException("Error reading istat output: " + ex.getLocalizedMessage());
            }
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static void closeFile(long fileHandle) {
        SleuthkitJNI.closeFile(fileHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeFile(long fileHandle, SleuthkitCase skCase) {
        boolean withinPool = false;
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            if (HandleCache.poolFileHandles.contains(fileHandle)) {
                withinPool = true;
            }
        }
        if (withinPool) {
            SleuthkitJNI.getTSKWriteLock();
        } else {
            SleuthkitJNI.getTSKReadLock();
        }
        try {
            object = HandleCache.cacheLock;
            synchronized (object) {
                block17: {
                    if (HandleCache.isValidFileHandle(fileHandle)) break block17;
                    return;
                }
                SleuthkitJNI.closeFileNat(fileHandle);
                HandleCache.removeFileHandle(fileHandle, skCase);
                if (HandleCache.poolFileHandles.contains(fileHandle)) {
                    HandleCache.poolFileHandles.remove(fileHandle);
                }
            }
        }
        finally {
            if (withinPool) {
                SleuthkitJNI.releaseTSKWriteLock();
            } else {
                SleuthkitJNI.releaseTSKReadLock();
            }
        }
    }

    public static void createLookupIndexForHashDatabase(int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbCreateIndexNat(dbHandle);
    }

    public static boolean hashDatabaseHasLookupIndex(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIndexExistsNat(dbHandle);
    }

    public static boolean hashDatabaseCanBeReindexed(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsReindexableNat(dbHandle);
    }

    public static String getHashDatabasePath(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbPathNat(dbHandle);
    }

    public static String getHashDatabaseIndexPath(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIndexPathNat(dbHandle);
    }

    public static int openHashDatabase(String path) throws TskCoreException {
        return SleuthkitJNI.hashDbOpenNat(path);
    }

    public static int createHashDatabase(String path) throws TskCoreException {
        return SleuthkitJNI.hashDbNewNat(path);
    }

    public static void closeAllHashDatabases() throws TskCoreException {
        SleuthkitJNI.hashDbCloseAll();
    }

    public static void closeHashDatabase(int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbClose(dbHandle);
    }

    public static String getHashDatabaseDisplayName(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbGetDisplayName(dbHandle);
    }

    public static boolean lookupInHashDatabase(String hash, int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbLookup(hash, dbHandle);
    }

    public static HashHitInfo lookupInHashDatabaseVerbose(String hash, int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbLookupVerbose(hash, dbHandle);
    }

    public static void addToHashDatabase(String filename, String md5, String sha1, String sha256, String comment, int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbAddEntryNat(filename, md5, sha1, sha256, comment, dbHandle);
    }

    public static void addToHashDatabase(List<HashEntry> hashes, int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbBeginTransactionNat(dbHandle);
        try {
            for (HashEntry entry : hashes) {
                SleuthkitJNI.hashDbAddEntryNat(entry.getFileName(), entry.getMd5Hash(), entry.getSha1Hash(), entry.getSha256Hash(), entry.getComment(), dbHandle);
            }
            SleuthkitJNI.hashDbCommitTransactionNat(dbHandle);
        }
        catch (TskCoreException ex) {
            try {
                SleuthkitJNI.hashDbRollbackTransactionNat(dbHandle);
            }
            catch (TskCoreException ex2) {
                ex2.initCause(ex);
                throw ex2;
            }
            throw ex;
        }
    }

    public static boolean isUpdateableHashDatabase(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsUpdateableNat(dbHandle);
    }

    public static boolean hashDatabaseIsIndexOnly(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsIdxOnlyNat(dbHandle);
    }

    private static String timezoneLongToShort(String timezoneLongForm) {
        if (timezoneLongForm == null || timezoneLongForm.isEmpty()) {
            return "";
        }
        TimeZone zone = TimeZone.getTimeZone(timezoneLongForm);
        int offset = zone.getRawOffset() / 1000;
        int hour = offset / 3600;
        int min = offset % 3600 / 60;
        SimpleDateFormat dfm = new SimpleDateFormat("z");
        dfm.setTimeZone(zone);
        boolean hasDaylight = zone.useDaylightTime();
        String first = dfm.format(new GregorianCalendar(2010, 1, 1).getTime()).substring(0, 3);
        String second = dfm.format(new GregorianCalendar(2011, 6, 6).getTime()).substring(0, 3);
        int mid = hour * -1;
        String timezoneShortForm = first + Integer.toString(mid);
        if (min != 0) {
            timezoneShortForm = timezoneShortForm + ":" + (min < 10 ? "0" : "") + Integer.toString(min);
        }
        if (hasDaylight) {
            timezoneShortForm = timezoneShortForm + second;
        }
        return timezoneShortForm;
    }

    public static int finishImageWriter(long imgHandle) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            int n = SleuthkitJNI.finishImageWriterNat(imgHandle);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static int getFinishImageProgress(long imgHandle) {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                int n = SleuthkitJNI.getFinishImageProgressNat(imgHandle);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static void cancelFinishImage(long imgHandle) {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                SleuthkitJNI.cancelFinishImageNat(imgHandle);
            }
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static long findDeviceSize(String devPath) throws TskCoreException {
        return SleuthkitJNI.findDeviceSizeNat(devPath);
    }

    public static boolean isImageSupported(String imagePath) {
        return SleuthkitJNI.isImageSupportedStringNat(imagePath, "").isBlank();
    }

    public static TestOpenImageResult testOpenImage(String imagePath, String password) {
        String resultStr = SleuthkitJNI.isImageSupportedStringNat(imagePath, password);
        if (resultStr.isBlank()) {
            return new TestOpenImageResult(true, "Image opened successfully");
        }
        return new TestOpenImageResult(false, resultStr);
    }

    static long getSleuthkitVersion() {
        return SleuthkitJNI.getSleuthkitVersionNat();
    }

    private static void getTSKReadLock() {
        tskLock.readLock().lock();
    }

    private static void releaseTSKReadLock() {
        tskLock.readLock().unlock();
    }

    private static void getTSKWriteLock() {
        tskLock.writeLock().lock();
    }

    private static void releaseTSKWriteLock() {
        tskLock.writeLock().unlock();
    }

    @Deprecated
    public static void closeImg(long imgHandle) {
    }

    @Deprecated
    public static void closeVs(long vsHandle) {
    }

    @Deprecated
    public static void closeFs(long fsHandle) {
    }

    @Deprecated
    public static long openImage(String[] imageFiles) throws TskCoreException {
        return SleuthkitJNI.openImage(imageFiles, 0, true, null);
    }

    @Deprecated
    public static long openImage(String[] imageFiles, int sSize) throws TskCoreException {
        return SleuthkitJNI.openImage(imageFiles, sSize, true, null);
    }

    @Deprecated
    public static long openFs(long imgHandle, long fsOffset) throws TskCoreException {
        return SleuthkitJNI.openFs(imgHandle, fsOffset, null);
    }

    @Deprecated
    public static long openFile(long fsHandle, long fileId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId) throws TskCoreException {
        return SleuthkitJNI.openFile(fsHandle, fileId, attrType, attrId, null);
    }

    private static native String getVersionNat();

    private static native void startVerboseLoggingNat(String var0);

    private static native int hashDbOpenNat(String var0) throws TskCoreException;

    private static native int hashDbNewNat(String var0) throws TskCoreException;

    private static native int hashDbBeginTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbCommitTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbRollbackTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbAddEntryNat(String var0, String var1, String var2, String var3, String var4, int var5) throws TskCoreException;

    private static native boolean hashDbIsUpdateableNat(int var0);

    private static native boolean hashDbIsReindexableNat(int var0);

    private static native String hashDbPathNat(int var0);

    private static native String hashDbIndexPathNat(int var0);

    private static native String hashDbGetDisplayName(int var0) throws TskCoreException;

    private static native void hashDbCloseAll() throws TskCoreException;

    private static native void hashDbClose(int var0) throws TskCoreException;

    private static native void hashDbCreateIndexNat(int var0) throws TskCoreException;

    private static native boolean hashDbIndexExistsNat(int var0) throws TskCoreException;

    private static native boolean hashDbIsIdxOnlyNat(int var0) throws TskCoreException;

    private static native boolean hashDbLookup(String var0, int var1) throws TskCoreException;

    private static native HashHitInfo hashDbLookupVerbose(String var0, int var1) throws TskCoreException;

    private static native long initAddImgNat(TskCaseDbBridge var0, String var1, boolean var2, boolean var3) throws TskCoreException;

    private static native long initAddImgNatPassword(TskCaseDbBridge var0, String var1, boolean var2, boolean var3, String var4) throws TskCoreException;

    private static native long initializeAddImgNat(TskCaseDbBridge var0, String var1, boolean var2, boolean var3, boolean var4) throws TskCoreException;

    private static native long initializeAddImgPasswordNat(TskCaseDbBridge var0, String var1, boolean var2, boolean var3, boolean var4, String var5) throws TskCoreException;

    private static native void runOpenAndAddImgNat(long var0, String var2, String[] var3, int var4, String var5) throws TskCoreException, TskDataException;

    private static native void runAddImgNat(long var0, String var2, long var3, long var5, String var7, String var8) throws TskCoreException, TskDataException;

    private static native void stopAddImgNat(long var0) throws TskCoreException;

    private static native long finishAddImgNat(long var0) throws TskCoreException;

    private static native long openImgNat(String[] var0, int var1, int var2) throws TskCoreException;

    private static native long openVsNat(long var0, long var2) throws TskCoreException;

    private static native long openVolNat(long var0, long var2) throws TskCoreException;

    private static native long openPoolNat(long var0, long var2) throws TskCoreException;

    private static native long getImgInfoForPoolNat(long var0, long var2) throws TskCoreException;

    private static native long openFsNat(long var0, long var2) throws TskCoreException;

    private static native long openFsDecryptNat(long var0, long var2, String var4) throws TskCoreException;

    private static native long openFileNat(long var0, long var2, int var4, int var5) throws TskCoreException;

    private static native int readImgNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readVsNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readPoolNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readVolNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readFsNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readFileNat(long var0, byte[] var2, long var3, int var5, long var6) throws TskCoreException;

    private static native int saveFileMetaDataTextNat(long var0, String var2) throws TskCoreException;

    private static native String[] getPathsForImageNat(long var0);

    private static native long getSizeForImageNat(long var0);

    private static native long getTypeForImageNat(long var0);

    private static native long getSectorSizeForImageNat(long var0);

    private static native String getMD5HashForImageNat(long var0);

    private static native String getSha1HashForImageNat(long var0);

    private static native String getCollectionDetailsForImageNat(long var0);

    private static native void closeImgNat(long var0);

    private static native void closePoolNat(long var0);

    private static native void closeVsNat(long var0);

    private static native void closeFsNat(long var0);

    private static native void closeFileNat(long var0);

    private static native long findDeviceSizeNat(String var0) throws TskCoreException;

    private static native String getCurDirNat(long var0);

    private static native String isImageSupportedStringNat(String var0, String var1);

    private static native long getSleuthkitVersionNat();

    private static native int finishImageWriterNat(long var0);

    private static native int getFinishImageProgressNat(long var0);

    private static native void cancelFinishImageNat(long var0);

    static {
        LibraryUtils.loadSleuthkitJNI();
    }

    public static class CaseDbHandle {
        private final String caseDbIdentifier;

        private CaseDbHandle(String databaseName) {
            this.caseDbIdentifier = "SingleUser:" + databaseName;
            HandleCache.createCaseHandleCache(this.caseDbIdentifier);
        }

        private CaseDbHandle(String databaseName, CaseDbConnectionInfo info) {
            this.caseDbIdentifier = "MultiUser:" + info.getHost() + ":" + databaseName;
            HandleCache.createCaseHandleCache(this.caseDbIdentifier);
        }

        String getCaseDbIdentifier() {
            return this.caseDbIdentifier;
        }

        void free() throws TskCoreException {
            tskLock.writeLock().lock();
            try {
                HandleCache.closeHandlesAndClearCache(this.caseDbIdentifier);
            }
            finally {
                tskLock.writeLock().unlock();
            }
        }

        long addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone, Host host, String password, SleuthkitCase skCase) throws TskCoreException {
            try {
                if (host == null) {
                    String hostName;
                    if (imageFilePaths.size() > 0) {
                        String path = imageFilePaths.get(0);
                        hostName = new File(path).getName() + " Host";
                    } else {
                        hostName = "Image_" + deviceObjId + " Host";
                    }
                    host = skCase.getHostManager().newHost(hostName);
                }
                TskCaseDbBridge dbHelper = new TskCaseDbBridge(skCase, new DefaultAddDataSourceCallbacks(), host);
                long tskAutoDbPointer = SleuthkitJNI.initializeAddImgPasswordNat(dbHelper, SleuthkitJNI.timezoneLongToShort(timeZone), false, false, false, password);
                SleuthkitJNI.runOpenAndAddImgNat(tskAutoDbPointer, UUID.randomUUID().toString(), imageFilePaths.toArray(new String[0]), imageFilePaths.size(), timeZone);
                long id = SleuthkitJNI.finishAddImgNat(tskAutoDbPointer);
                dbHelper.finish();
                skCase.addDataSourceToHasChildrenMap();
                return id;
            }
            catch (TskDataException ex) {
                throw new TskCoreException("Error adding image to case database", ex);
            }
        }

        AddImageProcess initAddImageProcess(String timeZone, boolean addUnallocSpace, boolean skipFatFsOrphans, String imageCopyPath, String password, SleuthkitCase skCase) {
            return new AddImageProcess(this, timeZone, addUnallocSpace, skipFatFsOrphans, imageCopyPath, password, skCase);
        }

        public class AddImageProcess {
            private final String timeZone;
            private final boolean addUnallocSpace;
            private final boolean skipFatFsOrphans;
            private final String imageWriterPath;
            private volatile long tskAutoDbPointer;
            private long imageId = 0L;
            private boolean isCanceled;
            private final SleuthkitCase skCase;
            private TskCaseDbBridge dbHelper;
            private final String password;

            private AddImageProcess(CaseDbHandle this$0, String timeZone, boolean addUnallocSpace, boolean skipFatFsOrphans, String imageWriterPath, String password, SleuthkitCase skCase) {
                this.timeZone = timeZone;
                this.addUnallocSpace = addUnallocSpace;
                this.skipFatFsOrphans = skipFatFsOrphans;
                this.imageWriterPath = imageWriterPath;
                this.tskAutoDbPointer = 0L;
                this.isCanceled = false;
                this.skCase = skCase;
                this.password = password;
            }

            public void run(String deviceId, String[] imageFilePaths, int sectorSize) throws TskCoreException, TskDataException {
                Image img = SleuthkitJNI.addImageToDatabase(this.skCase, imageFilePaths, sectorSize, "", "", "", "", deviceId, this.password, null);
                this.run(deviceId, img, sectorSize, new DefaultAddDataSourceCallbacks());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(String deviceId, Image image, int sectorSize, AddDataSourceCallbacks addDataSourceCallbacks) throws TskCoreException, TskDataException {
                this.dbHelper = new TskCaseDbBridge(this.skCase, addDataSourceCallbacks, image.getHost());
                SleuthkitJNI.getTSKReadLock();
                try {
                    long imageHandle = 0L;
                    AddImageProcess addImageProcess = this;
                    synchronized (addImageProcess) {
                        if (0L != this.tskAutoDbPointer) {
                            throw new TskCoreException("Add image process already started");
                        }
                        if (!this.isCanceled) {
                            imageHandle = image.getImageHandle();
                            this.tskAutoDbPointer = SleuthkitJNI.initAddImgNatPassword(this.dbHelper, SleuthkitJNI.timezoneLongToShort(this.timeZone), this.addUnallocSpace, this.skipFatFsOrphans, this.password);
                        }
                        if (0L == this.tskAutoDbPointer) {
                            throw new TskCoreException("initAddImgNat returned a NULL TskAutoDb pointer");
                        }
                    }
                    if (imageHandle != 0L) {
                        SleuthkitJNI.runAddImgNat(this.tskAutoDbPointer, deviceId, imageHandle, image.getId(), this.timeZone, this.imageWriterPath);
                    }
                }
                finally {
                    this.finishAddImageProcess();
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            public synchronized void stop() throws TskCoreException {
                SleuthkitJNI.getTSKReadLock();
                try {
                    this.isCanceled = true;
                    if (this.tskAutoDbPointer != 0L) {
                        SleuthkitJNI.stopAddImgNat(this.tskAutoDbPointer);
                    }
                }
                finally {
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            private synchronized void finishAddImageProcess() throws TskCoreException {
                if (this.tskAutoDbPointer == 0L) {
                    return;
                }
                if (!this.isCanceled && this.dbHelper != null) {
                    this.dbHelper.finish();
                }
                this.imageId = SleuthkitJNI.finishAddImgNat(this.tskAutoDbPointer);
                this.tskAutoDbPointer = 0L;
                this.skCase.addDataSourceToHasChildrenMap();
            }

            @Deprecated
            public synchronized void revert() throws TskCoreException {
            }

            @Deprecated
            public synchronized long commit() throws TskCoreException {
                return this.imageId;
            }

            public synchronized String currentDirectory() {
                return this.tskAutoDbPointer == 0L ? "" : SleuthkitJNI.getCurDirNat(this.tskAutoDbPointer);
            }

            @Deprecated
            public void run(String[] imageFilePaths) throws TskCoreException, TskDataException {
                this.run(null, imageFilePaths, 0);
            }

            public void run(String deviceId, String[] imageFilePaths) throws TskCoreException, TskDataException {
                this.run(deviceId, imageFilePaths, 0);
            }
        }
    }

    private static class HandleCache {
        private static final Object cacheLock = new Object();
        private static final Map<String, CaseHandles> caseHandlesCache = new HashMap<String, CaseHandles>();
        private static final String INVALID_FILE_HANDLE = "Invalid file handle.";
        private static final List<Long> poolFileHandles = new ArrayList<Long>();

        private HandleCache() {
        }

        private static void createCaseHandleCache(String caseIdentifier) {
            caseHandlesCache.put(caseIdentifier, new CaseHandles());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getDefaultCaseIdentifier() throws TskCoreException {
            Object object = cacheLock;
            synchronized (object) {
                if (caseHandlesCache.keySet().size() > 1) {
                    throw new TskCoreException("Can not get default case identifier with multiple open cases");
                }
                if (caseHandlesCache.keySet().isEmpty()) {
                    throw new TskCoreException("Can not get default case identifier with no open case");
                }
                return caseHandlesCache.keySet().iterator().next();
            }
        }

        private static CaseHandles getCaseHandles(String caseIdentifier) throws TskCoreException {
            Object object = cacheLock;
            synchronized (object) {
                if (caseHandlesCache.containsKey(caseIdentifier)) {
                    return caseHandlesCache.get(caseIdentifier);
                }
                throw new TskCoreException("No entry for case " + caseIdentifier + " in cache. Case may have been closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeCaseHandlesCache(String caseIdentifier) {
            Object object = cacheLock;
            synchronized (object) {
                if (caseHandlesCache.containsKey(caseIdentifier)) {
                    HandleCache.caseHandlesCache.get((Object)caseIdentifier).fsHandleCache.clear();
                    HandleCache.caseHandlesCache.get((Object)caseIdentifier).imageHandleCache.clear();
                    HandleCache.caseHandlesCache.get((Object)caseIdentifier).fileHandleCache.clear();
                    HandleCache.caseHandlesCache.get((Object)caseIdentifier).fileSystemToFileHandles.clear();
                    HandleCache.caseHandlesCache.get((Object)caseIdentifier).poolHandleCache.clear();
                    caseHandlesCache.remove(caseIdentifier);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isImageInAnyCache(long imgHandle) {
            Object object = cacheLock;
            synchronized (object) {
                for (String caseIdentifier : caseHandlesCache.keySet()) {
                    if (!HandleCache.caseHandlesCache.get((Object)caseIdentifier).fsHandleCache.keySet().contains(imgHandle)) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addFileHandle(String caseIdentifier, long fileHandle, long fsHandle) {
            try {
                Object object = cacheLock;
                synchronized (object) {
                    HandleCache.getCaseHandles((String)caseIdentifier).fileHandleCache.add(fileHandle);
                    if (HandleCache.getCaseHandles((String)caseIdentifier).fileSystemToFileHandles.containsKey(fsHandle)) {
                        HandleCache.getCaseHandles((String)caseIdentifier).fileSystemToFileHandles.get(fsHandle).add(fileHandle);
                    } else {
                        HandleCache.getCaseHandles((String)caseIdentifier).fileSystemToFileHandles.put(fsHandle, new ArrayList<Long>(Arrays.asList(fileHandle)));
                    }
                }
            }
            catch (TskCoreException ex) {
                logger.log(Level.WARNING, "Error caching file handle for case {0}", caseIdentifier);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeFileHandle(long fileHandle, SleuthkitCase skCase) {
            Object object = cacheLock;
            synchronized (object) {
                if (skCase != null) {
                    try {
                        HandleCache.getCaseHandles((String)skCase.getCaseHandleIdentifier()).fileHandleCache.remove(fileHandle);
                    }
                    catch (TskCoreException tskCoreException) {}
                } else {
                    for (String caseIdentifier : caseHandlesCache.keySet()) {
                        if (!HandleCache.caseHandlesCache.get((Object)caseIdentifier).fileHandleCache.contains(fileHandle)) continue;
                        HandleCache.caseHandlesCache.get((Object)caseIdentifier).fileHandleCache.remove(fileHandle);
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isValidFileHandle(long fileHandle) {
            Object object = cacheLock;
            synchronized (object) {
                for (String caseIdentifier : caseHandlesCache.keySet()) {
                    if (!HandleCache.caseHandlesCache.get((Object)caseIdentifier).fileHandleCache.contains(fileHandle)) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void closeHandlesAndClearCache(String caseIdentifier) throws TskCoreException {
            Object object = cacheLock;
            synchronized (object) {
                for (Map<Long, Long> imageToFsMap : HandleCache.getCaseHandles((String)caseIdentifier).fsHandleCache.values()) {
                    for (Long fsHandle : imageToFsMap.values()) {
                        if (HandleCache.getCaseHandles((String)caseIdentifier).fileSystemToFileHandles.containsKey(fsHandle)) {
                            for (Long fileHandle : HandleCache.getCaseHandles((String)caseIdentifier).fileSystemToFileHandles.get(fsHandle)) {
                                if (poolFileHandles.contains(fileHandle)) {
                                    poolFileHandles.remove(fileHandle);
                                }
                                SleuthkitJNI.closeFile(fileHandle);
                            }
                        }
                        SleuthkitJNI.closeFsNat(fsHandle);
                    }
                }
                HandleCache.getCaseHandles((String)caseIdentifier).poolFsList.clear();
                for (Long imgHandle : HandleCache.getCaseHandles((String)caseIdentifier).poolHandleCache.keySet()) {
                    for (Long poolHandle : HandleCache.getCaseHandles((String)caseIdentifier).poolHandleCache.get(imgHandle).values()) {
                        SleuthkitJNI.closePoolNat(poolHandle);
                    }
                }
                for (Long imageHandle : HandleCache.getCaseHandles((String)caseIdentifier).poolImgCache) {
                    SleuthkitJNI.closeImgNat(imageHandle);
                }
                for (Long imageHandle : HandleCache.getCaseHandles((String)caseIdentifier).imageHandleCache.values()) {
                    SleuthkitJNI.closeImgNat(imageHandle);
                }
                HandleCache.removeCaseHandlesCache(caseIdentifier);
            }
        }
    }

    private static class CaseHandles {
        private final Map<String, Long> imageHandleCache = new HashMap<String, Long>();
        private final Map<Long, Map<Long, Long>> fsHandleCache = new HashMap<Long, Map<Long, Long>>();
        private final Set<Long> fileHandleCache = new HashSet<Long>();
        private final Map<Long, List<Long>> fileSystemToFileHandles = new HashMap<Long, List<Long>>();
        private final Map<Long, Map<Long, Long>> poolHandleCache = new HashMap<Long, Map<Long, Long>>();
        private final List<Long> poolImgCache = new ArrayList<Long>();
        private final List<Long> poolFsList = new ArrayList<Long>();

        private CaseHandles() {
        }
    }

    private static enum TSK_FS_FILE_READ_OFFSET_TYPE_ENUM {
        START_OF_FILE(0),
        START_OF_SLACK(1);

        private final int val;

        private TSK_FS_FILE_READ_OFFSET_TYPE_ENUM(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    public static class TestOpenImageResult {
        boolean testSuccess;
        String message;

        TestOpenImageResult(boolean testSuccess, String message) {
            this.testSuccess = testSuccess;
            this.message = message;
        }

        public boolean wasSuccessful() {
            return this.testSuccess;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

