/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.sleuthkit.datamodel.TagName;

public class TagSet {
    private final String setName;
    private final long id;
    private final List<TagName> tagNameList;

    TagSet(long id, String setName, List<TagName> tagNameList) {
        if (setName == null || setName.isEmpty()) {
            throw new IllegalArgumentException("TagSet name must be a non-empty string");
        }
        this.tagNameList = new ArrayList<TagName>(tagNameList);
        this.tagNameList.sort(new TagNameComparator(this));
        this.id = id;
        this.setName = setName;
    }

    public String getName() {
        return this.setName;
    }

    public List<TagName> getTagNames() {
        return Collections.unmodifiableList(this.tagNameList);
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagSet other = (TagSet)obj;
        return this.id == other.getId() && this.setName.equals(other.getName()) && this.tagNameList.equals(other.tagNameList);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 89 * hash + Objects.hashCode(this.setName);
        hash = 89 * hash + Objects.hashCode(this.tagNameList);
        return hash;
    }

    private class TagNameComparator
    implements Comparator<TagName> {
        private TagNameComparator(TagSet tagSet) {
        }

        @Override
        public int compare(TagName tagName1, TagName tagName2) {
            int result = Integer.valueOf(tagName1.getRank()).compareTo(tagName2.getRank());
            if (result == 0) {
                result = tagName1.getDisplayName().compareTo(tagName2.getDisplayName());
            }
            return result;
        }
    }
}

