/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeUtilities {
    private static final Logger LOGGER = Logger.getLogger(TimeUtilities.class.getName());
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    private TimeUtilities() {
    }

    public static String epochToTime(long epoch) {
        String time = "0000-00-00 00:00:00";
        if (epoch != 0L) {
            time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(epoch * 1000L));
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String epochToTime(long epoch, TimeZone tzone) {
        String time = "0000-00-00 00:00:00";
        if (epoch != 0L) {
            SimpleDateFormat simpleDateFormat = DATE_FORMATTER;
            synchronized (simpleDateFormat) {
                DATE_FORMATTER.setTimeZone(tzone);
                time = DATE_FORMATTER.format(new Date(epoch * 1000L));
            }
        }
        return time;
    }

    public static String epochToTimeISO8601(long epoch, TimeZone tzone) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(tzone);
        return formatter.format(new Date(epoch));
    }

    public static long timeToEpoch(String time) {
        long epoch = 0L;
        try {
            epoch = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time).getTime() / 1000L;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to parse time string", e);
        }
        return epoch;
    }
}

