/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.logging.Logger;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeImpl;
import org.sleuthkit.datamodel.TimelineEventDescription;
import org.sleuthkit.datamodel.TimelineEventDescriptionWithTime;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TskCoreException;

class TimelineEventArtifactTypeSingleDescription
extends TimelineEventArtifactTypeImpl {
    private static final Logger logger = Logger.getLogger(TimelineEventArtifactTypeSingleDescription.class.getName());

    @Override
    public TimelineEventDescriptionWithTime makeEventDescription(BlackboardArtifact artifact) throws TskCoreException {
        BlackboardAttribute timeAttribute;
        String description = this.extractFullDescription(artifact);
        if (description.length() > 1024) {
            description = description.substring(0, 1024);
        }
        if ((timeAttribute = artifact.getAttribute(this.getDateTimeAttributeType())) == null) {
            return null;
        }
        long time = timeAttribute.getValueLong();
        return new TimelineEventDescriptionWithTime(time, timeAttribute.getDisplayString(), null, description);
    }

    TimelineEventArtifactTypeSingleDescription(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type timeAttribute, BlackboardAttribute.Type descriptionAttribute) {
        super(typeID, displayName, superType, artifactType, timeAttribute, new NullExtractor(), new NullExtractor(), new TimelineEventArtifactTypeImpl.AttributeExtractor(descriptionAttribute));
    }

    @Override
    TimelineEventDescription parseDescription(String fullDescription, String medDescription, String shortDescription) {
        return new TimelineEventDescription(fullDescription);
    }

    static final class NullExtractor
    implements TimelineEventArtifactTypeImpl.TSKCoreCheckedFunction<BlackboardArtifact, String> {
        NullExtractor() {
        }

        @Override
        public String apply(BlackboardArtifact ignored) throws TskCoreException {
            return null;
        }
    }
}

