/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.AddDataSourceCallbacks;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.OsAccountManager;
import org.sleuthkit.datamodel.OsAccountRealm;
import org.sleuthkit.datamodel.Pool;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimelineManager;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.VirtualDirectory;
import org.sleuthkit.datamodel.Volume;
import org.sleuthkit.datamodel.VolumeSystem;

class TskCaseDbBridge {
    private static final Logger logger = Logger.getLogger(TskCaseDbBridge.class.getName());
    private final SleuthkitCase caseDb;
    private SleuthkitCase.CaseDbTransaction trans = null;
    private final AddDataSourceCallbacks addDataSourceCallbacks;
    private final Host imageHost;
    private final Map<Long, Long> fsIdToRootDir = new HashMap<Long, Long>();
    private final Map<Long, TskData.TSK_FS_TYPE_ENUM> fsIdToFsType = new HashMap<Long, TskData.TSK_FS_TYPE_ENUM>();
    private final Map<ParentCacheKey, Long> parentDirCache = new HashMap<ParentCacheKey, Long>();
    private final Map<String, OsAccount> ownerIdToAccountMap = new HashMap<String, OsAccount>();
    private static final long BATCH_FILE_THRESHOLD = 500L;
    private final Queue<FileInfo> batchedFiles = new LinkedList<FileInfo>();
    private final Queue<LayoutRangeInfo> batchedLayoutRanges = new LinkedList<LayoutRangeInfo>();
    private final List<Long> layoutFileIds = new ArrayList<Long>();
    private final Map<Long, VirtualDirectory> unallocFileDirs = new HashMap<Long, VirtualDirectory>();

    TskCaseDbBridge(SleuthkitCase caseDb, AddDataSourceCallbacks addDataSourceCallbacks, Host host) {
        this.caseDb = caseDb;
        this.addDataSourceCallbacks = addDataSourceCallbacks;
        this.imageHost = host;
        this.trans = null;
    }

    private void beginTransaction() throws TskCoreException {
        this.trans = this.caseDb.beginTransaction();
    }

    private void commitTransaction() throws TskCoreException {
        this.trans.commit();
        this.trans = null;
    }

    private void revertTransaction() {
        try {
            if (this.trans != null) {
                this.trans.rollback();
                this.trans = null;
            }
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error rolling back transaction", ex);
        }
    }

    void finish() {
        this.addBatchedFilesToDb();
        this.addBatchedLayoutRangesToDb();
        this.processLayoutFiles();
    }

    long addImageInfo(int type, long ssize, String timezone, long size, String md5, String sha1, String sha256, String deviceId, String collectionDetails, String[] paths) {
        try {
            this.beginTransaction();
            long objId = this.addImageToDb(TskData.TSK_IMG_TYPE_ENUM.valueOf(type), ssize, size, timezone, md5, sha1, sha256, deviceId, collectionDetails, this.trans);
            for (int i = 0; i < paths.length; ++i) {
                this.addImageNameToDb(objId, paths[i], i, this.trans);
            }
            this.commitTransaction();
            return objId;
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding image to the database", ex);
            this.revertTransaction();
            return -1L;
        }
    }

    void addAcquisitionDetails(long imgId, String details) {
        try {
            this.beginTransaction();
            this.caseDb.setAcquisitionDetails(imgId, details, this.trans);
            this.commitTransaction();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding image details \"" + details + "\" to image with ID " + imgId, ex);
            this.revertTransaction();
        }
    }

    long addVsInfo(long parentObjId, int vsType, long imgOffset, long blockSize) {
        try {
            this.beginTransaction();
            VolumeSystem vs = this.caseDb.addVolumeSystem(parentObjId, TskData.TSK_VS_TYPE_ENUM.valueOf(vsType), imgOffset, blockSize, this.trans);
            this.commitTransaction();
            return vs.getId();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding volume system to the database - parent obj ID: " + parentObjId + ", image offset: " + imgOffset, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    long addVolume(long parentObjId, long addr, long start, long length, String desc, long flags) {
        try {
            this.beginTransaction();
            Volume vol = this.caseDb.addVolume(parentObjId, addr, start, length, desc, flags, this.trans);
            this.commitTransaction();
            return vol.getId();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding volume to the database - parent object ID: " + parentObjId + ", addr: " + addr, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    long addPool(long parentObjId, int poolType) {
        try {
            this.beginTransaction();
            Pool pool = this.caseDb.addPool(parentObjId, TskData.TSK_POOL_TYPE_ENUM.valueOf(poolType), this.trans);
            this.commitTransaction();
            return pool.getId();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding pool to the database - parent object ID: " + parentObjId, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    long addFileSystem(long parentObjId, long imgOffset, int fsType, long blockSize, long blockCount, long rootInum, long firstInum, long lastInum) {
        try {
            this.beginTransaction();
            FileSystem fs = this.caseDb.addFileSystem(parentObjId, imgOffset, TskData.TSK_FS_TYPE_ENUM.valueOf(fsType), blockSize, blockCount, rootInum, firstInum, lastInum, null, this.trans);
            this.commitTransaction();
            this.fsIdToFsType.put(fs.getId(), TskData.TSK_FS_TYPE_ENUM.valueOf(fsType));
            return fs.getId();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding file system to the database - parent object ID: " + parentObjId + ", offset: " + imgOffset, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    long addFile(long parentObjId, long fsObjId, long dataSourceObjId, int fsType, int attrType, int attrId, String name, long metaAddr, long metaSeq, int dirType, int metaType, int dirFlags, int metaFlags, long size, long crtime, long ctime, long atime, long mtime, int meta_mode, int gid, int uid, String escaped_path, String extension, long seq, long parMetaAddr, long parSeq, String ownerUid) {
        this.batchedFiles.add(new FileInfo(this, parentObjId, fsObjId, dataSourceObjId, fsType, attrType, attrId, name, metaAddr, metaSeq, dirType, metaType, dirFlags, metaFlags, size, crtime, ctime, atime, mtime, meta_mode, gid, uid, escaped_path, extension, seq, parMetaAddr, parSeq, ownerUid));
        if (fsObjId == parentObjId || (long)this.batchedFiles.size() > 500L) {
            return this.addBatchedFilesToDb();
        }
        return 0L;
    }

    private long addBatchedFilesToDb() {
        ArrayList<Long> newObjIds = new ArrayList<Long>();
        try {
            FileInfo fileInfo2;
            for (FileInfo fileInfo2 : this.batchedFiles) {
                String ownerUid = fileInfo2.ownerUid;
                if (Strings.isNullOrEmpty((String)fileInfo2.ownerUid) || this.ownerIdToAccountMap.containsKey(ownerUid)) continue;
                try {
                    Optional<OsAccount> ownerAccount = this.caseDb.getOsAccountManager().getWindowsOsAccount(ownerUid, null, null, this.imageHost);
                    if (ownerAccount.isPresent()) {
                        this.ownerIdToAccountMap.put(ownerUid, ownerAccount.get());
                        continue;
                    }
                    OsAccountManager accountMgr = this.caseDb.getOsAccountManager();
                    OsAccount newAccount = accountMgr.newWindowsOsAccount(ownerUid, null, null, this.imageHost, OsAccountRealm.RealmScope.UNKNOWN);
                    Content ds = this.caseDb.getContentById(fileInfo2.dataSourceObjId);
                    if (ds instanceof DataSource) {
                        accountMgr.newOsAccountInstance(newAccount, (DataSource)ds, OsAccountInstance.OsAccountInstanceType.ACCESSED);
                    }
                    this.ownerIdToAccountMap.put(ownerUid, newAccount);
                }
                catch (OsAccountManager.NotUserSIDException ex) {
                    this.ownerIdToAccountMap.put(ownerUid, null);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Error mapping ownerId " + ownerUid + " to account", ex);
                    this.ownerIdToAccountMap.put(ownerUid, null);
                }
            }
            this.beginTransaction();
            while ((fileInfo2 = this.batchedFiles.poll()) != null) {
                long computedParentObjId = fileInfo2.parentObjId;
                try {
                    if (fileInfo2.parentObjId == 0L) {
                        computedParentObjId = this.getParentObjId(fileInfo2);
                    }
                    Long ownerAccountObjId = OsAccount.NO_ACCOUNT;
                    if (!Strings.isNullOrEmpty((String)fileInfo2.ownerUid)) {
                        if (this.ownerIdToAccountMap.containsKey(fileInfo2.ownerUid)) {
                            if (Objects.nonNull(this.ownerIdToAccountMap.get(fileInfo2.ownerUid))) {
                                ownerAccountObjId = this.ownerIdToAccountMap.get(fileInfo2.ownerUid).getId();
                            }
                        } else {
                            throw new TskCoreException(String.format("Failed to add file. Owner account not found for file with parent object ID: %d, name: %s, owner id: %s", fileInfo2.parentObjId, fileInfo2.name, fileInfo2.ownerUid));
                        }
                    }
                    if (fileInfo2.parentObjId == fileInfo2.fsObjId && fileInfo2.metaType != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue()) {
                        fileInfo2.metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue();
                    }
                    long objId = this.addFileToDb(computedParentObjId, fileInfo2.fsObjId, fileInfo2.dataSourceObjId, fileInfo2.fsType, fileInfo2.attrType, fileInfo2.attrId, fileInfo2.name, fileInfo2.metaAddr, fileInfo2.metaSeq, fileInfo2.dirType, fileInfo2.metaType, fileInfo2.dirFlags, fileInfo2.metaFlags, fileInfo2.size, fileInfo2.crtime, fileInfo2.ctime, fileInfo2.atime, fileInfo2.mtime, fileInfo2.meta_mode, fileInfo2.gid, fileInfo2.uid, null, TskData.FileKnown.UNKNOWN, fileInfo2.escaped_path, fileInfo2.extension, fileInfo2.ownerUid, ownerAccountObjId, false, this.trans);
                    if (fileInfo2.fsObjId != fileInfo2.parentObjId) {
                        newObjIds.add(objId);
                    }
                    if (fileInfo2.parentObjId == fileInfo2.fsObjId) {
                        this.fsIdToRootDir.put(fileInfo2.fsObjId, objId);
                    }
                    if (fileInfo2.metaType != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() && fileInfo2.metaType != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue() || fileInfo2.name == null || fileInfo2.name.equals(".") || fileInfo2.name.equals("..")) continue;
                    String dirName = fileInfo2.escaped_path + fileInfo2.name;
                    ParentCacheKey key = new ParentCacheKey(this, fileInfo2.fsObjId, fileInfo2.metaAddr, fileInfo2.seq, dirName);
                    this.parentDirCache.put(key, objId);
                }
                catch (TskCoreException ex) {
                    if (computedParentObjId > 0L) {
                        logger.log(Level.SEVERE, "Error adding file to the database - parent object ID: " + computedParentObjId + ", file system object ID: " + fileInfo2.fsObjId + ", name: " + fileInfo2.name, ex);
                        continue;
                    }
                    logger.log(Level.SEVERE, "Error adding file to the database", ex);
                }
            }
            this.commitTransaction();
            try {
                this.addDataSourceCallbacks.onFilesAdded(newObjIds);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unexpected error from files added callback", ex);
            }
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Error adding batched files to database", ex);
            this.revertTransaction();
            return -1L;
        }
        return 0L;
    }

    private long getParentObjId(FileInfo fileInfo) throws TskCoreException {
        ParentCacheKey key;
        String parentPath = fileInfo.escaped_path;
        if (parentPath.endsWith("/") && !parentPath.equals("/")) {
            parentPath = parentPath.substring(0, parentPath.lastIndexOf(47));
        }
        if (this.parentDirCache.containsKey(key = new ParentCacheKey(this, fileInfo.fsObjId, fileInfo.parMetaAddr, fileInfo.parSeq, parentPath))) {
            return this.parentDirCache.get(key);
        }
        throw new TskCoreException("Could not find parent (fsObjId: " + fileInfo.fsObjId + ", parMetaAddr: " + fileInfo.parMetaAddr + ", parSeq: " + fileInfo.parSeq + ", parentPath: " + parentPath + ")");
    }

    long addLayoutFile(long parentObjId, long fsObjId, long dataSourceObjId, int fileType, String name, long size) {
        try {
            Long fsObjIdForDb = fsObjId;
            if (fsObjId == 0L) {
                fsObjIdForDb = null;
            }
            Object parentPath = "/";
            if (this.unallocFileDirs.containsKey(parentObjId)) {
                parentPath = "/" + this.unallocFileDirs.get(parentObjId).getName() + "/";
            }
            this.beginTransaction();
            long objId = this.addFileToDb(parentObjId, fsObjIdForDb, dataSourceObjId, fileType, null, null, name, null, null, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue(), TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue(), TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue(), TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue(), size, null, null, null, null, null, null, null, null, TskData.FileKnown.UNKNOWN, (String)parentPath, null, null, OsAccount.NO_ACCOUNT, true, this.trans);
            this.commitTransaction();
            this.layoutFileIds.add(objId);
            return objId;
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding layout file to the database - parent object ID: " + parentObjId + ", file system object ID: " + fsObjId + ", name: " + name, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    long addLayoutFileRange(long objId, long byteStart, long byteLen, long seq) {
        this.batchedLayoutRanges.add(new LayoutRangeInfo(this, objId, byteStart, byteLen, seq));
        if ((long)this.batchedLayoutRanges.size() > 500L) {
            return this.addBatchedLayoutRangesToDb();
        }
        return 0L;
    }

    private long addBatchedLayoutRangesToDb() {
        try {
            LayoutRangeInfo range;
            this.beginTransaction();
            while ((range = this.batchedLayoutRanges.poll()) != null) {
                try {
                    this.addLayoutFileRangeToDb(range.objId, range.byteStart, range.byteLen, range.seq, this.trans);
                }
                catch (TskCoreException ex) {
                    logger.log(Level.SEVERE, "Error adding layout file range to the database - layout file ID: " + range.objId + ", byte start: " + range.byteStart + ", length: " + range.byteLen + ", seq: " + range.seq, ex);
                }
            }
            this.commitTransaction();
            return 0L;
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error adding batched files to database", ex);
            this.revertTransaction();
            return -1L;
        }
    }

    void processLayoutFiles() {
        this.addDataSourceCallbacks.onFilesAdded(this.layoutFileIds);
        this.layoutFileIds.clear();
    }

    long addUnallocFsBlockFilesParent(long fsObjId, String name) {
        try {
            if (!this.fsIdToRootDir.containsKey(fsObjId)) {
                logger.log(Level.SEVERE, "Error - root directory for file system ID {0} not found", fsObjId);
                return -1L;
            }
            this.beginTransaction();
            VirtualDirectory dir = this.caseDb.addVirtualDirectory(this.fsIdToRootDir.get(fsObjId), name, this.trans);
            this.commitTransaction();
            this.unallocFileDirs.put(dir.getId(), dir);
            this.addDataSourceCallbacks.onFilesAdded(Arrays.asList(dir.getId()));
            return dir.getId();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error creating virtual directory " + name + " under file system ID " + fsObjId, ex);
            this.revertTransaction();
            return -1L;
        }
    }

    private long addFileToDb(long parentObjId, Long fsObjId, long dataSourceObjId, int fsType, Integer attrType, Integer attrId, String name, Long metaAddr, Long metaSeq, int dirType, int metaType, int dirFlags, int metaFlags, long size, Long crtime, Long ctime, Long atime, Long mtime, Integer meta_mode, Integer gid, Integer uid, String md5, TskData.FileKnown known, String escaped_path, String extension, String ownerUid, Long ownerAcctObjId, boolean hasLayout, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            long objectId = this.caseDb.addObject(parentObjId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            String fileInsert = "INSERT INTO tsk_files (fs_obj_id, obj_id, data_source_obj_id, type, attr_type, attr_id, name, meta_addr, meta_seq, dir_type, meta_type, dir_flags, meta_flags, size, crtime, ctime, atime, mtime, mode, gid, uid, md5, known, parent_path, extension, has_layout, owner_uid, os_account_obj_id, collected) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement preparedStatement = connection.getPreparedStatement(fileInsert, 2);
            preparedStatement.clearParameters();
            if (fsObjId != null) {
                preparedStatement.setLong(1, fsObjId);
            } else {
                preparedStatement.setNull(1, -5);
            }
            preparedStatement.setLong(2, objectId);
            preparedStatement.setLong(3, dataSourceObjId);
            preparedStatement.setShort(4, (short)fsType);
            if (attrType != null) {
                preparedStatement.setShort(5, attrType.shortValue());
            } else {
                preparedStatement.setNull(5, 5);
            }
            if (attrId != null) {
                preparedStatement.setInt(6, attrId);
            } else {
                preparedStatement.setNull(6, 4);
            }
            preparedStatement.setString(7, name);
            if (metaAddr != null) {
                preparedStatement.setLong(8, metaAddr);
            } else {
                preparedStatement.setNull(8, -5);
            }
            if (metaSeq != null) {
                preparedStatement.setInt(9, metaSeq.intValue());
            } else {
                preparedStatement.setNull(9, 4);
            }
            preparedStatement.setShort(10, (short)dirType);
            preparedStatement.setShort(11, (short)metaType);
            preparedStatement.setShort(12, (short)dirFlags);
            preparedStatement.setShort(13, (short)metaFlags);
            preparedStatement.setLong(14, size < 0L ? 0L : size);
            if (crtime != null) {
                preparedStatement.setLong(15, crtime);
            } else {
                preparedStatement.setNull(15, -5);
            }
            if (ctime != null) {
                preparedStatement.setLong(16, ctime);
            } else {
                preparedStatement.setNull(16, -5);
            }
            if (atime != null) {
                preparedStatement.setLong(17, atime);
            } else {
                preparedStatement.setNull(17, -5);
            }
            if (mtime != null) {
                preparedStatement.setLong(18, mtime);
            } else {
                preparedStatement.setNull(18, -5);
            }
            if (meta_mode != null) {
                preparedStatement.setLong(19, meta_mode.intValue());
            } else {
                preparedStatement.setNull(19, -5);
            }
            if (gid != null) {
                preparedStatement.setLong(20, gid.intValue());
            } else {
                preparedStatement.setNull(20, -5);
            }
            if (uid != null) {
                preparedStatement.setLong(21, uid.intValue());
            } else {
                preparedStatement.setNull(21, -5);
            }
            preparedStatement.setString(22, md5);
            preparedStatement.setInt(23, known.getFileKnownValue());
            preparedStatement.setString(24, escaped_path);
            preparedStatement.setString(25, extension);
            if (hasLayout) {
                preparedStatement.setInt(26, 1);
            } else {
                preparedStatement.setNull(26, 4);
            }
            preparedStatement.setString(27, ownerUid);
            if (ownerAcctObjId != OsAccount.NO_ACCOUNT) {
                preparedStatement.setLong(28, ownerAcctObjId);
            } else {
                preparedStatement.setNull(28, -5);
            }
            preparedStatement.setLong(29, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(preparedStatement);
            if (!(hasLayout || TskData.TSK_DB_FILES_TYPE_ENUM.SLACK.getFileType() == fsType || name.equals(".") || name.equals(".."))) {
                TimelineManager timelineManager = this.caseDb.getTimelineManager();
                DerivedFile derivedFile = new DerivedFile(this.caseDb, objectId, dataSourceObjId, fsObjId, name, TskData.TSK_FS_NAME_TYPE_ENUM.valueOf((short)dirType), TskData.TSK_FS_META_TYPE_ENUM.valueOf((short)metaType), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(dirFlags), (short)metaFlags, size, ctime, crtime, atime, mtime, null, null, null, null, escaped_path, null, parentObjId, null, null, extension, ownerUid, ownerAcctObjId);
                timelineManager.addEventsForNewFileQuiet(derivedFile, connection);
            }
            return objectId;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add file system file", ex);
        }
    }

    private long addImageToDb(TskData.TSK_IMG_TYPE_ENUM type, long sectorSize, long size, String timezone, String md5, String sha1, String sha256, String deviceId, String collectionDetails, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.caseDb.addObject(0L, TskData.ObjectType.IMG.getObjectType(), connection);
            String imageInfoSql = "INSERT INTO tsk_image_info (obj_id, type, ssize, tzone, size, md5, sha1, sha256, display_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement preparedStatement = connection.getPreparedStatement(imageInfoSql, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, (short)type.getValue());
            preparedStatement.setLong(3, sectorSize);
            preparedStatement.setString(4, timezone);
            long savedSize = size < 0L ? 0L : size;
            preparedStatement.setLong(5, savedSize);
            preparedStatement.setString(6, md5);
            preparedStatement.setString(7, sha1);
            preparedStatement.setString(8, sha256);
            preparedStatement.setString(9, null);
            connection.executeUpdate(preparedStatement);
            String dataSourceInfoSql = "INSERT INTO data_source_info (obj_id, device_id, time_zone, acquisition_details, host_id) VALUES (?, ?, ?, ?, ?)";
            preparedStatement = connection.getPreparedStatement(dataSourceInfoSql, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setString(2, deviceId);
            preparedStatement.setString(3, timezone);
            preparedStatement.setString(4, collectionDetails);
            preparedStatement.setLong(5, this.imageHost.getHostId());
            connection.executeUpdate(preparedStatement);
            return newObjId;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding image to database", new Object[0]), ex);
        }
    }

    private void addImageNameToDb(long objId, String name, long sequence, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            String imageNameSql = "INSERT INTO tsk_image_names (obj_id, name, sequence) VALUES (?, ?, ?)";
            PreparedStatement preparedStatement = connection.getPreparedStatement(imageNameSql, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, objId);
            preparedStatement.setString(2, name);
            preparedStatement.setLong(3, sequence);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding image name %s to image with object ID %d", name, objId), ex);
        }
    }

    void addLayoutFileRangeToDb(long objId, long byteStart, long byteLen, long seq, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            String insertRangeSql = "INSERT INTO tsk_file_layout (obj_id, byte_start, byte_len, sequence) VALUES (?, ?, ?, ?)";
            PreparedStatement preparedStatement = connection.getPreparedStatement(insertRangeSql, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, objId);
            preparedStatement.setLong(2, byteStart);
            preparedStatement.setLong(3, byteLen);
            preparedStatement.setLong(4, seq);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error adding layout range to file with obj ID " + objId, ex);
        }
    }

    private class FileInfo {
        long parentObjId;
        long fsObjId;
        long dataSourceObjId;
        int fsType;
        int attrType;
        int attrId;
        String name;
        long metaAddr;
        long metaSeq;
        int dirType;
        int metaType;
        int dirFlags;
        int metaFlags;
        long size;
        long crtime;
        long ctime;
        long atime;
        long mtime;
        int meta_mode;
        int gid;
        int uid;
        String escaped_path;
        String extension;
        long seq;
        long parMetaAddr;
        long parSeq;
        String ownerUid;

        FileInfo(TskCaseDbBridge tskCaseDbBridge, long parentObjId, long fsObjId, long dataSourceObjId, int fsType, int attrType, int attrId, String name, long metaAddr, long metaSeq, int dirType, int metaType, int dirFlags, int metaFlags, long size, long crtime, long ctime, long atime, long mtime, int meta_mode, int gid, int uid, String escaped_path, String extension, long seq, long parMetaAddr, long parSeq, String ownerUid) {
            this.parentObjId = parentObjId;
            this.fsObjId = fsObjId;
            this.dataSourceObjId = dataSourceObjId;
            this.fsType = fsType;
            this.attrType = attrType;
            this.attrId = attrId;
            this.name = name;
            this.metaAddr = metaAddr;
            this.metaSeq = metaSeq;
            this.dirType = dirType;
            this.metaType = metaType;
            this.dirFlags = dirFlags;
            this.metaFlags = metaFlags;
            this.size = size;
            this.crtime = crtime;
            this.ctime = ctime;
            this.atime = atime;
            this.mtime = mtime;
            this.meta_mode = meta_mode;
            this.gid = gid;
            this.uid = uid;
            this.escaped_path = escaped_path;
            this.extension = extension;
            this.seq = seq;
            this.parMetaAddr = parMetaAddr;
            this.parSeq = parSeq;
            this.ownerUid = ownerUid;
        }
    }

    private class ParentCacheKey {
        long fsObjId;
        long metaAddr;
        long seqNum;
        String path;

        ParentCacheKey(TskCaseDbBridge tskCaseDbBridge, long fsObjId, long metaAddr, long seqNum, String path) {
            this.fsObjId = fsObjId;
            this.metaAddr = metaAddr;
            this.seqNum = tskCaseDbBridge.ownerIdToAccountMap.containsKey(fsObjId) && (tskCaseDbBridge.ownerIdToAccountMap.get(fsObjId).equals((Object)TskData.TSK_FS_TYPE_ENUM.TSK_FS_TYPE_NTFS) || tskCaseDbBridge.ownerIdToAccountMap.get(fsObjId).equals((Object)TskData.TSK_FS_TYPE_ENUM.TSK_FS_TYPE_NTFS_DETECT)) ? seqNum : 0L;
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParentCacheKey)) {
                return false;
            }
            ParentCacheKey otherKey = (ParentCacheKey)obj;
            if (this.fsObjId != otherKey.fsObjId || this.metaAddr != otherKey.metaAddr || this.seqNum != otherKey.seqNum) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.path, (CharSequence)otherKey.path);
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + (int)(this.fsObjId ^ this.fsObjId >>> 32);
            hash = 31 * hash + (int)(this.metaAddr ^ this.metaAddr >>> 32);
            hash = 31 * hash + (int)(this.seqNum ^ this.seqNum >>> 32);
            hash = 31 * hash + Objects.hashCode(this.path);
            return hash;
        }
    }

    private class LayoutRangeInfo {
        long objId;
        long byteStart;
        long byteLen;
        long seq;

        LayoutRangeInfo(TskCaseDbBridge tskCaseDbBridge, long objId, long byteStart, long byteLen, long seq) {
            this.objId = objId;
            this.byteStart = byteStart;
            this.byteLen = byteLen;
            this.seq = seq;
        }
    }
}

