/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

public class VersionNumber
implements Comparable<VersionNumber> {
    private final int major;
    private final int minor;
    private final int patch;

    public VersionNumber(int majorVersion, int minorVersion, int patchVersion) {
        this.major = majorVersion;
        this.minor = minorVersion;
        this.patch = patchVersion;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(VersionNumber vs) {
        int majorComp = Integer.compare(this.getMajor(), vs.getMajor());
        if (majorComp != 0) {
            return majorComp;
        }
        int minorCompare = Integer.compare(this.getMinor(), vs.getMinor());
        if (minorCompare != 0) {
            return minorCompare;
        }
        return Integer.compare(this.getPatch(), vs.getPatch());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.major;
        hash = 97 * hash + this.minor;
        hash = 97 * hash + this.patch;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        return this.major == other.getMajor() && this.minor == other.getMinor() && this.patch == other.getPatch();
    }
}

