/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.Volume;

public class VolumeSystem
extends AbstractContent {
    private volatile long volumeSystemHandle = 0L;
    private long type;
    private long imgOffset;
    private long blockSize;

    protected VolumeSystem(SleuthkitCase db, long obj_id, String name, long type, long imgOffset, long blockSize) {
        super(db, obj_id, name);
        this.type = type;
        this.imgOffset = imgOffset;
        this.blockSize = blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] readBuffer, long offset, long len) throws TskCoreException {
        VolumeSystem volumeSystem = this;
        synchronized (volumeSystem) {
            if (this.volumeSystemHandle == 0L) {
                this.getVolumeSystemHandle();
            }
        }
        return SleuthkitJNI.readVs(this.volumeSystemHandle, readBuffer, offset, len);
    }

    @Override
    public long getSize() {
        return 0L;
    }

    public TskData.TSK_VS_TYPE_ENUM getType() {
        return TskData.TSK_VS_TYPE_ENUM.valueOf(this.type);
    }

    public long getOffset() {
        return this.imgOffset;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    protected synchronized long getVolumeSystemHandle() throws TskCoreException {
        if (this.volumeSystemHandle == 0L) {
            Content dataSource = this.getDataSource();
            if (dataSource != null && dataSource instanceof Image) {
                Image image = (Image)dataSource;
                this.volumeSystemHandle = SleuthkitJNI.openVs(image.getImageHandle(), this.imgOffset);
            } else {
                throw new TskCoreException("Volume System data source is not an image");
            }
        }
        return this.volumeSystemHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.volumeSystemHandle != 0L) {
            VolumeSystem volumeSystem = this;
            synchronized (volumeSystem) {
                if (this.volumeSystemHandle != 0L) {
                    this.volumeSystemHandle = 0L;
                }
            }
        }
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        return this.getSleuthkitCase().getVolumeSystemChildren(this);
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        return this.getSleuthkitCase().getVolumeSystemChildrenIds(this);
    }

    public List<Volume> getVolumes() throws TskCoreException {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (Content child : this.getChildren()) {
            if (!(child instanceof Volume)) continue;
            volumes.add((Volume)child);
        }
        return volumes;
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "VolumeSystem [\tblockSize " + this.blockSize + "\timgOffset " + this.imgOffset + "\ttype " + this.type + "]\t";
    }
}

