/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CommunicationsManager;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.InvalidAccountIDException;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.blackboardutils.ArtifactHelperBase;

public final class WebBrowserArtifactsHelper
extends ArtifactHelperBase {
    private static final Logger LOGGER = Logger.getLogger(WebBrowserArtifactsHelper.class.getName());
    private static final BlackboardArtifact.Type WEB_BOOKMARK_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_BOOKMARK);
    private static final BlackboardArtifact.Type WEB_COOKIE_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_COOKIE);
    private static final BlackboardArtifact.Type WEB_DOWNLOAD_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_DOWNLOAD);
    private static final BlackboardArtifact.Type WEB_FORM_ADDRESS_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_ADDRESS);
    private static final BlackboardArtifact.Type WEB_FORM_AUTOFILL_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_AUTOFILL);
    private static final BlackboardArtifact.Type WEB_HISTORY_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_HISTORY);

    public WebBrowserArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Long ingestJobId) {
        super(caseDb, moduleName, srcContent, ingestJobId);
    }

    @Deprecated
    public WebBrowserArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent) {
        this(caseDb, moduleName, srcContent, null);
    }

    public BlackboardArtifact addWebBookmark(String url, String title, long creationTime, String progName) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebBookmark(url, title, creationTime, progName, Collections.emptyList());
    }

    public BlackboardArtifact addWebBookmark(String url, String title, long creationTime, String progName, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL, this.getModuleName(), url));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED, creationTime, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TITLE, title, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN, WebBrowserArtifactsHelper.extractDomain(url), attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, progName, attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact bookMarkArtifact = content.newDataArtifact(WEB_BOOKMARK_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(bookMarkArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return bookMarkArtifact;
    }

    public BlackboardArtifact addWebCookie(String url, long creationTime, String name, String value, String programName) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebCookie(url, creationTime, name, value, programName, Collections.emptyList());
    }

    public BlackboardArtifact addWebCookie(String url, long creationTime, String name, String value, String programName, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL, this.getModuleName(), url));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, creationTime, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, name, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE, value, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN, WebBrowserArtifactsHelper.extractDomain(url), attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, programName, attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact cookieArtifact = content.newDataArtifact(WEB_COOKIE_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(cookieArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return cookieArtifact;
    }

    public BlackboardArtifact addWebDownload(String url, long startTime, String path, String programName) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebDownload(path, startTime, url, programName, Collections.emptyList());
    }

    public BlackboardArtifact addWebDownload(String url, long startTime, String path, String programName, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PATH, this.getModuleName(), path));
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL, this.getModuleName(), url));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, startTime, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, programName, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN, WebBrowserArtifactsHelper.extractDomain(url), attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact webDownloadArtifact = content.newDataArtifact(WEB_DOWNLOAD_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(webDownloadArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return webDownloadArtifact;
    }

    public BlackboardArtifact addWebFormAddress(String personName, String email, String phoneNumber, String mailingAddress, long creationTime, long accessTime, int count) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebFormAddress(personName, email, phoneNumber, mailingAddress, creationTime, accessTime, count, Collections.emptyList());
    }

    public BlackboardArtifact addWebFormAddress(String personName, String email, String phoneNumber, String mailingAddress, long creationTime, long accessTime, int count, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        CommunicationsManager commManager = this.getSleuthkitCase().getCommunicationsManager();
        Optional<Long> ingestJobId = this.getIngestJobId();
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            try {
                commManager.createAccountFileInstance(Account.Type.EMAIL, email, this.getModuleName(), this.getContent(), null, ingestJobId.orElse(null));
            }
            catch (InvalidAccountIDException ex) {
                LOGGER.log(Level.WARNING, String.format("Invalid account identifier %s", email), ex);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            try {
                commManager.createAccountFileInstance(Account.Type.PHONE, phoneNumber, this.getModuleName(), this.getContent(), null, ingestJobId.orElse(null));
            }
            catch (InvalidAccountIDException ex) {
                LOGGER.log(Level.WARNING, String.format("Invalid account identifier %s", phoneNumber), ex);
            }
        }
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, this.getModuleName(), personName));
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL, email, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, phoneNumber, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_LOCATION, mailingAddress, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED, creationTime, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, accessTime, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COUNT, count, (Collection<BlackboardAttribute>)attributes);
        Content content = this.getContent();
        DataArtifact webFormAddressArtifact = content.newDataArtifact(WEB_FORM_ADDRESS_TYPE, attributes);
        this.getSleuthkitCase().getBlackboard().postArtifact(webFormAddressArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return webFormAddressArtifact;
    }

    public BlackboardArtifact addWebFormAutofill(String name, String value, long creationTime, long accessTime, int count) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebFormAutofill(name, value, creationTime, accessTime, count, Collections.emptyList());
    }

    public BlackboardArtifact addWebFormAutofill(String name, String value, long creationTime, long accessTime, int count, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, this.getModuleName(), name));
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE, this.getModuleName(), value));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED, creationTime, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, accessTime, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COUNT, count, (Collection<BlackboardAttribute>)attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact webFormAutofillArtifact = content.newDataArtifact(WEB_FORM_AUTOFILL_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(webFormAutofillArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return webFormAutofillArtifact;
    }

    public BlackboardArtifact addWebHistory(String url, long accessTime, String referrer, String title, String programName) throws TskCoreException, Blackboard.BlackboardException {
        return this.addWebHistory(url, accessTime, referrer, title, programName, Collections.emptyList());
    }

    public BlackboardArtifact addWebHistory(String url, long accessTime, String referrer, String title, String programName, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL, this.getModuleName(), url));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED, accessTime, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TITLE, title, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_REFERRER, referrer, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, programName, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN, WebBrowserArtifactsHelper.extractDomain(url), attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact webHistoryArtifact = content.newDataArtifact(WEB_HISTORY_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(webHistoryArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return webHistoryArtifact;
    }

    private static String extractDomain(String urlString) {
        String result;
        if (urlString == null) {
            return "";
        }
        try {
            URL url = new URL(urlString);
            result = url.getHost();
        }
        catch (MalformedURLException ex) {
            result = null;
        }
        if (result == null || StringUtils.isBlank((CharSequence)result)) {
            return WebBrowserArtifactsHelper.getBaseDomain(urlString);
        }
        return result;
    }

    private static String getBaseDomain(String url) {
        String cleanUrl = url.replaceFirst(".*:\\/\\/", "");
        String[] dirToks = cleanUrl.split("\\/");
        String host = dirToks.length > 0 ? dirToks[0] : cleanUrl;
        StringTokenizer tok = new StringTokenizer(host, ".");
        StringBuilder hostB = new StringBuilder();
        int toks = tok.countTokens();
        for (int count = 0; count < toks; ++count) {
            String part = tok.nextToken();
            int diff = toks - count;
            if (diff < 3) {
                hostB.append(part);
            }
            if (diff != 2) continue;
            hostB.append('.');
        }
        String base = hostB.toString();
        if (base.matches(".*[~`!@#$%^&\\*\\(\\)\\+={}\\[\\];:\\?<>,/ ].*")) {
            return "";
        }
        if (!base.contains(".")) {
            return "";
        }
        return base;
    }
}

