/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils.attributes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public final class MessageAttachments {
    private final Collection<FileAttachment> fileAttachments;
    private final Collection<URLAttachment> urlAttachments;

    public MessageAttachments(Collection<FileAttachment> fileAttachments, Collection<URLAttachment> urlAttachments) {
        this.fileAttachments = fileAttachments;
        this.urlAttachments = urlAttachments;
    }

    public Collection<FileAttachment> getFileAttachments() {
        return Collections.unmodifiableCollection(this.fileAttachments);
    }

    public Collection<URLAttachment> getUrlAttachments() {
        return Collections.unmodifiableCollection(this.urlAttachments);
    }

    public int getAttachmentsCount() {
        return this.fileAttachments.size() + this.urlAttachments.size();
    }

    public static final class FileAttachment
    implements Attachment {
        private final String path;
        private final long objectID;
        private static final transient List<String> KNOWN_MOUNTPOINTS = ImmutableList.of((Object)"/data/", (Object)"/storage/emulated/");

        public FileAttachment(SleuthkitCase caseDb, Content dataSource, String pathName) throws TskCoreException {
            this.path = this.normalizePath(pathName);
            String fileName = this.path.substring(this.path.lastIndexOf(47) + 1);
            if (fileName.isEmpty()) {
                throw new TskCoreException(String.format("No file name specified for attachment file: %s, on data source = %d", this.path, dataSource.getId()));
            }
            String parentPathSubString = this.path.lastIndexOf(47) < 0 ? "" : this.path.substring(0, this.path.lastIndexOf(47));
            this.objectID = this.findAttachmentFile(caseDb, fileName, parentPathSubString, dataSource);
        }

        public FileAttachment(DerivedFile derivedFile) throws TskCoreException {
            this.objectID = derivedFile.getId();
            this.path = derivedFile.getUniquePath();
        }

        public FileAttachment(AbstractFile abstractFile) {
            this.objectID = abstractFile.getId();
            this.path = abstractFile.getParentPath() + "/" + abstractFile.getName();
        }

        public String getPathName() {
            return this.path;
        }

        public long getObjectId() {
            return this.objectID;
        }

        private String normalizePath(String path) {
            String adjustedPath = path.replace("\\", "/").replace("%20", " ");
            for (String mountPoint : KNOWN_MOUNTPOINTS) {
                if (!adjustedPath.toLowerCase().startsWith(mountPoint)) continue;
                adjustedPath = "/".concat(adjustedPath.substring(mountPoint.length()));
                break;
            }
            return adjustedPath;
        }

        private long findAttachmentFile(SleuthkitCase caseDb, String fileName, String parentPathSubstring, Content dataSource) throws TskCoreException {
            String whereClause = String.format("LOWER(name) = LOWER('%s') AND LOWER(parent_path) LIKE LOWER('%%%s%%')", fileName, parentPathSubstring);
            List<AbstractFile> matchedFiles = caseDb.findAllFilesWhere(whereClause);
            ArrayList<Long> allocFileMatchesOnSameDatasource = new ArrayList<Long>();
            ArrayList<Long> allocFileMatchesOnOtherDatasources = new ArrayList<Long>();
            ArrayList<Long> unallocFileMatches = new ArrayList<Long>();
            for (AbstractFile file : matchedFiles) {
                if (file.isMetaFlagSet(TskData.TSK_FS_META_FLAG_ENUM.ALLOC)) {
                    if (dataSource.getId() == file.getDataSource().getId()) {
                        allocFileMatchesOnSameDatasource.add(file.getId());
                        continue;
                    }
                    allocFileMatchesOnOtherDatasources.add(file.getId());
                    continue;
                }
                unallocFileMatches.add(file.getId());
            }
            return this.pickBestMatchFile(allocFileMatchesOnSameDatasource, allocFileMatchesOnOtherDatasources, unallocFileMatches);
        }

        private long pickBestMatchFile(List<Long> allocFileMatchesOnSameDatasource, List<Long> allocFileMatchesOnOtherDatasources, List<Long> unallocFileMatches) {
            if (!allocFileMatchesOnSameDatasource.isEmpty() && allocFileMatchesOnSameDatasource.size() == 1) {
                return allocFileMatchesOnSameDatasource.get(0);
            }
            if (!allocFileMatchesOnOtherDatasources.isEmpty() && allocFileMatchesOnOtherDatasources.size() == 1) {
                return allocFileMatchesOnOtherDatasources.get(0);
            }
            if (!unallocFileMatches.isEmpty() && unallocFileMatches.size() == 1) {
                return unallocFileMatches.get(0);
            }
            return -1L;
        }

        @Override
        public String getLocation() {
            return this.path;
        }

        @Override
        public Long getObjId() {
            return this.objectID;
        }
    }

    public static class URLAttachment
    implements Attachment {
        private final String url;

        public URLAttachment(String url) {
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        @Override
        public String getLocation() {
            return this.url;
        }

        @Override
        public Long getObjId() {
            return null;
        }
    }

    public static interface Attachment {
        public String getLocation();

        public Long getObjId();
    }
}

