/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.Facet;
import org.sleuthkit.caseuco.Location;

class CalendarEntry
extends Facet {
    private String eventType;
    private String startTime;
    private String endTime;
    private String location;

    CalendarEntry() {
        super(CalendarEntry.class.getSimpleName());
    }

    CalendarEntry setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    CalendarEntry setLocation(Location location) {
        this.location = location.getId();
        return this;
    }

    CalendarEntry setEndTime(Long endTime) {
        if (endTime != null) {
            this.endTime = Instant.ofEpochSecond(endTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    CalendarEntry setStartTime(Long startTime) {
        if (startTime != null) {
            this.startTime = Instant.ofEpochSecond(startTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    String getEventType() {
        return this.eventType;
    }

    String getStartTime() {
        return this.startTime;
    }

    String getEndTime() {
        return this.endTime;
    }

    String getLocation() {
        return this.location;
    }
}

