/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.sleuthkit.caseuco.Facet;
import org.sleuthkit.caseuco.Hash;
import org.sleuthkit.caseuco.Identity;
import org.sleuthkit.caseuco.UcoObject;

class ContentData
extends Facet {
    private Long sizeInBytes;
    private String mimeType;
    @SerializedName(value="hash")
    private final List<Hash> hashes = new ArrayList<Hash>();
    private String dataPayload;
    private String owner;
    private String dataPayloadReferenceUrl;

    ContentData() {
        super(ContentData.class.getSimpleName());
    }

    ContentData setSizeInBytes(long bytes) {
        this.sizeInBytes = bytes;
        return this;
    }

    ContentData setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    ContentData setMd5Hash(String md5Hash) {
        Hash md5HashType = new Hash(md5Hash).setHashMethod(Hash.HashMethod.MD5);
        this.hashes.add(md5HashType);
        return this;
    }

    ContentData setDataPayload(String dataPayload) {
        this.dataPayload = dataPayload;
        return this;
    }

    ContentData setOwner(Identity owner) {
        this.owner = owner.getId();
        return this;
    }

    ContentData setDataPayloadReferenceUrl(UcoObject url) {
        this.dataPayloadReferenceUrl = url.getId();
        return this;
    }

    Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    String getMimeType() {
        return this.mimeType;
    }

    List<Hash> getHashes() {
        return this.hashes;
    }

    String getDataPayload() {
        return this.dataPayload;
    }

    String getOwner() {
        return this.owner;
    }

    String getDataPayloadReferenceUrl() {
        return this.dataPayloadReferenceUrl;
    }
}

