/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.sleuthkit.caseuco.Facet;

class FacetDeserializer
implements JsonDeserializer<Facet> {
    private static final String BASE_PACKAGE = "org.sleuthkit.caseuco";

    FacetDeserializer() {
    }

    public Facet deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
        Class<?> deserializationClass;
        if (!(je instanceof JsonObject)) {
            throw new JsonParseException("Expected a json object for " + je);
        }
        JsonObject jObj = (JsonObject)je;
        JsonElement jsonId = jObj.get("@type");
        if (jsonId == null) {
            throw new JsonParseException("Expected non-null @type value");
        }
        String id = jsonId.getAsString();
        String className = "org.sleuthkit.caseuco." + id;
        try {
            deserializationClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new JsonParseException("Expected class to exist: " + className, (Throwable)ex);
        }
        return (Facet)jdc.deserialize((JsonElement)jObj, deserializationClass);
    }
}

