/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.CyberItem;
import org.sleuthkit.caseuco.Facet;

class PhoneCall
extends Facet {
    private String to;
    private String from;
    private String startTime;
    private String endTime;
    private String callType;

    PhoneCall() {
        super(PhoneCall.class.getSimpleName());
    }

    PhoneCall setTo(CyberItem to) {
        this.to = to.getId();
        return this;
    }

    PhoneCall setFrom(CyberItem from) {
        this.from = from.getId();
        return this;
    }

    PhoneCall setStartTime(Long startTime) {
        if (startTime != null) {
            this.startTime = Instant.ofEpochSecond(startTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    PhoneCall setEndTime(Long endTime) {
        if (endTime != null) {
            this.endTime = Instant.ofEpochSecond(endTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    PhoneCall setCallType(String callType) {
        this.callType = callType;
        return this;
    }

    String getTo() {
        return this.to;
    }

    String getFrom() {
        return this.from;
    }

    String getStartTime() {
        return this.startTime;
    }

    String getEndTime() {
        return this.endTime;
    }

    String getCallType() {
        return this.callType;
    }
}

