#!/usr/bin/perl -w
use strict;
use utf8;

sub toU($) { substr+(qq(\x{fff}).shift),1 }	# Some bullshit one must do to make perl's Unicode 8-bit-aware (!)

#use subs qw(chr lc);
use subs qw(chr lc uc);

#BEGIN { *CORE::GLOGAL::chr = sub ($) { toU CORE::chr shift };
#        *CORE::GLOGAL::lc  = sub ($)  { CORE::lc  toU shift };
#}
# Remove ß ẞ :
my %fix = qw( ԥ Ԥ ԧ Ԧ ӏ Ӏ ɀ Ɀ ꙡ Ꙡ ꞑ Ꞑ  ꞧ Ꞧ  ɋ Ɋ  ꞩ Ꞩ  ȿ Ȿ  ꞓ Ꞓ  ꞥ Ꞥ );		# Perl 5.8.8 uc is wrong with palochka, 5.10 with z with swash tail
my %unfix = reverse %fix;

sub chr($)  { local $^W = 0; toU CORE::chr shift }	# Avoid illegal character 0xfffe etc warnings...
sub lc($)   { my $in = shift; $unfix{$in} || CORE::lc toU $in }
sub uc($)   { my $in = shift;   $fix{$in} || CORE::uc toU $in }

my %html_esc = qw( & &amp; < &lt; > &gt; );
sub h($)  { (my $c = shift) =~ s/([&<>])/$html_esc{$1}/g; $c }
sub tags_by_rx {
  my ($c, @o) = shift;
  die "Need odd number of arguments" if @_ & 1;
  while (@_) {
    my $tag = shift;
    push @o, $tag if $c =~ shift;
  }
  return @o;
}

sub a_pair ($$$$;@) {
  my($opt, $lc, $uc, $name, $extra) = (shift, shift, shift, shift, shift || []);

  my $altLatin	= ($opt =~ /\b latinAlt \b/x);
  my $baseLatin	= ($opt =~ /\b latinBase \b/x);
  my $cyr 	= ($opt =~ /\b cyr \b/x);
  my $greek	= ($opt =~ /\b greek \b/x);
  $extra = [@$extra];
  my $alt = ("@$extra" =~ /\b on-right \b/x);
  my $e = @$extra;
  push @$extra, $name if $name;
  if ($uc eq uc $lc and $lc eq lc $uc) {
    if ($uc ne $lc) {
      s/[☠◌]//g and die "Do not expect a character `$_' to be a deadkey..." for $lc, $uc;
    }
    unshift @$extra, tags_by_rx $lc,	'in-stone'	=> qr/[ºª№€§Æßðþçñĳœ¡¿всыхѣєәϋϊươəƎϷͷϻΩ]/i,		# green
    					'high-freq'	=> ($baseLatin? qr/[aeyuio]/ : qr/[êαωεηυιοъёⲆⲔꙨꙪꙬ]/i),	# blue
    					'may-guess'	=> qr/[ϛϟϡɂͰҼҾѼүұӧғӻӑԋԅԇꙁꙃҹϪϤ]/i,			# yellow
    					'need-learn'	=> ($cyr ? qr/[åøìючяшщэьжθψѓјѐѝӹӳӛӕќѹꙋꙟԛꙏҀ]|[ꚑꚉꙚꙅԑꙉꙕӊꚏꚅԙӿҝԟꚕꚓꙙꙝҍꙓ]/i : qr/[åøìθψᾰῠῐᾱῡῑϝϙϲͻϿϾͲ℧ϗ]/i);
    my $q = (@$extra > 1 ? '"' : '');
    my $cl = @$extra ? " class=$q@$extra$q" : '';
    "<span$cl>" . h($uc) . "</span>";
  } else {
    my (@e_lc, @e_uc);
    my @do = ([$lc, [], 'lc'], [$uc, [], 'uc']);
    $_->[0] =~ s/[☠]//g and push @{$_->[1]}, 'prefix' for @do;
    push @{$_->[1]}, tags_by_rx $_->[0],	'in-stone' => ($altLatin ? qr/[ºª№€§Æßðþçñĳœ¡¿ĸ]/i : qr/[ºª№§Æßðþçñĳœ¡¿ĸ϶ᵼᵿƛ]/i),	# green
    						'not-surr' => qr/[„‚“‘”’«‹»›‐–—―‒‑‵‶‷′″‴⁗]/i,				# white
    						'high-freq'=> qr/[©®℠™℗℅℮‱ϒꙮ]/i,						# blue
    						'may-guess'=> ($alt ? qr/[ϗ∨⋁∧⋀]/i 
    								      : qr/[ⷵⷸᵸᴫ]/i),	# confuse: ϱ
    						'need-learn' => ($alt ? qr/[ъё៛﷼元圆΄΅∐℧♫]/i 
    								      : ($greek ? qr/[ъё៛﷼ϵϼ͵ʹ᾽ͺι₯]/i : qr/[ъё៛﷼ϵϼ͵ʹ᾽ͺι]/i))	# confuse: ϱ
    	for @do;
    	join '', map {
           my $q = ($e || @{$_->[1]}) ? '"' : '';
           my $e = [@$extra, @{$_->[1]}];
           my $j = ($name ? '-' : (@$e ? ' ' : ''));
           "<span class=$q@$e$j$_->[2]$q>" . h($_->[0]) . '</span>';
      } @do;
  }
}

my @mid = ('

<span class=drow>',
	   '<kbd style="width: 2.4em"><span class=vsmall>Backspace</span></kbd><kbd class=hidden-align></kbd></span>

<br><span class=arow><kbd style="width: 2.4em">Tab</kbd>',
	   '</span>

<br><span class=arow><kbd style="width: 3em"><span class=small>CapsLock</span></kbd>',
	   '<kbd style="width: 2.52em"><span class=shrink>Enter</span></kbd></span>

<br><span class=arow><kbd style="width: 4em" class="shift">Shift</kbd>',
	   '<kbd style="width: 3.24em" class="shift">Shift</kbd></span>

<br><span class=srow><kbd style="width: 2.5em">Ctrl</kbd><kbd class=win_logo></kbd><kbd style="width: 2em">Alt</kbd>', 
	   '<kbd style="width: 8.08em"></kbd><kbd style="width: 2em"><span class="small altgr">AltGr</span></kbd><kbd style="width: 2.5em">Menu</kbd><kbd style="width: 2.5em">Ctrl</kbd></span>

');
my @MID = @mid;

my @K_sets;	# = (\@KEYS, \@KEYS2);
my $kkkk = 0;
for (<DATA>) {
  chomp;
  $kkkk++, next if /^===/;
  push @{$K_sets[$kkkk]}, [split /\s+/]
}

sub do_keys {
  my $opt = shift;
  my $latin_arr = ($opt =~ /\b latinAlt \b/x);
  my $cyr2_arr  = ($opt =~ /\b cyr2 \b/x);
  my $cyr3_arr  = ($opt =~ /\b cyr3 \b/x);
  my $grk_arr   = ($opt =~ /\b polyBase \b/x);
  my $bus_arr   = ($opt =~ /\b businessAlt \b/x);
  my(@k, @extra) = @_;
  my $keep_O 	= ($opt =~ /\b keepO \b/x);
  for my $in (@k) {
    next if $keep_O;
    s/[◌]//g for @$in;			# ◌ is not good in a fixed-width font???
  }
  print(shift(@mid) || '') if $k[0][0] =~ /[qaz]/i; # or $k[1][0] =~ /[¶ӏ]/;	# or "$k[0][0]$k[1][0]" =~ /\\[Э¶ӏ]/i ;
  push @extra, 'with_x'  if @k > 1 and "@{$k[1]}" =~ /[ºª№§Æßðþçñĳœ¡¿]/i;
  push @extra, 'with_x'  if @k > 1 and "@{$k[1]}" =~ /[€]/i	and $latin_arr;
  push @extra, 'from_ne' if $k[0][0] =~ /[x]/i	and $latin_arr;
  push @extra, 'from_sw' if $k[0][0] =~ /[wf]/i	and $latin_arr;
  push @extra, 'from_nw' if $k[0][0] =~ /[l]/i	and $latin_arr;
  push @extra, 'to_w'    if $k[0][0] =~ /[=g]/i	and $cyr2_arr;
  push @extra, 'to_w'    if $k[0][0] =~ /[=]/i	and $cyr3_arr;
  push @extra, 'to_w'    if $k[0][0] =~ /[j]/i	and $grk_arr;
  push @extra, 'from_w'  if $k[0][0] =~ /[sl]/i	and $grk_arr or $k[0][0] =~ /[u]/i	and $bus_arr;
  my $q = (@extra > 1 ? '"' : '');
  my $cl = @extra ? " class=$q@extra$q" : '';
#  push @extra, 'from_se' if $k[0][0] =~ /---/i;
  print "<kbd$cl>", join('', map a_pair($opt, $_->[0], $_->[1], $_->[2], [@$_[3..$#$_]]), @k) . '</kbd>';
}

sub output_keys ($@) {
  my $opts = shift;
  @mid = @MID;
  print shift @mid;
 KEY:
  for my $kn (0..$#{$K_sets[0]}) {	# For each keyboard's key
    my ($symb, @keys, $last) = 0;
    for my $KK (@_) {
      my($ks, $p, $alt, @rest) = @$KK;
      my (@k) = split /(?<![☠◌])/, $K_sets[$ks][$kn][$p];
      next KEY if @k != 4 and not $symb;
      print(shift(@mid) || ''), $last = 1 if $symb++ == 0 and $k[2] =~ /[¶ӏ]/;
      push @keys, [@k[$alt*2, $alt*2+1], @rest];
    }
    do_keys($opts, @keys);
    print @mid and last if $last;
  }
}

my @col_L = qw(´ 	ˋ 	ˆ 	˜ 	° 	¸ 	ˇ 	¯ 	◌̸ 	¨ 	˵ 	µ 	£ 	ƒ 	Φ);
my %col_L = map +($col_L[$_] => $_+1), 0..$#col_L;
my @col_C = qw(◌́ 	  Ё 	µ 	£ 	ƒ 	µэ 	µш 	µщ 	µю);
my %col_C = map +($col_C[$_] => $_+1), 0..$#col_C;
my %col = ( l => \%col_L, c => \%col_C );

while (<>) {
  print; 
  next unless /^<div[^>]*\srebuild="(.*?)"/;
  my(@opt,@pos);
  my %tr = qw(l 0 c 1 h 2);
  for my $arg (split /\s+/, "$1") {
    push(@opt, $arg), next if $arg =~ s(^/opt=)();
    die "unknown `rebuild' option: `$arg'" 
      unless my($pre, $name, $g, $which) = ( $arg =~ m{^((?:[-\w]+(?:,[-\w]+)*)?)\+([-\w]*)=([lch]),((?:(?:\d+|[^\x20-\x7e][^,]*)(?=$|,),?){2})$} );
    $which =~ s/^([^\x20-\x7e][^,]*)(?=,)/ $col{$g}{$1}  /e;
    push(@pos, [$tr{$g}, split(/,/, $which), $name, split /,/, $pre]);
  }
  die "there must be one /opt= argument" unless @opt == 1;
  output_keys($opt[0], @pos);
  while (<>) {
    next unless m(^</div);
    print;
    last;
  }
}

__END__
`~☠ˋ☠˜	♪⥲◌̛◌̛	♪⭉◌̀∽	♪∿◌͒∽	♪≈◌͂≋	♪∾◌᷒⩪	♪⩫◌͂⸟	♪‿◌̐⁀	♪♪◌̅◌̅	♪≁♪♪	♪∼◌̏◌̏	♪⩪◌͑◌͑	☠Ϣ♪♪♪	¤∼¤≉	юЮ⋱≀	ѫѪѭѬ
1!¬¡	⩚⩛⌙◌̷	⩚⩛⌐◌᷆	⍡⍎≉⫫	⍕¡≆⫡	⫙⟒≭⟟	⫱⟟⫙⦹	⫟⫠≶⫛	⍑ǃ≢⍊	♪‼♪♪	⊤⊥≠⟂	♪♪◌᷆◌᷆	₁‐‑♪	⫪⫫≸¤	¹∣∤∁	⅒⅟♪½
2@ºª	⨗∲⨘ᵄ	⨒∳⨐⨖	∬∯⨜⫴	∱⨑⨌⫳	∮⨕∰≬	⨓⨕∬ᵅ	♪♪◌ᷓ◌ᷓ	⨛♪⨜⫲	⨎⨔⨏∦	∫∮∭∥	∯∰∭⫼	₂–♪♪	⨒¤ƻ⫽	²≈∃∀	½⅔♪⅖
3#√№	⧏⫸⫣⟝	⫷⧐⟞⊩	⨞⫐∛⊦	⫏⫐⫥⊫	◁▷◀▶	⫑⫒⪦⪧	⋭⋬◌᷾◌᷾	⊴⊵⩤⩥	⋪⋫♪⊬	⊲⊳⊣⊢	♪♪∜⊮	₃—♪♪	♪¤⫣⊩	³ъ∛∄	⅓¾⅔⅗
4$¢☠£	⟤⟡⟥⟣	⟤⌺⧈⟢	■◆▲▼	▫◈▵▿	⊡⟐▢◌͚	▢⟐◬◌͠	∎♪▬∀	▤⍚⧋⟠	▩♪◪♪	□◇△▽	▪⬩▴▾	₄―♪♪	▥⋄◫¤	⁴Ъ∜⨋	¼⅘¾⅘
5%€¥	⥁⧒⧕◌᷎	⥀⧑⧔⧒	●⧓○☆	◦⧓○◌᷑	⦁‰×⦼	⦿⦼⨷‰	♪♪◌᷌◌᷌	⦵♪⨲◌̚	⊝♪♪♪	•⋈⨯⋆	♪♪◌⃠◌⃠	₅˥꜒꜍	⦶¤∙¤	⁵ё☆★	⅕⅚⅖⅝
6^☠ˇ☠ˆ	⋎⋏◌᷄◌᷄	⊔⊓⟏⟎	⩖⩕⩔⩓	⩅⩄⩣⩠	⩒⩑⑥◌̤	⩏⩎⩒⩑	⋁⋀⨆⨅	⊻⊼⩝⩜	⩢⩞♪♪	∨∧◌⃨◌⃨	♪♪◌⃥◌⃥	₆˦꜓꜎	⩛⩚♪¤	⁶Ё⨊☠◌҃	⅙♪⅚♪
7&·§	♪⅋◌᷇◌᷇	⊔⊓⊡◌̀	⋓⋒⩃⁊	⩇⩆⩃⅋	⑦⩀⊙◌͘	⩏⩎⊙⩀	⋃⋂⨆⨅	⩂⩃⩌⩍	♪♪♪♪	∪∩⋅◌̈	♪♪◌̀◌̀	₇˧꜔꜏	⨚⨙⋅¤	⁷&◌҆◌҇	⅐⅞◌꙽ꙿ
8*„‚	≒⋊◌᷁⨵	≓⋉∺⨴	≎⨯◌̼⨶	≏⨱≊⨻	≖⊗≑⦻	≑⨰≖⊛	♪⨉◌͜⨂	˨⨱≅⩮	♪⨳≄⩐	≐×≃∗	♪⨷≇◌̀	₈˨꜕꜐	≭∗≇¤	⁸⊠∞⧆	⅛◌҅⅜♪
9(“‘	♪⟨◌̦◌̦	♪⟮◌̖〘	♪∊◌͎⋸	♪⟅◌᷏⟪	⑨⦅◌゚⦓	♪⦑◌᷏⦖	♪⦇◌̺⦗	˩⋳◌̠⋲	♪∉♪⋲	♪∈◌̤〔	♪♪◌̖◌̖	₉˩꜖꜑	♪⋳♪∌	⁹(♪‛	⅑♪ҁҀ
0)”’	⦳⟩◌̹◌̹	⦴⟯⦰〙	⦰∍◌᷊⋶	∝⟆⦰⟫	⦲⦆⓪⦔	⦲⦒◌᷐⦕	♪⦈ᴕ⦘	ə⋻ɚ⋽	∅∌⦱⋺	∅∋◌͈〕	♪♪◌̜◌̜	₀‒♪♪	⦽⋻♪¤	⁰)◌⧇	⅒↉◌꙼◌꙾
-_☠¯—	∹ˌ⧿◌̩	⊟ʻ⧿◌̜	−ꜛ⨺◌̯	≂¸⨺◌̧	⊸ʰ⊖◌̥	⨩¸⨬◌̧	ˬ˯◌̮◌̬	ˍ˻◌̄◌̲	♪♪♪♪	˶˵◌̤◌͈	ˎʻ◌̖◌̜	₋⁻⁃‾	∓¤¤¤	∓―±–	ҽҼҿҾ
=+☠µ±	≕⧾⥱⨮	≔⊞⭀⨭	≝∑≅⨹	≌⨤⩳⨦	≍⊕≖⨥	⊜⨢≗⨥	≸⨁≹◌͔	≡∦≣◌̟	≠∦♪♪	≢♪◌̎◌̎	≢∔◌̒◌̒	₌₊µ♪	⧧⧺≢⧻	чЧ♪♪	ҷҶӵӴ
qQäÄ	ʠ♪ɋɊ	ɋɊʠ♪	ꝗꝖ♪♪	ꝗꝖ♪♪	ⓠⓆ♪♪	♪♪♪♪	♪♪♪♪	♪♪ǟǞ	ꝙꝘꝗꝖ	ʠ♪♪♪	♪ℚǡǠ	θΘϑϴ	ĸ⌨♪♪	яЯѣѢ	ѧѦѩѨ
wWáÁ	ẃẂᶏ♪	ẁẀⱳⱲ	ŵŴấẤ	ƿǷʍᴡ	ẘ♪ǻǺ	ẉẈẇẆ	ɷ♪ắẮ	♪♪ȃȂ	♪♪ɒⱰ	ẅẄⱳⱲ	ẅẄᶐ♪	ωΩώΏ	₩₩ﬁﬂ	вВѵѴ	ꙍꙌԝԜ
eEêÊ	éÉếẾ	èÈềỀ	êÊɛƐ	ẽẼễỄ	ėĖẹẸ	ęĘȩȨ	ĕĔěĚ	ēĒȇȆ	ɇɆɘɞ	ëËẻẺ	ëËȅȄ	εΕέΈ	€₠℮♪	еЕёЁ	өӨӫӪ
rRåÅ	ŕŔǻǺ	ɽⱤɼᴙ	ɹʀɾʁ	ᵲᴚẵẴ	ṙṘặẶ	ŗŖṛṚ	řŘᶉᴩ	ȓȒṝṜ	ɍɌꞧꞦ	ꝛꝚẳẲ	ɿℝȑȐ	ρΡϱ∐	®₹₨ℛ	рР◌҄®	ѽѼԗԖ
tTþÞ	ƭƬʈƮ	ƫ♪ȶ♪	ʇᴛꞇꞆ	ᵵᴛꝧꝦ	ṫṪṭṬ	ţŢțȚ	ťŤꝥꝤ	ꝫꝪ♪♪	ŧŦⱦȾ	ẗ♪ƭƬ	ẗ♪ⱦȾ	τΤϛϚ	™₸₮௹	тТћЋ	ҭҬԏԎ
yYÿŸ	ýÝƴƳ	ỳỲƴƳ	ŷŶʎʏ	ỹỸʎ⅄	ẙ♪ỵỴ	ẏẎỵỴ	ỿỾ♪ᴪ	ȳȲꜽꜼ	ɏɎ♪♪	ÿŸỷỶ	ÿŸꜽꜼ	ψΨϝϜ	元¥円圓	ыЫіІ	үҮұҰ
uUüÜ	úÚᶙ♪	ùÙưƯ	ûÛʉɄ	ũŨṵṴ	ůŮụỤ	ųŲʊƱ	ǔǓǚǙ	ūŪǖǕ	ŭŬṻṺ	üÜủỦ	üÜȕȔ	υΥύΎ	ưƯ元圆	уУўЎ	ӯӮӱӰ
iIĳĲ	íÍᶖ♪	ìÌᶖ♪	îÎᴉɪ	ĩĨḭḬ	ıİịỊ	įĮɩƖ	ĭĬǐǏ	īĪȋȊ	ɨƗɻɺ	ïÏỉỈ	ïÏȉȈ	ιΙίΊ	៛﷼♪♪	иИѷѶ	ӣӢӥӤ
oOœŒ	óÓᶗ♪	òÒơƠ	ôÔɔƆ	õÕɵƟ	ȯȮọỌ	ǫǪꝏꝎ	ŏŎǒǑ	ōŌꜵꜴ	øØꝋꝊ	öÖỏỎ	öÖȍȌ	οΟόΌ	ơƠ℅ɶ	оОѡѠ	ѻѺѿѾ
pPøØ	ṕṔǿǾ	ƥƤᶈꟼ	♪℘ᴓᴘ	ᵱꟼỡỠ	ṗṖợỢ	ṗṖǭǬ	ꝓꝒᶈᴨ	♪♪ȭȬ	ᵽⱣꝑꝐ	ꝕꝔởỞ	♠ℙ♥♦	πΠϖ∏	℗₱₰₧	пПѱѰ	ԥԤҧҦ
[{«‹	⦏⊰⦍◌̓	⦍⦉⦏⊰	⟦❴⦋⦃	⦋⦃⟦❴	⟬⧼◌̇◌̇	⟬⧼◌᷽◌᷽	⨽◌̐◌͕◌͕	⁅◌⃪⦋◌̠	⌊⌈⧘⧚	◌⃨◌̏◌͛◌͛	◌⃠◌⃥◌̔◌̔	☠◌̔₍⁽♪	〈◄◃◂	шШ♪♪	ԧԦѐЀ
]}»›	⦎⊱⦐◌̕	⦐⦊⦎⊱	⟧❵⦌⦄	⦌⦄⟧❵	⟭⧽◌͘◌͘	⟭⧽◌⃯◌⃯	⨼◌ᷓ◌͖◌͖	⁆◌⃡⦌◌̘	⌋⌉⧙⧛	◌̈́◌᷉◌⃛◌⃛	◌͑◌᷆◌⃑◌⃑	☠◌̓₎⁾♪	〉►▹▸	щЩ♪♪	ꚇꚆѝЍ
\|†¦	ˈ⩗⸸◌̓	⋋⩘⧅⩗	∖∥⸸⫾	∢⫿∖⫾	⦸⍿◌̇⫯	⦸⫰◌̾⫯	⟍⫿⧹◌͢	⧷ǀ‡∟	♪∤⦚⦙	⧵∣◌̎◌͛	ʻ⫴◌̒⫻	☠◌͂­♪♪	⫮‖⧵⦀	эЭ◊⧫	ѥѤӧӦ
aAæÆ	áÁǽǼ	àÀᶏ♪	âÂɐⱯ	ãÃᴂᴀ	åÅạẠ	ąĄɑⱭ	ăĂǎǍ	āĀǣǢ	ⱥȺꜳꜲ	äÄảẢ	äÄȁȀ	αΑάΆ	؋₳⚤ᴁ	аАәӘ	ꙗꙖӓӒ
sSßẞ	śŚʂ♪	ȿⱾᶊ♪	ŝŜſꜱ	ᵴꜱꞅꞄ	ṡṠṣṢ	şŞșȘ	šŠṧṦ	ʃƩꝭꝬ	ʆ♪ẜ♪	ṩṨṥṤ	ẛ♪ꞩꞨ	σΣς∑	℠₪₷$	сСѕЅ	ҫҪԍԌ
dDðÐ	ɗƊɖƉ	ȡ♪ᶁ♪	♪ᴅ♪ᴆ	ᵭᴅꝺꝹ	ḋḊḍḌ	ḑḐƍ♪	ďĎǆǅ	ƌƋᶑ♪	đĐꝱ♪	ɗƊᶁ♪	ꝩꝨ♪♪	δΔẟ∆	₫₯֏֏	дДђЂ	ӟӞԁԀ
fFèÈ	ƒƑⱷ♪	♪ꟻȅȄ	ⅎℲềỀ	ᵮꟻễỄ	ḟḞệỆ	ɸ♪ꝼꝻ	ᶂꟻḛḚ	ʄǂḕḔ	♪♪ėĖ	ƒƑểỂ	♪♪♪♪	φΦϕ∅	ƒ₣♀⚢	фФѳѲ	ғҒӻӺ
gGýÝ	ǵǴɠƓ	ᶃᴦɠƓ	ĝĜɡɢ	ȝȜᵷ⅁	ġĠᵹꝽ	ģĢɣƔ	ğĞǧǦ	ḡḠʛ♪	ǥǤꞡꞠ	ɠƓᶃ♪	ꞡꞠ♪♪	γΓɣƔ	૱₲৻৻	гГґҐ	ӷӶҕҔ
hHúÚ	ɦꞪűŰ	ʮꞪừỪ	ĥĤƕǶ	ɥʜṹṸ	ḣḢḥḤ	ḩḨḥḤ	ȟȞḫḪ	ɧ♪ȗȖ	ħĦ♪♪	ḧḦǘǗ	ḧḦᴞℍ	ηΗήΉ	₴₴⌂♪	хХһҺ	ҳҲӽӼ
jJíÍ	ʝ♪ᶖ♪	ʝ♪ᶖ♪	ĵĴȷᴊ	ȷᴊ♪♪	ȷ♪ⓙⒿ	ȷ♪℩♪	ǰ♪ǯǮ	ɟ♪ȋȊ	ɉɈɟ♪	♪♪ḯḮ	♪♪ḯḮ	ϊΪΐ♪	ƺ♪ʓ♪	йЙїЇ	ҋ◌ҊӑӐ
kKóÓ	ḱḰőŐ	ƙƘờỜ	ʞᴋốỐ	ⱪⱩṍṌ	ḳḲⓚⓀ	ķĶḳḲ	ǩǨᶄ♪	ȏȎṓṒ	ꝁꝀǿǾ	ꝅꝄƙƘ	ꝃꝂꞣꞢ	κΚϰϗ	₭₭♪♪	кКқҚ	ҡҠҟҞ
lLöÖ	ĺĹɭ⅂	ȴᴧơƠ	ℓʟɮ⅂	ɫⱢṏṎ	ḷḶŀĿ	ļĻỻỺ	ľĽɬᴧ	ƚȽȫȪ	łŁꝉꝈ	ᶅ♪ⱡⱠ	ḹḸȱȰ	λΛ∧⋀	ლ£₤₶	лЛљЉ	ӆӅԓԒ
;:☠¨÷	⸵⧴΅◌⃐	⁏⧴῭◌⃭	⍮∶⁏⦂	⨟∻⨾⟌	♪⫶◌⃝⨸	♪⫶◌⃗⨸	♪♪◌⃞◌⃢	⍮♪◌⃒◌⃓	♪♪♪♪	♪♪◌̈◌⃜	♪♪◌⃑◌⃭	·♪·♪	‵‶‷‱	;:♪♪	ӹӸӳӲ
'"☠´☠˵	◌̸◌́◌́◌⃬	◌᷅◌᷀῞♪	◌͒◌͡◌⃰◌⃰	◌⃙◌⃚◌⃔◌⃔	◌͚∵♪♪	◌⃙∵῎◌⃔	◌᷾◌͐◌̆◌̆	◌⃗◌⃖◌⃦◌⃦	♪♪♪♪	◌᷈◌゙΅♪	◌᷅◌᷀΅◌̀	⁼⁺♪♪	′″‴⁗	∂∇☠◌́〃	◌̀◌̀◌́◌́
zZàÀ	źŹʐ♪	ʑ♪ȁȀ	ẑẐầẦ	ᵶᴢẫẪ	żŻậẬ	ꝣꝢẓẒ	žŽằẰ	ʒƷꜩꜨ	ƶƵȧȦ	ȥȤẩẨ	♪ℤɀⱿ	ζΖϟϞ	əƏǝƎ	зЗєЄ	ҙҘѯѮ
xXéÉ	ᶍ♪ᶒ♪	ᶍ♪ᶒ♪	♪♪ếẾ	♪♪♪♪	ẋẊⓧⓍ	ẋẊ♪♪	ᶍ♪ḝḜ	ʘǁḗḖ	♪♪ɜɝ	ẍẌᶍ♪	ẍẌ♪♪	χΧϡϠ	♪♪♪♪	ьЬъЪ	ӛӚӕӔ
cCçÇ	ćĆḉḈ	ƈƇɕ♪	ĉĈↄᴄ	ꜿꜾↄᴄ	ċĊⓒⒸ	çÇċĊ	čČ♪♪	♪ʗꞓꞒ	ȼȻ♪♪	ƈƇɕ♪	♪ℂ♪♪	ξΞϙϘ	©¢₵₡	цЦџЏ	ҵҴќЌ
vVìÌ	ʋƲᶌ♪	ⱴ♪ȉȈ	ʌɅ♪ᴠ	ṽṼỽỼ	ṿṾⓥⓋ	ṿṾ♪♪	ᶌ♪ḭḬ	ⱱɤꜹꜸ	ꝟꝞ♪İ	ʋƲᶌ♪	ꝟꝞꜻꜺ	ϋΫΰϔ	♪♪♪♪	жЖӂӁ	җҖӝӜ
bBùÙ	ɓƁứỨ	ᶀ♪ȕȔ	♪ʙ♪ᴃ	ữỮᵬᴃ	ựỰḃḂ	ḅḄḃḂ	ᶀ♪ṵṴ	ƃƂ♪♪	ƀɃ♪♪	ửỬǜǛ	♪♪ǜǛ	βΒϐ♪	৳฿₢৲	бБѓЃ	ѹѸꙋꙊ
nNñÑ	ńŃŉ♪	ǹǸƞȠ	♪ɴꞑꞐ	ñÑᵰᴎ	ṅṄṇṆ	ņŅṇṆ	ňŇɲƝ	ŋŊɳⁿ	ꞥꞤꝴ♪	ᶇ♪ȵ♪	♪ℕꞥꞤ	νΝ∨⋁	꠸₦꠷꠷	нНњЊ	ңҢҥҤ
mMòÒ	ḿḾớỚ	ɱⱮȍȌ	ɯƜồỒ	ᵯᴍỗỖ	ṁṀộỘ	ṃṂṁṀ	ᶆꟿ♪ꟽ	ɰ♪ṑṐ	ꝳ♪ȯȮ	ɱⱮổỔ	ꝸ♪♪♪	μΜµ♪	₥ℳ♂⚣	мМ☠µ±	ӎӍꙟꙞ
,<☠¸≤	≾≺⸲≼	≾⊏◌⃭⊑	⍪≪⸲⪡	⸲≲⍪⩽	⊙⊂◌⃝⋖	∘⧀◌̃⊆	◌⃣≨◌᷿⪕	⍪≦◌̙⪍	≴≮⋦≰	≲⋐◌⃜⟃	♪⋐◌⃭⟃	♪♪♪♪	¤⊄¤⊀	,<«♪	⁘⁙ԋԊ
.>☠°≥	≿≻⋄≽	∷⊐⊡⊒	⋮≫◌⃩⪢	⋮≳◌⃕⩾	∘⊃⊙⋗	⊙⧁⊚⊇	⨀≩◌⃣⪖	∸≧◌͉⪎	≵≯⋧≱	≳⋑⋅⟄	♪⋑♪⟄	♪♪♪♪	⫰⊅⫯⊁	…>»♪	·։჻⁖
/?☠◌̸¿	⋌≙◌̉⩼	⧄≚⋌⩻	∕¿⫽≛	∡ʖ⫻⸮	∴≘/≗	∴≗⊘≘	⋯≜⟋≞	∠ʔ⧶ʕ	⫽ʡ⫻ƾ	…≟∕◌̏	⫻˵⫼◌͑	₯;ɂɁ	℅≭¤ʢ	⁄�јЈ	ԛԚꙏꙎ
\|¶❧	ˈ⩗◌̍◌̓	⋋⩘⧅☙	∖∥⁋☙	∢⫿∖⫾	⦸⍿◌̇⫯	⦸⫰◌̾⫯	⟍⫿⧹◌͢	⧷ǀ◌͍∟	♪∤⦚⦙	⧵∣◌̎◌͛	ʻ⫴◌̒⫻	☠◌͂­♪♪	⫮‖⧵⦀	эЭӏӀ	ѥѤ♪♪
. , 	≿ ≾ 	∷ ≾ 	⋮ ⍪ 	⋮ ⸲ 	∘ ⊙ 	⊙ ∘ 	⨀ ◌⃣ 	∸ ⍪ 	≵ ≴ 	≳ ≲ 	♪ ♪ 	♪ ♪ 	⫰ ¤ 	… , 	· ⁘ 
\r\n  	ˀ΄  	ˤʻ  	ꜛʴ  	˷ⸯ  	ʰʲ  	˷ⸯ  	˽˿  	˺‗  	♪♪  	ː˶  	ˤʻ  	↲⤶  	⏎␤  	␍␊  	♪♪  
\b\x7f  	ˈˌ  	♪♪  	˰˪  	♪♪  	ᶣ˳  	♪♪  	ˬ˯  	˻˭  	♪♪  	♪♪  	♪♪  	⎌♪  	⌫⌦  	␈␡  	♪♪  
\t\x1b  	ˊˡ  	ˎʽ  	ʳʵ  	¸ꙿ  	ʱˢ  	¸ꙿ  	˾ˠ  	˼˖  	♪♪  	΅˵  	ˎʽ  	♪⎗  	↹⇤  	␉␛  	♪♪  
\x1c\x1d  	ˌˏ  	˵˴  	ˣʶ  	♪˞  	ᵊʷ  	♪˞  	ꜜʸ  	ˍ˗  	♪♪  	ʺˮ  	˵˴  	⎘♪  	⇥␀  	␜␝  	♪♪  
\x03   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	♪   	␃   	♪   
 ☠ƒ☠Φ☠ 	´ʼʾ♪	ˋʿˁ♪	ˆ˄˟♪	˜˛ͺ♪	°˚˙♪	˜˛ͺ♪	˘ˇ˅♪	¯ˉ˹♪	◌̸♪♪♪	¨˝˸♪	ˋʿˁ♪	µ♪♪♪	£♪♪♪	␠␣␢♪	  ☠◌҃♪
==============
юЮ`~	ѫѪѭѬ	◌ⷻ◌ⷾ♪◌ⷿ	☠Ϣ♪♪♪	¤∼¤≉	`~☠ˋ☠˜	ϼΡϱ♪	ῥῬ♪♪	ῤ♪♪♪	♪♪♪♪
1!¬∁	⅒⅟♪½	ꚑꚐꙩꙨ	₁‐‑♪	⫪⫫≸¤	¹∣¬¡	ᾶ♈ᾷ♪	ἇἏᾇᾏ	ἆἎᾆᾎ	‐☺ͱ◌Ͱ
2@∃∀	½⅔♪⅖	ꙭꙬꙫꙪ	₂–♪♪	⨒¤ƻ⫽	²≈ºª	ῶ♉ῷ♪	ὧὯᾧᾯ	ὦὮᾦᾮ	–☻ƨƧ
3ъ#№	⅓ӕ⅔⅗	҂◌ꙸꙮ♪	₃ϡ♪♪	♪¤⫣⊩	³é√№	͵ῲ΄΅	ʹᾣ♪♪	͵ᾢ♪♪	—ⳁзЗ
4Ъ$☠£	¼Ӕ¾⅘	◌⃝♪ꚉꚈ	₄Ϡ♪♪	▥⋄◫¤	⁴É¢☠£	♪♋♪♪	♪ᾫ♪♪	♪ᾪ♪♪	―ⳀчЧ
5ё%€	⅕ӫ⅖⅝	◌҈ӗꙛꙚ	₅έ꜒꜍	⦶℮∙¤	⁵ê☆¥	♪♌♪♪	♪♪♪♪	♪♪♪♪	˥϶ƽƼ
6Ё^☠◌҃	⅙Ӫ⅚♪	◌҉Ӗ♪◌҃	₆Έ꜓꜎	⩛⩚♪¤	⁶Ê☠ˇ☠ˆ	ῆ♍ῇ♪	ἧἯᾗᾟ	ἦἮᾖᾞ	˦♠ƅƄ
7&◌҆◌҇	⅐⅞◌꙽ꙿ	◌꙰♪ꙅꙄ	₇˧꜔꜏	⨚⨙⋅¤	⁷§·§	ῦ♎ῧ♪	ὗὟ♪♪	ὖ♪♪♪	˧•♪♪
8*„‚	⅛◌҅⅜♪	◌꙱◌꙳ԑԐ	₈˨꜕꜐	≭∗≇¤	⁸⊠„‚	ῖ♏ῗ♪	ἷἿ♪♪	ἶἾ♪♪	˨◘♪♪
9(“‘	⅑♪ҁҀ	◌꙲♪ꙉꙈ	₉˩꜖꜑	♪⋳♪∌	⁹(“‘	♪♐῀῁	♪♪῟♪	♪♪῏♪	˩○♪♪
0)”’	⅒↉◌꙼◌꙾	ꙁꙀꙃꙂ	₀‒♪♪	⦽⋻♪¤	⁰)”’	♪♑♪♪	♪♪♪♪	♪♪♪♪	‒◙♪♪
-_¯—	ҽҼҿҾ	◌꙯♪ҹҸ	₋⁻⁃‾	∓¤¤¤	∓―☠¯—	♪♒♪♪	♪♪♪♪	♪♪♪♪	⸗☼♪♫
чЧ=+	ҷҶӵӴ	◌ⷱ♪ӌӋ	₌₊♪♪	⧧⧺≢⧻	=+☠µ±	♪♓♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
яЯѣѢ	ѧѦѩѨ	♪◌ⷽ◌ⷺ♪	θΘϑϴ	ĸ⌨♪♪	qQäÄ	άΆᾴ♪	ἅἍᾅᾍ	ἄἌᾄᾌ	ⲑⲐϗϏ
вВѵѴ	ꙍꙌԝԜ	◌ⷡ♪ꚍꚌ	ωΩώΏ	₩₩ﬁﬂ	wWáÁ	ώΏῴ♪	ὥὭᾥᾭ	ὤὬᾤᾬ	ⲱⲰ℧Ω
еЕёЁ	өӨӫӪ	◌ⷷ♪ӗӖ	εΕέΈ	€₠℮⩚	eEêÊ	έΈ♌♍	ἕἝ♪Ἧ	ἔἜ♪Ἦ	ⲉⲈ϶♠
рР◌҄®	ѽѼԗԖ	◌ⷬ♪ҏҎ	ρΡϱ∐	®₹₨ℛ	rRåÅ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲣⲢͽϿ
тТћЋ	ҭҬԏԎ	◌ⷮ♪ꚋꚊ	τΤϛϚ	™₸₮௹	tTþÞ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲧⲦⲋⲊ
ыЫіІ	үҮұҰ	◌ꙹ♪ꙑꙐ	ψΨϝϜ	元¥円圓	yYÿŸ	ήΉῄ♪	ἥἭᾕᾝ	ἤἬᾔᾜ	ⲯⲮͼϾ
уУўЎ	ӯӮӱӰ	◌ꙷ♪ꙕꙔ	υΥύΎ	ưƯ元圆	uUüÜ	ύΎΰϓ	ὕὝ♪♪	ὔ♪♪♪	ⲩⲨᵿϒ
иИѷѶ	ӣӢӥӤ	◌ꙵ♪ӊӉ	ιΙίΊ	៛﷼♪♪	iIĳĲ	ίΊΐ♪	ἵἽ♪♪	ἴἼ♪♪	ⲓⲒᵼ♪
оОѡѠ	ѻѺѿѾ	◌ⷪ♪◌ꙻ♪	οΟόΌ	ơƠ℅ɶ	oOœŒ	όΌ´΅	ὅὍ῞♪	ὄὌ῎♪	ⲟⲞͻϽ
пПѱѰ	ԥԤҧҦ	◌ⷫ♪ꚏꚎ	πΠϖ∏	℗₱₰₧	pPøØ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲡⲠⳁⳀ
шШ[{	ԧԦѐЀ	◌ⷲ♪ꚅꚄ	☠◌̔₍⁽♪	〈◄◃◂	[{«‹	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
щЩ]}	ꚇꚆѝЍ	◌ⷳ♪ꚗꚖ	☠◌̓₎⁾♪	〉►▹▸	]}»›	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
эЭ\|	ѥѤӧӦ	♪ꚟӭӬ	☠◌͂­◌͂­	⫮‖⧵⦀	\|†¦	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
аАәӘ	ꙗꙖӓӒ	◌ⷶ◌ⷼԙԘ	αΑάΆ	؋₳⚤ᴁ	aAæÆ	ᾰᾸᾳᾼ	ἁἉᾁᾉ	ἀἈᾀᾈ	ⲁⲀⳉⳈ
сСѕЅ	ҫҪԍԌ	◌ⷭ◌ⷵꚃꚂ	σΣς∑	℠₪₷$	sSßẞ	ᾱᾹῳῼ	ὡὩᾡᾩ	ὠὨᾠᾨ	ⲥⲤϣϢ
дДђЂ	ӟӞԁԀ	◌ⷣ◌ⷸӡӠ	δΔẟ∆	₫₯֏֏	dDðÐ	ϵΕ♪♪	ἑἙ♪♪	ἐἘ♪♪	ⲇⲆϯϮ
фФѳѲ	ғҒӻӺ	♪♪◌ⷴ♪	φΦϕ∅	ƒ₣♀⚢	fFèÈ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲫⲪϥϤ
гГґҐ	ӷӶҕҔ	◌ⷢ♪ӿӾ	γΓɣƔ	૱₲৻৻	gGýÝ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲅⲄͷͶ
хХһҺ	ҳҲӽӼ	◌ⷯ♪ҩҨ	ηΗήΉ	₴₴⌂♪	hHúÚ	ῡῩῃῌ	ἡἩᾑᾙ	ἠἨᾐᾘ	ⲏⲎϩϨ
йЙїЇ	ҋ◌ҊӑӐ	ꙇꙆ◌ꙶ♪	ϊΪΐ♪	ƺ♪ʓ♪	jJíÍ	ῠῨϋΫ	ὑὙ♪♪	ὐ♪♪♪	ϫϪϳ♪
кКқҚ	ҡҠҟҞ	◌ⷦ♪ӄӃ	κΚϰϗ	₭₭♪♪	kKóÓ	ῐῘϊΪ	ἱἹ♪♪	ἰἸ♪♪	ⲕⲔϧϦ
лЛљЉ	ӆӅԓԒ	◌ⷧᴫԉԈ	λΛ∧⋀	ლ£₤₶	lLöÖ	ῑῙͺι	ὁὉ῾♪	ὀὈ᾿᾽	ⲗⲖƛ♪
;:¨÷	ӹӸӳӲ	ҝҜԟԞ	·♪·♪	‵‶‷‱	;:☠¨÷	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
'"☠◌́´	◌̀◌̀◌́◌́	ꚕꚔꚓꚒ	⁼⁺♪♪	′″‴⁗	∂∇☠´☠˵	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
зЗєЄ	ҙҘѯѮ	◌ⷥ♪ꙴ♪	ζΖϟϞ	əƏǝƎ	zZàÀ	ὰᾺᾲ♪	ἃἋᾃᾋ	ἂἊᾂᾊ	ⲍⲌϭϬ
ьЬъЪ	ӛӚӕӔ	◌ꙺ♪◌ꙸ♪	χΧϡϠ	♪♪¤⋄	xXéÉ	ὼῺῲ♋	ὣὫᾣᾫ	ὢὪᾢᾪ	ⲭⲬⳁⳀ
цЦџЏ	ҵҴќЌ	◌ⷰ♪ꙡꙠ	ξΞϙϘ	©¢₵₡	cCçÇ	ὲῈ♪♪	ἓἛ♪♪	ἒἚ♪♪	ⲝⲜϭϬ
жЖӂӁ	җҖӝӜ	◌ⷤ♪ԃԂ	ϋΫΰϔ	♪♪♪♪	vVìÌ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ϥϤϲϹ
бБѓЃ	ѹѸꙋꙊ	◌ⷠ♪♪◌ⷹ	βΒϐ♪	৳฿₢৲	bBùÙ	♪♪♪♪	♪♪♪♪	♪♪♪♪	ⲃⲂϸϷ
нНњЊ	ңҢҥҤ	◌ⷩᵸӈӇ	νΝ∨⋁	꠸₦꠷꠷	nNñÑ	ὴῊῂ♪	ἣἫᾓᾛ	ἢἪᾒᾚ	ⲛⲚͳͲ
мМ☠µ±	ӎӍꙟꙞ	◌ⷨ♪ꙧꙦ	μΜµ♪	₥ℳ♂⚣	mMòÒ	ὺῪῢ♪	ὓὛ♪♪	ὒ♪♪♪	ⲙⲘϻϺ
,<«≤	⁘⁙ԋԊ	ԅԄԇԆ	♪♪♪♪	¤⊄¤⊀	,<☠¸≤	ὶῚῒ♪	ἳἻ♪♪	ἲἺ♪♪	♪♪♪♪
.>»≥	·։჻⁖	ꙙꙘꙝꙜ	♪♪♪♪	⫰⊅⫯⊁	…>☠°≥	ὸῸ`♪	ὃὋ῝♪	ὂὊ῍♪	♪♪♪♪
/?јЈ	ԛԚꙏꙎ	ҍҌꙓꙒ	₯;ɂɁ	℅≭¤ʢ	⁄�☠◌̸¿	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
\|ӏӀ	ӧӦ♪♪	ӭӬ♪♪	◌͂­♪♪	⧵⦀⧵⦀	†¦¶❧	♪♪♪♪	♪♪♪♪	♪♪♪♪	♪♪♪♪
. , 	· ⁘ 	ꙙ ԅ 	♪ ♪ 	⫰ ¤ 	… , 	ὸ ὶ 	ὃ ἳ 	ὂ ἲ 	♪ ♪ 
\r\n  	♪♪  	♪♪  	↲⤶  	⏎␤  	␍␊  	♪♪  	♪♪  	♪♪  	♪♪  
\b\x7f  	♪♪  	♪♪  	⎌♪  	⌫⌦  	␈␡  	♪♪  	♪♪  	♪♪  	♪♪  
\t\x1b  	♪♪  	♪♪  	♪⎗  	↹⇤  	␉␛  	♪♪  	♪♪  	♪♪  	♪♪  
\x1c\x1d  	♪♪  	♪♪  	⎘♪  	⇥␀  	␜␝  	♪♪  	♪♪  	♪♪  	♪♪  
\x03   	♪   	♪   	♪   	♪   	␃   	♪   	♪   	♪   	♪   
 ☠ƒ☠Φ☠ 	◌́♪♪♪	   ♪	µ♪♪♪	£♪♪♪	␠␣␢♪	◌͂♪♪♪	◌̔♪♪♪	◌̓♪♪♪	Ϣ♪♪♪
=================
`~`~	ְ	◌ּ◌ּ◌ּ◌ּ	ּּּּ	ּּּּ	ּּּּ
1111	ֱ	1!◌ֲ◌ֲ	1!ֲֲ	1!ֲֲ	1!ֲֲ
2222	ֲ	2“◌ֳ◌ֳ	2“ֳֳ	2“ֳֳ	2“ֳֳ
3333	ֳ	3#◌ֱ◌ֱ	3#ֱֱ	3#ֱֱ	3#ֱֱ
4444	ִ	4$◌ִ◌ִ	4$ִִ	4$ִִ	4$ִִ
5555	ֵ	5%◌ֵ◌ֵ	5%ֵֵ	5%ֵֵ	5%ֵֵ
6666	ֶ	6”◌ַ◌ַ	6”ַַ	6”ַַ	6”ַַ
7777	ַ	7₪◌ָ◌ָ	7₪ָָ	7₪ָָ	7₪ָָ
8888	ָ	8*◌ֻ◌ֻ	8*ֻֻ	8*ֻֻ	8*ֻֻ
9999	ׂ	9)◌ֶ◌ֶ	9)ֶֶ	9)ֶֶ	9)ֶֶ
0000	ׁ	0(◌ְ◌ְ	0(ְְ	0(ְְ	0(ְְ
-_-_	ֹ	-—+-	-—+-	-—+-	-—+-
=+=+	ּ	=+-+	=+-+	=+-+	=+-+
QQQQ	♪	ק♪♪♪	ק♪♪♪	ק♪♪♪	ק♪♪♪
WWWW	♪	ש¿¿¿	ש¿¿¿	ש¿¿¿	ש¿¿¿
EEEE	♪	ע◌ֵ◌ֶ◌ֱ	עֱֵֶ	עֱֵֶ	עֱֵֶ
RRRR	♪	ר♪◌ָ◌ֳ	ר♪ֳָ	ר♪ֳָ	ר♪ֳָ
TTTT	♪	תט◌ָ◌ֳ	תטֳָ	תטֳָ	תטֳָ
YYYY	♪	טת¿¿	טת¿¿	טת¿¿	טת¿¿
UUUU	♪	ו¿◌ֻ◌ֻ	ו¿ֻֻ	ו¿ֻֻ	ו¿ֻֻ
IIII	♪	י¿◌ִ◌ִ	י¿ִִ	י¿ִִ	י¿ִִ
OOOO	♪	ו¿◌ֹ◌ֹ	ו¿ֹֹ	ו¿ֹֹ	ו¿ֹֹ
PPPP	♪	פף◌ְ◌ְ	פףְְ	פףְְ	פףְְ
[{[{	[	’}]}	’}]}	’}]}	’}]}
]}]}	]	¿{[{	¿{[{	¿{[{	¿{[{
\|\|	ֻ	ֿ-־◌ֿ	ֿ-־ֿ	ֿ-־ֿ	ֿ-־ֿ
AAAA	♪	א◌ָ◌ַ◌ֲ	אֲַָ	אֲַָ	אֲַָ
SSSS	♪	סש¿¿	סש¿¿	סש¿¿	סש¿¿
DDDD	♪	ד„♪♪	ד„♪♪	ד„♪♪	ד„♪♪
FFFF	♪	פף♪♪	פף♪♪	פף♪♪	פף♪♪
GGGG	♪	ג♪♪♪	ג♪♪♪	ג♪♪♪	ג♪♪♪
HHHH	♪	החחח	החחח	החחח	החחח
JJJJ	♪	ח♪◌ִ◌ִ	ח♪ִִ	ח♪ִִ	ח♪ִִ
KKKK	♪	כך♪♪	כך♪♪	כך♪♪	כך♪♪
LLLL	♪	ל¿♪♪	ל¿♪♪	ל¿♪♪	ל¿♪♪
;:;:	;	;:◌ְ◌ְ	;:ְְ	;:ְְ	;:ְְ
'"'"	'	'’’’	'’’’	'’’’	'’’’
ZZZZ	♪	ז♪––	ז♪––	ז♪––	ז♪––
XXXX	♪	כך——	כך——	כך——	כך——
CCCC	♪	צץ“◌֞	צץ“֞	צץ“֞	צץ“֞
VVVV	♪	וב””	וב””	וב””	וב””
BBBB	♪	ב◌ּ‘◌֜	בּ‘֜	בּ‘֜	בּ‘֜
NNNN	♪	נן’’	נן’’	נן’’	נן’’
MMMM	♪	מםםם	מםםם	מםםם	מםםם
,<,<	,	,>’‘	,>’‘	,>’‘	,>’‘
.>.>	.	.<◌ּ…	.<ּ…	.<ּ…	.<ּ…
/?/?	/	//♪♪	/?♪♪	/?♪♪	/?♪♪
\|\|	♪	\|♪♪	\|♪♪	\|♪♪	\|♪♪
SPACESPACESPACESPACE	♪	    	    	    	    
DECIMALDECIMALDECIMALDECIMAL	♪	...,	...,	...,	...,
