/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFontContext;

public class UFont {
    private final Font font;
    private final String family;

    public UFont(String string, int n, int n2) {
        this(new Font(string, n, n2), string);
    }

    private UFont(Font font, String string) {
        this.font = font;
        this.family = string;
    }

    public final Font getFont() {
        return this.font;
    }

    public UFont scaled(double d) {
        if (d == 1.0) {
            return this;
        }
        float f = this.font.getSize2D();
        return this.deriveSize((float)((double)f * d));
    }

    public UFont deriveSize(float f) {
        return new UFont(this.font.deriveFont(f), this.family);
    }

    public UFont deriveStyle(int n) {
        return new UFont(this.font.deriveFont(n), this.family);
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public int getSize() {
        return this.font.getSize();
    }

    public double getSize2D() {
        return this.font.getSize2D();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public String getFamily(UFontContext uFontContext) {
        if (uFontContext == UFontContext.EPS) {
            if (this.family == null) {
                return "Times-Roman";
            }
            return this.font.getPSName();
        }
        if (uFontContext == UFontContext.SVG) {
            if (this.family.equalsIgnoreCase("sansserif")) {
                return "sans-serif";
            }
            return this.family;
        }
        return this.family;
    }

    public String toString() {
        return this.font.toString();
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UFont)) {
            return false;
        }
        return this.font.equals(((UFont)object).font);
    }

    @Deprecated
    public static UFont getCurrentFont(Graphics2D graphics2D) {
        throw new UnsupportedOperationException();
    }

    public LineMetrics getLineMetrics(Graphics2D graphics2D, String string) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return this.font.getLineMetrics(string, fontRenderContext);
    }

    public FontMetrics getFontMetrics() {
        return TextBlockUtils.getFontMetrics(this.getFont());
    }
}

