#============================================================= -*-Perl-*-
#
# Async::Template::Grammar
#
# DESCRIPTION
#   This file based on Template::Grammar ftom Template Toolkit
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
#   This grammar taken ftom Template perl library and modified by Serguei
#   Okladnikov to integrate asynchronous EVENT, ASYNC and AWAIT operators
#
# AUTHORS
#   Andy Wardley   <abw@wardley.org>
#   Serguei Okladnikov <oklaspec@gmail.com> (EVENT/ASYNC/AWAIT and some more)
#
# COPYRIGHT
#   Copyright (C) 1996-2006 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#   Copyright (C) 2012-2017 Serguei Okladnikov
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
# REVISION
#   $Id$
#
# IMPORTANT NOTE
#   This module is constructed from the parser/Grammar.pm.skel file by
#   running the parser/yc script.  You only need to do this if # you
#   have modified the grammar in the parser/Parser.yp file and need #
#   to-recompile it.  See the README in the 'parser' directory for
#   more information (sub-directory of the Template distribution).
#
#========================================================================

package Async::Template::Grammar;

use strict;
use warnings;

our $VERSION  = 0.12;

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
        EVENT ASYNC AWAIT
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.


%CMPOP = qw( 
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);

#    eq eq  # add these lines to the above to 
#    lt lt  # enable the eq, lt and gt operators      
#    gt gt

#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'loopwf' => 53,
			'async_call' => 52,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'template' => 66,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 70,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'event_wrapper' => 30,
			'eventcall' => 31,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 1
		ACTIONS => {
			"\$" => 58,
			'LITERAL' => 97,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'setlist' => 98,
			'item' => 50,
			'assign' => 21,
			'node' => 27,
			'ident' => 96
		}
	},
	{#State 2
		DEFAULT => -19
	},
	{#State 3
		DEFAULT => -111
	},
	{#State 4
		DEFAULT => -192
	},
	{#State 5
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 101,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 6
		DEFAULT => -48
	},
	{#State 7
		ACTIONS => {
			";" => 102
		}
	},
	{#State 8
		DEFAULT => -60
	},
	{#State 9
		DEFAULT => -38
	},
	{#State 10
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 112,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 11
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"]" => 116,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 118,
			'item' => 50,
			'range' => 115,
			'node' => 27,
			'ident' => 99,
			'term' => 117,
			'list' => 114,
			'lterm' => 75
		}
	},
	{#State 12
		ACTIONS => {
			";" => 119
		}
	},
	{#State 13
		DEFAULT => -13
	},
	{#State 14
		ACTIONS => {
			";" => -44
		},
		DEFAULT => -52
	},
	{#State 15
		DEFAULT => -135,
		GOTOS => {
			'@3-1' => 120
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 121
		},
		DEFAULT => -147,
		GOTOS => {
			'blockargs' => 124,
			'metadata' => 123,
			'meta' => 122
		}
	},
	{#State 17
		ACTIONS => {
			'IDENT' => 121
		},
		GOTOS => {
			'metadata' => 125,
			'meta' => 122
		}
	},
	{#State 18
		ACTIONS => {
			'DOT' => 126,
			'ASSIGN' => 127
		},
		DEFAULT => -171
	},
	{#State 19
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 128,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 20
		ACTIONS => {
			'IDENT' => 129
		}
	},
	{#State 21
		DEFAULT => -211
	},
	{#State 22
		DEFAULT => -24
	},
	{#State 23
		DEFAULT => -36
	},
	{#State 24
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 130,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'loopvar' => 132,
			'node' => 27,
			'ident' => 99,
			'term' => 131,
			'lterm' => 75
		}
	},
	{#State 25
		DEFAULT => -140
	},
	{#State 26
		DEFAULT => -63
	},
	{#State 27
		DEFAULT => -189
	},
	{#State 28
		DEFAULT => -30
	},
	{#State 29
		ACTIONS => {
			"\"" => 139,
			"\$" => 136,
			'LITERAL' => 138,
			'FILENAME' => 105,
			'IDENT' => 133,
			'NUMBER' => 106,
			"\${" => 47
		},
		GOTOS => {
			'names' => 113,
			'lvalue' => 134,
			'item' => 135,
			'name' => 104,
			'filepart' => 109,
			'filename' => 107,
			'nameargs' => 140,
			'lnameargs' => 137
		}
	},
	{#State 30
		DEFAULT => -21
	},
	{#State 31
		DEFAULT => -23
	},
	{#State 32
		DEFAULT => -175
	},
	{#State 33
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 141
		}
	},
	{#State 34
		DEFAULT => -16
	},
	{#State 35
		ACTIONS => {
			'LITERAL' => 146,
			'FILENAME' => 105,
			'IDENT' => 142,
			'NUMBER' => 106
		},
		DEFAULT => -147,
		GOTOS => {
			'blockargs' => 145,
			'filepart' => 109,
			'filename' => 144,
			'blockname' => 143,
			'metadata' => 123,
			'meta' => 122
		}
	},
	{#State 36
		DEFAULT => -65
	},
	{#State 37
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 147
		}
	},
	{#State 38
		ACTIONS => {
			"\$" => 58,
			'LITERAL' => 152,
			'IDENT' => 4,
			"\${" => 47
		},
		DEFAULT => -181,
		GOTOS => {
			'params' => 151,
			'hash' => 148,
			'item' => 149,
			'param' => 150
		}
	},
	{#State 39
		DEFAULT => -50
	},
	{#State 40
		ACTIONS => {
			"\"" => 139,
			"\$" => 136,
			'LITERAL' => 138,
			'FILENAME' => 105,
			'IDENT' => 133,
			'NUMBER' => 106,
			"\${" => 47
		},
		GOTOS => {
			'names' => 113,
			'lvalue' => 134,
			'item' => 135,
			'name' => 104,
			'filepart' => 109,
			'filename' => 107,
			'nameargs' => 140,
			'lnameargs' => 153
		}
	},
	{#State 41
		ACTIONS => {
			";" => 156,
			'IF' => 155,
			'UNLESS' => 154
		}
	},
	{#State 42
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -8,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 157,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 158,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 43
		DEFAULT => -49
	},
	{#State 44
		DEFAULT => -47
	},
	{#State 45
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 159,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 46
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 160
		}
	},
	{#State 47
		ACTIONS => {
			"\"" => 82,
			"\$" => 58,
			'LITERAL' => 100,
			'IDENT' => 4,
			'REF' => 33,
			'NUMBER' => 32,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 161,
			'item' => 50,
			'node' => 27,
			'ident' => 99
		}
	},
	{#State 48
		ACTIONS => {
			";" => 162
		}
	},
	{#State 49
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 163,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 50
		ACTIONS => {
			"(" => 164
		},
		DEFAULT => -190
	},
	{#State 51
		ACTIONS => {
			";" => 165
		}
	},
	{#State 52
		DEFAULT => -45
	},
	{#State 53
		DEFAULT => -110
	},
	{#State 54
		DEFAULT => -14
	},
	{#State 55
		DEFAULT => -61
	},
	{#State 56
		DEFAULT => -139
	},
	{#State 57
		DEFAULT => -35
	},
	{#State 58
		ACTIONS => {
			'IDENT' => 166
		}
	},
	{#State 59
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 167,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 60
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 168,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 61
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 169,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 62
		ACTIONS => {
			'IF' => 173,
			'FILTER' => 172,
			'FOR' => 171,
			'WHILE' => 175,
			'WRAPPER' => 174,
			'UNLESS' => 170
		}
	},
	{#State 63
		DEFAULT => -62
	},
	{#State 64
		DEFAULT => -34
	},
	{#State 65
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 176,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 66
		ACTIONS => {
			'' => 177
		}
	},
	{#State 67
		DEFAULT => -20
	},
	{#State 68
		ACTIONS => {
			";" => 178
		}
	},
	{#State 69
		DEFAULT => -7
	},
	{#State 70
		DEFAULT => -1
	},
	{#State 71
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 78,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 179,
			'term' => 80,
			'expr' => 181,
			'assign' => 180,
			'lterm' => 75
		}
	},
	{#State 72
		DEFAULT => -18
	},
	{#State 73
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 182,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 74
		DEFAULT => -17
	},
	{#State 75
		DEFAULT => -165
	},
	{#State 76
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 183,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 77
		DEFAULT => -15
	},
	{#State 78
		ACTIONS => {
			'ASSIGN' => 184
		},
		DEFAULT => -174
	},
	{#State 79
		ACTIONS => {
			'END' => 185
		},
		DEFAULT => -5
	},
	{#State 80
		DEFAULT => -208
	},
	{#State 81
		DEFAULT => -39
	},
	{#State 82
		DEFAULT => -238,
		GOTOS => {
			'quoted' => 186
		}
	},
	{#State 83
		ACTIONS => {
			";" => -40,
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -51
	},
	{#State 84
		DEFAULT => -37
	},
	{#State 85
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 197,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 86
		DEFAULT => -59
	},
	{#State 87
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 198,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 88
		DEFAULT => -33
	},
	{#State 89
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 199,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 90
		DEFAULT => -166
	},
	{#State 91
		ACTIONS => {
			"\$" => 58,
			'LITERAL' => 97,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'setlist' => 200,
			'item' => 50,
			'assign' => 21,
			'node' => 27,
			'ident' => 96
		}
	},
	{#State 92
		ACTIONS => {
			'END' => 201
		},
		DEFAULT => -4
	},
	{#State 93
		ACTIONS => {
			"\$" => 58,
			'COMMA' => 203,
			'LITERAL' => 97,
			'IDENT' => 4,
			"\${" => 47
		},
		DEFAULT => -43,
		GOTOS => {
			'item' => 50,
			'assign' => 202,
			'node' => 27,
			'ident' => 96
		}
	},
	{#State 94
		DEFAULT => -32
	},
	{#State 95
		DEFAULT => -46
	},
	{#State 96
		ACTIONS => {
			'ASSIGN' => 204,
			'DOT' => 126
		}
	},
	{#State 97
		ACTIONS => {
			'ASSIGN' => 184
		}
	},
	{#State 98
		ACTIONS => {
			'COMMA' => 203,
			'LITERAL' => 97,
			'IDENT' => 4,
			"\$" => 58,
			"\${" => 47
		},
		DEFAULT => -55,
		GOTOS => {
			'item' => 50,
			'assign' => 202,
			'node' => 27,
			'ident' => 96
		}
	},
	{#State 99
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -171
	},
	{#State 100
		DEFAULT => -174
	},
	{#State 101
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 205,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 102
		DEFAULT => -31
	},
	{#State 103
		DEFAULT => -235
	},
	{#State 104
		DEFAULT => -228
	},
	{#State 105
		DEFAULT => -234
	},
	{#State 106
		DEFAULT => -236
	},
	{#State 107
		ACTIONS => {
			'DOT' => 206
		},
		DEFAULT => -230
	},
	{#State 108
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 207
		}
	},
	{#State 109
		DEFAULT => -233
	},
	{#State 110
		DEFAULT => -231
	},
	{#State 111
		DEFAULT => -238,
		GOTOS => {
			'quoted' => 208
		}
	},
	{#State 112
		DEFAULT => -58
	},
	{#State 113
		ACTIONS => {
			"(" => 210,
			"+" => 209
		},
		DEFAULT => -218,
		GOTOS => {
			'args' => 211
		}
	},
	{#State 114
		ACTIONS => {
			"{" => 38,
			'COMMA' => 214,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"]" => 212,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 213,
			'lterm' => 75
		}
	},
	{#State 115
		ACTIONS => {
			"]" => 215
		}
	},
	{#State 116
		DEFAULT => -169
	},
	{#State 117
		DEFAULT => -178
	},
	{#State 118
		ACTIONS => {
			'TO' => 216
		},
		DEFAULT => -166
	},
	{#State 119
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 225,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 120
		ACTIONS => {
			";" => 226
		}
	},
	{#State 121
		ACTIONS => {
			'ASSIGN' => 227
		}
	},
	{#State 122
		DEFAULT => -161
	},
	{#State 123
		ACTIONS => {
			'COMMA' => 229,
			'IDENT' => 121
		},
		DEFAULT => -146,
		GOTOS => {
			'meta' => 228
		}
	},
	{#State 124
		ACTIONS => {
			";" => 230
		}
	},
	{#State 125
		ACTIONS => {
			'COMMA' => 229,
			'IDENT' => 121
		},
		DEFAULT => -41,
		GOTOS => {
			'meta' => 228
		}
	},
	{#State 126
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			'NUMBER' => 232,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 231
		}
	},
	{#State 127
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'ASYNC' => 237,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			"(" => 71,
			'SWITCH' => 224,
			'FOR' => 24,
			'NEXT' => 26,
			'LITERAL' => 78,
			"\"" => 82,
			'FILTER' => 29,
			'RETURN' => 86,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 234,
			'AWAIT' => 236,
			'DEFAULT' => 91,
			"{" => 38,
			"\${" => 47
		},
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'node' => 27,
			'term' => 80,
			'loop' => 6,
			'expr' => 239,
			'atomexpr' => 222,
			'atomdir' => 14,
			'mdir' => 235,
			'sterm' => 90,
			'filter' => 36,
			'loopwhilevar' => 223,
			'ident' => 233,
			'perl' => 39,
			'setlist' => 93,
			'try' => 43,
			'switch' => 44,
			'assign' => 21,
			'directive' => 240,
			'mdir_ev' => 238,
			'condition' => 95,
			'lterm' => 75
		}
	},
	{#State 128
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 241,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 129
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			"(" => 244,
			'SWITCH' => 224,
			'FOR' => 24,
			'NEXT' => 26,
			'LITERAL' => 78,
			"\"" => 82,
			'FILTER' => 29,
			'RETURN' => 86,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 242,
			"{" => 38,
			'DEFAULT' => 91,
			"\${" => 47
		},
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'node' => 27,
			'term' => 80,
			'loop' => 6,
			'expr' => 245,
			'atomexpr' => 222,
			'atomdir' => 14,
			'mdir' => 243,
			'sterm' => 90,
			'filter' => 36,
			'loopwhilevar' => 223,
			'ident' => 233,
			'perl' => 39,
			'setlist' => 93,
			'try' => 43,
			'switch' => 44,
			'assign' => 21,
			'directive' => 240,
			'condition' => 95,
			'lterm' => 75
		}
	},
	{#State 130
		ACTIONS => {
			'IN' => 247,
			'ASSIGN' => 246
		},
		DEFAULT => -192
	},
	{#State 131
		DEFAULT => -218,
		GOTOS => {
			'args' => 248
		}
	},
	{#State 132
		DEFAULT => -116
	},
	{#State 133
		ACTIONS => {
			'ASSIGN' => -192
		},
		DEFAULT => -235
	},
	{#State 134
		ACTIONS => {
			'ASSIGN' => 249
		}
	},
	{#State 135
		DEFAULT => -221
	},
	{#State 136
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 250,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 207
		}
	},
	{#State 137
		ACTIONS => {
			";" => 251
		}
	},
	{#State 138
		ACTIONS => {
			'ASSIGN' => -223
		},
		DEFAULT => -231
	},
	{#State 139
		DEFAULT => -238,
		GOTOS => {
			'quoted' => 252
		}
	},
	{#State 140
		DEFAULT => -220
	},
	{#State 141
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -172
	},
	{#State 142
		ACTIONS => {
			'ASSIGN' => 227
		},
		DEFAULT => -235
	},
	{#State 143
		DEFAULT => -143
	},
	{#State 144
		ACTIONS => {
			'DOT' => 206
		},
		DEFAULT => -144
	},
	{#State 145
		ACTIONS => {
			";" => 253
		}
	},
	{#State 146
		DEFAULT => -145
	},
	{#State 147
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -27
	},
	{#State 148
		ACTIONS => {
			"}" => 254
		}
	},
	{#State 149
		ACTIONS => {
			'ASSIGN' => 255
		}
	},
	{#State 150
		DEFAULT => -184
	},
	{#State 151
		ACTIONS => {
			"\$" => 58,
			'COMMA' => 257,
			'LITERAL' => 152,
			'IDENT' => 4,
			"\${" => 47
		},
		DEFAULT => -180,
		GOTOS => {
			'item' => 149,
			'param' => 256
		}
	},
	{#State 152
		ACTIONS => {
			'ASSIGN' => 258
		}
	},
	{#State 153
		DEFAULT => -130
	},
	{#State 154
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 259,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 155
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 260,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 156
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 261,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 157
		DEFAULT => -12
	},
	{#State 158
		DEFAULT => -6
	},
	{#State 159
		ACTIONS => {
			";" => 262
		}
	},
	{#State 160
		ACTIONS => {
			'ASSIGN' => 263,
			'DOT' => 126
		},
		DEFAULT => -25
	},
	{#State 161
		ACTIONS => {
			"}" => 264
		}
	},
	{#State 162
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 266,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 267,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 163
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'BINOP' => 191,
			'CAT' => 193,
			'CMPOP' => 194,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -204
	},
	{#State 164
		DEFAULT => -218,
		GOTOS => {
			'args' => 268
		}
	},
	{#State 165
		DEFAULT => -133,
		GOTOS => {
			'@2-2' => 269
		}
	},
	{#State 166
		DEFAULT => -194
	},
	{#State 167
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 270,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 168
		ACTIONS => {
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -54
	},
	{#State 169
		ACTIONS => {
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -53
	},
	{#State 170
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 271,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 171
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 130,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'loopvar' => 272,
			'node' => 27,
			'ident' => 99,
			'term' => 131,
			'lterm' => 75
		}
	},
	{#State 172
		ACTIONS => {
			"\"" => 139,
			"\$" => 136,
			'LITERAL' => 138,
			'FILENAME' => 105,
			'IDENT' => 133,
			'NUMBER' => 106,
			"\${" => 47
		},
		GOTOS => {
			'names' => 113,
			'lvalue' => 134,
			'item' => 135,
			'name' => 104,
			'filepart' => 109,
			'filename' => 107,
			'nameargs' => 140,
			'lnameargs' => 273
		}
	},
	{#State 173
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 274,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 174
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 275,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 175
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 276,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 176
		DEFAULT => -64
	},
	{#State 177
		DEFAULT => 0
	},
	{#State 178
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 277,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 278,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 179
		ACTIONS => {
			'DOT' => 126,
			'ASSIGN' => 204
		},
		DEFAULT => -171
	},
	{#State 180
		ACTIONS => {
			")" => 279
		}
	},
	{#State 181
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			")" => 280,
			'OR' => 192
		}
	},
	{#State 182
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 281,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 183
		ACTIONS => {
			";" => 282
		}
	},
	{#State 184
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 283,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 185
		DEFAULT => -3
	},
	{#State 186
		ACTIONS => {
			"\"" => 288,
			'TEXT' => 285,
			";" => 287,
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 284,
			'quotable' => 286
		}
	},
	{#State 187
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 289,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 188
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 290,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 189
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 291,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 190
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 292,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 191
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 293,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 192
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 294,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 193
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 295,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 194
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 296,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 195
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 297,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 196
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 298,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 197
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 299,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 198
		DEFAULT => -57
	},
	{#State 199
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -117
	},
	{#State 200
		ACTIONS => {
			'COMMA' => 203,
			'LITERAL' => 97,
			'IDENT' => 4,
			"\$" => 58,
			"\${" => 47
		},
		DEFAULT => -56,
		GOTOS => {
			'item' => 50,
			'assign' => 202,
			'node' => 27,
			'ident' => 96
		}
	},
	{#State 201
		DEFAULT => -2
	},
	{#State 202
		DEFAULT => -209
	},
	{#State 203
		DEFAULT => -210
	},
	{#State 204
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 300,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 205
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 301,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 302,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 206
		ACTIONS => {
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 303
		}
	},
	{#State 207
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -218,
		GOTOS => {
			'args' => 304
		}
	},
	{#State 208
		ACTIONS => {
			"\"" => 305,
			'TEXT' => 285,
			";" => 287,
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 284,
			'quotable' => 286
		}
	},
	{#State 209
		ACTIONS => {
			"\"" => 111,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'filename' => 107,
			'name' => 306
		}
	},
	{#State 210
		DEFAULT => -218,
		GOTOS => {
			'args' => 307
		}
	},
	{#State 211
		ACTIONS => {
			'NOT' => 49,
			'IDENT' => 4,
			"\$" => 58,
			"[" => 11,
			"(" => 71,
			'LITERAL' => 311,
			"\"" => 82,
			'REF' => 33,
			'NUMBER' => 32,
			"{" => 38,
			'COMMA' => 313,
			"\${" => 47
		},
		DEFAULT => -225,
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 212
		DEFAULT => -167
	},
	{#State 213
		DEFAULT => -176
	},
	{#State 214
		DEFAULT => -177
	},
	{#State 215
		DEFAULT => -168
	},
	{#State 216
		ACTIONS => {
			"\"" => 82,
			"\$" => 58,
			'LITERAL' => 100,
			'IDENT' => 4,
			'REF' => 33,
			'NUMBER' => 32,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 314,
			'item' => 50,
			'node' => 27,
			'ident' => 99
		}
	},
	{#State 217
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 315,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 218
		ACTIONS => {
			'DOT' => 126,
			'ASSIGN' => 316
		},
		DEFAULT => -171
	},
	{#State 219
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -10,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 157,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'filter' => 36,
			'sterm' => 90,
			'perl' => 39,
			'setlist' => 93,
			'switch' => 44,
			'try' => 43,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 220
		ACTIONS => {
			";" => 317
		}
	},
	{#State 221
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 318,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 222
		ACTIONS => {
			'IF' => 173,
			'FILTER' => 172,
			'FOR' => 171,
			'WHILE' => 175,
			'UNLESS' => 170
		}
	},
	{#State 223
		ACTIONS => {
			";" => 319
		}
	},
	{#State 224
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 320,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 225
		ACTIONS => {
			'FINAL' => 321,
			'CATCH' => 323
		},
		DEFAULT => -129,
		GOTOS => {
			'final' => 322
		}
	},
	{#State 226
		ACTIONS => {
			'TEXT' => 324
		}
	},
	{#State 227
		ACTIONS => {
			"\"" => 327,
			'LITERAL' => 326,
			'NUMBER' => 325
		}
	},
	{#State 228
		DEFAULT => -159
	},
	{#State 229
		DEFAULT => -160
	},
	{#State 230
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 328,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 329,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 231
		DEFAULT => -187
	},
	{#State 232
		DEFAULT => -188
	},
	{#State 233
		ACTIONS => {
			'DOT' => 126,
			'ASSIGN' => 330
		},
		DEFAULT => -171
	},
	{#State 234
		ACTIONS => {
			";" => 331
		}
	},
	{#State 235
		DEFAULT => -150
	},
	{#State 236
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 332
		}
	},
	{#State 237
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 333
		}
	},
	{#State 238
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 334,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 239
		ACTIONS => {
			'FOR' => -51,
			"+" => 187,
			'UNLESS' => -51,
			'CAT' => 193,
			'IF' => -51,
			'FILTER' => -51,
			'WHILE' => -51,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -212
	},
	{#State 240
		DEFAULT => -154
	},
	{#State 241
		DEFAULT => -66
	},
	{#State 242
		ACTIONS => {
			";" => 335
		}
	},
	{#State 243
		DEFAULT => -152
	},
	{#State 244
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 78,
			'IDENT' => 336,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'margs' => 337,
			'node' => 27,
			'ident' => 179,
			'term' => 80,
			'expr' => 181,
			'assign' => 180,
			'lterm' => 75
		}
	},
	{#State 245
		ACTIONS => {
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -51
	},
	{#State 246
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 338,
			'lterm' => 75
		}
	},
	{#State 247
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 339,
			'lterm' => 75
		}
	},
	{#State 248
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'COMMA' => 313,
			'LITERAL' => 311,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		DEFAULT => -120,
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 249
		ACTIONS => {
			"\"" => 111,
			"\$" => 108,
			'LITERAL' => 110,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'names' => 113,
			'nameargs' => 340,
			'filename' => 107,
			'name' => 104
		}
	},
	{#State 250
		ACTIONS => {
			'ASSIGN' => -194
		},
		DEFAULT => -192
	},
	{#State 251
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 341,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 252
		ACTIONS => {
			"\"" => 342,
			'TEXT' => 285,
			";" => 287,
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 284,
			'quotable' => 286
		}
	},
	{#State 253
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 343,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 254
		DEFAULT => -170
	},
	{#State 255
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 344,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 256
		DEFAULT => -182
	},
	{#State 257
		DEFAULT => -183
	},
	{#State 258
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 345,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 259
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 346,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 260
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 347,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 261
		DEFAULT => -22
	},
	{#State 262
		DEFAULT => -131,
		GOTOS => {
			'@1-3' => 348
		}
	},
	{#State 263
		ACTIONS => {
			"\$" => 58,
			'IDENT' => 4,
			"\${" => 47
		},
		GOTOS => {
			'item' => 50,
			'node' => 27,
			'ident' => 349
		}
	},
	{#State 264
		DEFAULT => -193
	},
	{#State 265
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -10,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 157,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 158,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 266
		ACTIONS => {
			'END' => 350
		}
	},
	{#State 267
		ACTIONS => {
			'END' => 351
		}
	},
	{#State 268
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'COMMA' => 313,
			'LITERAL' => 311,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			")" => 352,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 269
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 353,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 270
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 354,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 355,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 271
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -77
	},
	{#State 272
		DEFAULT => -112
	},
	{#State 273
		DEFAULT => -138
	},
	{#State 274
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -75
	},
	{#State 275
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 356,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 276
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -113
	},
	{#State 277
		ACTIONS => {
			'END' => 357
		}
	},
	{#State 278
		ACTIONS => {
			'END' => 358
		}
	},
	{#State 279
		DEFAULT => -206
	},
	{#State 280
		DEFAULT => -207
	},
	{#State 281
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 359,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 282
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 360,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 361,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 283
		ACTIONS => {
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -213
	},
	{#State 284
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -239
	},
	{#State 285
		DEFAULT => -240
	},
	{#State 286
		DEFAULT => -237
	},
	{#State 287
		DEFAULT => -241
	},
	{#State 288
		DEFAULT => -173
	},
	{#State 289
		ACTIONS => {
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -197
	},
	{#State 290
		ACTIONS => {
			":" => 362,
			'CMPOP' => 194,
			"?" => 188,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 291
		ACTIONS => {
			'MOD' => 195
		},
		DEFAULT => -198
	},
	{#State 292
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'BINOP' => 191,
			'CAT' => 193,
			'CMPOP' => 194,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -202
	},
	{#State 293
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -195
	},
	{#State 294
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'BINOP' => 191,
			'CAT' => 193,
			'CMPOP' => 194,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -203
	},
	{#State 295
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'BINOP' => 191,
			'CMPOP' => 194,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -201
	},
	{#State 296
		ACTIONS => {
			"+" => 187,
			'DIV' => 189,
			'BINOP' => 191,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -200
	},
	{#State 297
		DEFAULT => -199
	},
	{#State 298
		ACTIONS => {
			'DIV' => 189,
			'MOD' => 195
		},
		DEFAULT => -196
	},
	{#State 299
		DEFAULT => -67
	},
	{#State 300
		ACTIONS => {
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'DIV' => 189,
			'MOD' => 195,
			"/" => 196,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192
		},
		DEFAULT => -212
	},
	{#State 301
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 366,
			'event_evnev_else' => 364,
			'else' => 365
		}
	},
	{#State 302
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 369,
			'else' => 368
		}
	},
	{#State 303
		DEFAULT => -232
	},
	{#State 304
		ACTIONS => {
			'NOT' => 49,
			'IDENT' => 4,
			"\$" => 58,
			"[" => 11,
			"(" => 71,
			'LITERAL' => 311,
			"\"" => 82,
			'REF' => 33,
			'NUMBER' => 32,
			"{" => 38,
			'COMMA' => 313,
			"\${" => 47
		},
		DEFAULT => -224,
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 305
		DEFAULT => -229
	},
	{#State 306
		DEFAULT => -227
	},
	{#State 307
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'COMMA' => 313,
			'LITERAL' => 311,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			")" => 370,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 308
		ACTIONS => {
			'DOT' => 126,
			'ASSIGN' => 371
		},
		DEFAULT => -171
	},
	{#State 309
		ACTIONS => {
			"(" => 164,
			'ASSIGN' => 255
		},
		DEFAULT => -190
	},
	{#State 310
		DEFAULT => -215
	},
	{#State 311
		ACTIONS => {
			'ASSIGN' => 258
		},
		DEFAULT => -174
	},
	{#State 312
		ACTIONS => {
			'DIV' => 189,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192,
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -214
	},
	{#State 313
		DEFAULT => -217
	},
	{#State 314
		DEFAULT => -179
	},
	{#State 315
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 372,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 316
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'ASYNC' => 237,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			"(" => 71,
			'SWITCH' => 224,
			'FOR' => 24,
			'NEXT' => 26,
			'LITERAL' => 78,
			"\"" => 82,
			'FILTER' => 29,
			'RETURN' => 86,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 242,
			'DEFAULT' => 91,
			"{" => 38,
			"\${" => 47
		},
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'node' => 27,
			'term' => 80,
			'loop' => 6,
			'expr' => 239,
			'atomexpr' => 222,
			'atomdir' => 14,
			'mdir' => 235,
			'sterm' => 90,
			'filter' => 36,
			'loopwhilevar' => 223,
			'ident' => 233,
			'perl' => 39,
			'setlist' => 93,
			'try' => 43,
			'switch' => 44,
			'assign' => 21,
			'directive' => 240,
			'condition' => 95,
			'lterm' => 75
		}
	},
	{#State 317
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 267,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 318
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 373,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 319
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 278,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 320
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 374,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 321
		ACTIONS => {
			";" => 375
		}
	},
	{#State 322
		ACTIONS => {
			'END' => 376
		}
	},
	{#State 323
		ACTIONS => {
			";" => 378,
			'DEFAULT' => 379,
			'FILENAME' => 105,
			'IDENT' => 103,
			'NUMBER' => 106
		},
		GOTOS => {
			'filepart' => 109,
			'filename' => 377
		}
	},
	{#State 324
		ACTIONS => {
			'END' => 380
		}
	},
	{#State 325
		DEFAULT => -164
	},
	{#State 326
		DEFAULT => -162
	},
	{#State 327
		ACTIONS => {
			'TEXT' => 381
		}
	},
	{#State 328
		ACTIONS => {
			'END' => 382
		}
	},
	{#State 329
		ACTIONS => {
			'END' => 383
		}
	},
	{#State 330
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			'ASYNC' => 237,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 300,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 331
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 384,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 385,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 332
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -28
	},
	{#State 333
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -29
	},
	{#State 334
		DEFAULT => -149
	},
	{#State 335
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 385,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 336
		ACTIONS => {
			'IDENT' => -158,
			")" => -158,
			'COMMA' => -158
		},
		DEFAULT => -192
	},
	{#State 337
		ACTIONS => {
			'COMMA' => 388,
			'IDENT' => 386,
			")" => 387
		}
	},
	{#State 338
		DEFAULT => -218,
		GOTOS => {
			'args' => 389
		}
	},
	{#State 339
		DEFAULT => -218,
		GOTOS => {
			'args' => 390
		}
	},
	{#State 340
		DEFAULT => -219
	},
	{#State 341
		ACTIONS => {
			'END' => 391
		}
	},
	{#State 342
		ACTIONS => {
			'ASSIGN' => -222
		},
		DEFAULT => -229
	},
	{#State 343
		ACTIONS => {
			'END' => 392
		}
	},
	{#State 344
		ACTIONS => {
			'DIV' => 189,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192,
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -186
	},
	{#State 345
		ACTIONS => {
			'DIV' => 189,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192,
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -185
	},
	{#State 346
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 393,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 347
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 394,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 348
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 395,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 349
		ACTIONS => {
			'DOT' => 126
		},
		DEFAULT => -26
	},
	{#State 350
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 396,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 351
		DEFAULT => -114
	},
	{#State 352
		DEFAULT => -191
	},
	{#State 353
		ACTIONS => {
			'END' => 397
		}
	},
	{#State 354
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 366,
			'event_evnev_else' => 398,
			'else' => 365
		}
	},
	{#State 355
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 400,
			'else' => 399
		}
	},
	{#State 356
		DEFAULT => -123
	},
	{#State 357
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 401,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 358
		DEFAULT => -115
	},
	{#State 359
		ACTIONS => {
			'CASE' => 403
		},
		GOTOS => {
			'caselst' => 402,
			'onecase' => 408,
			'eventcaselst' => 407,
			'eventcase' => 409,
			'case' => 406,
			'eventdefcase' => 405,
			'eventonecase' => 404
		}
	},
	{#State 360
		ACTIONS => {
			'END' => 410
		}
	},
	{#State 361
		ACTIONS => {
			'END' => 411
		}
	},
	{#State 362
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 412,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 363
		ACTIONS => {
			";" => 413
		}
	},
	{#State 364
		ACTIONS => {
			'END' => 414
		}
	},
	{#State 365
		DEFAULT => -78
	},
	{#State 366
		DEFAULT => -79
	},
	{#State 367
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 415,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 368
		ACTIONS => {
			'END' => 416
		}
	},
	{#State 369
		ACTIONS => {
			'END' => 417
		}
	},
	{#State 370
		DEFAULT => -226
	},
	{#State 371
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 418,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 372
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 419,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 373
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 420,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 374
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 421,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 375
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 422,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 376
		DEFAULT => -124
	},
	{#State 377
		ACTIONS => {
			'DOT' => 206,
			";" => 423
		}
	},
	{#State 378
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 424,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 379
		ACTIONS => {
			";" => 425
		}
	},
	{#State 380
		DEFAULT => -136
	},
	{#State 381
		ACTIONS => {
			"\"" => 426
		}
	},
	{#State 382
		DEFAULT => -141
	},
	{#State 383
		DEFAULT => -142
	},
	{#State 384
		ACTIONS => {
			'END' => 427
		}
	},
	{#State 385
		ACTIONS => {
			'END' => 428
		}
	},
	{#State 386
		DEFAULT => -156
	},
	{#State 387
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			"(" => 71,
			'SWITCH' => 224,
			'FOR' => 24,
			'NEXT' => 26,
			'LITERAL' => 78,
			"\"" => 82,
			'FILTER' => 29,
			'RETURN' => 86,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 242,
			"{" => 38,
			'DEFAULT' => 91,
			"\${" => 47
		},
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'node' => 27,
			'term' => 80,
			'loop' => 6,
			'expr' => 245,
			'atomexpr' => 222,
			'atomdir' => 14,
			'mdir' => 429,
			'sterm' => 90,
			'filter' => 36,
			'loopwhilevar' => 223,
			'ident' => 233,
			'perl' => 39,
			'setlist' => 93,
			'try' => 43,
			'switch' => 44,
			'assign' => 21,
			'directive' => 240,
			'condition' => 95,
			'lterm' => 75
		}
	},
	{#State 388
		DEFAULT => -157
	},
	{#State 389
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'COMMA' => 313,
			'LITERAL' => 311,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		DEFAULT => -118,
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 390
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'COMMA' => 313,
			'LITERAL' => 311,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		DEFAULT => -119,
		GOTOS => {
			'sterm' => 90,
			'item' => 309,
			'node' => 27,
			'ident' => 308,
			'term' => 80,
			'expr' => 312,
			'param' => 310,
			'lterm' => 75
		}
	},
	{#State 391
		DEFAULT => -137
	},
	{#State 392
		DEFAULT => -148
	},
	{#State 393
		DEFAULT => -73
	},
	{#State 394
		DEFAULT => -72
	},
	{#State 395
		ACTIONS => {
			'END' => 430
		}
	},
	{#State 396
		DEFAULT => -109
	},
	{#State 397
		DEFAULT => -134
	},
	{#State 398
		ACTIONS => {
			'END' => 431
		}
	},
	{#State 399
		ACTIONS => {
			'END' => 432
		}
	},
	{#State 400
		ACTIONS => {
			'END' => 433
		}
	},
	{#State 401
		DEFAULT => -108
	},
	{#State 402
		ACTIONS => {
			'CASE' => 434
		},
		DEFAULT => -99,
		GOTOS => {
			'onecase' => 438,
			'defcase' => 437,
			'eventdefcase' => 436,
			'eventonecase' => 435
		}
	},
	{#State 403
		ACTIONS => {
			";" => 439,
			'DEFAULT' => 441,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 440,
			'lterm' => 75
		}
	},
	{#State 404
		DEFAULT => -96
	},
	{#State 405
		DEFAULT => -97
	},
	{#State 406
		ACTIONS => {
			'END' => 442
		}
	},
	{#State 407
		ACTIONS => {
			'CASE' => 434
		},
		DEFAULT => -89,
		GOTOS => {
			'onecase' => 446,
			'defcase' => 445,
			'eventdefcase' => 444,
			'eventonecase' => 443
		}
	},
	{#State 408
		DEFAULT => -101
	},
	{#State 409
		ACTIONS => {
			'END' => 447
		}
	},
	{#State 410
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 448,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 411
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 449,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 412
		ACTIONS => {
			"+" => 187,
			"?" => 188,
			'DIV' => 189,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192,
			'CAT' => 193,
			'CMPOP' => 194,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -205
	},
	{#State 413
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 450,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 451,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 414
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 452,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 415
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 453,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 416
		DEFAULT => -76
	},
	{#State 417
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 454,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 418
		ACTIONS => {
			'DIV' => 189,
			'AND' => 190,
			'BINOP' => 191,
			'OR' => 192,
			"+" => 187,
			'CAT' => 193,
			'CMPOP' => 194,
			"?" => 188,
			'MOD' => 195,
			"/" => 196
		},
		DEFAULT => -216
	},
	{#State 419
		ACTIONS => {
			'ELSIF' => 456,
			'ELSE' => 455
		},
		DEFAULT => -86,
		GOTOS => {
			'else' => 368
		}
	},
	{#State 420
		ACTIONS => {
			'ELSIF' => 456,
			'ELSE' => 455
		},
		DEFAULT => -86,
		GOTOS => {
			'else' => 399
		}
	},
	{#State 421
		ACTIONS => {
			'CASE' => 458
		},
		GOTOS => {
			'caselst' => 457,
			'onecase' => 408,
			'case' => 406
		}
	},
	{#State 422
		DEFAULT => -128
	},
	{#State 423
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 459,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 424
		ACTIONS => {
			'FINAL' => 321,
			'CATCH' => 323
		},
		DEFAULT => -129,
		GOTOS => {
			'final' => 460
		}
	},
	{#State 425
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 461,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 426
		DEFAULT => -163
	},
	{#State 427
		DEFAULT => -153
	},
	{#State 428
		DEFAULT => -155
	},
	{#State 429
		DEFAULT => -151
	},
	{#State 430
		DEFAULT => -132
	},
	{#State 431
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 462,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 432
		DEFAULT => -74
	},
	{#State 433
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 463,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 434
		ACTIONS => {
			";" => 464,
			'DEFAULT' => 465,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 440,
			'lterm' => 75
		}
	},
	{#State 435
		DEFAULT => -95
	},
	{#State 436
		DEFAULT => -92
	},
	{#State 437
		DEFAULT => -98
	},
	{#State 438
		DEFAULT => -100
	},
	{#State 439
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -42,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 467,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 466,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 440
		ACTIONS => {
			";" => 468
		}
	},
	{#State 441
		ACTIONS => {
			";" => 469
		}
	},
	{#State 442
		DEFAULT => -88
	},
	{#State 443
		DEFAULT => -93
	},
	{#State 444
		DEFAULT => -90
	},
	{#State 445
		DEFAULT => -91
	},
	{#State 446
		DEFAULT => -94
	},
	{#State 447
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -9,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_template' => 470,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'finalblock' => 79,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 92,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 42,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 448
		DEFAULT => -122
	},
	{#State 449
		DEFAULT => -121
	},
	{#State 450
		DEFAULT => -83
	},
	{#State 451
		DEFAULT => -85
	},
	{#State 452
		DEFAULT => -70
	},
	{#State 453
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 471,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 472,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 454
		DEFAULT => -71
	},
	{#State 455
		ACTIONS => {
			";" => 473
		}
	},
	{#State 456
		ACTIONS => {
			'NOT' => 49,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"(" => 71,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'expr' => 474,
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 80,
			'lterm' => 75
		}
	},
	{#State 457
		ACTIONS => {
			'CASE' => 475
		},
		DEFAULT => -99,
		GOTOS => {
			'onecase' => 438,
			'defcase' => 437
		}
	},
	{#State 458
		ACTIONS => {
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 476,
			'lterm' => 75
		}
	},
	{#State 459
		ACTIONS => {
			'FINAL' => 321,
			'CATCH' => 323
		},
		DEFAULT => -129,
		GOTOS => {
			'final' => 477
		}
	},
	{#State 460
		DEFAULT => -127
	},
	{#State 461
		ACTIONS => {
			'FINAL' => 321,
			'CATCH' => 323
		},
		DEFAULT => -129,
		GOTOS => {
			'final' => 478
		}
	},
	{#State 462
		DEFAULT => -68
	},
	{#State 463
		DEFAULT => -69
	},
	{#State 464
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 467,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 479,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 465
		ACTIONS => {
			";" => 480
		}
	},
	{#State 466
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -42,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 157,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 158,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 467
		DEFAULT => -103
	},
	{#State 468
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 481,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 482,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 469
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -42,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 483,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 466,
			'try' => 43,
			'switch' => 44,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 470
		DEFAULT => -87
	},
	{#State 471
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 485,
			'else' => 484
		}
	},
	{#State 472
		ACTIONS => {
			'ELSIF' => 367,
			'ELSE' => 363
		},
		DEFAULT => -86,
		GOTOS => {
			'event_else' => 487,
			'else' => 486
		}
	},
	{#State 473
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 451,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 474
		ACTIONS => {
			'CMPOP' => 194,
			"?" => 188,
			";" => 488,
			"+" => 187,
			'MOD' => 195,
			'DIV' => 189,
			"/" => 196,
			'AND' => 190,
			'CAT' => 193,
			'BINOP' => 191,
			'OR' => 192
		}
	},
	{#State 475
		ACTIONS => {
			";" => 489,
			'DEFAULT' => 490,
			"{" => 38,
			'LITERAL' => 100,
			'IDENT' => 4,
			"\"" => 82,
			"\$" => 58,
			"[" => 11,
			'NUMBER' => 32,
			'REF' => 33,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 90,
			'item' => 50,
			'node' => 27,
			'ident' => 99,
			'term' => 476,
			'lterm' => 75
		}
	},
	{#State 476
		ACTIONS => {
			";" => 491
		}
	},
	{#State 477
		DEFAULT => -125
	},
	{#State 478
		DEFAULT => -126
	},
	{#State 479
		DEFAULT => -105
	},
	{#State 480
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 5,
			'IF' => 59,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			'INCLUDE' => 19,
			"(" => 71,
			'SWITCH' => 73,
			'MACRO' => 20,
			'WRAPPER' => 76,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'PROCESS' => 85,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'AWAIT' => 37,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			'EVENT' => 46,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'event_switch' => 2,
			'loopforvar' => 48,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'event_directive' => 54,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 62,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'event_process' => 67,
			'loopwhilevar' => 68,
			'event' => 69,
			'ident' => 18,
			'event_condition' => 72,
			'event_loop' => 74,
			'assign' => 21,
			'awaitcall' => 22,
			'macro' => 23,
			'lterm' => 75,
			'event_plug' => 77,
			'defblock_std' => 25,
			'node' => 27,
			'rawperl' => 81,
			'term' => 80,
			'use' => 84,
			'expr' => 83,
			'eventcall' => 31,
			'event_wrapper' => 30,
			'defblock' => 88,
			'event_capture' => 34,
			'sterm' => 90,
			'filter' => 36,
			'eventblock' => 483,
			'perl' => 39,
			'setlist' => 93,
			'event_atomdir' => 41,
			'chunks' => 265,
			'try' => 43,
			'switch' => 44,
			'block' => 492,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 481
		DEFAULT => -106
	},
	{#State 482
		DEFAULT => -107
	},
	{#State 483
		DEFAULT => -102
	},
	{#State 484
		DEFAULT => -80
	},
	{#State 485
		DEFAULT => -82
	},
	{#State 486
		DEFAULT => -84
	},
	{#State 487
		DEFAULT => -81
	},
	{#State 488
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 493,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 489
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 479,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 490
		ACTIONS => {
			";" => 494
		}
	},
	{#State 491
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 482,
			'directive' => 94,
			'condition' => 95
		}
	},
	{#State 492
		DEFAULT => -104
	},
	{#State 493
		ACTIONS => {
			'ELSIF' => 456,
			'ELSE' => 455
		},
		DEFAULT => -86,
		GOTOS => {
			'else' => 486
		}
	},
	{#State 494
		ACTIONS => {
			'SET' => 1,
			'PERL' => 51,
			'NOT' => 49,
			'IDENT' => 4,
			'CLEAR' => 55,
			'UNLESS' => 217,
			'IF' => 221,
			"\$" => 58,
			'STOP' => 8,
			'CALL' => 60,
			'THROW' => 10,
			'GET' => 61,
			"[" => 11,
			'TRY' => 12,
			'LAST' => 63,
			'DEBUG' => 65,
			'RAWPERL' => 15,
			'META' => 17,
			"(" => 71,
			'SWITCH' => 224,
			'MACRO' => 20,
			";" => -42,
			'FOR' => 24,
			'LITERAL' => 78,
			'NEXT' => 26,
			"\"" => 82,
			'TEXT' => 28,
			'RETURN' => 86,
			'FILTER' => 29,
			'INSERT' => 87,
			'NUMBER' => 32,
			'REF' => 33,
			'WHILE' => 89,
			'BLOCK' => 35,
			'DEFAULT' => 91,
			"{" => 38,
			'USE' => 40,
			'VIEW' => 45,
			"\${" => 47
		},
		DEFAULT => -11,
		GOTOS => {
			'loopforvar' => 220,
			'async_call' => 52,
			'loopwf' => 53,
			'item' => 50,
			'atomloop' => 3,
			'loop' => 6,
			'defblock_ev' => 56,
			'capture' => 57,
			'statement' => 7,
			'view' => 9,
			'atomexpr' => 222,
			'chunk' => 13,
			'atomdir' => 14,
			'anonblock' => 64,
			'defblockname' => 16,
			'loopwhilevar' => 223,
			'ident' => 218,
			'assign' => 21,
			'macro' => 23,
			'lterm' => 75,
			'defblock_std' => 25,
			'node' => 27,
			'term' => 80,
			'rawperl' => 81,
			'expr' => 83,
			'use' => 84,
			'defblock' => 88,
			'sterm' => 90,
			'filter' => 36,
			'perl' => 39,
			'setlist' => 93,
			'chunks' => 219,
			'try' => 43,
			'switch' => 44,
			'block' => 492,
			'directive' => 94,
			'condition' => 95
		}
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 69 "Parser.yp"
{ $factory->event_template( $_[1] )   }
	],
	[#Rule 2
		 'event_template', 2,
sub
#line 72 "Parser.yp"
{ $_[0]->rollback_token; $_[1]        }
	],
	[#Rule 3
		 'event_template', 2,
sub
#line 73 "Parser.yp"
{ $_[0]->rollback_token; $_[1]        }
	],
	[#Rule 4
		 'event_template', 1,
sub
#line 74 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 5
		 'event_template', 1,
sub
#line 75 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 6
		 'eventblock', 2,
sub
#line 78 "Parser.yp"
{ $factory->block([ @{$_[1]}, $_[2] ])}
	],
	[#Rule 7
		 'eventblock', 1,
sub
#line 79 "Parser.yp"
{ $factory->block( [ $_[1] ] )        }
	],
	[#Rule 8
		 'finalblock', 1,
sub
#line 82 "Parser.yp"
{ $factory->block([ @{$_[1]}, 
                                      $factory->event_finalize() ])       }
	],
	[#Rule 9
		 'finalblock', 0,
sub
#line 84 "Parser.yp"
{ $factory->block( [
                                      $factory->event_finalize() ])       }
	],
	[#Rule 10
		 'block', 1,
sub
#line 88 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 11
		 'block', 0,
sub
#line 89 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 12
		 'chunks', 2,
sub
#line 92 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                        if defined $_[2]; $_[1]           }
	],
	[#Rule 13
		 'chunks', 1,
sub
#line 94 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 14
		 'event', 1, undef
	],
	[#Rule 15
		 'event', 1, undef
	],
	[#Rule 16
		 'event', 1, undef
	],
	[#Rule 17
		 'event_directive', 1, undef
	],
	[#Rule 18
		 'event_directive', 1, undef
	],
	[#Rule 19
		 'event_directive', 1, undef
	],
	[#Rule 20
		 'event_directive', 1, undef
	],
	[#Rule 21
		 'event_directive', 1, undef
	],
	[#Rule 22
		 'event_plug', 3,
sub
#line 112 "Parser.yp"
{ $_[0]->location() .
                                      $factory->define_event(
                                        $_[1]->[0], $_[1]->[1], $_[3])    }
	],
	[#Rule 23
		 'event_atomdir', 1,
sub
#line 117 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 24
		 'event_atomdir', 1,
sub
#line 118 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 25
		 'eventcall', 2,
sub
#line 121 "Parser.yp"
{ $factory->ident_eventify( $_[2] );
                                      [ undef, $factory->ident($_[2]) ]   }
	],
	[#Rule 26
		 'eventcall', 4,
sub
#line 123 "Parser.yp"
{ $factory->ident_eventify( $_[4] );
                                      [ $_[2], $factory->ident($_[4]) ]   }
	],
	[#Rule 27
		 'awaitcall', 2,
sub
#line 127 "Parser.yp"
{ $factory->ident_eventify( $_[2] );
                                      [ undef, $factory->ident($_[2]) ]   }
	],
	[#Rule 28
		 'awaitcall', 4,
sub
#line 129 "Parser.yp"
{ $factory->ident_eventify( $_[4] );
                                      [ $_[1], $factory->ident($_[4]) ]   }
	],
	[#Rule 29
		 'async_call', 4,
sub
#line 133 "Parser.yp"
{ $factory->async_call($_[1],$_[4]); }
	],
	[#Rule 30
		 'chunk', 1,
sub
#line 136 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 31
		 'chunk', 2,
sub
#line 137 "Parser.yp"
{ return '' unless $_[1];
                                      $_[0]->location() . $_[1];
                                    }
	],
	[#Rule 32
		 'statement', 1, undef
	],
	[#Rule 33
		 'statement', 1, undef
	],
	[#Rule 34
		 'statement', 1, undef
	],
	[#Rule 35
		 'statement', 1, undef
	],
	[#Rule 36
		 'statement', 1, undef
	],
	[#Rule 37
		 'statement', 1, undef
	],
	[#Rule 38
		 'statement', 1, undef
	],
	[#Rule 39
		 'statement', 1, undef
	],
	[#Rule 40
		 'statement', 1,
sub
#line 150 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 41
		 'statement', 2,
sub
#line 151 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 42
		 'statement', 0, undef
	],
	[#Rule 43
		 'directive', 1,
sub
#line 155 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 44
		 'directive', 1, undef
	],
	[#Rule 45
		 'directive', 1, undef
	],
	[#Rule 46
		 'directive', 1, undef
	],
	[#Rule 47
		 'directive', 1, undef
	],
	[#Rule 48
		 'directive', 1, undef
	],
	[#Rule 49
		 'directive', 1, undef
	],
	[#Rule 50
		 'directive', 1, undef
	],
	[#Rule 51
		 'atomexpr', 1,
sub
#line 170 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 52
		 'atomexpr', 1, undef
	],
	[#Rule 53
		 'atomdir', 2,
sub
#line 174 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 54
		 'atomdir', 2,
sub
#line 175 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 55
		 'atomdir', 2,
sub
#line 176 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 56
		 'atomdir', 2,
sub
#line 177 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 57
		 'atomdir', 2,
sub
#line 178 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 58
		 'atomdir', 2,
sub
#line 181 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 59
		 'atomdir', 1,
sub
#line 182 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 60
		 'atomdir', 1,
sub
#line 183 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 61
		 'atomdir', 1,
sub
#line 184 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 62
		 'atomdir', 1,
sub
#line 185 "Parser.yp"
{ $_[0]->block_label('last ', ';')    }
	],
	[#Rule 63
		 'atomdir', 1,
sub
#line 186 "Parser.yp"
{ $_[0]->in_block('FOR')
                                        ? $factory->next($_[0]->block_label)
                                        : $_[0]->block_label('next ', ';') }
	],
	[#Rule 64
		 'atomdir', 2,
sub
#line 189 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
                                          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
                                          $factory->debug($_[2]);
                                      }
                                      else {
                                          $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
                                      }
                                    }
	],
	[#Rule 65
		 'atomdir', 1, undef
	],
	[#Rule 66
		 'event_process', 3,
sub
#line 204 "Parser.yp"
{ $factory->include(@_[2,3])          }
	],
	[#Rule 67
		 'event_process', 3,
sub
#line 206 "Parser.yp"
{ $factory->process(@_[2,3])          }
	],
	[#Rule 68
		 'event_condition', 7,
sub
#line 211 "Parser.yp"
{ $factory->event_if(@_[2, 4, 5, 7], 'ev')  }
	],
	[#Rule 69
		 'event_condition', 7,
sub
#line 214 "Parser.yp"
{ $factory->event_if(@_[2, 4, 5, 7])  }
	],
	[#Rule 70
		 'event_condition', 7,
sub
#line 217 "Parser.yp"
{ $factory->event_if("!($_[2])", @_[4, 5, 7], 'ev') }
	],
	[#Rule 71
		 'event_condition', 7,
sub
#line 220 "Parser.yp"
{ $factory->event_if("!($_[2])", @_[4, 5, 7]) }
	],
	[#Rule 72
		 'event_condition', 5,
sub
#line 222 "Parser.yp"
{ $factory->event_if_directive(
                                        $_[1]->[0], $_[1]->[1], $_[3], $_[5] ) }
	],
	[#Rule 73
		 'event_condition', 5,
sub
#line 225 "Parser.yp"
{ $factory->event_if_directive(
                                        $_[1]->[0], $_[1]->[1], "!($_[3])", $_[5] ) }
	],
	[#Rule 74
		 'condition', 6,
sub
#line 230 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 75
		 'condition', 3,
sub
#line 231 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 76
		 'condition', 6,
sub
#line 233 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 77
		 'condition', 3,
sub
#line 234 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 78
		 'event_evnev_else', 1, undef
	],
	[#Rule 79
		 'event_evnev_else', 1, undef
	],
	[#Rule 80
		 'event_else', 5,
sub
#line 242 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4], 'ev' ]); $_[5]; }
	],
	[#Rule 81
		 'event_else', 5,
sub
#line 244 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); $_[5]; }
	],
	[#Rule 82
		 'event_else', 5,
sub
#line 246 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4], 'ev' ]); $_[5]; }
	],
	[#Rule 83
		 'event_else', 3,
sub
#line 248 "Parser.yp"
{ [ [$_[3],'ev'] ] }
	],
	[#Rule 84
		 'else', 5,
sub
#line 252 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
                                      $_[5];                              }
	],
	[#Rule 85
		 'else', 3,
sub
#line 254 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 86
		 'else', 0,
sub
#line 255 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 87
		 'event_switch', 7,
sub
#line 260 "Parser.yp"
{ $factory->event_switch(@_[2, 5, 7]) }
	],
	[#Rule 88
		 'switch', 6,
sub
#line 264 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 89
		 'eventcase', 1,
sub
#line 267 "Parser.yp"
{ push( @{$_[1]}, undef ); $_[1]      }
	],
	[#Rule 90
		 'eventcase', 2,
sub
#line 268 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 91
		 'eventcase', 2,
sub
#line 269 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 92
		 'eventcase', 2,
sub
#line 270 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 93
		 'eventcaselst', 2,
sub
#line 274 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 94
		 'eventcaselst', 2,
sub
#line 275 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 95
		 'eventcaselst', 2,
sub
#line 276 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 96
		 'eventcaselst', 1,
sub
#line 279 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 97
		 'eventcaselst', 1,
sub
#line 280 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'case', 2,
sub
#line 284 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 99
		 'case', 1,
sub
#line 285 "Parser.yp"
{ push( @{$_[1]}, undef ); $_[1]      }
	],
	[#Rule 100
		 'caselst', 2,
sub
#line 288 "Parser.yp"
{ push( @{$_[1]}, $_[2] ); $_[1]      }
	],
	[#Rule 101
		 'caselst', 1,
sub
#line 289 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 102
		 'eventdefcase', 4,
sub
#line 293 "Parser.yp"
{ [ $_[4] ]                       }
	],
	[#Rule 103
		 'eventdefcase', 3,
sub
#line 294 "Parser.yp"
{ [ $_[3] ]                       }
	],
	[#Rule 104
		 'defcase', 4,
sub
#line 298 "Parser.yp"
{ $_[4]                           }
	],
	[#Rule 105
		 'defcase', 3,
sub
#line 299 "Parser.yp"
{ $_[3]                           }
	],
	[#Rule 106
		 'eventonecase', 4,
sub
#line 303 "Parser.yp"
{ [ $_[2], $_[4], 1 ]                 }
	],
	[#Rule 107
		 'onecase', 4,
sub
#line 306 "Parser.yp"
{ [ $_[2], $_[4] ]                    }
	],
	[#Rule 108
		 'event_loop', 5,
sub
#line 311 "Parser.yp"
{ $factory->event_while(@_[1, 3, 5],
                                      $_[0]->leave_block)                 }
	],
	[#Rule 109
		 'event_loop', 5,
sub
#line 315 "Parser.yp"
{ $factory->event_for(@{$_[1]},
                                      @_[3, 5], $_[0]->leave_block)       }
	],
	[#Rule 110
		 'loop', 1,
sub
#line 319 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 111
		 'loop', 1,
sub
#line 320 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 112
		 'atomloop', 3,
sub
#line 323 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 113
		 'atomloop', 3,
sub
#line 324 "Parser.yp"
{ $factory->while(@_[3, 1]) }
	],
	[#Rule 114
		 'loopwf', 4,
sub
#line 328 "Parser.yp"
{ $factory->foreach(@{$_[1]}, $_[3], $_[0]->leave_block)  }
	],
	[#Rule 115
		 'loopwf', 4,
sub
#line 330 "Parser.yp"
{ $factory->while(@_[1, 3], $_[0]->leave_block) }
	],
	[#Rule 116
		 'loopforvar', 2,
sub
#line 333 "Parser.yp"
{ $_[0]->enter_block('FOR'); $_[2]    }
	],
	[#Rule 117
		 'loopwhilevar', 2,
sub
#line 336 "Parser.yp"
{ $_[0]->enter_block('WHILE'); $_[2]  }
	],
	[#Rule 118
		 'loopvar', 4,
sub
#line 339 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 119
		 'loopvar', 4,
sub
#line 340 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 120
		 'loopvar', 2,
sub
#line 341 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 121
		 'event_wrapper', 6,
sub
#line 347 "Parser.yp"
{ $factory->event_wrapper(@_[2, 4, 6])}
	],
	[#Rule 122
		 'event_wrapper', 6,
sub
#line 350 "Parser.yp"
{ $factory->event_wrapper(@_[2, 4, 6], 'ev')}
	],
	[#Rule 123
		 'event_wrapper', 4,
sub
#line 353 "Parser.yp"
{ $factory->event_wrapper(@_[3, 1, 4])}
	],
	[#Rule 124
		 'try', 5,
sub
#line 357 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 125
		 'final', 5,
sub
#line 361 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
                                      $_[5];                              }
	],
	[#Rule 126
		 'final', 5,
sub
#line 364 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
                                      $_[5];                              }
	],
	[#Rule 127
		 'final', 4,
sub
#line 367 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
                                      $_[4];                              }
	],
	[#Rule 128
		 'final', 3,
sub
#line 369 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 129
		 'final', 0,
sub
#line 370 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 130
		 'use', 2,
sub
#line 373 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 131
		 '@1-3', 0,
sub
#line 376 "Parser.yp"
{ $_[0]->push_defblock();             }
	],
	[#Rule 132
		 'view', 6,
sub
#line 377 "Parser.yp"
{ $factory->view(@_[2,5], 
                                                     $_[0]->pop_defblock) }
	],
	[#Rule 133
		 '@2-2', 0,
sub
#line 381 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 134
		 'perl', 5,
sub
#line 382 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->perl($_[4])             
                                      : $factory->no_perl();              }
	],
	[#Rule 135
		 '@3-1', 0,
sub
#line 388 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
                                      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 136
		 'rawperl', 5,
sub
#line 390 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->rawperl($_[4], $rawstart)
                                      : $factory->no_perl();              }
	],
	[#Rule 137
		 'filter', 5,
sub
#line 397 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 138
		 'filter', 3,
sub
#line 399 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 139
		 'defblock', 1, undef
	],
	[#Rule 140
		 'defblock', 1, undef
	],
	[#Rule 141
		 'defblock_ev', 5,
sub
#line 408 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
                                      pop(@{ $_[0]->{ DEFBLOCKS } });
                                      $_[0]->define_block($name, $factory->event_proc($_[4])); 
                                      undef
                                    }
	],
	[#Rule 142
		 'defblock_std', 5,
sub
#line 417 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
                                      pop(@{ $_[0]->{ DEFBLOCKS } });
                                      $_[0]->define_block($name, $factory->event_proc(
                                        $_[4] . $factory->event_finalize() ));
                                      undef
                                    }
	],
	[#Rule 143
		 'defblockname', 2,
sub
#line 425 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
                                      $_[2];
                                    }
	],
	[#Rule 144
		 'blockname', 1, undef
	],
	[#Rule 145
		 'blockname', 1,
sub
#line 431 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 146
		 'blockargs', 1, undef
	],
	[#Rule 147
		 'blockargs', 0, undef
	],
	[#Rule 148
		 'anonblock', 5,
sub
#line 439 "Parser.yp"
{ local $" = ', ';
                                      print STDERR "experimental block args: [@{ $_[2] }]\n"
                                          if $_[2];
                                      $factory->anon_block($_[4])         }
	],
	[#Rule 149
		 'event_capture', 4,
sub
#line 446 "Parser.yp"
{ $factory->event_capture(@_[1, 3, 4]) }
	],
	[#Rule 150
		 'capture', 3,
sub
#line 449 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 151
		 'macro', 6,
sub
#line 453 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 152
		 'macro', 3,
sub
#line 454 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 153
		 'mdir_ev', 4,
sub
#line 457 "Parser.yp"
{ $_[3]                              }
	],
	[#Rule 154
		 'mdir', 1, undef
	],
	[#Rule 155
		 'mdir', 4,
sub
#line 461 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 156
		 'margs', 2,
sub
#line 464 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 157
		 'margs', 2,
sub
#line 465 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 158
		 'margs', 1,
sub
#line 466 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 159
		 'metadata', 2,
sub
#line 469 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 160
		 'metadata', 2, undef
	],
	[#Rule 161
		 'metadata', 1, undef
	],
	[#Rule 162
		 'meta', 3,
sub
#line 474 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
                                                       s/\\'/'/g  }; 
                                         [ @_[1,3] ] }
	],
	[#Rule 163
		 'meta', 5,
sub
#line 477 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 164
		 'meta', 3,
sub
#line 478 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 165
		 'term', 1, undef
	],
	[#Rule 166
		 'term', 1, undef
	],
	[#Rule 167
		 'lterm', 3,
sub
#line 490 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 168
		 'lterm', 3,
sub
#line 491 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 169
		 'lterm', 2,
sub
#line 492 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 170
		 'lterm', 3,
sub
#line 493 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 171
		 'sterm', 1,
sub
#line 496 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 172
		 'sterm', 2,
sub
#line 497 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 173
		 'sterm', 3,
sub
#line 498 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 174
		 'sterm', 1, undef
	],
	[#Rule 175
		 'sterm', 1, undef
	],
	[#Rule 176
		 'list', 2,
sub
#line 503 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 177
		 'list', 2, undef
	],
	[#Rule 178
		 'list', 1, undef
	],
	[#Rule 179
		 'range', 3,
sub
#line 508 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 180
		 'hash', 1, undef
	],
	[#Rule 181
		 'hash', 0,
sub
#line 513 "Parser.yp"
{ "" }
	],
	[#Rule 182
		 'params', 2,
sub
#line 516 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 183
		 'params', 2, undef
	],
	[#Rule 184
		 'params', 1, undef
	],
	[#Rule 185
		 'param', 3,
sub
#line 521 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 186
		 'param', 3,
sub
#line 522 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 187
		 'ident', 3,
sub
#line 525 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 188
		 'ident', 3,
sub
#line 526 "Parser.yp"
{ push(@{$_[1]}, 
                                           map {($_, 0)} split(/\./, $_[3]));
                                      $_[1];                              }
	],
	[#Rule 189
		 'ident', 1, undef
	],
	[#Rule 190
		 'node', 1,
sub
#line 532 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 191
		 'node', 4,
sub
#line 533 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 192
		 'item', 1,
sub
#line 536 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 193
		 'item', 3,
sub
#line 537 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 194
		 'item', 2,
sub
#line 538 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
                                       ? "'$_[2]'" 
                                       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 195
		 'expr', 3,
sub
#line 543 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 196
		 'expr', 3,
sub
#line 544 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 197
		 'expr', 3,
sub
#line 545 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 198
		 'expr', 3,
sub
#line 546 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 199
		 'expr', 3,
sub
#line 547 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 200
		 'expr', 3,
sub
#line 548 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 201
		 'expr', 3,
sub
#line 549 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 202
		 'expr', 3,
sub
#line 550 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 203
		 'expr', 3,
sub
#line 551 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 204
		 'expr', 2,
sub
#line 552 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 205
		 'expr', 5,
sub
#line 553 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 206
		 'expr', 3,
sub
#line 554 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 207
		 'expr', 3,
sub
#line 555 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 208
		 'expr', 1, undef
	],
	[#Rule 209
		 'setlist', 2,
sub
#line 559 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 210
		 'setlist', 2, undef
	],
	[#Rule 211
		 'setlist', 1, undef
	],
	[#Rule 212
		 'assign', 3,
sub
#line 565 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 213
		 'assign', 3,
sub
#line 566 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 214
		 'args', 2,
sub
#line 573 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 215
		 'args', 2,
sub
#line 574 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 216
		 'args', 4,
sub
#line 575 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
                                      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 217
		 'args', 2,
sub
#line 577 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 218
		 'args', 0,
sub
#line 578 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 219
		 'lnameargs', 3,
sub
#line 588 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 220
		 'lnameargs', 1, undef
	],
	[#Rule 221
		 'lvalue', 1, undef
	],
	[#Rule 222
		 'lvalue', 3,
sub
#line 593 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 223
		 'lvalue', 1, undef
	],
	[#Rule 224
		 'nameargs', 3,
sub
#line 597 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 225
		 'nameargs', 2,
sub
#line 598 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 226
		 'nameargs', 4,
sub
#line 599 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 227
		 'names', 3,
sub
#line 602 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 228
		 'names', 1,
sub
#line 603 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 229
		 'name', 3,
sub
#line 606 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 230
		 'name', 1,
sub
#line 607 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 231
		 'name', 1, undef
	],
	[#Rule 232
		 'filename', 3,
sub
#line 611 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 233
		 'filename', 1, undef
	],
	[#Rule 234
		 'filepart', 1, undef
	],
	[#Rule 235
		 'filepart', 1, undef
	],
	[#Rule 236
		 'filepart', 1, undef
	],
	[#Rule 237
		 'quoted', 2,
sub
#line 625 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                          if defined $_[2]; $_[1]         }
	],
	[#Rule 238
		 'quoted', 0,
sub
#line 627 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 239
		 'quotable', 1,
sub
#line 630 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 240
		 'quotable', 1,
sub
#line 631 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 241
		 'quotable', 1,
sub
#line 632 "Parser.yp"
{ undef                               }
	]
];



1;

__END__

=head1 NAME

Template::Grammar - Parser state/rule tables for the TT grammar

=head1 SYNOPSIS

    # no user serviceable parts inside

=head1 DESCRIPTION

This module defines the state and rule tables that the L<Template::Parser>
module uses to parse templates.  It is generated from a YACC-like grammar
using the C<Parse::Yapp> module.  The F<parser> sub-directory of the 
Template Toolkit source distribution contains the grammar and other 
files required to generate this module.

But you don't need to worry about any of that unless you're planning to 
modify the Template Toolkit language.

=head1 AUTHOR

Andy Wardley E<lt>abw@wardley.orgE<gt>
Serguei Okladnikov E<lt>oklaspec@gmail.comE<gt>

L<http://wardley.org/>

=head1 COPYRIGHT

Copyright (C) 1996-2007 Andy Wardley.  All Rights Reserved.
Copyright (C) 2012-2017 Serguei Okladnikov

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Template::Parser>

=cut

# Local Variables:
# mode: perl
# perl-indent-level: 4
# indent-tabs-mode: nil
# End:
#
# vim: expandtab shiftwidth=4:










