# Generated by default/object.tt
package Paws::MediaLive::Mpeg2Settings;
  use Moose;
  has AdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'adaptiveQuantization', traits => ['NameInRequest']);
  has AfdSignaling => (is => 'ro', isa => 'Str', request_name => 'afdSignaling', traits => ['NameInRequest']);
  has ColorMetadata => (is => 'ro', isa => 'Str', request_name => 'colorMetadata', traits => ['NameInRequest']);
  has ColorSpace => (is => 'ro', isa => 'Str', request_name => 'colorSpace', traits => ['NameInRequest']);
  has DisplayAspectRatio => (is => 'ro', isa => 'Str', request_name => 'displayAspectRatio', traits => ['NameInRequest']);
  has FilterSettings => (is => 'ro', isa => 'Paws::MediaLive::Mpeg2FilterSettings', request_name => 'filterSettings', traits => ['NameInRequest']);
  has FixedAfd => (is => 'ro', isa => 'Str', request_name => 'fixedAfd', traits => ['NameInRequest']);
  has FramerateDenominator => (is => 'ro', isa => 'Int', request_name => 'framerateDenominator', traits => ['NameInRequest'], required => 1);
  has FramerateNumerator => (is => 'ro', isa => 'Int', request_name => 'framerateNumerator', traits => ['NameInRequest'], required => 1);
  has GopClosedCadence => (is => 'ro', isa => 'Int', request_name => 'gopClosedCadence', traits => ['NameInRequest']);
  has GopNumBFrames => (is => 'ro', isa => 'Int', request_name => 'gopNumBFrames', traits => ['NameInRequest']);
  has GopSize => (is => 'ro', isa => 'Num', request_name => 'gopSize', traits => ['NameInRequest']);
  has GopSizeUnits => (is => 'ro', isa => 'Str', request_name => 'gopSizeUnits', traits => ['NameInRequest']);
  has ScanType => (is => 'ro', isa => 'Str', request_name => 'scanType', traits => ['NameInRequest']);
  has SubgopLength => (is => 'ro', isa => 'Str', request_name => 'subgopLength', traits => ['NameInRequest']);
  has TimecodeInsertion => (is => 'ro', isa => 'Str', request_name => 'timecodeInsertion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::Mpeg2Settings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::Mpeg2Settings object:

  $service_obj->Method(Att1 => { AdaptiveQuantization => $value, ..., TimecodeInsertion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::Mpeg2Settings object:

  $result = $service_obj->Method(...);
  $result->Att1->AdaptiveQuantization

=head1 DESCRIPTION

Mpeg2 Settings

=head1 ATTRIBUTES


=head2 AdaptiveQuantization => Str

Choose Off to disable adaptive quantization. Or choose another value to
enable the quantizer and set its strength. The strengths are: Auto,
Off, Low, Medium, High. When you enable this field, MediaLive allows
intra-frame quantizers to vary, which might improve visual quality.


=head2 AfdSignaling => Str

Indicates the AFD values that MediaLive will write into the video
encode. If you do not know what AFD signaling is, or if your downstream
system has not given you guidance, choose AUTO. AUTO: MediaLive will
try to preserve the input AFD value (in cases where multiple AFD values
are valid). FIXED: MediaLive will use the value you specify in
fixedAFD.


=head2 ColorMetadata => Str

Specifies whether to include the color space metadata. The metadata
describes the color space that applies to the video (the colorSpace
field). We recommend that you insert the metadata.


=head2 ColorSpace => Str

Choose the type of color space conversion to apply to the output. For
detailed information on setting up both the input and the output to
obtain the desired color space in the output, see the section on
\"MediaLive Features - Video - color space\" in the MediaLive User
Guide. PASSTHROUGH: Keep the color space of the input content - do not
convert it. AUTO:Convert all content that is SD to rec 601, and convert
all content that is HD to rec 709.


=head2 DisplayAspectRatio => Str

Sets the pixel aspect ratio for the encode.


=head2 FilterSettings => L<Paws::MediaLive::Mpeg2FilterSettings>

Optionally specify a noise reduction filter, which can improve quality
of compressed content. If you do not choose a filter, no filter will be
applied. TEMPORAL: This filter is useful for both source content that
is noisy (when it has excessive digital artifacts) and source content
that is clean. When the content is noisy, the filter cleans up the
source content before the encoding phase, with these two effects:
First, it improves the output video quality because the content has
been cleaned up. Secondly, it decreases the bandwidth because MediaLive
does not waste bits on encoding noise. When the content is reasonably
clean, the filter tends to decrease the bitrate.


=head2 FixedAfd => Str

Complete this field only when afdSignaling is set to FIXED. Enter the
AFD value (4 bits) to write on all frames of the video encode.


=head2 B<REQUIRED> FramerateDenominator => Int

description": "The framerate denominator. For example, 1001. The
framerate is the numerator divided by the denominator. For example,
24000 / 1001 = 23.976 FPS.


=head2 B<REQUIRED> FramerateNumerator => Int

The framerate numerator. For example, 24000. The framerate is the
numerator divided by the denominator. For example, 24000 / 1001 =
23.976 FPS.


=head2 GopClosedCadence => Int

MPEG2: default is open GOP.


=head2 GopNumBFrames => Int

Relates to the GOP structure. The number of B-frames between reference
frames. If you do not know what a B-frame is, use the default.


=head2 GopSize => Num

Relates to the GOP structure. The GOP size (keyframe interval) in the
units specified in gopSizeUnits. If you do not know what GOP is, use
the default. If gopSizeUnits is frames, then the gopSize must be an
integer and must be greater than or equal to 1. If gopSizeUnits is
seconds, the gopSize must be greater than 0, but does not need to be an
integer.


=head2 GopSizeUnits => Str

Relates to the GOP structure. Specifies whether the gopSize is
specified in frames or seconds. If you do not plan to change the
default gopSize, leave the default. If you specify SECONDS, MediaLive
will internally convert the gop size to a frame count.


=head2 ScanType => Str

Set the scan type of the output to PROGRESSIVE or INTERLACED (top field
first).


=head2 SubgopLength => Str

Relates to the GOP structure. If you do not know what GOP is, use the
default. FIXED: Set the number of B-frames in each sub-GOP to the value
in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of
B-frames in each sub-GOP, to improve visual quality.


=head2 TimecodeInsertion => Str

Determines how MediaLive inserts timecodes in the output video. For
detailed information about setting up the input and the output for a
timecode, see the section on \"MediaLive Features - Timecode
configuration\" in the MediaLive User Guide. DISABLED: do not include
timecodes. GOP_TIMECODE: Include timecode metadata in the GOP header.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

