/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericAuthorizer;
import org.apache.derby.impl.sql.conn.GenericStatementContext;
import org.apache.derby.impl.sql.conn.TempTableInfo;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;

public class GenericLanguageConnectionContext
extends ContextImpl
implements LanguageConnectionContext {
    private static final int NON_XA = 0;
    private static final int XA_ONE_PHASE = 1;
    private static final int XA_TWO_PHASE = 2;
    private final Vector acts;
    protected int bindCount;
    private boolean ddWriteMode;
    private boolean runTimeStatisticsSetting;
    private boolean statisticsTiming;
    private ArrayList allDeclaredGlobalTempTables;
    private int currentSavepointLevel = 0;
    protected long nextCursorId;
    protected int nextSavepointId;
    private RunTimeStatistics runTimeStatisticsObject;
    private StringBuffer sb;
    private Database db;
    private final int instanceNumber;
    private String drdaID;
    private String dbname;
    private int identifierCasing = -1;
    protected TransactionController tran;
    protected TransactionController childTransaction;
    protected int queryNestingDepth;
    protected DataValueFactory dataFactory;
    protected LanguageFactory langFactory;
    protected TypeCompilerFactory tcf;
    protected OptimizerFactory of;
    protected LanguageConnectionFactory connFactory;
    protected StatementContext[] statementContexts = new StatementContext[2];
    protected int statementDepth;
    protected int outermostTrigger = -1;
    protected Authorizer authorizer;
    protected String userName = null;
    protected SchemaDescriptor sd;
    private int defaultIsolationLevel;
    protected int isolationLevel = this.defaultIsolationLevel = 2;
    private boolean isolationLevelExplicitlySet = false;
    protected int prepareIsolationLevel = 0;
    private boolean logStatementText;
    private boolean logQueryPlan;
    private HeaderPrintWriter istream;
    private int lockEscalationThreshold;
    private Vector stmtValidators;
    private Vector triggerExecutionContexts;
    private Vector triggerTables;
    protected AccessFactory af;
    private boolean optimizerTrace;
    private boolean optimizerTraceHtml;
    private String lastOptimizerTraceOutput;
    private String optimizerTraceOutput;
    private Hashtable autoincrementHT;
    private boolean autoincrementUpdate;
    private long identityVal;
    private boolean identityNotNull;
    private Hashtable autoincrementCacheHashtable;
    public CacheManager statementCache;

    public GenericLanguageConnectionContext(ContextManager contextManager, TransactionController transactionController, LanguageFactory languageFactory, LanguageConnectionFactory languageConnectionFactory, Database database, String string, int n, String string2, String string3) throws StandardException {
        super(contextManager, "LanguageConnectionContext");
        this.acts = new Vector();
        this.tran = transactionController;
        this.dataFactory = languageConnectionFactory.getDataValueFactory();
        this.tcf = languageConnectionFactory.getTypeCompilerFactory();
        this.of = languageConnectionFactory.getOptimizerFactory();
        this.langFactory = languageFactory;
        this.connFactory = languageConnectionFactory;
        this.db = database;
        this.userName = string;
        this.instanceNumber = n;
        this.drdaID = string2;
        this.dbname = string3;
        String string4 = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logStatementText");
        this.logStatementText = Boolean.valueOf(string4);
        String string5 = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logQueryPlan");
        this.logQueryPlan = Boolean.valueOf(string5);
        this.setRunTimeStatisticsMode(this.logQueryPlan);
        this.lockEscalationThreshold = PropertyUtil.getServiceInt(transactionController, "derby.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.stmtValidators = new Vector();
        this.triggerExecutionContexts = new Vector();
        this.triggerTables = new Vector();
        this.af = languageConnectionFactory.getAccessFactory();
        this.statementCache = languageConnectionFactory.getStatementCache();
    }

    public void initialize(boolean bl) throws StandardException {
        this.authorizer = new GenericAuthorizer(this.getAuthorizationId(this.userName), this, bl);
        if (!bl) {
            return;
        }
        this.setDefaultSchema(this.initDefaultSchemaDescriptor());
    }

    protected SchemaDescriptor initDefaultSchemaDescriptor() throws StandardException {
        String string;
        DataDictionary dataDictionary = this.getDataDictionary();
        this.sd = dataDictionary.getSchemaDescriptor(string = this.getAuthorizationId(), this.getTransactionCompile(), false);
        if (this.sd == null) {
            this.sd = new SchemaDescriptor(dataDictionary, string, string, null, false);
        }
        return this.sd;
    }

    public boolean getLogStatementText() {
        return this.logStatementText;
    }

    public void setLogStatementText(boolean bl) {
        this.logStatementText = bl;
    }

    public boolean getLogQueryPlan() {
        return this.logQueryPlan;
    }

    public int getLockEscalationThreshold() {
        return this.lockEscalationThreshold;
    }

    public int getCacheSize() {
        if (this.statementCache != null) {
            return this.statementCache.getNumberInUse();
        }
        return 0;
    }

    public void addActivation(Activation activation) {
        this.acts.addElement(activation);
    }

    public boolean checkIfAnyDeclaredGlobalTempTablesForThisConnection() {
        return this.allDeclaredGlobalTempTables != null;
    }

    public void addDeclaredGlobalTempTable(TableDescriptor tableDescriptor) throws StandardException {
        if (this.findDeclaredGlobalTempTable(tableDescriptor.getName()) != null) {
            throw StandardException.newException("X0Y32.S", "Declared global temporary table", (Object)tableDescriptor.getName(), (Object)"Schema", (Object)"SESSION");
        }
        TempTableInfo tempTableInfo = new TempTableInfo(tableDescriptor, this.currentSavepointLevel);
        if (this.allDeclaredGlobalTempTables == null) {
            this.allDeclaredGlobalTempTables = new ArrayList();
        }
        this.allDeclaredGlobalTempTables.add(tempTableInfo);
    }

    public boolean dropDeclaredGlobalTempTable(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        if (tempTableInfo != null) {
            if (tempTableInfo.getDeclaredInSavepointLevel() == this.currentSavepointLevel) {
                this.allDeclaredGlobalTempTables.remove(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo));
                if (this.allDeclaredGlobalTempTables.size() == 0) {
                    this.allDeclaredGlobalTempTables = null;
                }
            } else {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            return true;
        }
        return false;
    }

    private void tempTablesReleaseSavepointLevels() {
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            TempTableInfo tempTableInfo = (TempTableInfo)this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDeclaredInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getModifiedInSavepointLevel() <= this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
        }
    }

    private void tempTablesAndCommit() {
        for (int i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TempTableInfo tempTableInfo = (TempTableInfo)this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() != -1) {
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            tempTableInfo.setDeclaredInSavepointLevel(-1);
            tempTableInfo.setModifiedInSavepointLevel(-1);
        }
    }

    public void resetFromPool() throws StandardException {
        this.identityNotNull = false;
        this.dropAllDeclaredGlobalTempTables();
    }

    private void dropAllDeclaredGlobalTempTables() throws StandardException {
        if (this.allDeclaredGlobalTempTables == null) {
            return;
        }
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        StandardException standardException = null;
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            try {
                TempTableInfo tempTableInfo = (TempTableInfo)this.allDeclaredGlobalTempTables.get(i);
                TableDescriptor tableDescriptor = tempTableInfo.getTableDescriptor();
                dependencyManager.invalidateFor(tableDescriptor, 1, this);
                this.tran.dropConglomerate(tableDescriptor.getHeapConglomerateId());
                continue;
            }
            catch (StandardException standardException2) {
                standardException2.setNestedException(standardException);
                standardException = standardException2;
            }
        }
        this.allDeclaredGlobalTempTables = null;
        try {
            this.internalCommit(true);
        }
        catch (StandardException standardException3) {
            standardException3.setNestedException(standardException);
            standardException = standardException3;
        }
        if (standardException != null) {
            throw standardException;
        }
    }

    private void tempTablesAndRollback() throws StandardException {
        for (int i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TableDescriptor tableDescriptor;
            TempTableInfo tempTableInfo = (TempTableInfo)this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDeclaredInSavepointLevel() >= this.currentSavepointLevel) {
                if (tempTableInfo.getDroppedInSavepointLevel() == -1) {
                    tableDescriptor = tempTableInfo.getTableDescriptor();
                    this.tran.dropConglomerate(tableDescriptor.getHeapConglomerateId());
                    this.allDeclaredGlobalTempTables.remove(i);
                    continue;
                }
                if (tempTableInfo.getDroppedInSavepointLevel() < this.currentSavepointLevel) continue;
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            if (tempTableInfo.getDroppedInSavepointLevel() >= this.currentSavepointLevel) {
                tableDescriptor = tempTableInfo.getTableDescriptor();
                tableDescriptor = this.cleanupTempTableOnCommitOrRollback(tableDescriptor, false);
                tempTableInfo.setTableDescriptor(tableDescriptor);
                tempTableInfo.setDroppedInSavepointLevel(-1);
                tempTableInfo.setModifiedInSavepointLevel(-1);
                this.allDeclaredGlobalTempTables.set(i, tempTableInfo);
                continue;
            }
            if (tempTableInfo.getModifiedInSavepointLevel() < this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(-1);
            tableDescriptor = tempTableInfo.getTableDescriptor();
            this.getDataDictionary().getDependencyManager().invalidateFor(tableDescriptor, 1, this);
            this.cleanupTempTableOnCommitOrRollback(tableDescriptor, true);
        }
        if (this.allDeclaredGlobalTempTables.size() == 0) {
            this.allDeclaredGlobalTempTables = null;
        }
    }

    private void replaceDeclaredGlobalTempTable(String string, TableDescriptor tableDescriptor) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        tempTableInfo.setDroppedInSavepointLevel(-1);
        tempTableInfo.setDeclaredInSavepointLevel(-1);
        tempTableInfo.setTableDescriptor(tableDescriptor);
        this.allDeclaredGlobalTempTables.set(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo), tempTableInfo);
    }

    public TableDescriptor getTableDescriptorForDeclaredGlobalTempTable(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        if (tempTableInfo == null) {
            return null;
        }
        return tempTableInfo.getTableDescriptor();
    }

    private TempTableInfo findDeclaredGlobalTempTable(String string) {
        if (this.allDeclaredGlobalTempTables == null) {
            return null;
        }
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            if (!((TempTableInfo)this.allDeclaredGlobalTempTables.get(i)).matches(string)) continue;
            return (TempTableInfo)this.allDeclaredGlobalTempTables.get(i);
        }
        return null;
    }

    public void markTempTableAsModifiedInUnitOfWork(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
    }

    public PreparedStatement prepareInternalStatement(String string) throws StandardException {
        return this.connFactory.getStatement(this.sd, string).prepare(this);
    }

    public PreparedStatement prepareInternalStatement(SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        return this.connFactory.getStatement(schemaDescriptor, string).prepare(this);
    }

    public void removeActivation(Activation activation) {
        this.acts.removeElement(activation);
        int n = this.acts.capacity();
        if (n > 20 && n > 2 * this.acts.size()) {
            this.acts.trimToSize();
        }
    }

    public int getActivationCount() {
        return this.acts.size();
    }

    public CursorActivation lookupCursorActivation(String string) {
        int n = this.acts.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ResultSet resultSet;
                String string2;
                Activation activation = (Activation)this.acts.elementAt(i);
                if (!activation.isInUse() || !string.equals(string2 = activation.getCursorName()) || (resultSet = activation.getResultSet()) == null || resultSet.isClosed()) continue;
                return (CursorActivation)activation;
            }
        }
        return null;
    }

    public void removeStatement(Statement statement) throws StandardException {
        if (this.statementCache == null) {
            return;
        }
        Cacheable cacheable = this.statementCache.findCached(statement);
        if (cacheable != null) {
            this.statementCache.remove(cacheable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement lookupStatement(GenericStatement genericStatement) throws StandardException {
        GenericPreparedStatement genericPreparedStatement;
        if (this.statementCache == null) {
            return null;
        }
        if (this.dataDictionaryInWriteMode()) {
            return null;
        }
        Cacheable cacheable = this.statementCache.find(genericStatement);
        CachedStatement cachedStatement = (CachedStatement)cacheable;
        GenericPreparedStatement genericPreparedStatement2 = genericPreparedStatement = cachedStatement.getPreparedStatement();
        synchronized (genericPreparedStatement2) {
            if (genericPreparedStatement.upToDate()) {
                GeneratedClass generatedClass = genericPreparedStatement.getActivationClass();
                int n = this.getLanguageConnectionFactory().getClassFactory().getClassLoaderVersion();
                if (generatedClass.getClassLoaderVersion() != n) {
                    genericPreparedStatement.makeInvalid(23, this);
                }
            }
        }
        this.statementCache.release(cacheable);
        return genericPreparedStatement;
    }

    public String getUniqueCursorName() {
        return this.getNameString("SQLCUR", this.nextCursorId++);
    }

    public String getUniqueSavepointName() {
        return this.getNameString("SAVEPT", this.nextSavepointId++);
    }

    public int getUniqueSavepointID() {
        return this.nextSavepointId - 1;
    }

    private String getNameString(String string, long l) {
        if (this.sb != null) {
            this.sb.setLength(0);
        } else {
            this.sb = new StringBuffer();
        }
        this.sb.append(string).append(l);
        return this.sb.toString();
    }

    public void internalCommit(boolean bl) throws StandardException {
        this.doCommit(bl, true, 0, false);
    }

    public void userCommit() throws StandardException {
        this.doCommit(true, true, 0, true);
    }

    public final void internalCommitNoSync(int n) throws StandardException {
        this.doCommit(true, false, n, false);
    }

    public final void xaCommit(boolean bl) throws StandardException {
        this.doCommit(true, true, bl ? 1 : 2, true);
    }

    protected void doCommit(boolean bl, boolean bl2, int n, boolean bl3) throws StandardException {
        Object object;
        StatementContext statementContext = this.getStatementContext();
        if (bl3 && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y66.S");
        }
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            object = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + (String)object + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Committing");
        }
        this.resetActivations(false);
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndCommit();
            if (this.allDeclaredGlobalTempTables != null) {
                for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
                    TableDescriptor tableDescriptor = ((TempTableInfo)this.allDeclaredGlobalTempTables.get(i)).getTableDescriptor();
                    if (!tableDescriptor.isOnCommitDeleteRows() || this.checkIfAnyActivationHasHoldCursor(tableDescriptor.getName())) continue;
                    this.getDataDictionary().getDependencyManager().invalidateFor(tableDescriptor, 1, this);
                    this.cleanupTempTableOnCommitOrRollback(tableDescriptor, true);
                }
            }
        }
        this.currentSavepointLevel = 0;
        if (bl2) {
            this.finishDDTransaction();
        }
        if ((object = this.getTransactionExecute()) != null && bl) {
            if (bl2) {
                if (n == 0) {
                    object.commit();
                } else {
                    ((XATransactionController)object).xa_commit(n == 1);
                }
            } else {
                object.commitNoSync(n);
            }
            this.resetSavepoints(statementContext);
        }
    }

    private TableDescriptor cleanupTempTableOnCommitOrRollback(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        long l = this.tran.createConglomerate("heap", tableDescriptor.getEmptyExecRow(this.getContextManager()).getRowArray(), null, null, 3);
        long l2 = tableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(l2);
        tableDescriptor.getConglomerateDescriptorList().dropConglomerateDescriptorByUUID(conglomerateDescriptor.getUUID());
        conglomerateDescriptor = this.getDataDictionary().getDataDescriptorGenerator().newConglomerateDescriptor(l, null, false, null, false, null, tableDescriptor.getUUID(), tableDescriptor.getSchemaDescriptor().getUUID());
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        conglomerateDescriptorList.add(conglomerateDescriptor);
        tableDescriptor.resetHeapConglomNumber();
        if (bl) {
            this.tran.dropConglomerate(l2);
            this.replaceDeclaredGlobalTempTable(tableDescriptor.getName(), tableDescriptor);
        }
        return tableDescriptor;
    }

    public void internalRollback() throws StandardException {
        this.doRollback(false, false);
    }

    public void userRollback() throws StandardException {
        this.doRollback(false, true);
    }

    public void xaRollback() throws StandardException {
        this.doRollback(true, true);
    }

    private void doRollback(boolean bl, boolean bl2) throws StandardException {
        Object object;
        StatementContext statementContext = this.getStatementContext();
        if (bl2 && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y67.S");
        }
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            object = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + (String)object + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Rolling back");
        }
        this.resetActivations(true);
        this.currentSavepointLevel = 0;
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
        this.finishDDTransaction();
        object = this.getTransactionExecute();
        if (object != null) {
            if (bl) {
                ((XATransactionController)object).xa_rollback();
            } else {
                object.abort();
            }
            this.resetSavepoints(statementContext);
        }
    }

    private void resetSavepoints(StatementContext statementContext) throws StandardException {
        if (statementContext == null) {
            return;
        }
        ContextManager contextManager = this.getContextManager();
        Stack<StatementContext> stack = new Stack<StatementContext>();
        do {
            stack.push(statementContext);
            statementContext.popMe();
        } while ((statementContext = (StatementContext)contextManager.getContext("StatementContext")) != null);
        while (!stack.empty()) {
            statementContext = (StatementContext)stack.pop();
            statementContext.resetSavePoint();
            statementContext.pushMe();
        }
    }

    public void internalRollbackToSavepoint(String string, boolean bl, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            boolean bl2;
            if (bl) {
                bl2 = true;
                this.resetActivations(true);
            } else {
                bl2 = false;
            }
            this.currentSavepointLevel = transactionController.rollbackToSavePoint(string, bl2, object);
        }
        if (transactionController != null && bl && this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
    }

    public void releaseSavePoint(String string, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            this.currentSavepointLevel = transactionController.releaseSavePoint(string, object);
            if (this.allDeclaredGlobalTempTables != null) {
                this.tempTablesReleaseSavepointLevels();
            }
        }
    }

    public void languageSetSavePoint(String string, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            this.currentSavepointLevel = transactionController.setSavePoint(string, object);
        }
    }

    public boolean anyoneBlocked() {
        return this.getTransactionExecute().anyoneBlocked();
    }

    public void setTransaction(TransactionController transactionController) {
        this.tran = transactionController;
    }

    public void beginNestedTransaction(boolean bl) throws StandardException {
        if (this.childTransaction == null) {
            this.childTransaction = this.tran.startNestedUserTransaction(bl);
        }
        ++this.queryNestingDepth;
    }

    public void commitNestedTransaction() throws StandardException {
        if (--this.queryNestingDepth == 0) {
            this.childTransaction.commit();
            this.childTransaction.destroy();
            this.childTransaction = null;
            return;
        }
    }

    public TransactionController getTransactionCompile() {
        return this.childTransaction != null ? this.childTransaction : this.tran;
    }

    public TransactionController getTransactionExecute() {
        return this.tran;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dataFactory;
    }

    public LanguageFactory getLanguageFactory() {
        return this.langFactory;
    }

    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    public LanguageConnectionFactory getLanguageConnectionFactory() {
        return this.connFactory;
    }

    private boolean checkIfAnyActivationHasHoldCursor(String string) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            Activation activation = (Activation)this.acts.elementAt(i);
            if (!activation.checkIfThisActivationHasHoldCursor(string)) continue;
            return true;
        }
        return false;
    }

    public boolean verifyAllHeldResultSetsAreClosed() throws StandardException {
        ResultSet resultSet;
        Activation activation;
        int n;
        boolean bl = false;
        for (n = this.acts.size() - 1; n >= 0; --n) {
            activation = (Activation)this.acts.elementAt(n);
            if (!activation.isInUse() || !activation.getResultSetHoldability() || (resultSet = ((CursorActivation)activation).getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return true;
        }
        System.gc();
        System.runFinalization();
        for (n = this.acts.size() - 1; n >= 0; --n) {
            activation = (Activation)this.acts.elementAt(n);
            if (!activation.isInUse() || !activation.getResultSetHoldability() || (resultSet = ((CursorActivation)activation).getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            return false;
        }
        return true;
    }

    public boolean verifyNoOpenResultSets(PreparedStatement preparedStatement, Provider provider, int n) throws StandardException {
        ResultSet resultSet;
        Activation activation;
        int n2;
        boolean bl = false;
        for (n2 = this.acts.size() - 1; n2 >= 0; --n2) {
            activation = (Activation)this.acts.elementAt(n2);
            if (!activation.isInUse() || preparedStatement != activation.getPreparedStatement() || (resultSet = activation.getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        System.gc();
        System.runFinalization();
        for (n2 = this.acts.size() - 1; n2 >= 0; --n2) {
            activation = (Activation)this.acts.elementAt(n2);
            if (!activation.isInUse() || preparedStatement != activation.getPreparedStatement() || (resultSet = activation.getResultSet()) == null || resultSet.isClosed()) continue;
            if (provider != null && resultSet.returnsRows()) {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0X95.S", dependencyManager.getActionString(n), (Object)provider.getObjectName());
            }
            return true;
        }
        return false;
    }

    public String getAuthorizationId() {
        return this.authorizer.getAuthorizationId();
    }

    public SchemaDescriptor getDefaultSchema() {
        return this.sd;
    }

    public String getCurrentSchemaName() {
        if (null == this.sd) {
            return null;
        }
        return this.sd.getSchemaName();
    }

    public void setDefaultSchema(SchemaDescriptor schemaDescriptor) throws StandardException {
        if (schemaDescriptor == null) {
            schemaDescriptor = this.initDefaultSchemaDescriptor();
        }
        this.sd = schemaDescriptor;
    }

    public Long getIdentityValue() {
        return this.identityNotNull ? new Long(this.identityVal) : null;
    }

    public void setIdentityValue(long l) {
        this.identityVal = l;
        this.identityNotNull = true;
    }

    public void emptyCache() {
        if (this.statementCache != null) {
            this.statementCache.ageOut();
        }
    }

    public final CompilerContext pushCompilerContext() {
        return this.pushCompilerContext(null);
    }

    public CompilerContext pushCompilerContext(SchemaDescriptor schemaDescriptor) {
        boolean bl = false;
        CompilerContext compilerContext = (CompilerContext)this.getContextManager().getContext("CompilerContext");
        if (compilerContext == null) {
            bl = true;
        }
        if (compilerContext == null || compilerContext.getInUse()) {
            compilerContext = new CompilerContextImpl(this.getContextManager(), this.connFactory, this.tcf);
            if (bl) {
                compilerContext.firstOnStack();
            }
        } else {
            compilerContext.resetContext();
        }
        compilerContext.setInUse(true);
        compilerContext.setEntryIsolationLevel(this.getCurrentIsolationLevel());
        StatementContext statementContext = this.getStatementContext();
        if (statementContext.getSystemCode()) {
            compilerContext.setReliability(0);
        }
        return compilerContext;
    }

    public void popCompilerContext(CompilerContext compilerContext) {
        compilerContext.setCurrentDependent(null);
        compilerContext.setInUse(false);
        this.isolationLevel = compilerContext.getEntryIsolationLevel();
        if (!compilerContext.isFirstOnStack()) {
            compilerContext.popMe();
        } else {
            compilerContext.setCompilationSchema(null);
        }
    }

    public StatementContext pushStatementContext(boolean bl, String string, ParameterValueSet parameterValueSet, boolean bl2) {
        int n = this.statementDepth;
        boolean bl3 = false;
        boolean bl4 = false;
        StatementContext statementContext = this.statementContexts[0];
        if (statementContext == null) {
            statementContext = this.statementContexts[0] = new GenericStatementContext(this, this.tran);
        } else if (this.statementDepth > 0) {
            StatementContext statementContext2;
            if (this.statementDepth == 1) {
                statementContext = this.statementContexts[1];
                if (statementContext == null) {
                    statementContext = this.statementContexts[1] = new GenericStatementContext(this, this.tran);
                } else {
                    statementContext.pushMe();
                }
                statementContext2 = this.statementContexts[0];
            } else {
                statementContext2 = this.getStatementContext();
                statementContext = new GenericStatementContext(this, this.tran);
            }
            bl3 = statementContext2.inTrigger() || this.outermostTrigger == n;
            bl4 = statementContext2.isAtomic();
            statementContext.setSQLAllowed(statementContext2.getSQLAllowed(), false);
            if (statementContext2.getSystemCode()) {
                statementContext.setSystemCode();
            }
        }
        this.incrementStatementDepth();
        statementContext.setInUse(bl3, bl || bl4, string, parameterValueSet);
        if (bl2) {
            statementContext.setParentRollback();
        }
        return statementContext;
    }

    public void popStatementContext(StatementContext statementContext, Throwable throwable) {
        if (statementContext != null) {
            if (!statementContext.inUse()) {
                return;
            }
            statementContext.clearInUse();
        }
        this.decrementStatementDepth();
        if (this.statementDepth == -1) {
            this.resetStatementDepth();
        } else if (this.statementDepth != 0) {
            this.getContextManager().getContext("StatementContext").popMe();
        }
    }

    public void pushExecutionStmtValidator(ExecutionStmtValidator executionStmtValidator) {
        this.stmtValidators.addElement(executionStmtValidator);
    }

    public void popExecutionStmtValidator(ExecutionStmtValidator executionStmtValidator) throws StandardException {
        boolean bl = this.stmtValidators.removeElement(executionStmtValidator);
    }

    public void pushTriggerExecutionContext(TriggerExecutionContext triggerExecutionContext) throws StandardException {
        if (this.outermostTrigger == -1) {
            this.outermostTrigger = this.statementDepth;
        }
        if (this.triggerExecutionContexts.size() >= 16) {
            throw StandardException.newException("54038");
        }
        this.triggerExecutionContexts.addElement(triggerExecutionContext);
    }

    public void popTriggerExecutionContext(TriggerExecutionContext triggerExecutionContext) throws StandardException {
        if (this.outermostTrigger == this.statementDepth) {
            this.outermostTrigger = -1;
        }
        boolean bl = this.triggerExecutionContexts.removeElement(triggerExecutionContext);
    }

    public TriggerExecutionContext getTriggerExecutionContext() {
        return this.triggerExecutionContexts.size() == 0 ? (TriggerExecutionContext)null : (TriggerExecutionContext)this.triggerExecutionContexts.lastElement();
    }

    public void validateStmtExecution(ConstantAction constantAction) throws StandardException {
        if (this.stmtValidators.size() > 0) {
            Enumeration enumeration = this.stmtValidators.elements();
            while (enumeration.hasMoreElements()) {
                ((ExecutionStmtValidator)enumeration.nextElement()).validateStatement(constantAction);
            }
        }
    }

    public void pushTriggerTable(TableDescriptor tableDescriptor) {
        this.triggerTables.addElement(tableDescriptor);
    }

    public void popTriggerTable(TableDescriptor tableDescriptor) {
        boolean bl = this.triggerTables.removeElement(tableDescriptor);
    }

    public TableDescriptor getTriggerTable() {
        return this.triggerTables.size() == 0 ? (TableDescriptor)null : (TableDescriptor)this.triggerTables.lastElement();
    }

    public Database getDatabase() {
        return this.db;
    }

    public int incrementBindCount() {
        ++this.bindCount;
        return this.bindCount;
    }

    public int decrementBindCount() {
        --this.bindCount;
        return this.bindCount;
    }

    public int getBindCount() {
        return this.bindCount;
    }

    public final void setDataDictionaryWriteMode() {
        this.ddWriteMode = true;
    }

    public final boolean dataDictionaryInWriteMode() {
        return this.ddWriteMode;
    }

    public void setRunTimeStatisticsMode(boolean bl) {
        this.runTimeStatisticsSetting = bl;
    }

    public boolean getRunTimeStatisticsMode() {
        return this.runTimeStatisticsSetting;
    }

    public void setStatisticsTiming(boolean bl) {
        this.statisticsTiming = bl;
    }

    public boolean getStatisticsTiming() {
        return this.statisticsTiming;
    }

    public void setRunTimeStatisticsObject(RunTimeStatistics runTimeStatistics) {
        this.runTimeStatisticsObject = runTimeStatistics;
    }

    public RunTimeStatistics getRunTimeStatisticsObject() {
        return this.runTimeStatisticsObject;
    }

    public int getStatementDepth() {
        return this.statementDepth;
    }

    public void setIsolationLevel(int n) throws StandardException {
        StatementContext statementContext = this.getStatementContext();
        if (statementContext != null && statementContext.inTrigger()) {
            throw StandardException.newException("X0Y71.S", this.getTriggerExecutionContext().toString());
        }
        if (this.isolationLevel != n && !this.verifyAllHeldResultSetsAreClosed()) {
            throw StandardException.newException("X0X03.S");
        }
        TransactionController transactionController = this.getTransactionExecute();
        if (!transactionController.isIdle()) {
            if (transactionController.isGlobal()) {
                throw StandardException.newException("X0Y77.S");
            }
            this.userCommit();
        }
        this.isolationLevel = n;
        this.isolationLevelExplicitlySet = true;
    }

    public int getCurrentIsolationLevel() {
        return this.isolationLevel == 0 ? this.defaultIsolationLevel : this.isolationLevel;
    }

    public String getCurrentIsolationLevelStr() {
        if (this.isolationLevel >= 0 && this.isolationLevel < ExecutionContext.CS_TO_SQL_ISOLATION_MAP.length) {
            return ExecutionContext.CS_TO_SQL_ISOLATION_MAP[this.isolationLevel][0];
        }
        return ExecutionContext.CS_TO_SQL_ISOLATION_MAP[0][0];
    }

    public void setPrepareIsolationLevel(int n) {
        this.prepareIsolationLevel = n;
    }

    public int getPrepareIsolationLevel() {
        if (!this.isolationLevelExplicitlySet) {
            return this.prepareIsolationLevel;
        }
        return 0;
    }

    public ExecutionContext getExecutionContext() {
        return (ExecutionContext)this.getContextManager().getContext("ExecutionContext");
    }

    public StatementContext getStatementContext() {
        return (StatementContext)this.getContextManager().getContext("StatementContext");
    }

    public boolean setOptimizerTrace(boolean bl) {
        if (this.of == null) {
            return false;
        }
        if (!this.of.supportsOptimizerTrace()) {
            return false;
        }
        this.optimizerTrace = bl;
        return true;
    }

    public boolean getOptimizerTrace() {
        return this.optimizerTrace;
    }

    public boolean setOptimizerTraceHtml(boolean bl) {
        if (this.of == null) {
            return false;
        }
        if (!this.of.supportsOptimizerTrace()) {
            return false;
        }
        this.optimizerTraceHtml = bl;
        return true;
    }

    public boolean getOptimizerTraceHtml() {
        return this.optimizerTraceHtml;
    }

    public void setOptimizerTraceOutput(String string) {
        if (this.optimizerTrace) {
            this.lastOptimizerTraceOutput = this.optimizerTraceOutput;
            this.optimizerTraceOutput = string;
        }
    }

    public void appendOptimizerTraceOutput(String string) {
        this.optimizerTraceOutput = this.optimizerTraceOutput == null ? string : this.optimizerTraceOutput + string;
    }

    public String getOptimizerTraceOutput() {
        return this.lastOptimizerTraceOutput;
    }

    public boolean isTransactionPristine() {
        return this.getTransactionExecute().isPristine();
    }

    public Object getLockObject(int n) throws StandardException {
        switch (n) {
            case 1: {
                return this.getTransactionExecute().getLockObject();
            }
            case 2: {
                return new Object();
            }
        }
        throw StandardException.newException("0A000.S");
    }

    public String convertIdentifierCase(String string) throws StandardException {
        if (1 == this.getIdentifierCasing()) {
            return StringUtil.SQLToLowerCase(string);
        }
        return StringUtil.SQLToUpperCase(string);
    }

    public int getIdentifierCasing() throws StandardException {
        if (-1 == this.identifierCasing) {
            this.identifierCasing = 0;
        }
        return this.identifierCasing;
    }

    public void cleanupOnError(Throwable throwable) throws StandardException {
        int n;
        int n2 = n = throwable instanceof StandardException ? ((StandardException)throwable).getSeverity() : 30000;
        if (this.statementContexts[0] != null) {
            this.statementContexts[0].clearInUse();
        }
        if (this.statementContexts[1] != null) {
            this.statementContexts[1].clearInUse();
        }
        if (n == 40000) {
            for (int i = this.acts.size() - 1; i >= 0; --i) {
                if (i >= this.acts.size()) continue;
                Activation activation = (Activation)this.acts.elementAt(i);
                activation.reset();
                activation.close();
            }
            this.popMe();
        } else if (n > 40000) {
            this.popMe();
        } else if (n >= 30000) {
            this.internalRollback();
        }
    }

    public boolean isLastHandler(int n) {
        return false;
    }

    private void resetActivations(boolean bl) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            ExecPreparedStatement execPreparedStatement;
            if (i >= this.acts.size()) continue;
            Activation activation = (Activation)this.acts.elementAt(i);
            if (bl) {
                activation.setResultSetHoldability(false);
            }
            if (!activation.isInUse()) {
                activation.close();
                continue;
            }
            activation.reset();
            if (!bl || !this.dataDictionaryInWriteMode() || (execPreparedStatement = activation.getPreparedStatement()) == null) continue;
            execPreparedStatement.makeInvalid(4, this);
        }
    }

    private void finishDDTransaction() throws StandardException {
        if (this.ddWriteMode) {
            DataDictionary dataDictionary = this.getDataDictionary();
            dataDictionary.transactionFinished();
            this.ddWriteMode = false;
        }
    }

    private void incrementStatementDepth() {
        ++this.statementDepth;
    }

    private void decrementStatementDepth() {
        --this.statementDepth;
    }

    protected void resetStatementDepth() {
        this.statementDepth = 0;
    }

    public String getSystemSchemaName() throws StandardException {
        return this.convertIdentifierCase("SYS");
    }

    public String getSysIBMSchemaName() throws StandardException {
        return this.convertIdentifierCase("SYSIBM");
    }

    public String getSystemDiagSchemaName() throws StandardException {
        return this.convertIdentifierCase("SYSCS_DIAG");
    }

    public String getSystemUtilSchemaName() throws StandardException {
        return this.convertIdentifierCase("SYSCS_UTIL");
    }

    public String getDeclaredGlobalTemporaryTablesSchemaName() throws StandardException {
        return this.convertIdentifierCase("SESSION");
    }

    public DataDictionary getDataDictionary() {
        DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)this.getContextManager().getContext("DataDictionaryContext");
        if (dataDictionaryContext != null) {
            return dataDictionaryContext.getDataDictionary();
        }
        return null;
    }

    public void setReadOnly(boolean bl) throws StandardException {
        if (!this.tran.isPristine()) {
            throw StandardException.newException("25501");
        }
        this.authorizer.setReadOnlyConnection(bl, true);
    }

    public boolean isReadOnly() {
        return this.authorizer.isReadOnlyConnection();
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public AccessFactory getAccessFactory() {
        return this.af;
    }

    public Long lastAutoincrementValue(String string, String string2, String string3) {
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        int n = this.triggerExecutionContexts.size();
        for (int i = n - 1; i >= 0; --i) {
            InternalTriggerExecutionContext internalTriggerExecutionContext = (InternalTriggerExecutionContext)this.triggerExecutionContexts.elementAt(i);
            Long l = internalTriggerExecutionContext.getAutoincrementValue(string4);
            if (l == null) continue;
            return l;
        }
        if (this.autoincrementHT == null) {
            return null;
        }
        return (Long)this.autoincrementHT.get(string4);
    }

    public void setAutoincrementUpdate(boolean bl) {
        this.autoincrementUpdate = bl;
    }

    public boolean getAutoincrementUpdate() {
        return this.autoincrementUpdate;
    }

    public void autoincrementCreateCounter(String string, String string2, String string3, Long l, long l2, int n) {
        AutoincrementCounter autoincrementCounter;
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        if (this.autoincrementCacheHashtable == null) {
            this.autoincrementCacheHashtable = new Hashtable();
        }
        if ((autoincrementCounter = (AutoincrementCounter)this.autoincrementCacheHashtable.get(string4)) != null) {
            return;
        }
        autoincrementCounter = new AutoincrementCounter(l, l2, 0L, string, string2, string3, n);
        this.autoincrementCacheHashtable.put(string4, autoincrementCounter);
    }

    public long nextAutoincrementValue(String string, String string2, String string3) throws StandardException {
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        AutoincrementCounter autoincrementCounter = (AutoincrementCounter)this.autoincrementCacheHashtable.get(string4);
        if (autoincrementCounter == null) {
            return 0L;
        }
        return autoincrementCounter.update();
    }

    public void autoincrementFlushCache(UUID uUID) throws StandardException {
        if (this.autoincrementCacheHashtable == null) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new Hashtable();
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        Enumeration enumeration = this.autoincrementCacheHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AutoincrementCounter autoincrementCounter = (AutoincrementCounter)this.autoincrementCacheHashtable.get(k);
            Long l = autoincrementCounter.getCurrentValue();
            autoincrementCounter.flushToDisk(this.getTransactionExecute(), dataDictionary, uUID);
            if (l == null) continue;
            this.autoincrementHT.put(k, l);
        }
        this.autoincrementCacheHashtable.clear();
    }

    public void copyHashtableToAIHT(Hashtable hashtable) {
        if (hashtable.isEmpty()) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            this.autoincrementHT.put(k, v);
        }
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getDrdaID() {
        return this.drdaID;
    }

    public void setDrdaID(String string) {
        this.drdaID = string;
    }

    public String getDbname() {
        return this.dbname;
    }

    public Activation getLastActivation() {
        return (Activation)this.acts.lastElement();
    }

    protected String getAuthorizationId(String string) throws StandardException {
        try {
            return IdUtil.parseId(string);
        }
        catch (StandardException standardException) {
            throw StandardException.newException("28502.C", string);
        }
    }

    public StringBuffer appendErrorInfo() {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(XID = ");
        stringBuffer.append(transactionController.getTransactionIdString());
        stringBuffer.append("), ");
        stringBuffer.append("(SESSIONID = ");
        stringBuffer.append(Integer.toString(this.getInstanceNumber()));
        stringBuffer.append("), ");
        stringBuffer.append("(DATABASE = ");
        stringBuffer.append(this.getDbname());
        stringBuffer.append("), ");
        stringBuffer.append("(DRDAID = ");
        stringBuffer.append(this.getDrdaID());
        stringBuffer.append("), ");
        return stringBuffer;
    }
}

