
use strict;
use Test::More;

BEGIN { use_ok('DDCCI') };

ok( defined &scan_devices, 'function scan_devices() presence');
my $devs = scan_devices();
BAIL_OUT("*** no monitors detected, further testing is impossible") if (scalar @{$devs} == 0);

diag( "\n\tmonitor found: $_->{'dev'} => id $_->{'id'}, s/n $_->{'sn'}, $_->{'type'} input" ) for (@$devs);

diag( "\n\tWARNING:\n\tsince multiple monitors were detected, the next tests will focus on the first one ('" . 
	$devs->[0]->{'dev'} . "').\n\tThis may lead to some errors, be warned.\n " ) if (scalar @{$devs} > 0);

done_testing();
