/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;

final class EmbedSavepoint30
extends ConnectionChild
implements Savepoint {
    private final String savepointName;
    private final int savepointID;

    EmbedSavepoint30(EmbedConnection embedConnection, String string) throws StandardException {
        super(embedConnection);
        if (string == null) {
            this.savepointName = "i." + embedConnection.getLanguageConnection().getUniqueSavepointName();
            this.savepointID = embedConnection.getLanguageConnection().getUniqueSavepointID();
        } else {
            this.savepointName = "e." + string;
            this.savepointID = -1;
        }
        embedConnection.getLanguageConnection().languageSetSavePoint(this.savepointName, this);
    }

    public int getSavepointId() throws SQLException {
        if (this.savepointID == -1) {
            throw this.newSQLException("XJ013.S");
        }
        return this.savepointID;
    }

    public String getSavepointName() throws SQLException {
        if (this.savepointID != -1) {
            throw this.newSQLException("XJ014.S");
        }
        return this.savepointName.substring(2);
    }

    String getInternalName() {
        return this.savepointName;
    }

    boolean sameConnection(EmbedConnection embedConnection) {
        return this.getEmbedConnection().getLanguageConnection() == embedConnection.getLanguageConnection();
    }
}

