# NAME

AI::ConfusionMatrix - make a confusion matrix

# SYNOPSIS

    my %matrix;

    Loop over your tests

    ---

    $matrix{$expected}{$predicted} += 1;

    ---

    makeConfusionMatrix(\%matrix, 'output.csv');

# DESCRIPTION

This module prints a [confusion matrix](https://en.wikipedia.org/wiki/Confusion_matrix) from a hash reference. This module tries to be generic enough to be used within a lot of machine learning projects.

### Function

#### `makeConfusionMatrix($hash_ref, $filename)`

This function makes a confusion matrix from `$hash_ref` and writes it to `$filename`.

Example:

    makeConfusionMatrix(\%matrix, 'output.csv');

The hash reference must look like this :

    $VAR1 = {


              'value_expected1' => {
                          'value_predicted1' => value
                        },
              'value_expected2' => {
                          'value_predicted1' => value,
                          'value_predicted2' => value
                        },
              'value_expected3' => {
                          'value_predicted3' => value
                        }

            };

The output will be in CSV. Here is an example:

    ,1997,1998,2001,2003,2005,2008,2012,2015,TOTAL,TP,FP,FN,ACC
    1997,1,,,,,,,1,2,1,0,1,50.00%
    1998,,1,,,,,,,1,1,0,0,100.00%
    2001,,,1,,,,,,1,1,0,0,100.00%
    2003,,,,5,,,,2,7,5,0,2,71.43%
    2005,,,,,5,,,4,9,5,0,4,55.56%
    2008,,,,,,3,,,3,3,0,0,100.00%
    2012,,,,,,,5,,5,5,0,0,100.00%
    2015,,,,,,,,2,2,2,7,0,100.00%
    TOTAL,1,1,1,5,5,3,5,9,30,23,7,7,84.62%

Prettified:

|       | 1997 | 1998 | 2001 | 2003 | 2005 | 2008 | 2012 | 2015 | TOTAL | TP | FP | FN | ACC     |
|-------|------|------|------|------|------|------|------|------|-------|----|----|----|---------|
| 1997  | 1    |      |      |      |      |      |      | 1    | 2     | 1  | 0  | 1  | 50.00%  |
| 1998  |      | 1    |      |      |      |      |      |      | 1     | 1  | 0  | 0  | 100.00% |
| 2001  |      |      | 1    |      |      |      |      |      | 1     | 1  | 0  | 0  | 100.00% |
| 2003  |      |      |      | 5    |      |      |      | 2    | 7     | 5  | 0  | 2  | 71.43%  |
| 2005  |      |      |      |      | 5    |      |      | 4    | 9     | 5  | 0  | 4  | 55.56%  |
| 2008  |      |      |      |      |      | 3    |      |      | 3     | 3  | 0  | 0  | 100.00% |
| 2012  |      |      |      |      |      |      | 5    |      | 5     | 5  | 0  | 0  | 100.00% |
| 2015  |      |      |      |      |      |      |      | 2    | 2     | 2  | 7  | 0  | 100.00% |
| TOTAL | 1    | 1    | 1    | 5    | 5    | 3    | 5    | 9    | 30    | 23 | 7  | 7  | 84.62%  |

- TP:

    True Positive

- FP:

    False Positive

- FN:

    False Negative

- ACC:

    Accuracy

# AUTHOR

Vincent Lequertier <sky@riseup.net>

# LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
