
class Meta::Class;

has $.name;
has @.traits;

method new(Str $name) returns Meta::Class {
    $.name = $name;
    return $?SELF;
}

method apply {
    ...
}

=head1 NAME

Meta::Class - Entities in the Perl 6 language model (M2)

=head1 SYNOPSIS

 my $role_mc = Meta::Class.new("Role");
 my $class_mc = Meta::Class.new("Class");

=head1 DESCRIPTION

Meta::Class objects are objects in the Perl 6 class system.

These objects are changed when you define new traits of Classes,
Roles, etc - or when you do even scarier things to the Perl 6 class
system.

Note that the files in this distribution at C<lib/Class.pm> will
probably eventually be auto-generated by methods called on
these objects.

=cut

