package WordLists::EN::CommonException;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-07-01'; # DATE
our $DIST = 'WordLists-EN-CommonException'; # DIST
our $VERSION = '0.001'; # VERSION

1;
# ABSTRACT: Collection of English common exception words

__END__

=pod

=encoding UTF-8

=head1 NAME

WordLists::EN::CommonException - Collection of English common exception words

=head1 VERSION

This document describes version 0.001 of WordLists::EN::CommonException (from Perl distribution WordLists-EN-CommonException), released on 2020-07-01.

=head1 DESCRIPTION

Common exception words, sometimes called "red words", or "tricky words", or
"sight words", are words that don't quite follow the spelling or phonics rules
but are often found in high frequency in English text [1]. Examples would
include "once", "our", "was", etc. Therefore, children are taught to memorize
these words in early years of learning.

Each school or teacher will probably setup a slightly different list of these
words.

From monsterphonics.com: "The most top 300 high-frequency words make up 65% of
all printed words. Almost half of these are not decodable using phonics. The
result is that around a quarter of the words that children are asked to learn to
read and spell cannot be done so phonetically. It is therefore vital to
explicitly teach the common exception words."

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-CommonException>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-EN-CommonException>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-CommonException>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
