#!/usr/local/bin/perl -w

=head1 NAME

90revml2p4_3.t - testing of vcp p4 i/o

=head1 DESCRIPTION

This tests revml->p4 *without* forcing changes on to the first revision
of a branch (which is how the other test suites operate).

Unlike the other t/90revml2p4_*.t files, t/91p42revml.t does not check
the details of this transfer, that would be a pain without having
bin/gentrevml emit custom revml just to test the output of this test
with.  That will make sense if we ever want to run tests using this mode
and t/91p42revml.t should be expanded to cover this test case in that
event.

=cut

use strict ;

use Carp ;
use Cwd ;
use File::Path qw( rmtree );
use Test ;
use VCP::TestUtils ;

my @vcp = vcp_cmd ;

my $t = -d 't' ? 't/' : '' ;

my $module = 'foo' ;  ## Must match the rev_root in the testrevml files

my $infile_0 = $t . "test-p4-in-0.revml";

my $p4root_3  = "${t}p4root_3";
my $p4state_3 = "${t}p4state_3";

my $p4_spec = "p4:revml2p4\@$p4root_3://depot/foo/...";
my $p4_repo_id = "p4:test_repository";


my @tests = (

##
## revml->p4
##
sub {
   my $out;
   run [ @vcp, "revml:$infile_0", $p4_spec, 
         "--init-p4d",
         "--delete-p4d-dir",
         "--db-dir=$p4state_3",
         "--repo-id=$p4_repo_id",
       ], \undef, \$out
      or die "`vcp revml:$infile_0 $p4_spec` returned $?" ;

   ok 1;
},


##
## check result previous sub
##
sub {
   my $got = parse_files_and_revids_from_head_revs_db {
      state_dir       => $p4state_3,
      repo_id         => $p4_repo_id,
      remove_rev_root => "/ignored/"
   };
   my $exp = parse_files_and_revids_from_revml $infile_0 ;

   #$exp =~ s{(main-branch-1.*)(\d+)}{$1 . ( 1 + $2 ) }ge
   #   or die "unable to tweak expected output";

   ok_or_diff $got, $exp;
},

);



plan tests => scalar @tests ;

my $p4d_borken = p4d_borken ;

my $why_skip ;
$why_skip .= "p4 command not found\n"  unless ( `p4 -V`  || 0 ) =~ /^Perforce/ ;
$why_skip .= "$p4d_borken\n"           if $p4d_borken ;

$why_skip ? skip( $why_skip, '' ) : $_->() for @tests ;

