use Test::More tests => 84;
use strict;
use MARC::Charset;

BEGIN {
    use_ok('MARC::Charset::Greek');
}

my $cs = MARC::Charset->new();
$cs->g0( MARC::Charset::Greek->new() );

## make sure we were able to set the G0 charset to Greek

isa_ok( $cs->g0(), 'MARC::Charset::Greek' );

## see if we can use valid Greek characters

my %valid = (

chr(0x21)=>chr(0x0300), 
chr(0x22)=>chr(0x0301), 
chr(0x23)=>chr(0x0308), 
chr(0x24)=>chr(0x0342), 
chr(0x25)=>chr(0x0313), 
chr(0x26)=>chr(0x0314), 
chr(0x27)=>chr(0x0345), 
chr(0x30)=>chr(0x00AB), 
chr(0x31)=>chr(0x00BB), 
chr(0x32)=>chr(0x201C), 
chr(0x33)=>chr(0x201D), 
chr(0x34)=>chr(0x0374), 
chr(0x35)=>chr(0x0375), 
chr(0x3B)=>chr(0x0387), 
chr(0x3F)=>chr(0x037E), 
chr(0x41)=>chr(0x0391), 
chr(0x42)=>chr(0x0392), 
chr(0x44)=>chr(0x0393), 
chr(0x45)=>chr(0x0394), 
chr(0x46)=>chr(0x0395), 
chr(0x47)=>chr(0x03DA), 
chr(0x48)=>chr(0x03DC), 
chr(0x49)=>chr(0x0396), 
chr(0x4A)=>chr(0x0397), 
chr(0x4B)=>chr(0x0398), 
chr(0x4C)=>chr(0x0399), 
chr(0x4D)=>chr(0x039A), 
chr(0x4E)=>chr(0x039B), 
chr(0x4F)=>chr(0x039C), 
chr(0x50)=>chr(0x039D), 
chr(0x51)=>chr(0x039E), 
chr(0x52)=>chr(0x039F), 
chr(0x53)=>chr(0x03A0), 
chr(0x54)=>chr(0x03DE), 
chr(0x55)=>chr(0x03A1), 
chr(0x56)=>chr(0x03A3), 
chr(0x58)=>chr(0x03A4), 
chr(0x59)=>chr(0x03A5), 
chr(0x5A)=>chr(0x03A6), 
chr(0x5B)=>chr(0x03A7), 
chr(0x5C)=>chr(0x03A8), 
chr(0x5D)=>chr(0x03A9), 
chr(0x5E)=>chr(0x03E0), 
chr(0x61)=>chr(0x03B1), 
chr(0x62)=>chr(0x03B2), 
chr(0x63)=>chr(0x03D0), 
chr(0x64)=>chr(0x03B3), 
chr(0x65)=>chr(0x03B4), 
chr(0x66)=>chr(0x03B5), 
chr(0x67)=>chr(0x03DB), 
chr(0x68)=>chr(0x03DD), 
chr(0x69)=>chr(0x03B6), 
chr(0x6A)=>chr(0x03B7), 
chr(0x6B)=>chr(0x03B8), 
chr(0x6C)=>chr(0x03B9), 
chr(0x6D)=>chr(0x03BA), 
chr(0x6E)=>chr(0x03BB), 
chr(0x6F)=>chr(0x03BC), 
chr(0x70)=>chr(0x03BD), 
chr(0x71)=>chr(0x03BE), 
chr(0x72)=>chr(0x03BF), 
chr(0x73)=>chr(0x03C0), 
chr(0x74)=>chr(0x03DF), 
chr(0x75)=>chr(0x03C1), 
chr(0x76)=>chr(0x03C3), 
chr(0x77)=>chr(0x03C2),
chr(0x78)=>chr(0x03C4), 
chr(0x79)=>chr(0x03C5), 
chr(0x7A)=>chr(0x03C6), 
chr(0x7B)=>chr(0x03C7), 
chr(0x7C)=>chr(0x03C8), 
chr(0x7D)=>chr(0x03C9), 
chr(0x7E)=>chr(0x03E1), 

);

my @combining = (

chr(0x21), 
chr(0x22), 
chr(0x23), 
chr(0x24), 
chr(0x25), 
chr(0x26),
chr(0x27), 

);

while ( my($test,$expected) = each %valid ) {
    my $converted = $cs->to_utf8($test);
    is( $converted => $expected,
	'valid Greek character chr(0x'.sprintf("%2x",ord($test)).')'
    ); 
}

## test each combining character, to make sure things get reordered with
## Note: 0x3B (Greek) is 0x0387 (UTF8)
foreach my $test (@combining) {
    my $converted = $cs->to_utf8( $test.chr(0x3B) );
    is ( $converted => $valid{chr(0x3B)}.$valid{$test}, 
	'valid Greek combining character chr(0x'.sprintf("%2x",ord($test)).')'
    );
}
 
## try one test with multiple combining characters

is ( 
    $cs->to_utf8(chr(0x21).chr(0x22).chr(0x3B)),
    chr(0x0387).chr(0x0300).chr(0x0301),
    'mulitple Greek combining characters'
);

## and lets try one longish string
my $test = chr(0x61).chr(0x6C).chr(0x70).chr(0x70).chr(0x59);
my $expected = chr(0x03B1).chr(0x03B9).chr(0x03BD).chr(0x03BD).chr(0x03A5);
is ($cs->to_utf8($test),$expected,'longish Greek string');







