# Generated by default/object.tt
package Paws::Batch::FargatePlatformConfiguration;
  use Moose;
  has PlatformVersion => (is => 'ro', isa => 'Str', request_name => 'platformVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::FargatePlatformConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::FargatePlatformConfiguration object:

  $service_obj->Method(Att1 => { PlatformVersion => $value, ..., PlatformVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::FargatePlatformConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->PlatformVersion

=head1 DESCRIPTION

The platform configuration for jobs running on Fargate resources. For
jobs that run on EC2 resources, you shouldn't specify this parameter.

=head1 ATTRIBUTES


=head2 PlatformVersion => Str

The AWS Fargate platform version where the jobs are running. A platform
version is specified only for jobs running on Fargate resources. If one
isn't specified, the C<LATEST> platform version is used by default.
This uses a recent, approved version of the AWS Fargate platform for
compute resources. For more information, see AWS Fargate platform
versions
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
in the I<Amazon Elastic Container Service Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

