# Generated by default/object.tt
package Paws::NetworkFirewall::LogDestinationConfig;
  use Moose;
  has LogDestination => (is => 'ro', isa => 'Paws::NetworkFirewall::LogDestinationMap', required => 1);
  has LogDestinationType => (is => 'ro', isa => 'Str', required => 1);
  has LogType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::LogDestinationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::LogDestinationConfig object:

  $service_obj->Method(Att1 => { LogDestination => $value, ..., LogType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::LogDestinationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->LogDestination

=head1 DESCRIPTION

Defines where AWS Network Firewall sends logs for the firewall for one
log type. This is used in LoggingConfiguration. You can send each type
of log to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis
Data Firehose delivery stream.

Network Firewall generates logs for stateful rule groups. You can save
alert and flow log types. The stateful rules engine records flow logs
for all network traffic that it receives. It records alert logs for
traffic that matches stateful rules that have the rule action set to
C<DROP> or C<ALERT>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> LogDestination => L<Paws::NetworkFirewall::LogDestinationMap>

The named location for the logs, provided in a key:value mapping that
is specific to the chosen destination type.

=over

=item *

For an Amazon S3 bucket, provide the name of the bucket, with key
C<bucketName>, and optionally provide a prefix, with key C<prefix>. The
following example specifies an Amazon S3 bucket named
C<DOC-EXAMPLE-BUCKET> and the prefix C<alerts>:

C<"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix":
"alerts" }>

=item *

For a CloudWatch log group, provide the name of the CloudWatch log
group, with key C<logGroup>. The following example specifies a log
group named C<alert-log-group>:

C<"LogDestination": { "logGroup": "alert-log-group" }>

=item *

For a Kinesis Data Firehose delivery stream, provide the name of the
delivery stream, with key C<deliveryStream>. The following example
specifies a delivery stream named C<alert-delivery-stream>:

C<"LogDestination": { "deliveryStream": "alert-delivery-stream" }>

=back



=head2 B<REQUIRED> LogDestinationType => Str

The type of storage destination to send these logs to. You can send
logs to an Amazon S3 bucket, a CloudWatch log group, or a Kinesis Data
Firehose delivery stream.


=head2 B<REQUIRED> LogType => Str

The type of log to send. Alert logs report traffic that matches a
StatefulRule with an action setting that sends an alert log message.
Flow logs are standard network traffic flow logs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

