use Test::More tests => 7;
## test some CWB::CL utility functions (without corpus access)

use CWB::CL;
use strict;
use warnings;

our $fs1a = CWB::CL::make_set("aaa Ba 0 BAa a", 'split'); # -- feature set manipulation
our $fs1b = CWB::CL::make_set("|0|a|BAa|Ba|aaa|");
our $fs1  = "|0|BAa|Ba|a|aaa|"; # this is the normalised form that should be generated by make_set()
our $fs2a = CWB::CL::make_set("aaa äää ßa 0", 'split');
our $fs2  = "|ßa|äää|0|aaa|"; # normalisation should produce signed char ordering

is($fs1a, $fs1, "feature set normalisation"); # T1
is($fs1b, $fs1, "feature set normalisation");
is($fs2a, $fs2, "normalisation of feature set with non-ASCII characters");

our $fs = CWB::CL::set_intersection($fs1, $fs2);
is($fs, "|0|aaa|", "intersection of feature sets"); # T4
diag("");
diag("- unify($fs1, $fs2) = $fs");
is(CWB::CL::set_size($fs), 2, "cardinality of feature set");

our $hash1 = CWB::CL::set2hash($fs1);
isa_ok($hash1, "HASH", "convert feature set to hash"); # T6
our $expected = { map { $_ => 1 } qw(0 BAa Ba a aaa) };
is_deeply($hash1, $expected, "convert feature set to hash");

# total: 7 tests