/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractBoxParser;
import com.coremedia.iso.BoxParser;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MovieBox;
import com.googlecode.mp4parser.DoNotParseDetail;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

@DoNotParseDetail
public class IsoFile
extends AbstractContainerBox {
    protected BoxParser boxParser = new PropertyBoxParserImpl(new String[0]);
    ReadableByteChannel byteChannel;

    public IsoFile() {
        super("");
    }

    public IsoFile(ReadableByteChannel byteChannel) throws IOException {
        super("");
        this.byteChannel = byteChannel;
        this.boxParser = this.createBoxParser();
        this.parse();
    }

    public IsoFile(ReadableByteChannel byteChannel, BoxParser boxParser) throws IOException {
        super("");
        this.byteChannel = byteChannel;
        this.boxParser = boxParser;
        this.parse();
    }

    protected BoxParser createBoxParser() {
        return new PropertyBoxParserImpl(new String[0]);
    }

    public void _parseDetails(ByteBuffer content) {
    }

    public void parse(ReadableByteChannel inFC, ByteBuffer header, long contentSize, AbstractBoxParser abstractBoxParser) throws IOException {
        throw new IOException("This method is not meant to be called. Use #parse() directly.");
    }

    private void parse() throws IOException {
        boolean done = false;
        while (!done) {
            try {
                Box box = this.boxParser.parseBox(this.byteChannel, this);
                if (box != null) {
                    this.boxes.add(box);
                    continue;
                }
                done = true;
            }
            catch (EOFException eOFException) {
                done = true;
            }
        }
    }

    @DoNotParseDetail
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("IsoFile[");
        if (this.boxes == null) {
            buffer.append("unparsed");
        } else {
            int i = 0;
            while (i < this.boxes.size()) {
                if (i > 0) {
                    buffer.append(";");
                }
                buffer.append(((Box)this.boxes.get(i)).toString());
                ++i;
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @DoNotParseDetail
    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            int i = 0;
            while (i < Math.min(4, fourCC.length())) {
                result[i] = (byte)fourCC.charAt(i);
                ++i;
            }
        }
        return result;
    }

    @DoNotParseDetail
    public static String bytesToFourCC(byte[] type) {
        byte[] result = new byte[4];
        if (type != null) {
            System.arraycopy(type, 0, result, 0, Math.min(type.length, 4));
        }
        try {
            return new String(result, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Required character encoding is missing", e);
        }
    }

    public long getNumOfBytesToFirstChild() {
        return 0L;
    }

    public long getSize() {
        long size = 0L;
        for (Box box : this.boxes) {
            size += box.getSize();
        }
        return size;
    }

    public IsoFile getIsoFile() {
        return this;
    }

    @DoNotParseDetail
    public MovieBox getMovieBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        for (Box box : this.boxes) {
            if (os instanceof FileChannel) {
                long startPos = ((FileChannel)os).position();
                box.getBox(os);
                long size = ((FileChannel)os).position() - startPos;
                assert (size == box.getSize());
                continue;
            }
            box.getBox(os);
        }
    }
}

