/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class MatchCDFDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "MatchCDF"}, {"LocalName", "MatchCDF"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("MatchCDFDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/MatchCDFDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", "The desired Cumulative Distribution Function."}};
    private static final Class[] paramClasses = new Class[]{array$$F == null ? (array$$F = MatchCDFDescriptor.class$("[[F")) : array$$F};
    private static final String[] paramNames = new String[]{"CDF"};
    private static final Object[] paramDefaults = new Object[]{null};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    static /* synthetic */ Class array$$F;

    public MatchCDFDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n;
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Object object = (float[][])parameterBlock.getObjectParameter(0);
        Object object2 = renderedImage.getProperty("histogram");
        if (object2 == null || object2.equals(Image.UndefinedProperty)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor1"));
            return false;
        }
        if (!(object2 instanceof Histogram)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor2"));
            return false;
        }
        Histogram histogram = (Histogram)object2;
        int n2 = histogram.getNumBands();
        if (object == null) {
            int[] nArray = histogram.getNumBins();
            object = new float[n2][];
            n = 0;
            while (n < n2) {
                object[n] = new float[nArray[n]];
                int n3 = 0;
                while (n3 < nArray[n]) {
                    object[n][n3] = (n3 + 1) / nArray[n];
                    ++n3;
                }
                ++n;
            }
        }
        if (((float[][])object).length != n2) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor3"));
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (object[n4].length != histogram.getNumBins(n4)) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor4"));
                return false;
            }
            ++n4;
        }
        n = 0;
        while (n < n2) {
            float[] fArray = object[n];
            int n5 = fArray.length;
            if ((double)fArray[n5 - 1] != 1.0) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor7"));
                return false;
            }
            int n6 = 0;
            while (n6 < n5) {
                if (fArray[n6] < 0.0f) {
                    stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor5"));
                    return false;
                }
                if (n6 != 0 && fArray[n6] < fArray[n6 - 1]) {
                    stringBuffer.append(this.getName() + " " + JaiI18N.getString("MatchCDFDescriptor6"));
                    return false;
                }
                ++n6;
            }
            ++n;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.create("MatchCDF", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, float[][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("MatchCDF", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("CDF", fArray);
        return JAI.createRenderable("MatchCDF", parameterBlockJAI, renderingHints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

