use strict;
use warnings;

use Test::More tests => 6;
use blib;

my $perl = $^X;
my $example = 't/utf1.xml';
my $result;
my $expected;

$result= `$perl $example`;
$expected = '<h1>smile ☺</h1>';
like($result, qr($expected), "utf-8 text as expected: [$expected]");

$expected = '<h2>€1</h2>';
like($result, qr($expected), "utf-8 print output as expected: [$expected]");

$expected = '<h3>和平:peace</h3>';
like($result, qr($expected), "utf-8 from src is as expected: [$expected]");

$example = 't/utf3.xml';
$result= `$perl $example`;
$expected = 'Content-length: 12';
like($result, qr($expected), "utf-8 body has header length as expected: [$expected]");

$example = 't/notutf.xml';
$result= `$perl $example`;

$expected = '<h1>not utf8</h1>';
like($result, qr($expected), "non utf content as expected: [$expected]");

$expected = '<h2>not utf8 either</h2>';
like($result, qr($expected), "non utf src as expected: [$expected]");

print $result;